"""Entry point module: process-chunk

Implements the entry-point by using Python or any other languages.

"""
import os
import cv2
import json
import sys
import random
path = os.path.dirname(__file__)
path = os.path.join(path, '../')
sys.path.insert(0, path)
path = os.path.dirname(__file__)

if len(sys.argv) != 3:
    print("Process video not invoked correctly")
    sys.exit()

vid = sys.argv[1]
system_cache_dir = sys.argv[2]

out_dict = {}
activities = []

vid_name = vid.split('/')[-1]
out_dict['filesProcessed'] = [vid_name]

random_fail = random.random() < 1/3

out_dict['activities'] = activities
out_dict['processingReport'] = {
    "siteSpecific": {},
    "fileStatuses": {
        vid_name: {
            "status": 'fail' if random_fail else 'success',
            "message": 'Random fail' if random_fail else 'success'
        }
    }
}
json.dump(out_dict, open(os.path.join(
    system_cache_dir, "Chunk_%s_out.json" % vid_name), 'w'))
