"""Entry point module: experiment-init

Implements the entry-point by using Python or any other languages.
"""

import os
import json


def entry_point(file_index, activity_index, chunks,
                video_location, system_cache_dir, config_file=None,
                prepare_proposal_outputs=False,
                prepare_localization_outputs=False):
    """Method to complete: you have to raise an exception if an error occured
    in the program.

    Start servers, starts cluster, etc.

    Args:
        file_index(str): Path to file index json file for test set
        activity_index(str): Path to activity index json file for test set
        chunks (str): Path to chunks json file
        video_location (str): Path to videos content
        system_cache_dir (str): Path to system cache directory
        config_file (str, optional): Path to config file

    """
    # Checking file-index content
    with open(file_index, 'r') as fd:
        fi = json.load(fd)
    fi.keys()

    chunks = json.load(open(chunks, 'r'))
    chunk_names = list(chunks.keys())
    for chunk in chunk_names:
        temp_file = os.path.join(system_cache_dir, chunk+"_temp.txt")
        temp_file2 = os.path.join(system_cache_dir, chunk+"_temp2.txt")
        file_names = chunks[chunk]['files']
        f1 = open(temp_file, 'w')
        f2 = open(temp_file2, 'w')
        for file_name in file_names:
            f1.write(os.path.join(video_location, file_name)+'\n')
            f2.write(
              os.path.join(system_cache_dir, file_name.split('/')[-1])+'\n')
        f1.close()
        f2.close()
