"""Entry point module: design-chunks

Implements the entry-point by using Python or any other languages.
"""

import argparse
import json
import os


def entry_point(file_index, activity_index, output, nb_videos_per_chunk):
    """Method to complete: you have to raise an exception if an error occured
    in the program.

    Given a file index and an activity index, produce a chunks file that is
    suitable for the system.

    Args:
        file_index (str): Path to file index json file for test set
        activity_index (str): Path to activity index json file for test set
        output (str): Path to save chunks file
        nb_video_per_chunk (int): Number of videos in the chunk

    """
    activities = json.load(open(activity_index, 'r'))
    file_ind = json.load(open(file_index, 'r'))
    activities = list(activities.keys())
    files = [file_ind[f]['filename'] for f in list(file_ind.keys())]
    chunk_dict = {}
    nb_videos_per_chunk = 14
    nChunks = len(files)/nb_videos_per_chunk
    if (len(files) % nb_videos_per_chunk != 0):
        nChunks += 1
    counter = 0
    for i in range(int(nChunks)):
        key_name = 'Chunk%d' % (i)
        chunk_dict[key_name] = {}
        chunk_dict[key_name]['activities'] = activities
        if counter+nb_videos_per_chunk < len(files):
            chunk_dict[key_name]['files'] = \
              files[counter:counter + nb_videos_per_chunk]
        else:
            chunk_dict[key_name]['files'] = files[counter:]
        counter += nb_videos_per_chunk
    json.dump(chunk_dict, open(output, 'w'))
