"""Actev module: experiment-init

Actev modules are used to parse actev commands in order to get arguments
before calling associated entry point methods to execute systems.

Warning: this file should not be modified: see src/entry_points to add your
source code.
"""

from diva_evaluation_cli.bin.commands.actev_command import ActevCommand
from diva_evaluation_cli.bin.private_src.entry_points.actev_experiment_init \
    import before_entry_point
from diva_evaluation_cli.src.entry_points.actev_experiment_init import \
    entry_point


class ActevExperimentInit(ActevCommand):
    """Start servers, starts cluster, etc.

    Command args:
        * file-index or f:       path to file index json file for test set
        * activity-index or a:   path to activity index json file for test set
        * chunks or c:           path to chunks json file
        * video-location or v:   path to videos content
        * system-cache-dir or s: path to system cache directory
        * config-file or C:      path to config file
    """

    def __init__(self):
        super(ActevExperimentInit, self).__init__(
            'experiment-init', entry_point,
            before_entry_point=before_entry_point)

    def cli_parser(self, arg_parser):
        """Configure the description and the arguments (positional and
        optional) to parse.

        Args:
            arg_parser(:obj:`ArgParser`): Python arg parser to describe how
                to parse the command

        """
        arg_parser.description = "Start servers, starts cluster, etc."
        required_named = arg_parser.add_argument_group(
            'required named arguments')

        required_named.add_argument("-f", "--file-index",
                                    help="path to file index json file",
                                    required=True)
        required_named.add_argument("-a", "--activity-index",
                                    help="path to activity index json file",
                                    required=True)
        required_named.add_argument("-c", "--chunks",
                                    help="path to chunks json file",
                                    required=True)
        required_named.add_argument("-v", "--video-location",
                                    help="path to videos content",
                                    required=True)
        required_named.add_argument("-s", "--system-cache-dir",
                                    help="path to system cache directory",
                                    required=True)
        arg_parser.add_argument("-C", "--config-file",
                                help="path to config file")
        arg_parser.add_argument("--prepare-proposal-outputs",
                                help="If True, the system will retain \
                                proposal output information during \
                                execution and output the proposals \
                                during merge_chunks", action="store_true",
                                default=False)
        arg_parser.add_argument("--prepare-localization-outputs",
                                help="If True, the system will retain \
                                spatial localization output information \
                                during execution and output the proposals \
                                during merge_chunks", action="store_true",
                                default=False)
        arg_parser.set_defaults(func=ActevExperimentInit.command, object=self)
