"""
SOURCE

"""
import json
import os

class StatusFactory():

    @staticmethod
    def generateStatus(command, status, args):
        """ Generate a dictionary inside a json file containing status of the commands
        """
        from diva_evaluation_cli.bin.cli import public_subcommands
        
        status_id = 0
        path = os.path.dirname(__file__)
        status_log = os.path.join(path, './command_history.json')
        json_status = {}

        if not os.path.isfile(status_log) or os.stat(status_log).st_size == 0:
            for subcommand in public_subcommands:
                json_status[subcommand.command] = [{'status': 'not defined', 'id': status_id, 'args': None}]
                status_id += 1
            json_status['id'] = status_id
        else:    
            with open(status_log, 'r') as f:
                json_status = json.load(f)
                if command in public_subcommands:
                    json_status['id'] += 1
                    json_status[command.command].append({'status': status, 'id': json_status['id'], 'args': args})
        
        with open(status_log, 'w+') as f:
            json.dump(json_status, f)

