"""
USAGE

ActEV reset-chunk 
Description
-----------
Delete all cached information for ChunkID so that the chunk can be re-run.

Args
----
chunk-id or i: chunk id

Warning: this file should not be modified: see src/entry_points to add your source code.
"""
import logging

from diva_evaluation_cli.bin.actev_command import ActevCommand
from diva_evaluation_cli.src.entry_points.actev_reset_chunk import entry_point


class ActevResetChunk(ActevCommand):

    def __init__(self):
        super(ActevResetChunk, self).__init__('reset-chunk', entry_point)

    def cli_parser(self, arg_parser):
        """ Configure the description and the arguments (positional and optional) to parse.

        @param arg_parser: python arg parser to describe how to parse the command
        """
        arg_parser.description = "Delete all cached information"
        required_named = arg_parser.add_argument_group('required named arguments')

        required_named.add_argument("-i", "--chunk_id", help="chunk id", required=True)
        arg_parser.set_defaults(func=ActevResetChunk.command, object=self)
