"""
USAGE

ActEV design-chunks 
Description
-----------
Given a file index and an activity index, produce a chunks file that is suitable for the system.

Args
----
file-index or f:         path to file index json file for test set
activity-index or a:     path to activity index json file for test set
output or o:             path to save chunks file
nb_video-per-chunk or n: number of videos in the chunk

Warning: this file should not be modified: see src/entry_points to add your source code.
"""
from diva_evaluation_cli.bin.actev_command import ActevCommand
from diva_evaluation_cli.src.entry_points.actev_design_chunks import entry_point


class ActevDesignChunks(ActevCommand):

    def __init__(self):
        super(ActevDesignChunks, self).__init__('design-chunks', entry_point)

    def cli_parser(self, arg_parser):
        """ Configure the description and the arguments (positional and optional) to parse.

        @param arg_parser: python arg parser to describe how to parse the command
        """
        arg_parser.description = "Produce a chunks file that is suitable for the system"
        required_named = arg_parser.add_argument_group('required named arguments')

        required_named.add_argument("-f", "--file_index", help="path to file index json file", required=True)
        required_named.add_argument("-a", "--activity_index", help="path to activity index json file", required=True)
        required_named.add_argument("-o", "--output", help="path to save chunks file", required=True)
        arg_parser.add_argument("-n", "--nb_videos_per_chunk", type=int, help="number of videos in a chunk")
        arg_parser.set_defaults(func=ActevDesignChunks.command, object=self)
