"""
SOURCE


"""
import json
import sys
import os

def get_videos_to_transform_into_frames(file_json, output, frames_directory):
    """ Get videos from a file json file
    """
    videos_id = []
    videos = json.load(open(file_json, 'r'))
    with open(output, "w") as f:
        for video in videos:
            (exists, path_number) = are_frames_exist(video, frames_directory)
            if not exists:
                f.write(video + "," + path_number + "\n")

def are_frames_exist(video, frames_directory):
    """ Check if videos are already transformed into frames
    """
    video_name = video.split('.')[0]
    short_number = video_name.split('_')[2][:4]
    frames_path = os.path.join(frames_directory, short_number, video_name)
    return (os.path.exists(frames_path), short_number)

if __name__ == '__main__':
    if len(sys.argv) == 4:
        get_videos_to_transform_into_frames(sys.argv[1], sys.argv[2], sys.argv[3])
