"""
SOURCE


"""
import json

def design_chunks(file_index_file, activity_index_file, save_path, num_videos_per_chunk):
    """  Merge file_index with activity_index content into different chunks written in a file

    @param file_index_file:       path to file index json file
    @param activity_index_file:   path to activity index json file
    @param save_path:             path to save chunks file
    @param num_videos_per_chunks: number of videos in a chunk
    """
    file_index = json.load(open(file_index_file, 'r'))
    activity_index = json.load(open(activity_index_file, 'r'))
    chunk_dict = {}
    chunk_count = 0
    chunk_prefix = "Chunk"
    all_activities = list(activity_index.keys())

    for index, file_name in enumerate(file_index.keys()):
        if index % num_videos_per_chunk == 0:
            # start a new chunk
            chunk_count += 1
            chunk_name = chunk_prefix + str(chunk_count)
            chunk_dict[chunk_name] = {"activities": all_activities, 
                                    "files": []}
        chunk_name = chunk_prefix + str(chunk_count)
        chunk_dict[chunk_name]["files"].append(file_name)
    with open(save_path, 'w') as f:
        json.dump(chunk_dict, f, indent=2)
