"""
USAGE

ActEV process-chunk 
Description
-----------
Process a chunk.

Args
----
chunk-id or i:           chunk id
system-cache-dir or s:   path to system cache directory

Warning: this file should not be modified: see src/entry_points to add your source code.
"""
import logging

from diva_evaluation_cli.bin.commands.actev_command import ActevCommand
from diva_evaluation_cli.src.entry_points.actev_process_chunk import entry_point


class ActevProcessChunk(ActevCommand):

    def __init__(self):
        super(ActevProcessChunk, self).__init__('process-chunk', entry_point)

    def cli_parser(self, arg_parser):
        """ Configure the description and the arguments (positional and optional) to parse.

        @param arg_parser: python arg parser to describe how to parse the command
        """
        arg_parser.description = "Process a chunk"
        required_named = arg_parser.add_argument_group('required named arguments')

        required_named.add_argument("-i", "--chunk-id", help="chunk id", required=True)
        arg_parser.add_argument("-s", "--system-cache-dir", help="path to system cache directory")
        arg_parser.set_defaults(func=ActevProcessChunk.command, object=self)
