Introduction
============

Consult the documentation to learn more about the CLI: [introduction](doc/introduction.md)

This repository contains:
* an abstract CLI to implement on the `master` branch 
* an implementation example on the branch `baseline_system_master`. 

You should fork the project and use the `master` branch in order to implement the entry point methods and get the updates.

Installation
============

Get the CLI
-----------

**Requirements: python3.X**

Clone the repository:
```
git clone https://gitlab.kitware.com/alexandreB/diva_evaluation_cli.git
```

Automatic installation
----------------------

* Go into the clone of this repository:

```
$ cd diva_evaluation_cli
```

* Execute the following script:

```
$ diva_evaluation_cli/bin/install.sh
```

Manual installation
-------------------

### Create an editable package

In order to test your code with the CLI, you need to create a python package of the project.
An editable package is the best option to avoid to package the project at each modification of the code.

* Go into the clone of this repository:

```
$ cd diva_evaluation_cli
```

* Run the following command to install the CLI: 

```
$ python3 -m pip install -e . --user
```

**Note: if you are using a python virtual environment, remove the `--user` option from the command.**

### Configure the PATH variable

* Check that the $PATH environment variable contains `~/.local/bin`:

```
$ echo $PATH
``` 

* If it is not the case, add it to the path:

```
$ PATH="${PATH}:~/.local/bin"
$ export $PATH
```

**Note: add these lines to your bashrc and source it to always have the right PATH.**

Test the installation
---------------------

Run the following command:

```
$ actev
```

You should be able to see the available subcommands.


Usage
=====

Command line
------------

Run the following command to obtain help with the CLI:

```
$ actev -h
```

Documentation
-------------

Consult the documentation to have information: [cli](doc/cli.md)


Development
===========

The cli components are included in the `bin` directory, you do not have to modify it. 
To add your code, you simply have to implement the methods in `src/entry_points`. 

We suggest you to call your scripts in the entry point methods and store them in `src`. 
More information about the development and the update of the CLI here: [development](doc/development.md)

