import abc
import logging

class ActevCommand():
    """ Abstract class that represents an actev command.
    """
    __metaclass__ = abc.ABCMeta

    def __init__(self, command, entry_point):
        """ 
        @param command: string representing the name of the command
        """
        self.command = command
        self.entry_point = entry_point

    @abc.abstractmethod
    def cli_parser(self, arg_parser):
        """ Configure the description and the arguments (positional and optional) to parse.

        @param arg_parser: python arg parser to describe how to parse the command
        """ 
        return

    def command(self, args):
        """ Gets arguments and passe them to an entry point. Catch the exception occured.

        @param args: list of arguments passed during the command call
        """
        del args.__dict__['object']
        del args.__dict__['func']
        try:
            self.entry_point(**args.__dict__)
            logging.info("%s done" % self.command)
        except:
            logging.exception("Issue during %s" % self.command)
            raise
    
