Installation
============

Get the CLI
-----------

Clone the repository:
```
git clone https://gitlab.kitware.com/alexandreB/diva_evaluation_cli.git
```

Automatic installation
----------------------

Go into the project directory and execute `install.sh`:

```
bin/install.sh
```

Manual installation
-------------------

### Create an editable package

In order to test your code with the CLI, you need to create a python package of the project.
An editable package is the best option to avoid to package the project at each modification of the code.

Go into the project directory and run the following command to install the CLI: 
```
python -m pip install -e . --user
```

### Configure the PATH variable

Check that the $PATH environment variable contains `~/.local/bin`:
```
echo $PATH
``` 

If it is not the case, add it to the path:
```
PATH="${PATH}:~/.local/bin"
```

Test the installation
---------------------

Run the following command:

```
actev
```

You should be able to see the available subcommands.


Usage
=====

Get the existing commands
-------------------------

```
actev -h
```

Get system
-------------

```
actev get-system -h 
```

### Docker

Generic command:

```
actev get-system docker -u <docker image url>
```

With username and password: 

```
actev get-system docker -u <docker image url> -U <username> -p <password>
```

:warning: if your password starts with *-* as in this example: `-9r45ijFo0`, you should write `--password=-9r45ijFo0` instead of `-p -9r45ijFo0`. Otherwise, the value will be interpreted as an argument to parse.

Example:

```
actev get-system docker -u gitlab.kitware.com:4567/diva-baseline/diva-baseline:eval_cli
```

### Git

Generic command:

```
actev get-system git -u <git repository>
```

With username and password: 

```
actev get-system git -u <git repository url> -U <username> -p <password>
```

With a token: 

```
actev get-system git -u <git repository url> -t <token>
```

Store the system in a specific directory:

```
actev get-system git -u <git repository url> ... -l <location>
```

:information_source: You can also directly add your credentials inside the url.

:warning: if your password or token starts with *-* as in this example: `-9r45ijFo0`, you should write `--password=-9r45ijFo0` instead of `-p -9r45ijFo0`. Otherwise, the value will be interpreted as an argument to parse.


Example:

```
actev get-system git -u https://gitlab.kitware.com/alexandreB/diva_evaluation_cli.git -l /tmp
```

### Other (web resources as a tar file)


Generic command:

```
actev get-system other -u <web resource url>
```

With username and password: 

```
actev get-system other -u <web resource url> -U <username> -p <password>
```

With a token: 

```
actev get-system git -u <web resource url> -t <token>
```

Store the system in a specific directory:

```
actev get-system git -u <web resource url> ... -l <location>
```

:information_source: You can also directly add your credentials inside the url.

:warning: if your password or token starts with *-* as in this example: `-9r45ijFo0`, you should write `--password=-9r45ijFo0` instead of `-p -9r45ijFo0`. Otherwise, the value will be interpreted as an argument to parse.


Example:

```
actev get-system other -u https://path/to/file.tgz -l /tmp
```

System setup
------------

```
actev system-setup
```

Design chunks
-------------
Generic command:

```
actev design-chunks -f <path to file.json> -a <path to activity.json> -o <path to output result> -n <number of video per chunks> 
```

Example:

```
actev design-chunks -f ~/file.json -a ~/activity.json -o ~/chunks.json -n 96
```

Experiment initialization
-------------------------
Generic command:

```
actev experiment-init -f <path to file.json> -a <path to activity.json> -c <path to chunks.json > -v <path to frames directory> -s <path to system cache directory>
```

Example:

```
actev experiment-init -f ~/file.json -a ~/activity.json -c ~/chunks.json -v ~/frames_location/ -s ~/system_cache_dir/
```

Pre-process a chunk
-------------------
Generic command:

```
actev pre-process-chunk -i <id of a chunk>
```

Example:

```
actev pre-process-chunk -i Chunk1
```

Process a chunk
---------------
Generic command:

```
actev process-chunk -i <id of a chunk>
```

Example:

```
actev process-chunk -i Chunk1
```

Post process a chunk
--------------------
Generic command:

```
actev post-process-chunk -i <id of a chunk>
```

Example:

```
actev post-process-chunk -i Chunk1
```

Reset a chunk
-------------
Generic command:

```
actev reset-chunk -i <id of a chunk>
```

Example:

```
actev reset-chunk -i Chunk1
```

Merge chunks
------------
Generic command:

```
actev merge-chunks -o <path to merging result> -c <path to chunks file generated during merging> -r ~/<result directory> -i <list of chunk ids>
```

Example:

```
actev merge-chunks -o ~/output.json -c ~/merging_chunks.json -r ~/system_cache_dir/ -i Chunk1 Chunk2 
```

Experiment cleanup
------------------

```
actev experiment-cleanup
```

Documentation
=============

Documentation is available here [doc](doc)

Development
===========

The cli components are included in the `bin` directory, you do not have to modify it. 
To add your code, you simply have to implement the methods in `src/entry_points`. 

We suggest you to call your scripts in the entry point methods and store them in `src`. 
You have an example in this repository to help you in the package creation.

