This document describes how to generate a set of JSON formatted input/index files for the DIVA and ActEV evaluations. Source dataset files are expected to be in Kitware's KPF format.

## Installation

These script currently require the following:
Python3, as well as pandas and pyaml. Install them using pip or conda:


```
< pip | conda > install pandas pyaml
```

## Usages:

### Generate an index file
```
python3 ./scripts/generate_video_index_file.py -f filelist.txt -cm m1.camera_status.txt -vm m1.clip.txt -vp videos_paths.txt -o file-index.json

```

### Generate the activity index and the reference annotations
```
python3 kpf_to_json_avi_py3.py -f file-index.json -d annotations/ -o outputdir -a activity.txt -p activitymapping.txt -j objind.txt -t objectmap.txt
```

## Input files

Prepare input files for 'kpf_to_json_py3.py':
  * a filelist.txt (newline separated list of filenames (without extensions)) – This is the list of files that will be included in the output dataset
  * a camera_status.txt file, provided by kitware, which maps cameras and cameras metadata
  * a m1.clip.txt file, provided by kitware, that maps videos and videos metadata
  * a videos_paths.txt file, that contains a list of file paths to find the videos


Prepare input files for 'kpf_to_json_py3.py':
  * a file-index.json, generated by the previous script (a JSON file whose keys are all the file names)
  * an activity.txt (newline separated list of activities) – This is the list of activities included in the output dataset
  * an object-index.txt (newline separated list of objects) – This is the list of objects included in the output dataset
  * an objecttypemap.csv file (comma-separated file with source object type, and destination object type to be included in the "objectTypeMap" for every activity)
  * an activitymapping.txt, that maps the activities in the KPF files to the names in our activity list
  * an annotations/ directory containing the kitware annotation files


### 1.1 file-list.txt
```
$ head file-list.txt
VIRAT_S_000200_04_000937_001443.mp4
VIRAT_S_000200_06_001693_001824.mp4
VIRAT_S_000202_01_001334_001520.mp4
```


### 1.2 camera_status.txt

```
$ m1.camera_status.txt
CameraID|ReleaseStatus|IntExt|EOIR|Model|Resolution|Notes
G299|public|int|EO_NIR|wasp|1920x1080|
G300|public|ext|EO|shopkeeper PTZ|1920x1080|
G301|public|ext|EO|shopkeeper PTZ|1920x1080|
```

### 1.3 m1.clip.txt

```
$ head m1.clip.txt
ScenarioRecordingID|ClipID|ClipFileName|CameraID|LocationName|DateTime|Date|BeginTime|EndTime|FrameCount
2018-03-04.10-55-00.11-00-00|2018-03-04.10-58-39.10-59-59.hospital.G476|2018-03-04.10-58-39.10-59-59.hospital.G476.avi|G476|hospital|2018-03-04.10-58-39.10-59-59|2018-03-04|10-58-39|10-59-59|2402
2018-03-04.10-50-00.10-55-00|2018-03-04.10-54-11.10-55-00.admin.G335|2018-03-04.10-54-11.10-55-00.admin.G335.avi|G335|admin|2018-03-04.10-54-11.10-55-00|2018-03-04|10-54-11|10-55-00|1477
2018-03-04.10-50-00.10-55-00|2018-03-04.10-54-17.10-55-00.admin.G337|2018-03-04.10-54-17.10-55-00.admin.G337.avi|G337|admin|2018-03-04.10-54-17.10-55-00|2018-03-04|10-54-17|10-55-00|1290
```


### 1.4 videos_paths.txt

```
$ head videos_paths.txt
./drive/drive/2018-03-09/09/2018-03-09.09-10-01.09-15-01.admin.G329.avi
./drive/drive/2018-03-09/09/2018-03-09.09-01-27.09-05-07.admin.G335.avi
./drive/drive/2018-03-09/09/2018-03-09.09-10-01.09-15-01.bus.G327.avi
./drive/drive/2018-03-09/09/2018-03-09.09-01-36.09-05-04.admin.G337.avi
./drive/drive/2018-03-09/09/2018-03-09.09-10-04.09-15-04.admin.G337.avi
./drive/drive/2018-03-09/09/2018-03-09.09-01-38.09-05-00.admin.G334.avi
```

### 2.1 file-index.json

```
$ head file-index.json
{
    "2018-03-08.10-55-00.11-00-00.admin.G326.avi": {
        "begin_time": "10-55-00",
        "camera_id": "G326",
        "camera_type": "EO_NIR",
        "date": "2018-03-08",
        "end_time": "11-00-00",
    ...
```



### 2.2 activity.txt

```
$head VIRAT-V1_leaderboard-activity-index.txt
Closing
Closing_Trunk
Entering
Exiting
Interacts
Loading
Open_Trunk
Opening
Pull
Riding
```


### 2.3 object-index.txt

```
$head VIRAT-V1_EVAL-object-index.txt
Construction_Vehicle
Person
Vehicle
```


### 2.4 objecttypemap.csv

```
$head VIRAT-V1_EVAL-objecttypemap.csv
Construction_Vehicle,*Vehicle*
Vehicle,*Vehicle*
```

### 2.5 activitymapping.txt

**First column:** Kitware's activity IDs,
**Second column:** NIST's activity id,
```
$head activitymapping.txt
Close_Trunk,Closing_Trunk
Close_Vehicle_Door,person_closes_vehicle_door
Embrace_Interaction,person_person_embrace
Enter_Facility,person_enters_through_structure
Exit_Facility,person_exits_through_structure

```


### 2.6 annotations/ directory

Directory containing yml annotation files

```
find ../kitware | head
../kitware
../kitware/2018-03-15
../kitware/2018-03-15/10
../kitware/2018-03-15/10/2018-03-15.10-35-01.10-40-01.bus.G333.geom.yml
../kitware/2018-03-15/10/2018-03-15.10-35-01.10-40-01.bus.G508.geom.yml
../kitware/2018-03-15/10/2018-03-15.10-40-00.10-45-00.admin.G335.activities.yml
../kitware/2018-03-15/10/2018-03-15.10-40-03.10-45-03.bus.G340.activities.yml
../kitware/2018-03-15/10/2018-03-15.10-35-01.10-40-01.bus.G505.types.yml
../kitware/2018-03-15/10/2018-03-15.10-40-00.10-45-00.bus.G506.activities.yml
../kitware/2018-03-15/10/2018-03-15.10-35-00.10-40-00.school.G424.geom.yml
```


Author: David Joy, Maxime Hubert

Last Modifications: 2019-07-24 Mon 16:55
Created: 2018-07-09 Mon 12:22
