#!/bin/sh

err_exit(){ 
    echo Error: $@  Aborting
    exit 1
}

echo "This script builds a set of ActEV Scoring JSONs beginnig with a list of files.  The primary outputs of this script are:"
echo "    file-index.json"
echo "    activity-index.json"
echo "    activities.json"
echo "" 
echo "Step1: Build the file-index.json.  This step as written requires a metadata dataset that only the T&E has. If the file"
echo "       previously exists, (for instance the data set is built outside of NIST), this step is skipped"
echo ""
echo "Step 2: Build the activities.json and activity-index.json"
echo "" 

if [ ! -f file-index.json ] ; then
    echo "Starting Step 1: Build file-index.json"

    if [ ! -f files-list.txt ] ; then err_exit "files-list.txt: is required" ; fi
    if [ ! -f ../../recording-metadata/m1/m1.camera_status.txt ] ; then err_exit "../../recording-metadata/m1/m1.camera_status.txt: is required" ; fi
    if [ ! -f ../../recording-metadata/m1/m1.clip.txt ] ; then err_exit "../../recording-metadata/m1/m1.clip.txt: is required" ; fi
    if [ ! -f videos_paths.txt ] ; then err_exit "videos_paths.txt: is required" ; fi
    
    python3 ../../scripts/generate_video_index_file.py \
	-f files-list.txt -cm ../../recording-metadata/m1/m1.camera_status.txt -vm ../../recording-metadata/m1/m1.clip.txt -vp videos_paths.txt \
        -o file-index.json 2>&1 | tee Log.step1.txt

    if [ ! -f file-index.json ] ; then err_exit "File file-index.json not generated"; fi
else
    echo "Skipping Step 1: file-index.json already exisits"
fi

echo "Starting Step 2: Building activities.json and activity-index.json"

if [ ! -f activity.txt ] ; then err_exit "activity.txt: is required" ; fi
if [ ! -f activitymapping.txt ] ; then err_exit "activitymapping.txt: is required" ; fi
if [ ! -f objind.txt ] ; then err_exit "objind.txt: is required" ; fi
if [ ! -f objectmap.txt ] ; then err_exit "objectmap.txt: is required" ; fi

python3 ../../scripts/kpf_to_json_py3.py -f file-index.json -d ../../../meva-data-repo/annotation/DIVA-phase-2/MEVA \
    -o . -a activity.txt -p activitymapping.txt -j objind.txt -t objectmap.txt | tee Log.step2.txt

echo ""
echo "Counting Instances: See Log.instancecounts.txt"
grep '"activity"'  activities.json | awk '{print $2}' | sed 's/[,"]//g' | sort | uniq -c | tee Log.instancecounts.txt

