/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkVectorText.cxx
  Language:  C++
  Date:      $Date$
  Version:   $Revision$


Copyright (c) 1993-1996 Ken Martin, Will Schroeder, Bill Lorensen.

This software is copyrighted by Ken Martin, Will Schroeder and Bill Lorensen.
The following terms apply to all files associated with the software unless
explicitly disclaimed in individual files. This copyright specifically does
not apply to the related textbook "The Visualization Toolkit" ISBN
013199837-4 published by Prentice Hall which is covered by its own copyright.

The authors hereby grant permission to use, copy, and distribute this
software and its documentation for any purpose, provided that existing
copyright notices are retained in all copies and that this notice is included
verbatim in any distributions. Additionally, the authors grant permission to
modify this software and its documentation for any purpose, provided that
such modifications are not distributed without the explicit consent of the
authors and that existing copyright notices are retained in all copies. Some
of the algorithms implemented by this software are patented, observe all
applicable patent law.

IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS PROVIDED ON AN
"AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO OBLIGATION TO PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.


=========================================================================*/
#include "vtkVectorText.h"
#include "vtkFloatPoints.h"
#include "vtkTransformPolyFilter.h"
#include "vtkPolyReader.h"

char *VTK_VECTOR_TEXT_33 = "36 0.189286 "
"0.14286 -0.35786 0.13000 -0.35643 0.11857 -0.35214 0.16143 -0.35071 0.10786 -0.34429 "
"0.17643 -0.33571 0.09786 -0.33000 0.17929 -0.32714 0.18214 -0.31286 0.09500 -0.30429 "
"0.10214 -0.28857 0.17500 -0.28857 0.16571 -0.27786 0.11429 -0.27643 0.12571 -0.27071 "
"0.14429 -0.26929 0.14286 -0.22500 0.13643 -0.22143 0.15214 -0.19857 0.12786 -0.17000 "
"0.16929 0.00286 0.11500 0.01571 0.11214 0.03571 0.10357 0.08286 0.18357 0.08857 "
"0.10214 0.09714 0.18643 0.11286 0.10071 0.12000 0.18786 0.13000 0.09929 0.15143 "
"0.18929 0.15286 0.10500 0.17000 0.18214 0.17000 0.17429 0.17786 0.12143 0.18500 "
"0.14143 0.18929 32 6 3 9 7 3 "
"5 1 0 4 0 3 4 9 3 10 "
"1 4 2 3 6 4 11 10 3 10 11 "
"12 13 10 15 3 7 8 13 15 14 "
"15 10 12 11 3 8 18 19 17 18 17 "
"16 19 20 21 20 19 18 22 24 23 "
"22 21 20 24 25 23 27 25 26 26 25 "
"24 24 22 20 29 27 28 27 26 28 "
"32 33 30 29 28 31 33 28 30 31 35 "
"34 35 31 33 31 28 33 "
;

char *VTK_VECTOR_TEXT_34 = "205 0.249286 "
"0.11000 -0.01214 0.21429 -0.01071 0.10786 -0.00857 0.21500 -0.00571 0.21357 -0.00429 "
"0.21643 -0.00429 0.11071 -0.00286 0.21214 -0.00286 0.10786 -0.00143 0.11214 -0.00143 "
"0.21643 -0.00143 0.10643 0.00000 0.21786 0.00000 0.21786 0.00286 0.10643 0.00429 "
"0.11214 0.00429 0.21214 0.00429 0.21929 0.00429 0.10500 0.00571 0.11357 0.00571 "
"0.21071 0.00571 0.21929 0.00857 0.22071 0.01000 0.10500 0.01143 0.11357 0.01143 "
"0.21071 0.01143 0.10357 0.01286 0.11500 0.01286 0.20929 0.01286 0.22071 0.01429 "
"0.22214 0.01571 0.10357 0.01714 0.10214 0.01857 0.11500 0.01857 0.11643 0.02000 "
"0.20929 0.02000 0.22214 0.02000 0.20786 0.02143 0.22357 0.02143 0.10214 0.02286 "
"0.10071 0.02429 0.11643 0.02571 0.20786 0.02571 0.22357 0.02571 0.11786 0.02714 "
"0.20643 0.02714 0.22500 0.02714 0.10071 0.02857 0.09929 0.03000 0.22500 0.03143 "
"0.09929 0.03286 0.11786 0.03286 0.20643 0.03286 0.22643 0.03286 0.09786 0.03429 "
"0.11929 0.03429 0.20500 0.03429 0.22643 0.03714 0.09786 0.03857 0.22786 0.03857 "
"0.09643 0.04000 0.11929 0.04000 0.20500 0.04000 0.12071 0.04143 0.20357 0.04143 "
"0.22786 0.04286 0.09643 0.04429 0.22929 0.04429 0.09500 0.04571 0.20357 0.04571 "
"0.12071 0.04714 0.20214 0.04714 0.12214 0.04857 0.22929 0.04857 0.09500 0.05000 "
"0.23071 0.05000 0.09357 0.05143 0.12214 0.05286 0.20214 0.05286 0.12357 0.05429 "
"0.20071 0.05429 0.23071 0.05429 0.09357 0.05571 0.23214 0.05571 0.09214 0.05714 "
"0.12357 0.05857 0.20071 0.05857 0.12500 0.06000 0.19929 0.06000 0.23214 0.06000 "
"0.09214 0.06143 0.23357 0.06143 0.09071 0.06286 0.12500 0.06429 0.12643 0.06571 "
"0.19929 0.06571 0.23357 0.06571 0.09071 0.06714 0.19786 0.06714 0.23500 0.06714 "
"0.08929 0.06857 0.23500 0.07000 0.12643 0.07143 0.19786 0.07143 0.23643 0.07143 "
"0.08929 0.07286 0.12786 0.07286 0.19643 0.07286 0.08786 0.07429 0.23643 0.07571 "
"0.12786 0.07714 0.19643 0.07714 0.23786 0.07714 0.08786 0.07857 0.12929 0.07857 "
"0.19500 0.07857 0.08643 0.08000 0.23786 0.08000 0.23929 0.08143 0.12929 0.08286 "
"0.19500 0.08286 0.08643 0.08429 0.13071 0.08429 0.19357 0.08429 0.08500 0.08571 "
"0.23929 0.08571 0.24071 0.08714 0.08500 0.08857 0.13071 0.08857 0.19357 0.08857 "
"0.08357 0.09000 0.13214 0.09000 0.19214 0.09000 0.24071 0.09000 0.24214 0.09143 "
"0.08357 0.09429 0.13214 0.09429 0.19214 0.09429 0.24214 0.09429 0.08214 0.09571 "
"0.13357 0.09571 0.19071 0.09571 0.24357 0.09571 0.08214 0.09857 0.13357 0.09857 "
"0.19071 0.09857 0.24357 0.09857 0.08071 0.10000 0.13500 0.10000 0.24500 0.10000 "
"0.18929 0.10143 0.08071 0.10286 0.18786 0.10286 0.24500 0.10286 0.13500 0.10429 "
"0.07929 0.10571 0.13643 0.10571 0.18786 0.10571 0.24643 0.10571 0.07786 0.10857 "
"0.13643 0.10857 0.18643 0.10857 0.24786 0.10857 0.24929 0.11000 0.07643 0.11143 "
"0.13786 0.11143 0.18500 0.11143 0.24929 0.11286 0.07500 0.11429 0.14071 0.11429 "
"0.24643 0.11571 0.24500 0.11857 0.19214 0.12000 0.08214 0.12286 0.19500 0.12571 "
"0.23929 0.12714 0.08500 0.12857 0.19929 0.13000 0.23786 0.13000 0.19929 0.13143 "
"0.08929 0.13286 0.12786 0.13286 0.08929 0.13429 0.23500 0.13429 0.20357 0.13571 "
"0.12357 0.13714 0.20357 0.13714 0.12357 0.13857 0.09500 0.14000 0.23214 0.14000 "
"0.09500 0.14143 0.20786 0.14143 0.11929 0.14286 0.20786 0.14286 0.11929 0.14429 "
"0.22786 0.14429 0.22786 0.14571 0.10214 0.14857 0.10214 0.15000 0.11357 0.15000 "
"0.22357 0.15000 0.11357 0.15143 0.10857 0.15643 0.21857 0.15643 0.22000 0.15643 201 6 8 2 1 "
"3 4 6 2 0 5 4 3 8 14 11 4 10 7 4 5 10 9 8 6 16 "
"7 13 8 9 14 13 7 10 12 13 10 15 14 9 25 20 21 17 21 16 17 "
"16 13 16 21 20 31 23 24 24 23 18 14 24 18 19 24 14 19 14 15 23 "
"31 26 29 25 21 22 29 21 25 29 28 29 35 28 35 29 36 39 31 33 35 "
"42 37 33 31 24 27 33 24 31 39 32 42 35 36 30 36 29 42 36 43 47 "
"39 41 39 47 40 41 39 33 34 41 33 42 52 45 38 43 36 66 58 61 52 "
"42 43 62 52 57 52 43 49 46 49 43 50 58 54 47 50 48 58 50 51 51 "
"47 41 44 51 41 52 62 56 52 49 57 50 47 51 74 66 70 69 62 65 53 "
"57 49 58 66 60 58 51 61 78 69 73 55 61 51 62 69 64 82 74 70 62 "
"57 65 59 65 57 66 74 68 66 61 70 69 78 71 63 70 61 90 82 77 69 "
"65 73 67 73 65 74 82 76 86 78 81 95 86 89 82 70 77 72 77 70 78 "
"86 80 97 90 85 78 73 81 75 81 73 82 90 84 79 85 77 86 95 88 105 "
"97 93 86 81 89 83 89 81 90 97 92 90 77 85 103 95 89 87 93 85 111 "
"103 89 113 105 102 95 103 98 91 96 89 97 105 100 97 85 93 120 111 101 111 "
"89 96 99 101 96 121 113 102 103 111 107 105 113 108 94 102 93 105 93 102 129 "
"120 101 111 96 101 104 109 101 127 121 102 106 110 102 111 120 115 113 121 116 129 "
"101 109 112 117 109 137 129 117 143 135 119 127 110 119 114 119 110 120 129 123 135 "
"127 119 127 102 110 129 109 117 118 125 117 145 137 117 127 135 130 121 127 124 122 "
"128 119 129 137 132 150 117 125 126 133 125 151 143 119 155 128 136 131 136 128 150 "
"145 117 134 138 133 150 125 133 155 119 128 155 151 119 135 143 139 140 144 136 137 "
"145 141 161 170 172 142 146 138 161 157 133 143 151 147 157 150 133 149 153 146 148 "
"154 144 150 157 152 161 153 170 159 155 136 164 144 154 156 160 154 166 161 172 164 "
"159 136 164 154 173 168 164 173 161 138 146 170 162 163 170 163 167 162 170 158 164 "
"136 144 161 133 138 180 176 154 179 177 170 171 179 170 172 170 174 161 146 153 153 "
"158 170 181 160 165 175 178 179 170 177 174 179 178 184 182 180 188 176 173 154 188 "
"180 154 181 188 154 175 179 171 178 183 184 181 154 160 191 184 195 181 165 169 186 "
"184 191 185 188 181 190 188 197 198 197 199 192 185 187 189 195 184 189 184 183 188 "
"185 192 199 188 192 197 188 199 202 198 201 193 195 200 193 200 203 198 199 201 200 "
"195 196 199 192 194 200 204 203 193 191 195 "
;

char *VTK_VECTOR_TEXT_35 = "78 0.395714 "
"0.20857 -0.32929 0.23714 -0.32929 0.10571 -0.32643 0.13429 -0.32643 0.20786 -0.32429 "
"0.23929 -0.32000 0.10929 -0.31000 0.24214 -0.30857 0.24357 -0.30143 0.24500 -0.29571 "
"0.21643 -0.29143 0.24643 -0.28857 0.24929 -0.27714 0.25071 -0.27000 0.25214 -0.26429 "
"0.15214 -0.25857 0.25357 -0.25714 0.25643 -0.24571 0.25786 -0.23857 0.25929 -0.23286 "
"0.26071 -0.22571 0.26357 -0.21429 0.26500 -0.20714 0.16643 -0.20143 0.26786 -0.19571 "
"0.26929 -0.18857 0.14357 -0.18429 0.24071 -0.18429 0.27071 -0.18286 0.07214 -0.17857 "
"0.14286 -0.17929 0.17286 -0.17929 0.24000 -0.17929 0.27286 -0.17929 0.35143 -0.17929 "
"0.07643 -0.17000 0.07929 -0.16286 0.35929 -0.15429 0.08286 -0.15214 0.15000 -0.15214 "
"0.17929 -0.15143 0.25143 -0.15214 0.28214 -0.15143 0.25357 -0.14714 0.15357 -0.14571 "
"0.15786 -0.12857 0.28929 -0.12286 0.29071 -0.11857 0.26500 -0.10143 0.27071 -0.08000 "
"0.30214 -0.07286 0.30357 -0.06857 0.18071 -0.04143 0.21357 -0.02857 0.28500 -0.02286 "
"0.31500 -0.02286 0.18643 -0.01857 0.10857 -0.01786 0.21714 -0.01786 0.28429 -0.01786 "
"0.31714 -0.01786 0.38571 -0.01786 0.12143 0.01357 0.19571 0.01357 0.22857 0.01357 "
"0.32429 0.01357 0.39571 0.01357 0.29357 0.01571 0.22929 0.02143 0.32500 0.02143 "
"0.20071 0.02571 0.22500 0.11571 0.35071 0.12429 0.25929 0.13286 0.32714 0.13643 "
"0.35286 0.13643 0.26000 0.13786 0.23071 0.14000 78 4 0 1 4 5 "
"10 2 3 6 4 1 5 26 6 15 "
"5 7 10 7 8 10 8 9 10 10 16 "
"27 10 9 11 10 12 13 16 17 27 "
"10 11 12 15 6 3 17 18 27 18 19 "
"27 19 20 27 10 13 14 10 14 16 "
"20 21 27 21 22 27 23 26 15 22 24 "
"27 24 25 27 30 26 23 27 25 32 "
"31 39 23 39 30 23 33 41 32 29 30 "
"35 25 28 32 31 32 41 41 33 43 "
"28 33 32 35 30 36 42 33 34 36 30 "
"38 38 30 39 37 42 34 31 40 39 "
"33 42 43 39 40 44 43 46 48 45 44 "
"40 40 31 41 52 45 40 43 42 46 "
"46 47 48 49 51 54 50 49 48 50 48 "
"47 49 50 51 53 56 52 53 52 40 "
"54 55 59 55 54 51 58 56 53 55 60 "
"59 59 60 67 56 63 62 60 61 66 "
"57 56 62 64 59 67 63 56 64 65 60 "
"66 64 56 58 70 63 64 74 67 69 "
"69 67 65 64 58 59 68 70 64 67 60 "
"65 70 68 71 73 77 71 72 74 69 "
"73 71 68 75 74 72 77 73 76 "
;

char *VTK_VECTOR_TEXT_36 = "96 0.403571 "
"0.22571 -0.42071 0.27786 -0.42000 0.27786 -0.36857 0.10857 -0.36500 0.22500 -0.36286 "
"0.31000 -0.36071 0.21714 -0.35929 0.09643 -0.35714 0.33429 -0.35214 0.12071 -0.34571 "
"0.28857 -0.34500 0.27786 -0.34286 0.29571 -0.34357 0.35143 -0.34071 0.13000 -0.33786 "
"0.14714 -0.33786 0.22500 -0.33714 0.30857 -0.33786 0.09500 -0.33286 0.18857 -0.32929 "
"0.36929 -0.32429 0.09786 -0.32286 0.17000 -0.32071 0.33071 -0.31714 0.09929 -0.31286 "
"0.13786 -0.29143 0.34500 -0.29143 0.38929 -0.29000 0.34786 -0.28286 0.09929 -0.26571 "
"0.39643 -0.26571 0.11929 -0.26000 0.39929 -0.25000 0.34929 -0.24714 0.09500 -0.24571 "
"0.40071 -0.23857 0.34357 -0.22571 0.09214 -0.21857 0.33500 -0.21000 0.40357 -0.20286 "
"0.10286 -0.19929 0.40214 -0.19143 0.31143 -0.18643 0.27786 -0.17000 0.22429 -0.16071 "
"0.38786 -0.15286 0.18571 -0.15071 0.15286 -0.13929 0.13000 -0.12643 0.36286 -0.12214 "
"0.10929 -0.10857 0.31286 -0.09071 0.09500 -0.08286 0.27786 -0.08000 0.22500 -0.06857 "
"0.21000 -0.06643 0.08929 -0.06429 0.19000 -0.05929 0.08643 -0.04286 0.15571 -0.04071 "
"0.36714 -0.03643 0.35500 -0.03000 0.37214 -0.02857 0.14214 -0.02571 0.13643 -0.01286 "
"0.37214 -0.00714 0.08643 0.00000 0.36929 0.00286 0.13500 0.02143 0.33500 0.02429 "
"0.09500 0.02857 0.13786 0.03429 0.32500 0.04429 0.14643 0.05429 0.11071 0.06000 "
"0.30429 0.06786 0.36929 0.07000 0.16429 0.07214 0.27786 0.08000 0.28429 0.07929 "
"0.13286 0.08214 0.19000 0.08357 0.22500 0.08429 0.33571 0.08786 0.34571 0.08786 "
"0.16571 0.09786 0.37214 0.10143 0.18143 0.10214 0.36000 0.10357 0.19857 0.10500 "
"0.21286 0.10643 0.27786 0.10714 0.36857 0.10643 0.22500 0.10857 0.22571 0.16357 "
"0.27714 0.16357 98 0 2 "
"4 0 1 2 5 10 2 5 12 10 "
"9 18 7 17 8 23 6 19 15 11 2 "
"10 2 11 16 12 5 17 4 2 16 "
"14 21 9 4 16 6 9 7 3 18 9 "
"21 6 16 19 24 21 14 22 15 19 "
"8 17 5 24 14 15 24 25 29 13 23 "
"8 23 13 20 23 20 26 25 31 29 "
"25 15 22 27 28 26 27 26 20 30 33 "
"28 30 28 27 29 31 34 24 15 25 "
"33 32 36 32 33 30 37 34 31 38 45 "
"42 36 32 35 40 37 31 36 39 38 "
"45 49 42 46 55 47 39 36 35 51 43 "
"42 38 41 45 43 16 11 16 43 44 "
"51 42 49 47 55 48 44 43 51 59 56 "
"52 53 44 51 38 39 41 44 53 54 "
"56 63 58 44 55 46 59 52 50 55 44 "
"54 50 55 57 48 55 50 56 59 63 "
"59 50 57 61 67 69 68 70 66 64 66 "
"58 60 62 61 61 62 65 64 58 63 "
"72 84 75 68 66 64 70 71 74 61 65 "
"67 71 70 68 76 84 72 80 74 73 "
"73 74 71 76 72 69 77 80 73 80 77 "
"85 78 54 53 79 91 78 82 54 78 "
"79 75 83 81 85 77 84 76 88 76 69 "
"67 75 84 83 91 93 82 87 81 89 "
"81 87 85 76 86 88 88 86 92 90 82 "
"93 91 82 78 82 90 89 91 79 83 "
"82 89 81 95 93 91 95 94 93 "
;

char *VTK_VECTOR_TEXT_37 = "112 0.386429 "
"0.30143 -0.36071 0.26857 -0.35786 0.06786 -0.35286 0.11429 -0.35357 0.25571 -0.35357 "
"0.24429 -0.34786 0.33714 -0.34786 0.23286 -0.33929 0.30143 -0.33786 0.28429 -0.33643 "
"0.30857 -0.33643 0.31857 -0.33214 0.27143 -0.33071 0.35929 -0.32857 0.21929 -0.32714 "
"0.33500 -0.31714 0.25071 -0.31000 0.37214 -0.30571 0.20357 -0.30000 0.34214 -0.30000 "
"0.24071 -0.29286 0.37643 -0.29143 0.19929 -0.28571 0.37786 -0.28429 0.23643 -0.28143 "
"0.34357 -0.28000 0.19786 -0.27857 0.23357 -0.27000 0.34214 -0.26571 0.34071 -0.25714 "
"0.19643 -0.24857 0.37929 -0.24429 0.19929 -0.23429 0.33357 -0.23143 0.23500 -0.22857 "
"0.23643 -0.22286 0.37214 -0.22000 0.20929 -0.21000 0.32214 -0.21000 0.24214 -0.20857 "
"0.31429 -0.20071 0.36071 -0.20000 0.25429 -0.19500 0.30000 -0.19071 0.27000 -0.18786 "
"0.29143 -0.18786 0.34143 -0.18071 0.23571 -0.17929 0.32714 -0.17214 0.26000 -0.16786 "
"0.27571 -0.16500 0.29571 -0.16357 0.18429 -0.03214 0.16714 -0.03071 0.15714 -0.02929 "
"0.14143 -0.02500 0.21286 -0.02357 0.12286 -0.01500 0.22714 -0.01500 0.19143 -0.01071 "
"0.16714 -0.00786 0.20429 -0.00643 0.24000 -0.00500 0.15429 -0.00214 0.22071 0.00857 "
"0.09500 0.01143 0.13214 0.01857 0.26071 0.02000 0.22929 0.02286 0.12500 0.03000 "
"0.08500 0.03429 0.23500 0.03857 0.08357 0.04000 0.26929 0.04000 0.11929 0.04571 "
"0.08214 0.04857 0.23786 0.06000 0.23643 0.07000 0.08071 0.07143 0.27071 0.07571 "
"0.11786 0.07857 0.23214 0.08429 0.12071 0.09143 0.25786 0.10143 0.12786 0.10714 "
"0.21929 0.10714 0.09929 0.11143 0.37214 0.11143 0.32786 0.11286 0.23786 0.11857 "
"0.28571 0.11929 0.30000 0.12214 0.32429 0.12214 0.14429 0.12357 0.20000 0.12500 "
"0.11571 0.12929 0.19286 0.12929 0.16000 0.13071 0.18286 0.13214 0.38500 0.13286 "
"0.24857 0.14071 0.13429 0.14214 0.28000 0.14214 0.29000 0.14357 0.29857 0.14500 "
"0.38643 0.14571 0.30857 0.14643 0.32000 0.14786 0.15857 0.14929 0.33143 0.14929 "
"0.18429 0.15071 0.37571 0.15214 112 "
"4 9 5 9 0 8 10 0 6 9 1 "
"0 1 9 4 10 8 0 2 3 88 "
"5 16 7 10 6 11 5 12 16 11 6 "
"15 13 15 6 18 20 22 20 18 14 "
"15 17 19 24 26 22 14 7 16 21 23 "
"25 17 15 13 12 5 9 21 19 17 "
"20 14 16 19 21 25 28 25 23 24 22 "
"20 27 26 24 29 31 33 26 27 30 "
"34 32 30 33 36 38 31 28 23 32 34 "
"37 29 28 31 34 30 27 34 35 37 "
"31 36 33 37 42 47 37 39 42 43 51 "
"45 39 37 35 46 38 41 40 38 46 "
"40 48 43 42 44 49 47 42 49 41 38 "
"36 48 40 46 49 44 50 50 44 45 "
"51 50 45 51 43 48 54 60 55 61 56 "
"64 60 53 52 60 54 53 55 63 57 "
"59 56 61 60 52 59 62 64 58 63 55 "
"60 56 59 52 64 62 68 66 57 63 "
"58 64 56 65 69 70 66 65 57 69 65 "
"66 68 67 71 74 75 72 67 68 62 "
"72 70 69 76 71 73 73 71 67 74 72 "
"69 79 77 76 80 78 75 77 79 81 "
"80 75 74 86 78 80 81 89 85 79 76 "
"73 82 86 80 88 87 92 84 86 82 "
"87 88 3 81 83 89 79 83 81 95 86 "
"84 93 101 95 109 107 92 89 110 94 "
"85 89 94 107 91 92 97 101 93 98 108 "
"97 97 108 101 91 103 90 100 89 90 "
"93 95 84 90 103 102 94 110 96 96 110 "
"98 100 90 102 87 109 92 89 100 110 "
"104 103 91 106 104 91 107 106 91 111 99 "
"105 98 110 108 109 99 111 109 87 99 "
;

char *VTK_VECTOR_TEXT_38 = "145 0.595000 "
"0.21857 -0.35786 0.47429 -0.35786 0.18857 -0.35643 0.46000 -0.35643 0.17857 -0.35500 "
"0.45143 -0.35500 0.17143 -0.35357 0.24286 -0.35357 0.49143 -0.35357 0.15143 -0.34786 "
"0.42857 -0.34786 0.25857 -0.34643 0.27000 -0.34071 0.13429 -0.33929 0.51857 -0.33786 "
"0.28571 -0.33071 0.11429 -0.32500 0.38571 -0.32357 0.30071 -0.31857 0.54000 -0.31929 "
"0.37571 -0.31643 0.26714 -0.31071 0.24000 -0.30929 0.27571 -0.30643 0.09214 -0.30429 "
"0.22714 -0.30500 0.55929 -0.30000 0.21429 -0.29786 0.08500 -0.29143 0.29214 -0.29143 "
"0.20143 -0.28786 0.49000 -0.27929 0.51857 -0.27929 0.33000 -0.27786 0.07786 -0.27571 "
"0.53143 -0.27357 0.57929 -0.27286 0.18500 -0.27000 0.54143 -0.26643 0.07500 -0.26429 "
"0.31214 -0.26143 0.17786 -0.26000 0.07357 -0.25571 0.45000 -0.25643 0.59071 -0.25000 "
"0.56357 -0.24714 0.17071 -0.24571 0.59357 -0.24143 0.42571 -0.23929 0.28357 -0.23429 "
"0.07214 -0.23000 0.57714 -0.23071 0.16500 -0.22714 0.59500 -0.22571 0.59286 -0.22214 "
"0.07929 -0.20571 0.37643 -0.19429 0.16357 -0.19143 0.16500 -0.18286 0.09357 -0.18000 "
"0.36286 -0.17929 0.37929 -0.17857 0.16643 -0.17714 0.23929 -0.17429 0.49286 -0.17357 "
"0.46000 -0.17214 0.50000 -0.17071 0.38357 -0.16857 0.51571 -0.16643 0.23357 -0.16286 "
"0.53000 -0.15786 0.17500 -0.15571 0.22786 -0.15286 0.12000 -0.15071 0.17929 -0.14857 "
"0.40143 -0.14929 0.32929 -0.14571 0.42000 -0.14500 0.22214 -0.14286 0.41429 -0.14357 "
"0.55500 -0.13714 0.55929 -0.13000 0.39071 -0.12286 0.16143 -0.12214 0.31214 -0.12000 "
"0.56643 -0.11857 0.20857 -0.11786 0.30357 -0.10143 0.20071 -0.10000 0.56929 -0.09857 "
"0.41214 -0.09000 0.29786 -0.08714 0.56786 -0.08429 0.18929 -0.07286 0.28786 -0.06429 "
"0.43714 -0.06357 0.18500 -0.06000 0.55786 -0.06000 0.29000 -0.05929 0.44429 -0.05929 "
"0.18357 -0.05286 0.45571 -0.05214 0.54857 -0.04929 0.31286 -0.04500 0.47000 -0.04500 "
"0.18214 -0.04286 0.27857 -0.04357 0.49000 -0.03929 0.50000 -0.03786 0.52571 -0.03786 "
"0.18071 -0.02714 0.33571 -0.02786 0.26929 -0.02571 0.30714 -0.02071 0.17929 0.00000 "
"0.36786 0.00143 0.25500 0.00857 0.33786 0.01000 0.18500 0.02000 0.34643 0.02143 "
"0.38357 0.03000 0.24500 0.03714 0.35357 0.03714 0.38500 0.03714 0.24357 0.04429 "
"0.35500 0.04429 0.24500 0.05714 0.38500 0.05714 0.20357 0.05857 0.35357 0.06571 "
"0.25214 0.07143 0.35071 0.07286 0.37071 0.08857 0.33286 0.09071 0.27286 0.09214 "
"0.32143 0.09643 0.28571 0.09786 0.31000 0.09929 0.24286 0.10214 0.35571 0.10500 "
"0.27286 0.11929 0.32714 0.12071 0.28286 0.12214 0.29000 0.12357 0.30571 0.12500 147 17 31 20 10 31 17 7 "
"25 0 12 21 11 11 21 7 27 13 9 27 4 2 6 4 27 6 27 9 13 "
"27 16 31 5 3 5 31 10 15 21 12 29 23 18 31 14 32 31 1 8 21 "
"15 23 22 7 21 25 27 0 27 2 0 18 23 15 25 7 22 30 16 27 31 "
"3 1 32 19 35 33 40 29 35 26 38 26 35 19 34 37 39 37 16 30 28 "
"37 34 42 39 37 31 8 14 14 19 32 20 48 33 24 16 37 43 20 31 36 "
"38 26 24 37 28 33 29 18 36 45 38 41 42 37 40 60 49 51 53 54 47 "
"45 44 51 45 53 76 72 69 50 52 55 50 42 46 47 53 45 46 42 41 57 "
"73 59 44 45 36 20 43 48 76 69 63 52 50 46 59 55 52 56 33 48 82 "
"60 67 61 60 56 73 58 62 73 71 83 75 82 67 65 90 77 57 59 52 33 "
"56 60 40 33 60 64 66 90 67 60 61 73 57 58 84 78 72 64 90 65 73 "
"62 71 104 101 92 78 87 86 49 76 63 79 82 75 76 49 60 71 74 83 83 "
"86 88 87 88 86 82 79 90 84 72 76 87 78 84 81 89 70 83 74 86 101 "
"89 92 85 89 81 89 90 68 90 79 77 80 81 70 91 93 88 89 68 70 93 "
"91 96 68 90 66 91 88 87 101 99 89 94 100 96 94 96 91 98 106 94 99 "
"90 89 105 100 94 97 102 108 106 105 94 106 103 113 104 92 107 95 90 99 97 "
"108 92 108 102 109 108 107 92 106 98 103 112 110 105 111 113 103 112 105 106 113 "
"111 117 116 114 110 111 115 117 114 116 118 117 115 119 116 110 112 120 122 119 118 "
"121 124 118 124 128 121 118 116 122 120 123 120 119 115 125 122 123 127 125 123 125 "
"127 129 128 130 138 129 132 131 126 128 124 131 139 133 128 126 130 138 134 140 131 "
"132 139 127 132 129 135 133 139 134 138 130 135 141 137 136 143 142 137 143 136 141 "
"135 139 140 136 142 144 137 141 136 140 134 144 143 137 "
;

char *VTK_VECTOR_TEXT_39 = "101 0.202143 "
"0.16714 -0.01214 0.16643 -0.00714 0.16786 -0.00714 0.16500 -0.00571 0.16929 -0.00571 "
"0.16929 -0.00286 0.17071 -0.00143 0.16500 0.00143 0.17071 0.00143 0.16357 0.00286 "
"0.17214 0.00286 0.17214 0.00571 0.17357 0.00714 0.16357 0.00857 0.16214 0.01000 "
"0.17357 0.01143 0.17500 0.01286 0.16214 0.01714 0.17500 0.01714 0.16071 0.01857 "
"0.17643 0.01857 0.16071 0.02429 0.17643 0.02429 0.15929 0.02571 0.17786 0.02571 "
"0.17786 0.03000 0.15929 0.03143 0.17929 0.03143 0.15786 0.03286 0.17929 0.03571 "
"0.18071 0.03714 0.15786 0.03857 0.15643 0.04000 0.18071 0.04143 0.18214 0.04286 "
"0.15643 0.04571 0.15500 0.04714 0.18214 0.04714 0.18357 0.04857 0.15500 0.05286 "
"0.15357 0.05429 0.18357 0.05429 0.18500 0.05571 0.15357 0.06000 0.18500 0.06000 "
"0.15214 0.06143 0.18643 0.06143 0.15214 0.06571 0.18643 0.06571 0.15071 0.06714 "
"0.18786 0.06714 0.15071 0.07143 0.18786 0.07143 0.14929 0.07286 0.18929 0.07286 "
"0.14929 0.07714 0.18929 0.07714 0.14786 0.07857 0.19071 0.07857 0.14786 0.08286 "
"0.19071 0.08286 0.14643 0.08429 0.19214 0.08429 0.19214 0.08714 0.14643 0.08857 "
"0.19357 0.08857 0.14500 0.09000 0.19357 0.09143 0.14500 0.09286 0.19500 0.09286 "
"0.14357 0.09429 0.19500 0.09571 0.14357 0.09714 0.19643 0.09714 0.14214 0.09857 "
"0.19643 0.10000 0.14214 0.10143 0.19786 0.10286 0.14071 0.10429 0.19929 0.10571 "
"0.13929 0.10714 0.13786 0.10857 0.20214 0.10857 0.20071 0.11143 0.19929 0.11429 "
"0.14214 0.11571 0.14643 0.12000 0.14643 0.12143 0.15071 0.12571 0.19071 0.12714 "
"0.18929 0.13000 0.15357 0.13143 0.18643 0.13429 0.15929 0.13714 0.15929 0.13857 "
"0.18357 0.13857 0.16357 0.14286 0.16357 0.14429 0.16786 0.14857 0.17143 0.15500 "
"0.17286 0.15500 99 2 1 0 4 5 3 4 3 1 4 1 2 7 11 9 8 7 3 13 "
"9 11 8 3 5 6 8 5 7 8 11 10 11 8 15 13 11 12 15 11 13 "
"15 14 15 17 14 17 15 18 21 17 18 16 18 15 17 21 19 21 18 22 21 "
"26 23 20 22 18 26 21 22 31 26 29 26 22 25 24 25 22 26 31 28 26 "
"25 29 35 31 33 27 29 25 31 35 32 31 29 33 30 33 29 39 35 37 35 "
"39 36 35 33 37 34 37 33 43 39 41 39 43 40 39 37 41 38 41 37 47 "
"43 44 51 47 44 43 47 45 43 41 44 42 44 41 55 51 52 47 51 49 46 "
"48 44 59 55 52 51 55 53 51 44 48 50 52 48 51 48 52 64 59 52 55 "
"59 57 54 56 52 68 64 60 59 64 61 64 56 60 58 60 56 64 52 56 62 "
"63 60 72 68 60 65 67 63 76 72 60 64 68 66 69 71 67 78 76 60 68 "
"72 70 73 75 71 72 76 74 80 67 71 80 78 60 81 80 85 83 79 82 80 "
"60 63 80 71 75 79 83 84 75 84 80 75 77 84 77 79 84 80 63 67 87 "
"86 88 89 93 91 89 91 88 84 89 88 84 88 86 84 86 80 86 85 80 93 "
"89 90 93 90 92 93 92 96 94 93 96 92 95 96 98 96 95 97 96 98 100 "
"99 98 100 98 95 "
;

char *VTK_VECTOR_TEXT_40 = "24 0.248571 "
"0.24857 -0.50214 0.20500 -0.46286 0.19643 -0.40000 0.15214 -0.39286 0.12643 -0.34429 "
"0.17357 -0.32571 0.16214 -0.27143 0.09643 -0.26429 0.08643 -0.22286 0.15357 -0.20714 "
"0.07786 -0.15714 0.14929 -0.09286 0.07500 -0.08000 0.15214 -0.02286 0.08071 -0.02143 "
"0.15786 0.03000 0.09214 0.04429 0.17214 0.10286 0.11786 0.12000 0.18500 0.15143 "
"0.13786 0.16286 0.20071 0.19571 0.18929 0.23571 0.24857 0.28500 22 1 2 3 "
"2 1 0 5 4 3 4 6 7 5 3 "
"2 9 8 7 4 5 6 8 9 10 "
"9 7 6 10 11 12 11 10 9 13 14 "
"12 14 15 16 13 12 11 16 17 18 "
"14 13 15 16 15 17 20 18 17 19 20 "
"17 20 21 22 20 19 21 22 21 23 "
;

char *VTK_VECTOR_TEXT_41 = "25 0.243571 "
"0.07000 -0.50214 0.12500 -0.44857 0.12357 -0.40143 0.16357 -0.39714 0.14214 -0.34286 "
"0.19500 -0.33857 0.15500 -0.28714 0.21929 -0.27571 0.23214 -0.22429 0.16500 -0.21000 "
"0.23786 -0.18714 0.24214 -0.13143 0.16929 -0.08286 0.24357 -0.08000 0.23929 -0.03286 "
"0.16643 -0.02143 0.22786 0.04143 0.15786 0.05571 0.22357 0.05857 0.20214 0.12000 "
"0.13786 0.14286 0.18357 0.16000 0.12071 0.19143 0.12929 0.23857 0.06786 0.28571 23 1 2 0 2 3 4 3 2 1 4 5 6 5 "
"4 3 6 7 9 7 6 5 7 8 9 9 11 12 11 9 10 10 9 8 11 "
"13 12 12 13 15 15 16 17 15 13 14 16 15 14 17 19 20 17 16 18 17 "
"18 19 22 20 21 19 21 20 22 23 24 23 22 21 "
;

char *VTK_VECTOR_TEXT_42 = "223 0.217857 "
"0.15143 0.00786 0.15857 0.00786 0.14500 0.01286 0.16500 0.01286 0.14357 0.01571 "
"0.16643 0.01714 0.16786 0.01857 0.14357 0.02429 0.14214 0.02571 0.16786 0.02571 "
"0.16929 0.02714 0.16929 0.03143 0.16786 0.03286 0.14214 0.03429 0.14357 0.03571 "
"0.10000 0.03786 0.10429 0.03786 0.16786 0.03857 0.20714 0.03786 0.21000 0.03786 "
"0.09857 0.03929 0.10571 0.03929 0.10857 0.03929 0.16643 0.04000 0.20286 0.03929 "
"0.20571 0.03929 0.09429 0.04071 0.09571 0.04071 0.19857 0.04071 0.20143 0.04071 "
"0.09357 0.04286 0.11286 0.04214 0.11571 0.04214 0.19714 0.04214 0.21643 0.04286 "
"0.09214 0.04429 0.14357 0.04429 0.16643 0.04429 0.19286 0.04357 0.19429 0.04357 "
"0.11857 0.04500 0.14500 0.04571 0.16500 0.04571 0.21786 0.04571 0.12143 0.04643 "
"0.12286 0.04643 0.18857 0.04643 0.19000 0.04643 0.16500 0.04857 0.14500 0.05000 "
"0.16357 0.05000 0.18429 0.04929 0.18571 0.04929 0.14643 0.05143 0.12857 0.05214 "
"0.13000 0.05214 0.09214 0.05429 0.16357 0.05429 0.21786 0.05429 0.14643 0.05571 "
"0.16214 0.05571 0.09500 0.05714 0.14786 0.05714 0.17571 0.05643 0.17714 0.05643 "
"0.21643 0.05714 0.09500 0.05857 0.16214 0.05857 0.16071 0.06000 0.09714 0.06071 "
"0.09857 0.06071 0.14786 0.06143 0.14929 0.06286 0.16071 0.06429 0.10286 0.06500 "
"0.15929 0.06571 0.20857 0.06500 0.10714 0.06643 0.14929 0.06714 0.20429 0.06643 "
"0.11000 0.06786 0.15071 0.06857 0.15929 0.06857 0.16286 0.06786 0.16429 0.06786 "
"0.11143 0.06929 0.11429 0.06929 0.15786 0.07000 0.19714 0.06929 0.20000 0.06929 "
"0.11571 0.07071 0.12000 0.07071 0.15071 0.07143 0.19143 0.07071 0.19571 0.07071 "
"0.12143 0.07214 0.12429 0.07214 0.15214 0.07286 0.15857 0.07214 0.18571 0.07214 "
"0.19000 0.07214 0.12571 0.07357 0.13000 0.07357 0.15143 0.07357 0.18000 0.07357 "
"0.18429 0.07357 0.13143 0.07500 0.13571 0.07500 0.17429 0.07500 0.17857 0.07500 "
"0.13714 0.07643 0.14143 0.07643 0.16857 0.07643 0.17286 0.07643 0.14286 0.07786 "
"0.14786 0.07857 0.16286 0.07786 0.16714 0.07786 0.16214 0.08000 0.14000 0.08071 "
"0.14429 0.08071 0.16571 0.08071 0.13571 0.08214 0.13857 0.08214 0.16714 0.08214 "
"0.17000 0.08214 0.13143 0.08357 0.13429 0.08357 0.17143 0.08357 0.17571 0.08357 "
"0.12714 0.08500 0.13000 0.08500 0.15000 0.08571 0.15143 0.08500 0.15214 0.08571 "
"0.17714 0.08500 0.18000 0.08500 0.12143 0.08643 0.12571 0.08643 0.15000 0.08643 "
"0.15143 0.08643 0.15857 0.08643 0.15786 0.08714 0.18143 0.08643 0.18571 0.08643 "
"0.11714 0.08786 0.12000 0.08786 0.15929 0.08857 0.18714 0.08786 0.19143 0.08786 "
"0.11571 0.08929 0.15071 0.09000 0.19286 0.08929 0.19571 0.08929 0.11286 0.09071 "
"0.14929 0.09143 0.16286 0.09071 0.16429 0.09071 0.11000 0.09214 0.15929 0.09286 "
"0.10714 0.09357 0.14929 0.09429 0.16071 0.09429 0.10286 0.09500 0.10429 0.09500 "
"0.14786 0.09571 0.20714 0.09500 0.16071 0.09857 0.21000 0.09786 0.21143 0.09786 "
"0.09714 0.09929 0.09857 0.09929 0.16214 0.10000 0.14786 0.10143 0.14643 0.10286 "
"0.16214 0.10286 0.21643 0.10286 0.16357 0.10429 0.09214 0.10571 0.21786 0.10571 "
"0.14643 0.10714 0.14500 0.10857 0.16357 0.10857 0.16500 0.11000 0.18429 0.11071 "
"0.18571 0.11071 0.21786 0.11286 0.09214 0.11429 0.12143 0.11357 0.12286 0.11357 "
"0.14500 0.11429 0.16500 0.11429 0.14357 0.11571 0.16643 0.11571 0.19000 0.11500 "
"0.21643 0.11571 0.19429 0.11643 0.10714 0.12000 0.16643 0.12000 0.19714 0.11929 "
"0.20000 0.11929 0.09857 0.12071 0.10143 0.12071 0.10714 0.12071 0.11000 0.12071 "
"0.16786 0.12143 0.20143 0.12071 0.20429 0.12071 0.20857 0.12071 0.21143 0.12071 "
"0.10286 0.12214 0.10571 0.12214 0.20714 0.12214 0.16786 0.12857 0.16929 0.13000 "
"0.16929 0.13429 0.16786 0.13571 0.16786 0.14143 0.14357 0.14429 0.14571 0.14786 "
"0.16429 0.14786 0.15143 0.15071 0.15857 0.15071 223 2 "
"1 4 1 7 4 0 1 2 5 7 3 14 7 12 7 1 3 7 5 9 6 "
"9 5 12 9 10 13 7 14 7 9 12 41 14 23 12 10 11 7 13 8 24 "
"25 29 30 26 27 36 14 41 23 12 17 14 12 23 58 39 33 28 29 33 21 "
"20 15 30 27 21 30 31 40 21 15 16 40 31 32 34 25 19 25 18 19 31 "
"30 21 53 41 50 42 23 37 38 39 47 58 29 25 58 33 29 43 58 25 41 "
"23 42 27 20 21 46 47 52 31 21 22 49 41 53 50 42 48 41 42 50 51 "
"52 64 56 30 61 30 56 35 70 61 40 54 44 45 62 53 60 43 25 34 70 "
"66 61 59 53 62 60 50 57 53 50 60 47 65 76 61 30 40 66 70 69 63 "
"112 84 88 52 47 74 40 77 96 102 101 68 60 67 62 60 68 71 62 72 72 "
"62 68 65 47 39 80 40 44 102 107 106 65 39 58 74 70 40 86 80 44 75 "
"68 73 72 68 75 113 112 108 80 77 40 80 86 85 78 72 81 83 84 116 88 "
"47 79 79 47 76 86 91 90 81 72 75 117 116 112 89 88 79 94 52 88 96 "
"91 44 91 86 44 91 96 95 102 44 54 107 111 110 87 75 82 81 75 87 83 "
"116 98 63 64 112 93 52 94 52 100 99 102 96 44 107 54 55 103 111 107 98 "
"97 87 92 81 97 100 52 93 105 52 99 107 102 54 104 52 105 52 112 64 114 "
"103 115 97 81 87 52 108 112 52 109 108 109 52 104 111 103 114 103 107 55 115 "
"103 98 116 84 112 103 97 98 119 120 123 118 115 98 122 123 127 115 133 132 121 "
"141 118 121 124 141 126 127 131 118 98 116 128 124 125 157 124 128 127 123 188 130 "
"131 138 115 118 141 115 132 120 135 128 129 185 135 143 137 138 146 132 140 139 151 "
"140 142 133 115 141 140 134 142 134 133 141 143 135 136 185 143 148 145 146 150 142 "
"134 141 124 157 156 148 143 144 185 128 135 120 132 139 124 156 141 152 148 149 185 "
"152 153 154 150 188 171 197 187 161 151 159 157 128 184 147 159 151 147 151 142 171 "
"187 178 173 161 167 151 161 155 185 148 152 160 158 188 150 146 188 166 168 196 163 "
"164 171 158 154 188 173 180 174 167 161 159 162 167 159 188 123 120 190 180 182 161 "
"173 165 170 171 178 180 173 175 173 167 175 172 175 167 146 138 188 180 175 182 128 "
"185 184 176 168 169 166 196 153 138 131 188 131 127 188 180 190 181 186 168 176 197 "
"164 188 177 182 175 171 164 197 194 153 196 211 197 203 189 120 139 179 186 176 190 "
"182 191 183 191 182 200 196 168 189 188 120 190 191 198 194 185 153 195 208 168 208 "
"207 168 209 208 195 202 201 187 164 160 188 207 200 168 196 200 199 197 202 187 202 "
"197 210 203 197 204 204 197 188 193 198 191 195 168 186 212 207 208 200 207 206 211 "
"210 197 213 190 198 205 213 198 216 213 214 190 213 192 218 192 216 216 214 215 192 "
"213 216 219 216 221 216 217 221 222 221 217 222 217 220 219 218 216 "
;

char *VTK_VECTOR_TEXT_43 = "12 0.387857 "
"0.23857 -0.29643 0.28357 -0.29571 0.13714 -0.19071 0.23714 -0.19071 0.28429 -0.19071 "
"0.38786 -0.19000 0.13714 -0.14929 0.23786 -0.14857 0.28357 -0.14857 0.38714 -0.14929 "
"0.23857 -0.04214 0.28286 -0.04214 10 0 1 "
"3 6 2 3 4 8 3 6 3 7 "
"4 3 1 8 4 9 9 4 5 8 7 "
"3 7 8 10 11 10 8 "
;

char *VTK_VECTOR_TEXT_44 = "112 0.200714 "
"0.12214 -0.45286 0.12429 -0.45286 0.12429 -0.45357 0.12571 -0.45214 0.12500 -0.45143 "
"0.12857 -0.45214 0.13000 -0.45071 0.13286 -0.45071 0.12857 -0.44786 0.14000 -0.44643 "
"0.14286 -0.44643 0.13429 -0.44500 0.15000 -0.44214 0.15286 -0.44214 0.16429 -0.43643 "
"0.15143 -0.43214 0.17000 -0.43071 0.17143 -0.43071 0.17643 -0.42571 0.17643 -0.42429 "
"0.16071 -0.42286 0.16071 -0.42143 0.18214 -0.41857 0.16643 -0.41571 0.18500 -0.41286 "
"0.16929 -0.41143 0.18786 -0.41000 0.17071 -0.40857 0.18929 -0.40571 0.17357 -0.40429 "
"0.19071 -0.40286 0.17500 -0.40143 0.19214 -0.40143 0.17643 -0.39857 0.19214 -0.39857 "
"0.19357 -0.39571 0.17643 -0.39429 0.19500 -0.39429 0.17786 -0.39286 0.19500 -0.39000 "
"0.19643 -0.38857 0.17786 -0.38714 0.17929 -0.38571 0.19643 -0.38429 0.19786 -0.38286 "
"0.17929 -0.37714 0.19786 -0.37714 0.18071 -0.37571 0.19929 -0.37571 0.18071 -0.36857 "
"0.18214 -0.36714 0.19929 -0.36571 0.20071 -0.36429 0.18214 -0.35857 0.14000 -0.35786 "
"0.15000 -0.35786 0.18357 -0.35714 0.13571 -0.35643 0.13857 -0.35643 0.15143 -0.35643 "
"0.15714 -0.35643 0.13143 -0.35500 0.13429 -0.35500 0.15857 -0.35500 0.16429 -0.35500 "
"0.16571 -0.35357 0.17000 -0.35357 0.17143 -0.35214 0.17429 -0.35214 0.17571 -0.35071 "
"0.17857 -0.35071 0.18286 -0.34786 0.11500 -0.34000 0.20071 -0.33286 0.19929 -0.33143 "
"0.10786 -0.32857 0.10786 -0.32571 0.10643 -0.32429 0.19929 -0.32429 0.19786 -0.32286 "
"0.10643 -0.32000 0.10500 -0.31857 0.19786 -0.31714 0.19643 -0.31571 0.19643 -0.31286 "
"0.19500 -0.31143 0.19500 -0.30714 0.10500 -0.30571 0.19357 -0.30571 0.10643 -0.30429 "
"0.19357 -0.30286 0.19214 -0.30143 0.10643 -0.30000 0.10786 -0.29857 0.19214 -0.29857 "
"0.10786 -0.29571 0.18786 -0.29000 0.11214 -0.28857 0.17714 -0.27786 0.12714 -0.27500 "
"0.13143 -0.27357 0.13286 -0.27214 0.13571 -0.27214 0.15714 -0.27143 0.16429 -0.27214 "
"0.16714 -0.27214 0.13714 -0.27071 0.14143 -0.27071 0.15714 -0.27071 0.16286 -0.27071 "
"0.14286 -0.26929 0.15571 -0.26929 110 "
"2 1 0 0 1 3 4 3 8 3 5 "
"8 5 6 8 6 7 11 8 6 11 "
"11 12 15 9 11 7 11 9 12 15 12 "
"13 9 10 12 16 20 14 14 20 15 "
"20 16 19 21 20 23 18 16 17 14 15 "
"13 18 19 16 25 23 19 25 19 22 "
"23 20 19 24 25 22 27 25 24 27 24 "
"26 29 27 28 28 27 26 38 34 35 "
"31 28 30 31 29 28 33 31 30 33 30 "
"34 32 34 30 38 33 34 42 38 39 "
"36 33 38 38 35 39 37 39 35 42 39 "
"43 41 38 42 40 43 39 45 42 47 "
"46 42 43 44 46 43 47 42 46 49 47 "
"50 51 50 47 51 47 46 48 51 46 "
"52 56 51 53 50 56 57 58 62 59 54 "
"55 56 50 51 61 62 72 54 59 58 "
"63 59 60 65 63 64 67 65 66 72 63 "
"76 69 67 68 62 59 72 62 58 59 "
"56 52 71 72 76 75 89 80 83 65 67 "
"79 52 73 71 63 65 79 69 71 74 "
"80 76 63 59 63 72 73 74 71 76 80 "
"77 67 69 79 71 69 70 79 74 78 "
"80 63 83 69 74 79 83 79 82 63 79 "
"83 85 83 84 93 89 83 87 80 89 "
"80 87 81 88 85 86 91 88 90 92 89 "
"93 95 93 97 93 85 88 93 83 85 "
"93 88 97 98 104 91 97 103 100 103 102 "
"100 97 91 103 97 100 99 104 103 91 "
"97 88 91 103 107 102 100 102 101 98 91 "
"96 102 107 106 96 91 94 105 104 98 "
"110 103 111 107 103 110 108 103 109 109 103 "
"104 111 103 108 "
;

char *VTK_VECTOR_TEXT_45 = "8 0.219286 "
"0.08357 -0.25429 0.08429 -0.25500 0.21857 -0.25500 0.21929 -0.25429 0.08357 -0.21857 "
"0.21929 -0.21857 0.08429 -0.21786 0.21857 -0.21786 6 2 6 1 2 3 "
"5 6 4 0 6 0 1 2 5 7 "
"2 7 6 "
;

char *VTK_VECTOR_TEXT_46 = "87 0.193571 "
"0.14286 -0.35929 0.15429 -0.35929 0.13714 -0.35786 0.14143 -0.35786 0.15571 -0.35786 "
"0.16000 -0.35786 0.13429 -0.35643 0.13571 -0.35643 0.16143 -0.35643 0.16429 -0.35643 "
"0.13143 -0.35500 0.13286 -0.35500 0.16571 -0.35500 0.16857 -0.35500 0.12857 -0.35357 "
"0.13000 -0.35357 0.17000 -0.35357 0.17143 -0.35357 0.17429 -0.35071 0.17571 -0.35071 "
"0.12286 -0.34929 0.12429 -0.34929 0.11929 -0.34571 0.11929 -0.34429 0.11357 -0.33857 "
"0.18786 -0.33857 0.11357 -0.33714 0.18786 -0.33714 0.11214 -0.33571 0.18929 -0.33571 "
"0.11214 -0.33429 0.18929 -0.33429 0.11071 -0.33286 0.19071 -0.33286 0.11071 -0.33143 "
"0.19071 -0.33143 0.10929 -0.33000 0.19214 -0.33000 0.10929 -0.32714 0.10786 -0.32571 "
"0.19214 -0.32571 0.19357 -0.32429 0.10786 -0.32143 0.10643 -0.32000 0.10643 -0.30714 "
"0.19357 -0.30714 0.10786 -0.30571 0.19000 -0.30571 0.19214 -0.30571 0.10786 -0.30143 "
"0.19214 -0.30143 0.10929 -0.30000 0.19071 -0.30000 0.10929 -0.29714 0.19071 -0.29714 "
"0.11071 -0.29571 0.18929 -0.29571 0.11071 -0.29429 0.18929 -0.29429 0.11214 -0.29286 "
"0.18786 -0.29286 0.11214 -0.29143 0.18786 -0.29143 0.18500 -0.28857 0.18500 -0.28714 "
"0.12429 -0.27929 0.12571 -0.27929 0.17429 -0.27786 0.17571 -0.27786 0.12857 -0.27643 "
"0.13000 -0.27643 0.17143 -0.27643 0.17286 -0.27643 0.13143 -0.27500 0.13286 -0.27500 "
"0.16857 -0.27500 0.17000 -0.27500 0.13429 -0.27357 0.13714 -0.27357 0.16429 -0.27357 "
"0.16714 -0.27357 0.13857 -0.27214 0.14286 -0.27214 0.15857 -0.27214 0.16286 -0.27214 "
"0.14429 -0.27071 0.15714 -0.27071 86 4 0 1 2 3 7 6 7 11 8 4 5 10 11 15 7 3 4 23 "
"11 4 12 8 9 16 12 13 0 4 3 14 15 21 21 23 22 23 21 15 11 "
"7 4 23 15 11 20 21 22 18 16 17 26 23 4 38 30 4 25 27 19 23 "
"26 24 27 18 19 26 30 28 29 31 27 12 16 18 38 34 30 42 38 4 30 "
"34 32 33 35 31 30 26 4 12 18 40 38 42 39 34 38 36 37 40 35 46 "
"42 40 18 31 40 18 27 31 8 12 40 4 8 40 42 4 40 31 35 40 51 "
"46 40 44 42 46 42 44 43 48 47 45 41 45 47 41 47 40 59 40 47 55 "
"51 40 49 46 51 50 47 48 57 55 59 52 47 50 61 59 65 53 51 55 56 "
"52 54 59 55 40 47 52 56 60 56 58 78 70 66 60 47 56 78 66 63 63 "
"60 62 59 66 65 59 47 63 66 59 63 66 70 69 78 74 70 68 63 64 68 "
"67 63 47 60 63 72 71 67 70 74 73 74 78 77 79 83 63 82 78 63 76 "
"75 71 71 63 67 78 82 81 71 79 63 80 79 75 86 82 83 71 75 79 83 "
"82 63 84 83 79 86 85 82 "
;

char *VTK_VECTOR_TEXT_47 = "10 0.337143 "
"0.08929 -0.35714 0.17000 -0.35786 0.09214 -0.35143 0.17929 -0.33286 0.14357 -0.19714 "
"0.14643 -0.19000 0.33500 0.13286 0.25500 0.13571 0.25714 0.14071 0.33714 0.14071 8 0 1 2 "
"2 3 4 2 1 3 6 7 5 5 4 "
"3 6 5 3 6 8 7 9 8 6 "
;

char *VTK_VECTOR_TEXT_48 = "108 0.420714 "
"0.24286 -0.35643 0.28143 -0.35643 0.23143 -0.35500 0.22429 -0.35357 0.29000 -0.35357 "
"0.21857 -0.35214 0.30000 -0.35214 0.21286 -0.35071 0.20000 -0.34643 0.18714 -0.34071 "
"0.25143 -0.33786 0.27000 -0.33786 0.24429 -0.33643 0.27714 -0.33643 0.33571 -0.33500 "
"0.23571 -0.33357 0.28571 -0.33357 0.17143 -0.33071 0.22714 -0.32929 0.29429 -0.32929 "
"0.34714 -0.32643 0.16429 -0.32500 0.31071 -0.31429 0.20786 -0.31143 0.36786 -0.30714 "
"0.14357 -0.30571 0.20071 -0.30143 0.37786 -0.29429 0.32357 -0.29286 0.19500 -0.29143 "
"0.32643 -0.28571 0.19214 -0.28429 0.12357 -0.27857 0.18929 -0.27571 0.33071 -0.27286 "
"0.18786 -0.26857 0.33214 -0.26714 0.18643 -0.26000 0.33357 -0.26000 0.39929 -0.25571 "
"0.10786 -0.24857 0.33500 -0.24714 0.10357 -0.23857 0.40929 -0.23000 0.41071 -0.22429 "
"0.41214 -0.22000 0.09643 -0.21714 0.41357 -0.21429 0.09500 -0.21143 0.41500 -0.20857 "
"0.09357 -0.20571 0.41643 -0.20143 0.09214 -0.19857 0.41786 -0.19286 0.09071 -0.19143 "
"0.41929 -0.18286 0.08929 -0.18143 0.42071 -0.16714 0.08786 -0.16571 0.08786 -0.11857 "
"0.42071 -0.11571 0.09071 -0.10714 0.41786 -0.10429 0.09071 -0.10000 0.41786 -0.09714 "
"0.09357 -0.09286 0.41500 -0.09000 0.41500 -0.08429 0.09786 -0.07714 0.10071 -0.06857 "
"0.40786 -0.06429 0.10357 -0.06143 0.40500 -0.05714 0.40214 -0.05000 0.18643 -0.04571 "
"0.33500 -0.04571 0.11357 -0.03857 0.18786 -0.03857 0.33357 -0.03571 0.18929 -0.03286 "
"0.33214 -0.03000 0.39357 -0.03000 0.19214 -0.02429 0.32929 -0.02143 0.32357 -0.01000 "
"0.20071 -0.00857 0.14071 0.00000 0.37357 0.00000 0.22286 0.01357 0.30000 0.01357 "
"0.28857 0.01929 0.23714 0.02071 0.24143 0.02214 0.28000 0.02214 0.24857 0.02357 "
"0.27429 0.02357 0.35000 0.02357 0.16714 0.02500 0.18429 0.03500 0.19857 0.04214 "
"0.31714 0.04357 0.21000 0.04643 0.21571 0.04786 0.22000 0.04929 0.22714 0.05071 "
"0.23429 0.05214 0.24714 0.05357 0.27000 0.05500 108 13 1 4 "
"1 11 0 8 15 9 6 19 4 12 5 "
"3 7 12 8 12 7 5 2 11 10 "
"2 0 11 2 12 3 13 4 16 14 19 "
"6 12 2 10 1 13 11 8 12 15 "
"19 16 4 18 9 15 19 14 22 22 20 "
"28 22 14 20 23 9 18 9 23 17 "
"30 27 34 26 21 17 25 31 32 26 17 "
"23 20 24 28 36 34 27 29 25 21 "
"27 28 24 25 29 31 32 35 40 29 21 "
"26 27 30 28 38 36 27 41 38 27 "
"32 33 35 33 32 31 40 35 37 40 37 "
"42 50 48 37 42 37 46 39 41 27 "
"48 46 37 43 41 39 52 50 37 41 44 "
"45 41 43 44 41 45 47 41 47 49 "
"41 49 51 41 51 53 54 52 37 56 54 "
"37 41 55 57 41 53 55 58 56 37 "
"60 41 57 58 37 59 37 61 59 62 41 "
"60 63 61 65 61 37 65 66 41 62 "
"65 37 68 68 37 69 69 37 71 75 41 "
"66 66 62 64 75 70 72 78 75 73 "
"75 66 67 70 75 67 71 37 74 75 72 "
"73 76 74 86 80 73 81 84 87 96 "
"80 78 73 76 71 74 84 96 89 74 77 "
"86 77 79 86 82 86 79 83 87 84 "
"88 102 101 85 86 82 89 100 90 88 97 "
"85 91 104 88 80 87 83 97 86 85 "
"87 80 81 91 92 106 88 101 99 90 100 "
"93 98 88 99 107 95 93 96 100 89 "
"88 98 97 103 102 88 104 103 88 106 94 "
"95 105 104 91 106 92 94 106 105 91 "
"107 106 95 100 107 93 "
;

char *VTK_VECTOR_TEXT_49 = "48 0.307857 "
"0.12714 -0.35786 0.27571 -0.35786 0.30143 -0.35786 0.15714 -0.35643 0.26571 -0.35643 "
"0.17000 -0.35500 0.11929 -0.35286 0.18429 -0.35357 0.30786 -0.35286 0.20571 -0.35214 "
"0.11929 -0.34571 0.30786 -0.34571 0.13000 -0.33786 0.27857 -0.33786 0.29714 -0.33786 "
"0.27286 -0.33643 0.16286 -0.33500 0.26857 -0.33500 0.26214 -0.32714 0.17357 -0.32429 "
"0.26071 -0.32286 0.17786 -0.31571 0.25929 -0.31571 0.17929 -0.31000 0.17929 -0.05857 "
"0.17786 -0.05143 0.17643 -0.04714 0.17071 -0.03714 0.09714 -0.03357 0.11571 -0.03214 "
"0.08786 -0.02714 0.13143 -0.02643 0.15571 -0.02643 0.13714 -0.02500 0.15000 -0.02500 "
"0.08643 -0.01143 0.09143 -0.00500 0.09857 -0.00214 0.16714 0.00214 0.17286 0.00357 "
"0.18143 0.00643 0.19857 0.01500 0.20714 0.02071 0.22357 0.03571 0.23357 0.04857 "
"0.25786 0.05571 0.24143 0.05786 0.25143 0.06071 46 7 9 19 10 0 12 "
"16 5 7 16 3 5 0 10 6 8 11 "
"2 4 1 13 4 17 9 2 14 1 "
"12 3 16 0 3 12 14 13 1 14 2 "
"11 4 13 15 16 7 19 4 15 17 "
"19 9 21 21 9 20 18 9 17 23 21 "
"20 9 18 20 23 20 22 24 23 22 "
"27 39 38 27 38 32 40 27 41 39 27 "
"40 36 35 28 30 28 35 31 37 29 "
"37 31 33 33 34 38 32 38 34 29 37 "
"28 37 33 38 37 36 28 43 45 44 "
"42 24 43 25 24 42 26 25 42 26 41 "
"27 26 42 41 45 43 24 46 45 47 "
"45 46 44 45 24 22 "
;

char *VTK_VECTOR_TEXT_50 = "117 0.399286 "
"0.09714 -0.35786 0.37000 -0.35786 0.38071 -0.33143 0.38357 -0.32286 0.38500 -0.31714 "
"0.38643 -0.31143 0.09643 -0.30714 0.38786 -0.30571 0.10286 -0.30357 0.38929 -0.30143 "
"0.39071 -0.29571 0.12571 -0.29214 0.39214 -0.29000 0.13571 -0.28643 0.20286 -0.28643 "
"0.36429 -0.28643 0.13857 -0.28500 0.39357 -0.28429 0.20429 -0.28071 0.39500 -0.28000 "
"0.14857 -0.27929 0.39643 -0.27429 0.37929 -0.27286 0.38357 -0.26571 0.23143 -0.26214 "
"0.38500 -0.25714 0.39929 -0.25429 0.18714 -0.25214 0.39000 -0.25214 0.24857 -0.24929 "
"0.19429 -0.24643 0.26571 -0.23500 0.28000 -0.22214 0.22786 -0.21286 0.24214 -0.19429 "
"0.30929 -0.19429 0.32500 -0.17429 0.26214 -0.16286 0.26500 -0.15714 0.34214 -0.15000 "
"0.26929 -0.14714 0.34929 -0.13857 0.16000 -0.13214 0.14286 -0.13071 0.27500 -0.13000 "
"0.13571 -0.12929 0.35500 -0.12857 0.12571 -0.12500 0.27643 -0.12429 0.18857 -0.12214 "
"0.27786 -0.11857 0.35929 -0.11857 0.27929 -0.11143 0.20357 -0.10857 0.10643 -0.10714 "
"0.36357 -0.10571 0.28071 -0.10143 0.36500 -0.10000 0.20786 -0.09714 0.09929 -0.09429 "
"0.36643 -0.09429 0.20929 -0.09143 0.36786 -0.08714 0.09500 -0.08571 0.28214 -0.08571 "
"0.09214 -0.07714 0.36929 -0.07571 0.09071 -0.07000 0.20929 -0.06714 0.08929 -0.06143 "
"0.20214 -0.05286 0.37071 -0.04571 0.28071 -0.04286 0.08786 -0.03857 0.19000 -0.03929 "
"0.11714 -0.03357 0.36786 -0.03286 0.12286 -0.03214 0.27929 -0.03143 0.11643 -0.03000 "
"0.13143 -0.02929 0.13857 -0.02786 0.16143 -0.02643 0.36786 -0.02571 0.27786 -0.02286 "
"0.09071 -0.02143 0.27643 -0.01714 0.09357 -0.01571 0.27357 -0.00857 0.36214 -0.00857 "
"0.13071 0.00000 0.10071 0.00286 0.26786 0.00286 0.35357 0.01143 0.14286 0.01500 "
"0.11071 0.01714 0.34786 0.01857 0.15143 0.02214 0.24571 0.02500 0.16000 0.02786 "
"0.24000 0.02786 0.23143 0.03071 0.12714 0.03214 0.17143 0.03214 0.22286 0.03214 "
"0.17857 0.03357 0.21143 0.03357 0.32857 0.03786 0.14000 0.03929 0.15429 0.04643 "
"0.16714 0.05071 0.17286 0.05214 0.17857 0.05357 0.29000 0.05357 0.18571 0.05500 "
"0.19429 0.05643 0.24857 0.05929 115 11 0 13 2 0 1 3 "
"15 2 15 3 4 6 0 8 8 0 11 15 5 7 0 14 13 15 7 9 15 "
"10 12 20 18 27 0 2 14 5 15 4 15 9 10 15 12 22 20 16 14 2 "
"15 14 22 12 17 16 13 14 22 17 19 22 19 21 22 21 23 23 26 25 20 "
"14 18 25 26 28 30 27 18 23 21 26 24 29 33 31 33 29 30 24 33 30 "
"18 24 31 32 33 34 36 37 33 36 34 40 36 44 36 33 35 38 36 40 37 "
"36 38 33 32 35 50 48 39 39 48 36 47 43 54 77 75 69 48 44 36 52 "
"50 39 75 73 69 56 52 41 41 52 39 46 56 41 47 45 43 69 81 80 77 "
"69 80 64 56 55 55 56 51 64 57 60 42 61 68 51 56 46 64 71 72 64 "
"55 57 74 67 65 58 49 53 74 69 67 63 74 65 74 81 69 64 60 62 42 "
"74 54 70 74 42 49 58 61 42 49 61 70 42 68 64 62 66 54 74 59 78 "
"72 71 64 66 71 59 74 63 78 76 83 76 78 71 73 79 85 43 42 54 85 "
"79 87 82 81 74 84 78 89 73 75 79 91 87 79 88 89 92 92 113 98 90 "
"91 79 95 91 90 92 107 113 89 78 83 86 84 89 86 89 88 95 94 102 95 "
"90 94 102 94 108 99 108 97 92 96 107 92 93 96 109 99 103 116 100 98 100 "
"116 101 112 105 106 112 103 105 97 108 94 116 104 101 108 99 109 109 103 110 92 "
"89 93 111 110 103 112 111 103 114 112 106 115 114 106 116 106 104 115 106 116 113 "
"116 98 "
;

char *VTK_VECTOR_TEXT_51 = "136 0.370714 "
"0.22714 -0.35786 0.19000 -0.35643 0.17857 -0.35500 0.25000 -0.35500 0.17000 -0.35357 "
"0.16286 -0.35214 0.15714 -0.35071 0.27571 -0.34786 0.13714 -0.34357 0.28857 -0.34357 "
"0.18000 -0.33929 0.21000 -0.33929 0.17143 -0.33786 0.21714 -0.33786 0.16571 -0.33643 "
"0.22286 -0.33643 0.12000 -0.33500 0.16143 -0.33500 0.23857 -0.32929 0.32429 -0.32643 "
"0.10071 -0.32143 0.13929 -0.32000 0.33286 -0.32071 0.15857 -0.31500 0.17000 -0.31071 "
"0.25929 -0.30857 0.34929 -0.30714 0.08929 -0.30571 0.08786 -0.30000 0.35786 -0.29571 "
"0.18643 -0.29429 0.26643 -0.29429 0.18929 -0.28571 0.08214 -0.28286 0.27071 -0.28143 "
"0.36500 -0.27857 0.27214 -0.27429 0.36786 -0.27000 0.27357 -0.26714 0.19357 -0.26571 "
"0.08214 -0.26286 0.36929 -0.26286 0.27500 -0.25571 0.37071 -0.25143 0.09071 -0.24143 "
"0.18500 -0.24000 0.17571 -0.22929 0.27500 -0.22571 0.10857 -0.22357 0.36929 -0.21857 "
"0.12429 -0.21786 0.15429 -0.21786 0.27357 -0.21429 0.36643 -0.21286 0.27214 -0.20714 "
"0.36500 -0.20571 0.27071 -0.20143 0.26786 -0.19286 0.35786 -0.19286 0.26500 -0.18714 "
"0.25000 -0.17071 0.24286 -0.16643 0.23857 -0.16500 0.32857 -0.16500 0.16571 -0.16357 "
"0.23286 -0.16357 0.22571 -0.16214 0.16071 -0.16000 0.16071 -0.15000 0.28500 -0.14571 "
"0.16714 -0.14500 0.19714 -0.14500 0.21000 -0.14357 0.22000 -0.14214 0.22714 -0.14071 "
"0.23714 -0.13643 0.25071 -0.12571 0.25786 -0.11714 0.32714 -0.11500 0.26357 -0.10857 "
"0.26786 -0.10000 0.27071 -0.09286 0.34929 -0.09286 0.15714 -0.09071 0.16857 -0.08929 "
"0.27214 -0.08857 0.14143 -0.08786 0.13571 -0.08643 0.27357 -0.08143 0.18857 -0.08071 "
"0.12357 -0.07429 0.36071 -0.07286 0.19786 -0.07143 0.12214 -0.07000 0.27500 -0.07000 "
"0.36214 -0.06857 0.11929 -0.06429 0.36357 -0.06286 0.20214 -0.06000 0.20357 -0.05143 "
"0.11357 -0.04714 0.36357 -0.03857 0.20500 -0.03714 0.27500 -0.03714 0.27357 -0.02857 "
"0.36214 -0.02571 0.27214 -0.02286 0.19786 -0.01714 0.27071 -0.01714 0.35786 -0.01571 "
"0.11643 -0.01000 0.18286 -0.00357 0.17429 -0.00214 0.16857 0.00071 0.26214 0.00143 "
"0.15857 0.00214 0.15643 0.00429 0.34500 0.01000 0.13214 0.02000 0.24286 0.02071 "
"0.17571 0.02214 0.23429 0.02500 0.18714 0.02643 0.19286 0.02786 0.22571 0.02786 "
"0.20286 0.02929 0.21857 0.02929 0.32571 0.02929 0.15714 0.04214 0.30000 0.04500 "
"0.17571 0.05071 0.18857 0.05500 0.19429 0.05643 0.20286 0.05786 0.21429 0.05929 "
"0.24000 0.06071 134 6 12 8 "
"15 0 3 7 25 18 6 5 12 5 4 "
"12 19 25 9 0 11 1 4 2 12 "
"13 11 0 2 10 12 11 2 1 2 11 "
"10 15 13 0 14 8 12 7 9 25 "
"8 21 16 8 14 17 15 3 18 7 18 "
"3 20 21 27 21 8 17 16 21 20 "
"36 34 22 19 31 25 28 21 33 21 28 "
"27 39 24 32 31 19 34 26 42 22 "
"38 36 22 42 38 22 19 22 34 42 26 "
"29 49 47 42 23 33 21 32 24 30 "
"45 40 33 45 44 40 41 43 42 45 23 "
"24 35 42 29 44 46 51 37 42 35 "
"45 33 23 44 51 50 49 42 43 37 41 "
"42 48 44 50 57 63 59 44 45 46 "
"45 24 39 52 47 63 54 52 63 56 54 "
"63 58 47 55 56 63 57 47 53 55 "
"63 47 58 49 53 47 69 66 65 67 64 "
"70 66 71 64 69 60 59 67 70 68 "
"60 69 61 69 62 61 69 65 62 71 70 "
"64 71 66 72 69 59 63 72 66 73 "
"74 73 66 74 66 75 69 75 66 75 69 "
"76 77 76 69 78 81 80 79 77 69 "
"78 80 79 78 85 81 78 79 69 88 85 "
"78 96 93 86 93 90 86 82 94 78 "
"94 88 78 103 94 95 87 86 90 100 96 "
"86 100 99 110 99 112 115 84 89 92 "
"84 98 99 100 84 99 91 95 94 91 94 "
"82 99 115 110 104 103 95 95 97 101 "
"107 112 102 106 104 101 108 106 101 98 84 "
"92 104 95 101 108 109 114 115 112 113 "
"110 116 118 108 101 105 100 83 84 112 99 "
"102 112 107 111 109 108 105 100 86 83 "
"117 114 109 114 117 127 135 126 124 135 125 "
"126 110 115 116 118 116 128 122 130 120 "
"135 123 125 133 122 123 135 124 121 120 128 "
"116 129 114 127 130 122 131 114 129 119 "
"130 128 120 135 121 119 132 131 122 133 132 "
"122 134 133 123 134 123 135 135 119 129 "
;

char *VTK_VECTOR_TEXT_52 = "74 0.390714 "
"0.19571 -0.35786 0.22429 -0.35786 0.34286 -0.35786 0.36857 -0.35786 0.33286 -0.35643 "
"0.23714 -0.35500 0.18786 -0.35286 0.25143 -0.35357 0.37500 -0.35286 0.27286 -0.35214 "
"0.18786 -0.34571 0.37500 -0.34571 0.19714 -0.33786 0.34714 -0.33786 0.36429 -0.33786 "
"0.34000 -0.33643 0.23000 -0.33500 0.33571 -0.33500 0.23429 -0.33214 0.32929 -0.32714 "
"0.32786 -0.32286 0.24357 -0.31857 0.32643 -0.31571 0.24500 -0.31429 0.24643 -0.30857 "
"0.24571 -0.25500 0.32714 -0.25500 0.39071 -0.25429 0.09143 -0.25357 0.08500 -0.24857 "
"0.08357 -0.24143 0.13714 -0.21214 0.24643 -0.21143 0.32643 -0.21143 0.39000 -0.21214 "
"0.13643 -0.21000 0.10786 -0.20429 0.15214 -0.18571 0.15929 -0.17429 0.16786 -0.16143 "
"0.17500 -0.15000 0.18071 -0.14143 0.18786 -0.13000 0.18071 -0.09714 0.18357 -0.09143 "
"0.18500 -0.08571 0.24714 -0.07929 0.32571 -0.07929 0.18500 -0.07286 0.22500 -0.07286 "
"0.18357 -0.06714 0.18214 -0.06143 0.23214 -0.06143 0.17929 -0.05429 0.24071 -0.04857 "
"0.17643 -0.04571 0.17500 -0.04143 0.24786 -0.03714 0.17357 -0.03429 0.17214 -0.02571 "
"0.25643 -0.02429 0.26214 -0.01714 0.26786 -0.00571 0.27357 0.00429 0.17071 0.00571 "
"0.27643 0.01286 0.27786 0.01857 0.18214 0.03143 0.27786 0.04143 0.27000 0.05071 "
"0.20429 0.05214 0.21286 0.05500 0.26000 0.05643 0.23714 0.06071 72 16 7 9 16 5 7 5 16 "
"1 12 1 16 10 0 12 0 10 6 "
"8 11 3 4 2 13 4 17 9 3 13 "
"2 3 14 13 12 0 1 14 3 11 "
"4 13 15 18 16 9 4 15 17 18 9 "
"21 23 9 20 23 21 9 19 9 17 "
"9 19 20 24 23 20 24 20 22 24 22 "
"25 25 33 32 30 31 36 31 30 28 "
"33 26 34 25 22 26 25 26 33 31 25 "
"32 34 26 27 30 29 28 25 31 28 "
"39 43 36 31 35 36 39 36 38 40 43 "
"39 38 36 37 41 43 40 37 36 35 "
"42 43 41 44 43 42 49 48 45 47 46 "
"33 49 45 44 32 33 46 49 50 48 "
"49 44 42 51 50 49 52 58 56 52 56 "
"55 52 55 53 54 58 52 51 49 53 "
"52 53 49 59 58 54 57 59 54 60 59 "
"57 64 59 60 64 60 67 67 60 61 "
"71 70 62 71 62 63 62 67 61 73 66 "
"72 68 69 66 66 69 72 70 67 62 "
"73 71 66 71 65 66 65 71 63 "
;

char *VTK_VECTOR_TEXT_53 = "122 0.369286 "
"0.20714 -0.35786 0.17571 -0.35500 0.16857 -0.35357 0.24143 -0.35357 0.16286 -0.35214 "
"0.25000 -0.35071 0.25571 -0.34929 0.14714 -0.34643 0.28000 -0.34214 0.29000 -0.33786 "
"0.18857 -0.33643 0.18143 -0.33500 0.12429 -0.33357 0.21000 -0.33357 0.30429 -0.33071 "
"0.16857 -0.32929 0.22571 -0.32643 0.31143 -0.32643 0.15929 -0.32143 0.10786 -0.32000 "
"0.23429 -0.32071 0.15929 -0.31571 0.32429 -0.31643 0.09786 -0.30571 0.33643 -0.30571 "
"0.17143 -0.30500 0.25643 -0.29857 0.18214 -0.29714 0.34214 -0.29714 0.09214 -0.29000 "
"0.18786 -0.28714 0.34929 -0.28571 0.09071 -0.28429 0.18929 -0.28286 0.26643 -0.28143 "
"0.19071 -0.27714 0.08929 -0.27571 0.26929 -0.27429 0.35500 -0.27429 0.27214 -0.26571 "
"0.35929 -0.26143 0.08929 -0.25714 0.27500 -0.25429 0.19071 -0.25143 0.36214 -0.25000 "
"0.27643 -0.24714 0.36357 -0.24143 0.09786 -0.23857 0.27786 -0.23714 0.18214 -0.23000 "
"0.36500 -0.22857 0.11571 -0.22214 0.16714 -0.21786 0.13143 -0.21643 0.13714 -0.21500 "
"0.15286 -0.21357 0.27786 -0.19571 0.36643 -0.19286 0.27643 -0.18143 0.27500 -0.17286 "
"0.36357 -0.17143 0.27357 -0.16571 0.27071 -0.15429 0.35786 -0.15286 0.14000 -0.15071 "
"0.12500 -0.14857 0.26643 -0.14286 0.14357 -0.14143 0.12643 -0.13857 0.34929 -0.13286 "
"0.25929 -0.13143 0.15071 -0.12714 0.12786 -0.12429 0.15714 -0.11929 0.33929 -0.11857 "
"0.24286 -0.11500 0.16429 -0.11357 0.12929 -0.10857 0.23286 -0.10929 0.17714 -0.10786 "
"0.22857 -0.10786 0.22286 -0.10643 0.18857 -0.10500 0.19857 -0.10357 0.32000 -0.10071 "
"0.15000 -0.09929 0.15429 -0.09786 0.16000 -0.09643 0.13071 -0.09429 0.16857 -0.09357 "
"0.17429 -0.09214 0.17857 -0.09071 0.18429 -0.08929 0.19143 -0.08786 0.19857 -0.08643 "
"0.28571 -0.08643 0.21143 -0.08500 0.26714 -0.08357 0.13214 -0.08000 0.15714 -0.02929 "
"0.29857 -0.02786 0.31429 -0.02071 0.33786 0.00143 0.34643 0.01429 0.29000 0.04071 "
"0.22571 0.04214 0.30000 0.04214 0.36357 0.04429 0.21286 0.04500 0.14357 0.04857 "
"0.32000 0.04929 0.36643 0.05286 0.14714 0.05357 0.18429 0.05500 0.16143 0.05643 "
"0.33143 0.05643 0.36929 0.06857 0.34357 0.07286 0.34786 0.08143 0.36643 0.08429 "
"0.35571 0.09071 0.36000 0.09071 120 4 2 11 "
"4 11 7 13 0 3 3 5 16 8 9 "
"26 8 26 6 2 1 11 7 18 12 "
"10 11 1 10 0 13 0 10 1 20 5 "
"6 13 3 16 7 15 18 19 18 23 "
"16 5 20 7 11 15 12 18 19 20 6 "
"26 23 18 29 32 29 21 36 32 25 "
"17 26 14 9 14 26 27 43 25 26 17 "
"34 29 18 21 28 22 24 25 32 21 "
"22 37 17 41 25 47 37 28 39 34 17 "
"37 37 22 28 27 35 43 39 28 42 "
"27 33 35 27 30 33 41 36 25 45 42 "
"38 38 42 31 44 48 40 31 42 28 "
"49 47 25 40 48 38 48 45 38 48 44 "
"46 43 49 25 55 54 47 55 47 49 "
"48 46 50 51 47 53 54 53 47 56 48 "
"50 55 49 52 60 61 59 56 50 57 "
"60 59 58 60 58 56 61 63 62 60 56 "
"57 62 63 66 68 65 67 67 65 64 "
"63 61 60 66 63 70 70 63 69 70 97 "
"75 71 72 67 72 68 67 77 72 71 "
"85 77 73 97 80 78 70 95 97 76 85 "
"73 73 77 71 79 87 76 82 92 79 "
"75 97 78 97 81 80 81 96 83 96 82 "
"83 70 84 95 86 85 76 87 86 76 "
"79 90 89 88 77 85 79 89 87 91 90 "
"79 92 91 79 93 92 82 94 93 82 "
"96 94 82 70 74 84 70 69 74 81 97 "
"96 98 88 85 98 99 109 99 98 85 "
"100 104 99 104 101 102 101 104 100 99 114 "
"109 103 104 102 115 110 103 105 99 104 "
"99 113 114 106 103 110 103 106 104 112 109 "
"114 107 115 103 99 105 108 99 108 113 "
"111 115 107 115 116 117 117 116 118 116 115 "
"111 118 119 120 119 121 120 119 118 116 "
;

char *VTK_VECTOR_TEXT_54 = "123 0.399286 "
"0.25429 -0.35786 0.22143 -0.35500 0.21429 -0.35357 0.20857 -0.35214 0.20429 -0.35071 "
"0.29143 -0.35071 0.19857 -0.34929 0.29714 -0.34786 0.19143 -0.34643 0.23571 -0.34214 "
"0.26286 -0.34214 0.31429 -0.34214 0.26857 -0.34071 0.27286 -0.33929 0.17429 -0.33786 "
"0.21429 -0.33214 0.28571 -0.33214 0.16429 -0.33071 0.29143 -0.32786 0.34000 -0.32643 "
"0.15714 -0.32500 0.35286 -0.31643 0.19500 -0.31286 0.14214 -0.31143 0.30643 -0.31000 "
"0.30929 -0.30429 0.18929 -0.30143 0.18786 -0.29714 0.31214 -0.29571 0.37500 -0.29429 "
"0.18643 -0.29143 0.31357 -0.29000 0.31500 -0.27857 0.11786 -0.27429 0.38643 -0.27429 "
"0.11214 -0.26429 0.39071 -0.26286 0.39357 -0.25429 0.10643 -0.25143 0.39500 -0.24857 "
"0.39643 -0.24143 0.09929 -0.23143 0.39786 -0.23000 0.09786 -0.22571 0.09643 -0.22143 "
"0.09500 -0.21571 0.09357 -0.21000 0.39929 -0.20571 0.09214 -0.20286 0.09071 -0.19429 "
"0.39643 -0.18714 0.08929 -0.18429 0.08786 -0.16857 0.31500 -0.16714 0.38929 -0.16571 "
"0.31357 -0.15571 0.31214 -0.14857 0.18643 -0.14714 0.18786 -0.14143 0.30929 -0.14000 "
"0.08643 -0.13857 0.37357 -0.13429 0.19357 -0.12857 0.30214 -0.12714 0.19786 -0.12286 "
"0.08929 -0.11286 0.28571 -0.11071 0.35143 -0.11071 0.18429 -0.10929 0.21429 -0.10929 "
"0.09214 -0.10429 0.27429 -0.10500 0.22571 -0.10357 0.23000 -0.10214 0.26571 -0.10214 "
"0.23571 -0.10071 0.26000 -0.10071 0.09214 -0.09857 0.20857 -0.09357 0.31429 -0.08929 "
"0.24143 -0.08214 0.27571 -0.08071 0.10214 -0.06857 0.10643 -0.05857 0.11500 -0.03857 "
"0.18357 -0.03857 0.32714 -0.03929 0.30429 -0.03786 0.29286 -0.03500 0.34000 -0.03357 "
"0.18500 -0.03000 0.28357 -0.02714 0.18643 -0.02429 0.35357 -0.02000 0.28071 -0.01857 "
"0.27929 -0.01286 0.35786 -0.00714 0.14071 -0.00143 0.27786 0.00000 0.20071 0.00143 "
"0.20500 0.00714 0.28071 0.00857 0.28214 0.01571 0.35786 0.01571 0.16143 0.01929 "
"0.17429 0.02929 0.28357 0.03143 0.22857 0.03214 0.27429 0.03500 0.34786 0.03714 "
"0.19000 0.03786 0.24000 0.03786 0.24571 0.03929 0.26143 0.03929 0.20429 0.04500 "
"0.33857 0.04643 0.22000 0.05071 0.22571 0.05214 0.23143 0.05357 0.23714 0.05500 "
"0.32000 0.05500 0.24571 0.05643 0.29143 0.05929 123 0 9 1 10 9 0 14 8 15 15 2 1 13 "
"5 16 5 13 12 7 18 5 15 1 9 12 10 0 4 3 15 5 12 0 18 "
"16 5 22 17 14 11 18 7 23 30 33 3 2 15 6 4 15 24 18 11 19 "
"24 11 8 6 15 25 19 21 22 14 15 19 25 24 23 20 26 26 20 17 25 "
"21 28 31 28 21 29 32 21 26 17 22 32 31 21 23 27 30 23 26 27 34 "
"32 29 33 30 35 35 30 38 36 32 34 32 37 39 38 30 41 32 39 40 37 "
"32 36 32 40 42 44 43 30 43 41 30 45 44 30 47 32 42 46 45 30 48 "
"46 30 49 48 30 53 32 47 51 49 30 54 55 53 52 51 30 50 53 47 56 "
"55 54 54 53 50 56 54 59 60 52 57 57 52 30 60 57 65 61 59 54 59 "
"67 63 67 59 61 57 70 65 77 70 62 82 64 83 77 62 82 68 64 69 68 "
"69 78 66 81 71 78 72 73 80 75 76 63 79 66 78 73 80 79 63 67 71 "
"81 74 81 76 74 78 69 72 73 75 80 80 76 81 62 70 58 79 81 66 70 "
"57 58 62 64 82 83 64 68 84 85 97 83 68 85 87 95 94 87 94 88 84 "
"83 85 85 90 97 96 101 98 89 87 86 91 88 94 90 92 97 96 102 101 104 "
"99 100 104 100 105 95 87 89 98 89 93 104 97 92 98 95 89 99 104 92 96 "
"98 93 102 103 106 103 102 96 110 105 100 109 115 106 121 111 112 121 112 113 106 "
"122 108 111 118 107 109 106 103 108 122 113 110 100 114 100 107 114 114 107 116 117 "
"116 107 118 117 107 119 118 111 119 111 121 121 113 122 106 115 120 122 106 120 "
;

char *VTK_VECTOR_TEXT_55 = "72 0.379286 "
"0.20571 -0.36071 0.15286 -0.35786 0.14286 -0.35643 0.19143 -0.35643 0.21786 -0.35571 "
"0.16000 -0.35500 0.18429 -0.35500 0.17286 -0.35357 0.22071 -0.34714 0.12786 -0.34571 "
"0.22214 -0.34143 0.22357 -0.33429 0.12786 -0.33000 0.22500 -0.32571 0.13071 -0.32429 "
"0.13357 -0.31571 0.22643 -0.31571 0.13643 -0.30857 0.22786 -0.30714 0.22929 -0.29571 "
"0.14500 -0.29000 0.23071 -0.28571 0.23214 -0.27714 0.23357 -0.26857 0.15786 -0.26429 "
"0.23500 -0.26143 0.23643 -0.25429 0.23786 -0.24714 0.23929 -0.24143 0.24071 -0.23429 "
"0.24214 -0.23000 0.17786 -0.22857 0.24357 -0.22429 0.24500 -0.21857 0.24643 -0.21429 "
"0.24786 -0.20857 0.25786 -0.18286 0.27929 -0.13857 0.28357 -0.13143 0.28929 -0.12143 "
"0.32500 -0.06857 0.09429 -0.06643 0.10000 -0.06643 0.08929 -0.06143 0.10643 -0.06143 "
"0.08786 -0.05000 0.11214 -0.04857 0.12143 -0.03929 0.30143 -0.03929 0.09357 -0.02571 "
"0.35071 -0.02429 0.09500 -0.02000 0.09643 -0.01429 0.10214 0.01000 0.36929 0.01286 "
"0.10357 0.01571 0.10500 0.02571 0.37643 0.03143 0.37786 0.03714 0.14143 0.04071 "
"0.32000 0.04071 0.32714 0.04214 0.10500 0.05000 0.37929 0.05000 0.13357 0.05143 "
"0.35143 0.05071 0.35857 0.05500 0.37286 0.05643 0.13071 0.06714 0.10929 0.06857 "
"0.11571 0.07500 0.12286 0.07500 70 7 6 11 2 1 5 8 3 0 "
"2 12 9 5 14 12 6 3 10 3 8 "
"10 7 11 14 8 0 4 6 10 11 "
"2 5 12 14 11 15 5 7 14 20 13 "
"16 20 11 13 15 11 17 22 23 31 "
"20 19 24 17 11 20 23 25 31 20 18 "
"19 20 16 18 24 22 31 24 19 21 "
"24 21 22 26 27 31 37 31 36 25 26 "
"31 37 48 31 31 28 29 37 38 48 "
"31 27 28 31 29 30 31 32 33 38 39 "
"48 31 30 32 36 31 35 31 34 35 "
"31 33 34 43 41 42 43 42 44 45 46 "
"49 43 44 45 40 48 39 45 44 46 "
"46 47 49 51 49 47 52 51 47 52 47 "
"53 50 48 40 48 60 47 48 50 60 "
"55 53 47 60 56 47 57 65 54 54 61 "
"50 56 55 47 59 56 60 61 60 50 "
"61 54 65 68 69 62 64 56 59 66 57 "
"58 65 57 66 66 63 67 66 58 63 "
"64 62 56 68 70 69 71 70 68 68 62 "
"64 "
;

char *VTK_VECTOR_TEXT_56 = "151 0.403571 "
"0.28571 -0.35786 0.23429 -0.35500 0.29857 -0.35500 0.30571 -0.35500 0.22429 -0.35357 "
"0.21714 -0.35214 0.21000 -0.35071 0.20286 -0.34929 0.32286 -0.34929 0.19714 -0.34786 "
"0.19286 -0.34643 0.33000 -0.34643 0.18714 -0.34500 0.16571 -0.33786 0.35000 -0.33643 "
"0.24857 -0.33357 0.26143 -0.33214 0.22000 -0.33071 0.26857 -0.33071 0.14571 -0.32929 "
"0.27429 -0.32929 0.21429 -0.32786 0.36143 -0.32786 0.28286 -0.32643 0.20286 -0.32500 "
"0.13000 -0.31929 0.30000 -0.31786 0.12286 -0.31357 0.18286 -0.31357 0.31000 -0.31071 "
"0.38357 -0.30571 0.10643 -0.29857 0.16357 -0.29286 0.32500 -0.29286 0.39357 -0.28714 "
"0.32929 -0.28429 0.15786 -0.28143 0.09357 -0.27714 0.15500 -0.27429 0.33357 -0.27143 "
"0.39929 -0.27000 0.09071 -0.26857 0.15357 -0.26857 0.33500 -0.26429 0.40071 -0.26429 "
"0.08929 -0.26286 0.15214 -0.26286 0.40214 -0.25714 0.08786 -0.25429 0.15071 -0.25429 "
"0.33500 -0.25143 0.40357 -0.24714 0.33357 -0.24571 0.08643 -0.24143 0.15071 -0.24000 "
"0.32929 -0.23571 0.08929 -0.23000 0.15214 -0.22857 0.15357 -0.22286 0.09643 -0.21714 "
"0.30857 -0.21500 0.15929 -0.20571 0.40357 -0.20571 0.10500 -0.20429 0.28714 -0.20214 "
"0.39929 -0.19571 0.16500 -0.19429 0.27000 -0.19500 0.25857 -0.19071 0.25143 -0.18786 "
"0.23000 -0.18071 0.13143 -0.17929 0.22429 -0.17929 0.21857 -0.17786 0.13714 -0.17643 "
"0.21286 -0.17643 0.20571 -0.17500 0.19857 -0.17357 0.18571 -0.17214 0.38500 -0.16857 "
"0.16357 -0.15857 0.15786 -0.15000 0.36571 -0.14786 0.14357 -0.13286 0.32643 -0.12000 "
"0.13071 -0.11571 0.31000 -0.10786 0.12357 -0.10429 0.27714 -0.10214 0.35571 -0.09929 "
"0.25429 -0.09643 0.24857 -0.09357 0.24143 -0.09214 0.32071 -0.08857 0.22286 -0.08500 "
"0.37214 -0.08286 0.32357 -0.08143 0.11071 -0.07857 0.32500 -0.07714 0.37500 -0.07714 "
"0.10929 -0.07429 0.20429 -0.07500 0.32643 -0.07143 0.38071 -0.07000 0.10786 -0.06714 "
"0.32786 -0.06429 0.38214 -0.06429 0.18071 -0.05571 0.38643 -0.05429 0.17500 -0.04571 "
"0.32786 -0.04286 0.17357 -0.04143 0.10786 -0.03857 0.32643 -0.03429 0.32500 -0.02857 "
"0.17357 -0.02286 0.11357 -0.02143 0.32214 -0.02000 0.38500 -0.02000 0.11786 -0.01143 "
"0.17786 -0.01143 0.31643 -0.00857 0.12214 -0.00286 0.18357 -0.00143 0.12500 0.00143 "
"0.18929 0.00571 0.37357 0.00714 0.29714 0.01214 0.28857 0.01786 0.20571 0.01929 "
"0.21143 0.02214 0.21857 0.02500 0.27286 0.02500 0.35714 0.02500 0.22429 0.02643 "
"0.26714 0.02643 0.14857 0.02786 0.23000 0.02786 0.26143 0.02786 0.25000 0.02929 "
"0.15429 0.03071 0.16571 0.03786 0.33143 0.04071 0.18286 0.04643 0.20000 0.05214 "
"0.20571 0.05357 0.21286 0.05500 0.22143 0.05643 0.28000 0.05643 0.23714 0.05786 "
"0.25286 0.05929 153 17 5 4 26 11 14 17 7 6 10 9 7 0 "
"15 1 8 26 3 17 12 10 17 10 7 17 6 5 23 0 2 17 4 1 17 "
"13 12 16 15 0 18 16 0 17 1 15 20 18 0 26 2 3 13 17 21 20 "
"0 23 13 28 19 23 2 26 24 13 21 19 32 25 26 14 29 26 8 11 28 "
"13 24 29 22 33 31 36 37 22 30 33 22 29 14 35 30 39 27 25 32 35 "
"33 30 19 28 32 34 39 30 48 45 42 37 36 41 31 27 32 45 41 38 43 "
"39 34 36 31 32 41 36 38 45 38 42 50 43 34 50 40 44 48 42 46 53 "
"54 56 52 50 47 40 50 34 52 47 55 48 46 49 50 44 47 53 48 54 48 "
"49 54 55 79 60 55 51 79 56 54 59 59 57 58 68 84 86 65 79 51 59 "
"54 57 59 58 63 88 77 76 61 63 58 64 84 67 84 68 67 63 61 71 60 "
"84 64 88 75 73 88 73 72 88 69 68 74 66 80 69 88 70 66 74 61 88 "
"72 70 74 71 61 77 94 78 80 94 81 94 80 78 78 80 66 79 82 60 82 "
"84 60 86 84 93 55 47 51 87 94 97 94 77 92 92 77 91 90 77 88 77 "
"90 91 94 100 97 85 94 87 89 95 102 88 68 86 88 76 75 89 98 96 83 "
"94 85 89 102 98 89 96 84 81 94 83 112 111 116 65 51 62 107 104 100 99 "
"102 95 105 102 99 96 93 84 118 114 113 103 106 105 101 100 94 107 100 101 118 "
"113 110 103 105 99 109 104 107 118 110 105 112 104 111 108 105 106 104 109 111 121 "
"133 127 116 111 119 119 111 122 111 115 122 120 122 115 117 118 121 114 118 117 118 "
"105 108 124 120 136 121 126 133 124 122 120 123 125 136 120 123 136 121 118 126 141 "
"129 143 129 140 125 128 148 132 136 125 140 129 130 144 147 130 131 148 135 132 148 "
"138 135 129 141 140 143 129 144 139 149 137 139 150 149 127 133 142 127 142 128 145 "
"144 130 146 145 130 147 146 130 149 134 137 149 147 131 149 131 134 150 139 138 142 "
"148 128 150 138 148 "
;

char *VTK_VECTOR_TEXT_57 = "134 0.397857 "
"0.22143 -0.35786 0.18000 -0.35500 0.17286 -0.35357 0.16429 -0.35214 0.25571 -0.35214 "
"0.15857 -0.35071 0.15286 -0.34929 0.26143 -0.34929 0.27000 -0.34643 0.14143 -0.34500 "
"0.12857 -0.33786 0.30000 -0.33214 0.20143 -0.32929 0.22429 -0.32929 0.19000 -0.32786 "
"0.23000 -0.32786 0.18286 -0.32643 0.17786 -0.32429 0.24286 -0.32357 0.11214 -0.32143 "
"0.31429 -0.32214 0.25429 -0.31786 0.32286 -0.31500 0.26286 -0.31214 0.10786 -0.31000 "
"0.10643 -0.30286 0.19786 -0.30286 0.34071 -0.29857 0.20357 -0.28857 0.29071 -0.28429 "
"0.10643 -0.28000 0.20357 -0.27286 0.20071 -0.26429 0.30214 -0.26286 0.36786 -0.26286 "
"0.11643 -0.26000 0.30500 -0.25429 0.19000 -0.25071 0.30643 -0.24714 0.13286 -0.24500 "
"0.14286 -0.24214 0.15143 -0.24071 0.17000 -0.24071 0.37929 -0.24000 0.15714 -0.23929 "
"0.38357 -0.23000 0.30929 -0.22143 0.22714 -0.22071 0.20429 -0.21929 0.19429 -0.21786 "
"0.23571 -0.21786 0.24143 -0.21786 0.18857 -0.21643 0.18286 -0.21500 0.38929 -0.21286 "
"0.17000 -0.21071 0.39071 -0.20714 0.39214 -0.20143 0.14857 -0.19929 0.39357 -0.19571 "
"0.23000 -0.19357 0.25286 -0.19357 0.22429 -0.19214 0.26000 -0.19214 0.26429 -0.19071 "
"0.30786 -0.19000 0.13571 -0.18929 0.39500 -0.18714 0.21000 -0.18643 0.27857 -0.18357 "
"0.20143 -0.18071 0.39643 -0.17857 0.11643 -0.17143 0.29643 -0.16714 0.39786 -0.16286 "
"0.18357 -0.16143 0.10786 -0.16000 0.30357 -0.15571 0.17786 -0.14857 0.30643 -0.14857 "
"0.17643 -0.14286 0.30786 -0.14286 0.09786 -0.14000 0.30929 -0.13571 0.09357 -0.12714 "
"0.09214 -0.12143 0.09071 -0.11429 0.39786 -0.11286 0.08929 -0.10286 0.39357 -0.08714 "
"0.08786 -0.08000 0.09071 -0.06571 0.38500 -0.06000 0.09214 -0.05286 0.38214 -0.05286 "
"0.38071 -0.04857 0.09500 -0.04714 0.37500 -0.03571 0.10071 -0.02857 0.36643 -0.01857 "
"0.30929 -0.01714 0.17643 -0.01143 0.30786 -0.01000 0.17786 -0.00571 0.11643 -0.00429 "
"0.30500 -0.00143 0.35500 0.00000 0.30214 0.00429 0.35071 0.00571 0.18357 0.00714 "
"0.29143 0.01786 0.19714 0.02214 0.14286 0.02357 0.33429 0.02500 0.28000 0.02643 "
"0.20857 0.02929 0.21571 0.03214 0.26857 0.03214 0.22000 0.03357 0.26429 0.03357 "
"0.22571 0.03500 0.25857 0.03500 0.23429 0.03643 0.25000 0.03643 0.31857 0.03643 "
"0.17286 0.04214 0.18286 0.04643 0.30286 0.04643 0.20000 0.05214 0.20571 0.05357 "
"0.21143 0.05500 0.22000 0.05643 0.23286 0.05786 0.26429 0.05786 134 4 15 0 8 21 "
"7 4 7 18 14 2 1 14 5 3 "
"6 14 9 14 3 2 21 8 23 9 16 "
"10 6 5 14 15 13 0 15 4 18 "
"12 1 13 11 20 29 12 14 1 0 13 "
"1 9 14 16 17 10 16 19 17 24 "
"18 7 21 10 17 19 25 24 17 32 17 "
"31 23 11 29 39 35 40 23 8 11 "
"35 25 17 29 27 33 29 20 22 30 25 "
"35 29 22 27 17 26 31 33 27 36 "
"38 36 27 28 31 26 38 34 43 38 43 "
"46 35 37 42 32 37 17 41 40 35 "
"44 41 42 41 35 42 35 17 37 45 46 "
"43 65 46 54 64 63 51 61 50 51 "
"50 61 47 34 38 27 55 62 58 54 46 "
"45 62 49 48 65 54 56 65 56 57 "
"62 53 52 62 48 47 60 62 47 61 60 "
"47 49 62 52 53 62 55 69 65 73 "
"65 69 51 63 61 51 69 64 51 68 58 "
"62 70 58 68 78 82 76 65 57 59 "
"78 72 66 78 76 72 59 83 81 73 65 "
"59 73 59 77 58 75 66 59 67 83 "
"59 81 79 75 58 70 77 59 79 67 71 "
"83 86 85 80 84 78 80 82 78 84 "
"78 66 75 85 84 80 71 74 83 87 83 "
"74 88 86 80 90 88 80 89 83 87 "
"90 80 91 91 96 93 92 83 89 91 80 "
"96 83 92 94 96 80 98 97 83 95 "
"83 94 95 99 100 97 100 83 97 105 108 "
"107 107 113 110 80 101 98 98 101 104 "
"104 101 112 109 112 103 102 108 105 108 102 "
"100 106 100 99 112 101 103 112 109 125 "
"106 108 100 127 121 119 107 108 113 111 125 "
"109 127 119 117 126 111 115 116 130 115 "
"110 124 114 124 110 113 130 116 118 132 120 "
"122 132 118 120 125 111 126 127 117 114 "
"122 123 133 127 114 124 126 115 128 123 121 "
"133 129 128 115 130 129 115 131 130 118 "
"131 118 132 132 122 133 133 121 127 "
;

char *VTK_VECTOR_TEXT_58 = "57 0.193571 "
"0.14286 -0.35929 0.14143 -0.35786 0.16000 -0.35786 0.13571 -0.35643 0.13286 -0.35500 "
"0.16571 -0.35500 0.13000 -0.35357 0.17571 -0.35071 0.12429 -0.34929 0.11929 -0.34571 "
"0.11357 -0.33857 0.18786 -0.33857 0.11214 -0.33429 0.18929 -0.33429 0.11071 -0.33143 "
"0.10929 -0.32714 0.19357 -0.32429 0.10786 -0.32143 0.10643 -0.32000 0.10643 -0.30714 "
"0.19357 -0.30714 0.11214 -0.29143 0.18500 -0.28714 0.17571 -0.27786 0.12857 -0.27643 "
"0.13286 -0.27500 0.13714 -0.27357 0.14286 -0.27214 0.14429 -0.27071 0.15714 -0.27071 "
"0.14143 -0.19929 0.15571 -0.19929 0.14000 -0.19786 0.13429 -0.19643 0.13143 -0.19500 "
"0.12714 -0.19214 0.17429 -0.19214 0.11357 -0.17857 0.18786 -0.17857 0.11214 -0.17429 "
"0.18929 -0.17429 0.11071 -0.17143 0.10929 -0.16714 0.19357 -0.16429 0.10786 -0.16143 "
"0.10643 -0.16000 0.10643 -0.14714 0.19357 -0.14714 0.11357 -0.13000 0.18643 -0.12857 "
"0.17571 -0.11786 0.12857 -0.11643 0.13286 -0.11500 0.13714 -0.11357 0.14286 -0.11214 "
"0.14429 -0.11071 0.15714 -0.11071 53 20 22 21 17 15 8 17 8 5 9 "
"12 10 9 8 12 4 3 1 15 14 12 8 4 1 8 6 4 15 12 8 11 "
"13 5 7 11 5 2 1 0 2 5 8 2 8 1 21 17 5 19 17 21 17 "
"19 18 16 20 13 26 25 21 21 22 23 27 26 21 21 25 24 20 5 13 20 "
"21 5 29 21 23 29 27 21 29 28 27 32 30 31 44 42 48 35 31 36 42 "
"39 48 34 33 32 35 34 32 42 41 39 35 32 31 35 36 40 35 39 37 39 "
"35 48 53 52 48 40 36 38 46 44 48 44 46 45 43 35 40 49 50 48 56 "
"54 48 48 52 51 43 47 35 50 56 48 54 53 48 47 48 35 47 49 48 56 "
"55 54 "
;

char *VTK_VECTOR_TEXT_59 = "58 0.200714 "
"0.12357 -0.45286 0.12571 -0.45357 0.12714 -0.45214 0.14714 -0.43786 0.16429 -0.43643 "
"0.18214 -0.41857 0.16643 -0.41714 0.16929 -0.41286 0.19071 -0.40286 0.17786 -0.39571 "
"0.17929 -0.39000 0.18071 -0.38429 0.19929 -0.37571 0.18071 -0.36714 0.17929 -0.36000 "
"0.13857 -0.35643 0.15714 -0.35643 0.13143 -0.35500 0.16429 -0.35357 0.17786 -0.35286 "
"0.17000 -0.35214 0.17571 -0.35071 0.11500 -0.34000 0.20071 -0.33714 0.10786 -0.32857 "
"0.19786 -0.32714 0.10643 -0.32000 0.19643 -0.31857 0.19500 -0.31143 0.10500 -0.30571 "
"0.19500 -0.30571 0.18786 -0.29000 0.11214 -0.28857 0.12714 -0.27500 0.17429 -0.27500 "
"0.13571 -0.27214 0.14143 -0.27071 0.15857 -0.26929 0.15571 -0.19929 0.13857 -0.19786 "
"0.13429 -0.19643 0.12857 -0.19357 0.17143 -0.19357 0.18643 -0.18000 0.11214 -0.17714 "
"0.11071 -0.17286 0.18929 -0.17286 0.10786 -0.16857 0.19214 -0.16857 0.19357 -0.15143 "
"0.10643 -0.14429 0.10929 -0.13571 0.18643 -0.13000 0.17714 -0.11929 0.12571 -0.11786 "
"0.13286 -0.11500 0.13714 -0.11214 0.15714 -0.11071 53 2 0 1 3 4 6 4 3 2 "
"5 7 6 5 6 4 7 5 9 5 8 "
"9 10 9 8 11 10 8 23 19 14 "
"12 13 11 12 11 8 14 13 12 15 22 "
"17 16 22 15 18 27 22 23 14 12 "
"18 20 25 21 25 20 21 19 23 27 24 "
"22 27 26 24 25 21 23 16 18 22 "
"18 25 27 29 26 32 26 28 32 26 27 "
"28 31 36 32 31 28 30 31 32 28 "
"37 36 31 33 32 35 37 31 34 36 35 "
"32 44 39 38 40 44 41 40 39 44 "
"45 44 38 46 48 49 50 54 51 47 45 "
"54 46 42 43 50 47 54 57 56 55 "
"45 38 54 46 49 42 52 42 49 57 38 "
"42 38 57 55 52 57 42 38 55 54 "
"52 53 57 "
;

char *VTK_VECTOR_TEXT_60 = "120 0.405000 "
"0.40429 -0.30071 0.39714 -0.29500 0.39429 -0.29357 0.39000 -0.29071 0.38714 -0.28929 "
"0.38286 -0.28643 0.38000 -0.28500 0.37143 -0.27929 0.36857 -0.27786 0.36429 -0.27500 "
"0.36143 -0.27357 0.35714 -0.27071 0.35429 -0.26929 0.35000 -0.26643 0.34714 -0.26500 "
"0.33857 -0.25929 0.33571 -0.25786 0.33143 -0.25500 0.32857 -0.25357 0.32429 -0.25071 "
"0.32143 -0.24929 0.31714 -0.24643 0.31429 -0.24500 0.30571 -0.23929 0.30286 -0.23786 "
"0.29857 -0.23500 0.29571 -0.23357 0.29143 -0.23071 0.28857 -0.22929 0.28429 -0.22643 "
"0.28143 -0.22500 0.38714 -0.22286 0.27286 -0.21929 0.27000 -0.21786 0.26571 -0.21500 "
"0.26286 -0.21357 0.25857 -0.21071 0.25571 -0.20929 0.25143 -0.20643 0.24857 -0.20500 "
"0.40500 -0.20143 0.24000 -0.19929 0.23714 -0.19786 0.23286 -0.19500 0.23000 -0.19357 "
"0.22571 -0.19071 0.22286 -0.18929 0.21857 -0.18643 0.21571 -0.18500 0.37286 -0.18357 "
"0.36857 -0.18214 0.20714 -0.17929 0.20429 -0.17786 0.20000 -0.17500 0.19714 -0.17357 "
"0.19286 -0.17071 0.19000 -0.16929 0.18143 -0.16357 0.17857 -0.16214 0.17429 -0.15929 "
"0.17143 -0.15786 0.16714 -0.15500 0.16429 -0.15357 0.16000 -0.15071 0.15714 -0.14929 "
"0.14857 -0.14357 0.14571 -0.14214 0.14143 -0.13929 0.12929 -0.13286 0.27929 -0.13286 "
"0.28857 -0.12643 0.29429 -0.12357 0.29857 -0.12071 0.15143 -0.11929 0.30429 -0.11786 "
"0.30857 -0.11500 0.15857 -0.11357 0.31143 -0.11357 0.31571 -0.11071 0.31857 -0.10929 "
"0.17000 -0.10786 0.17714 -0.10357 0.32714 -0.10357 0.33000 -0.10214 0.18429 -0.09929 "
"0.33429 -0.09929 0.33714 -0.09786 0.34143 -0.09500 0.19143 -0.09357 0.34714 -0.09214 "
"0.35143 -0.08929 0.20286 -0.08786 0.35714 -0.08643 0.21000 -0.08357 0.36143 -0.08357 "
"0.36714 -0.08071 0.21714 -0.07929 0.37143 -0.07786 0.22429 -0.07500 0.37714 -0.07500 "
"0.38143 -0.07214 0.23143 -0.06929 0.39000 -0.06786 0.39429 -0.06500 0.24286 -0.06357 "
"0.40000 -0.06214 0.25000 -0.05929 0.40500 -0.05857 0.25714 -0.05500 0.26429 -0.05071 "
"0.27143 -0.04500 0.29714 -0.03071 0.30429 -0.02500 0.31571 -0.01929 0.32286 -0.01500 "
"0.33000 -0.01071 0.33714 -0.00643 0.34429 -0.00071 0.37714 0.01786 0.40429 0.03500 119 31 16 15 31 17 "
"16 31 18 17 31 19 18 31 11 10 "
"31 20 19 20 31 21 31 8 7 31 10 "
"9 14 31 15 31 14 13 6 31 7 "
"31 12 11 31 13 12 31 22 21 31 6 "
"5 31 9 8 31 5 4 24 31 25 "
"22 31 23 26 25 31 24 23 31 30 29 "
"31 28 27 31 26 31 27 30 31 32 "
"28 31 29 33 32 31 35 34 31 33 31 "
"34 37 36 31 35 31 36 48 47 84 "
"51 48 84 31 4 3 40 2 1 0 40 "
"1 40 3 2 43 42 84 40 31 3 "
"44 43 84 46 45 84 47 46 84 45 44 "
"84 49 31 40 42 41 84 50 31 49 "
"54 53 84 41 31 84 41 38 31 52 51 "
"84 55 54 84 53 52 84 41 39 38 "
"38 37 31 56 84 57 56 55 84 69 96 "
"93 69 98 96 69 91 88 69 93 91 "
"76 73 64 31 50 69 64 73 65 67 66 "
"73 68 67 73 76 64 63 84 58 57 "
"66 65 73 71 98 70 69 88 84 81 80 "
"63 80 76 63 111 83 85 84 81 63 "
"111 85 86 71 72 98 82 108 106 82 110 "
"109 70 98 69 111 82 83 84 59 58 "
"82 104 101 82 109 108 82 106 104 84 60 "
"59 98 78 79 84 61 60 84 62 61 "
"82 111 110 31 69 84 111 89 90 99 111 "
"97 111 92 94 84 63 62 92 111 90 "
"111 86 87 95 111 94 111 95 97 99 100 "
"111 112 100 113 82 101 98 105 115 103 "
"115 102 103 74 98 72 98 74 75 98 75 "
"77 98 77 78 105 107 115 102 115 100 "
"89 111 87 82 98 79 112 111 100 113 100 "
"114 114 100 115 115 107 116 117 107 118 "
"117 116 107 118 107 119 "
;

char *VTK_VECTOR_TEXT_61 = "8 0.385000 "
"0.11571 -0.27786 0.38500 -0.27714 0.11571 -0.22929 0.38429 -0.22929 0.11571 -0.12786 "
"0.38500 -0.12714 0.11571 -0.07786 0.38429 -0.07786 4 1 3 2 1 2 "
"0 5 7 6 5 6 4 "
;

char *VTK_VECTOR_TEXT_62 = "108 0.390714 "
"0.11571 -0.30071 0.12143 -0.29643 0.12571 -0.29357 0.12857 -0.29214 0.13714 -0.28643 "
"0.14000 -0.28500 0.14429 -0.28214 0.14714 -0.28071 0.15143 -0.27786 0.15429 -0.27643 "
"0.16286 -0.27071 0.16571 -0.26929 0.17000 -0.26643 0.17286 -0.26500 0.17714 -0.26214 "
"0.18000 -0.26071 0.18429 -0.25786 0.18714 -0.25643 0.19571 -0.25071 0.19857 -0.24929 "
"0.20286 -0.24643 0.20571 -0.24500 0.21000 -0.24214 0.21286 -0.24071 0.21714 -0.23786 "
"0.22000 -0.23643 0.22857 -0.23071 0.23143 -0.22929 0.23571 -0.22643 0.23857 -0.22500 "
"0.24286 -0.22214 0.24571 -0.22071 0.25000 -0.21786 0.25286 -0.21643 0.26143 -0.21071 "
"0.26429 -0.20929 0.26857 -0.20643 0.27143 -0.20500 0.11500 -0.20143 0.27571 -0.20214 "
"0.27857 -0.20071 0.28286 -0.19786 0.12571 -0.19643 0.20429 -0.19571 0.28571 -0.19643 "
"0.13571 -0.19071 0.29429 -0.19071 0.29714 -0.18929 0.14143 -0.18786 0.30143 -0.18643 "
"0.30429 -0.18500 0.15143 -0.18214 0.30857 -0.18214 0.31143 -0.18071 0.15714 -0.17929 "
"0.32000 -0.17500 0.16714 -0.17357 0.32286 -0.17357 0.32714 -0.17071 0.33000 -0.16929 "
"0.33429 -0.16643 0.33714 -0.16500 0.34143 -0.16214 0.34429 -0.16071 0.35286 -0.15500 "
"0.35571 -0.15357 0.36000 -0.15071 0.36286 -0.14929 0.36714 -0.14643 0.22000 -0.14500 "
"0.37000 -0.14500 0.37429 -0.14214 0.37714 -0.14071 0.23000 -0.13929 0.23571 -0.13643 "
"0.38571 -0.13500 0.24071 -0.13286 0.39071 -0.13286 0.24000 -0.13071 0.23143 -0.12643 "
"0.22714 -0.12357 0.22143 -0.12071 0.21714 -0.11786 0.21429 -0.11643 0.21000 -0.11357 "
"0.20714 -0.11214 0.19857 -0.10643 0.19571 -0.10500 0.19143 -0.10214 0.18857 -0.10071 "
"0.18429 -0.09786 0.18143 -0.09643 0.17714 -0.09357 0.17143 -0.09071 0.16714 -0.08786 "
"0.15857 -0.08357 0.31000 -0.08357 0.15429 -0.08071 0.14571 -0.07643 0.14143 -0.07357 "
"0.13571 -0.07071 0.13143 -0.06786 0.12286 -0.06357 0.11857 -0.06071 0.11500 -0.05857 "
"0.12429 0.02929 0.11500 0.03429 0.11714 0.03500 107 38 2 42 "
"1 38 0 38 1 2 4 2 3 43 8 "
"9 43 6 7 43 7 8 43 2 4 "
"43 5 6 43 4 5 10 43 9 43 11 "
"12 43 10 11 43 15 16 43 12 14 "
"43 16 17 12 13 14 43 14 15 18 43 "
"17 43 19 20 43 18 19 43 23 24 "
"43 20 21 43 24 25 43 21 22 43 22 "
"23 43 32 33 43 27 28 26 43 25 "
"43 26 27 43 30 31 43 29 30 43 28 "
"29 43 31 32 43 35 36 34 43 33 "
"43 34 35 39 40 41 36 37 39 42 2 "
"45 43 39 41 77 96 75 43 36 39 "
"2 43 45 45 43 48 65 66 96 70 71 "
"96 48 43 51 51 43 54 68 70 96 "
"64 65 96 67 68 96 54 43 56 56 43 "
"69 66 67 96 57 96 55 58 59 60 "
"43 41 69 69 41 73 73 41 74 74 41 "
"76 61 62 96 62 63 96 96 71 72 "
"96 76 41 60 61 96 75 96 72 96 85 "
"84 64 96 63 96 78 76 78 96 79 "
"46 96 41 46 41 44 96 46 47 96 84 "
"83 57 58 96 96 52 53 96 50 52 "
"96 82 81 96 83 82 55 96 53 96 49 "
"50 96 47 49 58 60 96 80 96 81 "
"105 100 99 105 99 98 105 98 97 85 96 "
"86 105 101 100 105 97 95 96 80 79 "
"87 86 96 88 87 96 89 88 96 105 102 "
"101 105 104 103 94 93 96 93 92 96 "
"95 94 96 105 103 102 92 90 96 90 89 "
"96 92 91 90 106 104 105 106 105 107 "
"105 95 96 "
;

char *VTK_VECTOR_TEXT_63 = "97 0.305000 "
"0.17286 -0.35786 0.16143 -0.35643 0.15571 -0.35500 0.19000 -0.35214 0.14571 -0.34929 "
"0.13500 -0.34000 0.20786 -0.33571 0.21071 -0.32571 0.12643 -0.32429 0.21214 -0.30286 "
"0.12643 -0.30143 0.13214 -0.29143 0.19857 -0.27929 0.14571 -0.27643 0.16143 -0.27071 "
"0.17571 -0.26929 0.16857 -0.23214 0.19429 -0.23214 0.16143 -0.23071 0.14857 -0.22500 "
"0.21000 -0.22500 0.14143 -0.21929 0.22500 -0.21000 0.12643 -0.20429 0.17286 -0.20357 "
"0.19571 -0.20214 0.20000 -0.20071 0.16286 -0.19929 0.22929 -0.19857 0.15786 -0.19143 "
"0.23071 -0.19143 0.21071 -0.19000 0.15643 -0.18429 0.11786 -0.18286 0.23214 -0.17857 "
"0.11500 -0.17143 0.21214 -0.16571 0.22643 -0.16286 0.11357 -0.16000 0.15929 -0.15714 "
"0.16214 -0.14857 0.20500 -0.14429 0.20286 -0.13786 0.11500 -0.13429 0.17071 -0.13286 "
"0.13357 -0.10714 0.20714 -0.09500 0.25143 -0.06071 0.27214 -0.04143 0.28786 -0.02143 "
"0.21929 -0.01857 0.29643 -0.00429 0.14286 0.00071 0.11000 0.00214 0.09857 0.00500 "
"0.09286 0.00786 0.16286 0.00929 0.23786 0.01000 0.30214 0.01143 0.30357 0.01857 "
"0.07786 0.02143 0.17357 0.02286 0.24643 0.02857 0.17786 0.03286 0.07071 0.04000 "
"0.06929 0.04714 0.25214 0.04714 0.30500 0.05286 0.06786 0.05857 0.17643 0.06286 "
"0.25500 0.06286 0.06643 0.07857 0.16929 0.07857 0.29643 0.08571 0.25357 0.09286 "
"0.14143 0.09929 0.13000 0.10071 0.12286 0.10357 0.10857 0.10500 0.10357 0.10714 "
"0.24786 0.10714 0.28214 0.11143 0.07929 0.11429 0.12571 0.12643 0.22857 0.12643 "
"0.09571 0.13357 0.21429 0.13357 0.14571 0.13643 0.15714 0.13929 0.19571 0.13929 "
"0.18714 0.14071 0.25000 0.14214 0.12143 0.14929 0.23143 0.15214 0.14143 0.15643 "
"0.15429 0.15929 0.19286 0.16214 93 3 "
"13 11 3 5 1 2 1 4 3 11 8 5 4 1 8 11 10 5 3 8 7 "
"3 6 3 1 0 14 13 3 9 14 3 12 14 9 15 14 12 7 9 3 24 "
"16 17 23 29 33 18 24 19 24 18 16 20 26 25 24 17 25 20 25 17 26 "
"22 31 27 19 24 19 27 21 28 30 31 26 20 22 23 21 29 28 31 22 29 "
"21 27 31 34 36 31 30 34 33 32 35 33 29 32 38 35 32 39 43 32 36 "
"37 41 37 36 34 45 43 40 43 38 32 42 41 37 44 45 40 40 43 39 45 "
"46 50 45 44 46 47 50 46 50 48 57 48 49 57 50 47 48 57 51 62 51 "
"58 62 57 49 51 60 55 53 60 53 64 55 54 53 56 61 53 62 58 66 65 "
"64 53 61 63 53 56 53 52 67 66 58 67 58 59 66 67 70 68 65 53 72 "
"68 53 74 81 80 71 79 82 69 72 53 70 73 74 63 69 53 73 70 67 71 "
"68 76 80 91 84 68 72 76 75 76 72 74 73 81 71 76 78 71 78 79 78 "
"76 77 82 79 85 85 83 92 91 80 81 85 79 83 87 92 83 96 90 89 88 "
"95 87 84 93 86 94 87 95 93 84 91 87 94 92 86 96 89 86 93 96 90 "
"95 88 90 96 95 "
;

char *VTK_VECTOR_TEXT_64 = "157 0.713571 "
"0.48286 -0.42214 0.40286 -0.41929 0.49286 -0.41929 0.37857 -0.41500 0.52714 -0.41357 "
"0.36286 -0.41071 0.55000 -0.41071 0.47857 -0.39643 0.32286 -0.39500 0.41714 -0.39500 "
"0.49571 -0.39500 0.50857 -0.39357 0.39714 -0.39214 0.52429 -0.39071 0.37714 -0.38786 "
"0.36714 -0.38500 0.54571 -0.38500 0.34714 -0.37786 0.62929 -0.37714 0.57857 -0.37214 "
"0.27286 -0.36500 0.30857 -0.35643 0.61714 -0.35214 0.25286 -0.34929 0.29429 -0.34500 "
"0.22500 -0.32429 0.26357 -0.31000 0.25357 -0.29429 0.40429 -0.28786 0.59429 -0.28643 "
"0.19500 -0.28429 0.36857 -0.28500 0.54143 -0.28500 0.53571 -0.28357 0.35714 -0.28071 "
"0.44143 -0.27643 0.52000 -0.27500 0.18786 -0.27286 0.34571 -0.27357 0.63286 -0.26929 "
"0.46143 -0.26357 0.23786 -0.26143 0.33214 -0.26143 0.50357 -0.26000 0.40286 -0.25786 "
"0.42286 -0.25786 0.57143 -0.25786 0.59143 -0.25786 0.39286 -0.25357 0.60429 -0.25357 "
"0.17643 -0.25143 0.55429 -0.25214 0.65357 -0.24857 0.23214 -0.24429 0.45000 -0.24500 "
"0.54500 -0.24286 0.62143 -0.24357 0.38214 -0.24143 0.32071 -0.24000 0.49143 -0.23357 "
"0.16929 -0.23143 0.37643 -0.22857 0.54357 -0.22429 0.22643 -0.22143 0.67214 -0.22143 "
"0.47929 -0.21571 0.31357 -0.21429 0.31214 -0.20429 0.65357 -0.20429 0.22214 -0.19857 "
"0.16071 -0.19714 0.49071 -0.19286 0.66071 -0.19286 0.22071 -0.18714 0.31071 -0.18000 "
"0.69643 -0.17857 0.15643 -0.17286 0.15500 -0.16000 0.67786 -0.15429 0.37786 -0.14714 "
"0.31929 -0.14286 0.50929 -0.14286 0.70929 -0.14000 0.68500 -0.13143 0.38214 -0.12857 "
"0.15357 -0.12571 0.51500 -0.12286 0.71214 -0.12143 0.22357 -0.11714 0.38786 -0.11286 "
"0.32929 -0.11143 0.51786 -0.10714 0.15643 -0.10571 0.69071 -0.10143 0.22929 -0.08429 "
"0.40214 -0.08429 0.16500 -0.08000 0.34643 -0.07571 0.69214 -0.06714 0.41500 -0.06571 "
"0.23500 -0.06286 0.35786 -0.05714 0.51786 -0.05429 0.68929 -0.05143 0.71357 -0.04429 "
"0.51357 -0.04143 0.24357 -0.04000 0.68500 -0.03571 0.53429 -0.03500 0.45143 -0.03214 "
"0.50429 -0.03071 0.19357 -0.02143 0.49000 -0.02214 0.47571 -0.02071 0.39571 -0.01929 "
"0.52214 -0.01714 0.25643 -0.01429 0.59786 -0.01429 0.54071 -0.01286 0.67643 -0.01286 "
"0.51286 -0.00643 0.70357 -0.00571 0.26357 -0.00286 0.42286 -0.00357 0.54286 -0.00214 "
"0.60000 -0.00214 0.44857 0.00500 0.45714 0.00643 0.48000 0.00786 0.69500 0.01429 "
"0.28643 0.02714 0.65500 0.02714 0.23071 0.03143 0.68643 0.03143 0.63929 0.04857 "
"0.33857 0.07357 0.28286 0.07786 0.60571 0.08214 0.35714 0.08500 0.64286 0.08643 "
"0.58429 0.09643 0.38714 0.09929 0.56429 0.10643 0.41143 0.10786 0.54429 0.11357 "
"0.60714 0.11357 0.34714 0.11500 0.43714 0.11500 0.52714 0.11786 0.46143 0.11929 "
"0.47571 0.12071 0.58857 0.12500 0.40571 0.13643 0.41714 0.13929 0.54857 0.13929 "
"0.44571 0.14357 0.50000 0.14643 157 2 11 0 0 7 1 5 14 8 1 7 3 3 9 5 13 4 6 3 "
"7 9 4 11 2 10 7 0 11 10 0 5 12 14 11 4 13 13 6 16 5 "
"9 12 8 21 20 8 14 15 16 6 19 8 15 17 18 22 19 8 17 21 18 "
"19 6 24 20 21 20 24 23 27 25 26 25 27 30 26 23 24 41 37 30 25 "
"23 26 28 48 31 51 33 32 51 36 33 58 61 66 34 57 38 29 47 32 35 "
"45 28 49 47 29 37 41 50 43 55 59 39 49 29 45 44 28 62 65 59 32 "
"47 46 27 41 30 48 28 44 35 40 54 45 35 54 36 55 43 36 51 55 51 "
"32 46 49 39 56 31 57 34 54 59 65 68 56 52 57 31 48 42 38 57 52 "
"56 39 50 53 60 53 50 41 61 58 42 60 69 70 65 62 71 54 40 59 64 "
"68 52 63 60 53 67 66 61 61 42 57 62 59 55 70 73 76 68 64 72 60 "
"63 69 72 75 78 70 69 73 74 67 61 75 72 64 79 80 74 86 117 91 71 "
"62 81 83 78 75 80 79 90 88 92 85 82 83 75 79 74 61 83 87 93 77 "
"76 73 79 84 90 87 83 82 89 90 84 96 92 88 117 86 81 88 85 77 91 "
"108 102 88 77 73 90 89 97 98 93 87 95 97 89 97 95 101 96 100 111 98 "
"104 103 99 101 95 102 108 105 103 104 107 100 96 94 101 99 114 91 117 108 94 "
"96 88 119 107 104 104 98 87 115 110 105 117 118 108 123 109 126 110 120 112 115 "
"105 108 106 111 100 118 117 124 111 116 132 117 81 62 119 129 131 111 106 116 125 "
"124 117 99 109 123 121 119 104 128 113 112 114 99 123 129 119 121 113 127 109 127 "
"126 109 128 112 120 110 115 120 113 128 127 122 132 116 133 131 129 132 130 136 134 "
"139 137 134 131 133 130 132 122 136 130 135 139 134 133 136 135 146 135 138 146 140 "
"151 142 144 154 148 142 154 144 141 143 152 148 154 150 146 141 152 137 145 140 147 "
"153 143 145 137 139 141 146 138 151 140 145 152 143 153 156 149 150 142 151 154 153 "
"147 155 155 149 156 149 155 147 156 150 154 "
;

char *VTK_VECTOR_TEXT_65 = "57 0.609286 "
"0.57714 -0.35929 0.59714 -0.35929 0.09429 -0.35786 0.23429 -0.35786 0.60286 -0.35786 "
"0.43429 -0.35643 0.14143 -0.35500 0.53429 -0.35500 0.08643 -0.35143 0.42786 -0.35143 "
"0.23929 -0.35000 0.60929 -0.34571 0.08857 -0.34357 0.23143 -0.34214 0.21714 -0.34071 "
"0.43429 -0.34071 0.60286 -0.34071 0.45714 -0.33929 0.11286 -0.33643 0.20500 -0.33571 "
"0.46357 -0.33571 0.57429 -0.33643 0.12000 -0.33214 0.46643 -0.32857 0.20214 -0.32714 "
"0.13214 -0.32143 0.55929 -0.32000 0.46643 -0.31000 0.15500 -0.28429 0.20643 -0.28000 "
"0.20786 -0.27143 0.22500 -0.21000 0.42357 -0.20714 0.42071 -0.19714 0.23071 -0.19286 "
"0.41286 -0.18357 0.23857 -0.18214 0.40857 -0.18214 0.40000 -0.18071 0.26571 -0.16214 "
"0.38429 -0.16214 0.25143 -0.16071 0.39571 -0.16071 0.24786 -0.15857 0.25071 -0.14429 "
"0.39500 -0.13857 0.24500 -0.09429 0.37786 -0.08857 0.28214 -0.06000 0.30357 -0.01286 "
"0.34357 0.00000 0.33214 0.02143 0.32429 0.02786 0.33500 0.12286 0.37929 0.14000 "
"0.37000 0.15929 0.35857 0.16214 57 2 6 18 7 17 5 21 0 1 8 "
"2 12 12 2 18 0 21 7 15 5 17 3 14 6 10 13 3 9 5 15 11 "
"16 4 14 19 6 1 4 16 7 20 17 18 6 22 21 1 16 3 13 14 20 "
"7 23 22 6 25 23 7 27 25 6 24 24 6 19 26 7 21 25 24 28 42 "
"37 35 27 7 26 28 43 46 29 28 24 43 28 34 34 28 31 31 28 30 32 "
"27 26 47 45 26 45 42 35 43 44 46 42 38 37 28 29 30 38 39 36 40 "
"38 42 51 53 52 39 38 40 53 51 50 41 43 36 39 41 36 54 50 47 33 "
"32 26 36 43 34 53 46 48 33 26 35 49 53 48 48 46 44 54 53 50 52 "
"53 49 45 35 26 53 54 56 54 47 26 54 55 56 "
;

char *VTK_VECTOR_TEXT_66 = "97 0.480714 "
"0.11286 -0.35786 0.35429 -0.35643 0.12286 -0.35500 0.27429 -0.35500 0.08571 -0.35357 "
"0.13143 -0.35357 0.25571 -0.35357 0.14143 -0.35214 0.15286 -0.35071 0.08071 -0.34857 "
"0.18857 -0.34929 0.37857 -0.34643 0.08429 -0.33929 0.40143 -0.33643 0.11143 -0.33500 "
"0.32143 -0.33357 0.23286 -0.33214 0.32857 -0.33214 0.34143 -0.32643 0.12500 -0.32286 "
"0.42143 -0.32357 0.21643 -0.31714 0.12786 -0.31429 0.43429 -0.31357 0.21357 -0.31143 "
"0.36357 -0.30143 0.45643 -0.29286 0.37071 -0.28571 0.47071 -0.27000 0.37786 -0.26286 "
"0.38071 -0.24857 0.47929 -0.24429 0.48071 -0.21429 0.38357 -0.21000 0.38214 -0.19286 "
"0.47643 -0.18571 0.37929 -0.17714 0.37643 -0.16571 0.46214 -0.15286 0.36786 -0.14286 "
"0.35929 -0.12857 0.43143 -0.12357 0.21357 -0.11857 0.34429 -0.11357 0.22429 -0.10786 "
"0.33000 -0.10786 0.32000 -0.10643 0.37286 -0.09786 0.36571 -0.09643 0.35500 -0.09000 "
"0.23714 -0.08214 0.31571 -0.08214 0.36571 -0.08071 0.32857 -0.07643 0.22071 -0.06714 "
"0.39857 -0.06643 0.34357 -0.06286 0.21643 -0.05714 0.41857 -0.05643 0.35071 -0.05286 "
"0.42429 -0.05214 0.36071 -0.03000 0.44643 -0.03000 0.45500 -0.01000 0.36786 -0.00429 "
"0.45786 0.00286 0.36929 0.00429 0.45929 0.01429 0.46071 0.03571 0.37071 0.04714 "
"0.36929 0.05714 0.45214 0.07143 0.36500 0.07571 0.44357 0.09143 0.35929 0.09286 "
"0.43357 0.10571 0.12786 0.10857 0.35071 0.11000 0.12357 0.12286 0.21786 0.12429 "
"0.33857 0.12357 0.32714 0.13071 0.08714 0.13214 0.10143 0.13214 0.11571 0.13357 "
"0.08000 0.13500 0.23000 0.13500 0.31286 0.13500 0.40000 0.13500 0.07357 0.14000 "
"0.07357 0.14857 0.16714 0.15071 0.36429 0.15071 0.34286 0.15500 0.08143 0.15786 "
"0.09143 0.16071 0.10857 0.16214 99 6 "
"16 10 2 5 19 5 7 19 9 4 12 14 0 2 18 1 11 12 0 14 1 "
"15 3 0 12 4 6 3 15 11 13 25 14 2 19 1 17 15 16 6 15 18 "
"11 25 17 1 18 7 8 19 21 10 16 22 19 8 21 22 8 10 21 8 24 "
"22 21 27 20 29 25 13 27 29 26 30 20 23 29 20 27 13 29 23 26 30 "
"31 33 34 35 36 30 28 31 30 26 28 33 31 32 35 33 32 37 36 35 37 "
"41 39 35 34 33 47 40 39 38 37 35 37 38 41 42 22 24 40 48 43 46 "
"51 44 47 39 41 43 48 45 40 47 48 46 45 48 49 46 48 46 49 53 44 "
"54 42 51 50 44 51 46 53 52 56 49 56 53 49 57 22 42 61 58 60 57 "
"42 54 54 44 50 56 52 59 58 61 55 59 55 61 55 59 52 61 60 64 62 "
"64 60 66 64 62 71 70 69 63 66 62 66 65 67 66 67 68 71 69 66 66 "
"63 65 71 66 68 70 71 72 72 73 75 72 75 74 77 92 80 74 75 77 76 "
"22 57 72 71 73 96 83 84 91 78 76 94 83 95 85 90 89 86 87 93 80 "
"92 81 77 88 92 86 91 79 82 90 85 81 92 87 90 83 94 84 78 91 79 "
"76 57 91 86 93 77 75 88 93 87 92 79 91 76 82 83 90 96 95 83 96 "
"84 91 "
;

char *VTK_VECTOR_TEXT_67 = "95 0.576429 "
"0.38143 -0.35786 0.40000 -0.35500 0.29571 -0.35357 0.42000 -0.35357 0.27571 -0.35071 "
"0.25429 -0.34643 0.23286 -0.34071 0.47000 -0.33929 0.35286 -0.33786 0.40571 -0.33643 "
"0.41571 -0.33500 0.32571 -0.33357 0.20143 -0.32929 0.44000 -0.32929 0.29286 -0.32214 "
"0.18429 -0.32071 0.46286 -0.32071 0.52571 -0.30929 0.16429 -0.30786 0.26429 -0.30500 "
"0.50000 -0.30071 0.15143 -0.29786 0.51571 -0.28929 0.55357 -0.28286 0.12786 -0.27571 "
"0.23214 -0.27429 0.11214 -0.25429 0.57214 -0.25429 0.20500 -0.23429 0.57643 -0.23286 "
"0.56857 -0.23214 0.09929 -0.22857 0.09357 -0.21286 0.19214 -0.20714 0.08786 -0.19571 "
"0.18643 -0.19143 0.08357 -0.17714 0.18214 -0.17714 0.08071 -0.16000 0.17643 -0.15143 "
"0.07929 -0.14857 0.17500 -0.14286 0.07786 -0.13000 0.07643 -0.08714 0.17214 -0.07714 "
"0.17357 -0.05857 0.17500 -0.04714 0.08214 -0.04571 0.17643 -0.03714 0.08643 -0.02429 "
"0.50286 -0.02071 0.18071 -0.01571 0.49786 -0.01286 0.51357 -0.01286 0.09071 -0.00857 "
"0.18357 -0.00429 0.09643 0.00857 0.10214 0.02143 0.19786 0.03571 0.49929 0.03714 "
"0.11071 0.03857 0.49500 0.05000 0.53786 0.06143 0.12643 0.06286 0.21357 0.06571 "
"0.21929 0.07429 0.47929 0.07857 0.14857 0.08643 0.24857 0.10357 0.45429 0.10357 "
"0.18714 0.11500 0.27429 0.11786 0.42857 0.11786 0.53429 0.11786 0.29429 0.12500 "
"0.40857 0.12500 0.31429 0.12929 0.39000 0.12929 0.54571 0.12929 0.32286 0.13071 "
"0.55143 0.13071 0.57214 0.13143 0.22000 0.13214 0.33857 0.13214 0.48143 0.14643 "
"0.26143 0.14786 0.27714 0.15214 0.45286 0.15500 0.29714 0.15643 0.44714 0.15786 "
"0.31429 0.15929 0.32571 0.16071 0.34000 0.16214 0.35857 0.16357 0.40429 0.16500 93 3 9 1 1 9 0 8 11 2 0 8 2 8 "
"0 9 4 11 5 2 11 4 10 9 3 20 16 7 6 19 12 5 19 6 10 "
"3 13 14 5 11 12 19 15 13 7 16 13 3 7 19 5 14 18 28 21 20 "
"17 22 24 28 26 27 30 22 17 20 7 23 22 17 26 28 31 25 15 19 18 "
"15 25 27 22 23 28 24 21 31 28 32 29 30 27 32 33 34 28 18 25 34 "
"35 36 32 28 33 36 37 38 34 33 35 39 40 38 36 35 37 42 40 39 39 "
"38 37 42 39 41 44 42 41 44 43 42 43 44 47 47 46 49 47 45 46 47 "
"44 45 54 48 51 49 46 54 53 52 50 54 51 56 54 46 48 59 52 53 60 "
"57 55 56 51 57 55 57 51 62 61 59 63 60 55 61 62 66 58 63 55 62 "
"59 53 64 65 70 67 63 64 66 73 84 67 64 70 64 63 58 66 84 69 82 "
"68 85 66 62 73 75 84 77 80 78 73 72 84 75 68 71 85 86 71 74 69 "
"84 72 81 80 73 68 70 65 76 88 74 91 76 79 68 82 70 81 73 62 85 "
"71 86 87 79 83 86 74 88 87 77 84 77 87 83 94 79 87 88 76 90 76 "
"91 90 92 91 79 93 92 79 79 94 93 94 87 89 "
;

char *VTK_VECTOR_TEXT_68 = "82 0.600714 "
"0.11286 -0.35786 0.35571 -0.35643 0.12286 -0.35500 0.08571 -0.35357 0.25571 -0.35357 "
"0.14000 -0.35214 0.15143 -0.35071 0.08071 -0.34857 0.16714 -0.34929 0.08071 -0.34286 "
"0.40571 -0.34214 0.41429 -0.33929 0.08714 -0.33786 0.11000 -0.33500 0.11429 -0.33357 "
"0.24143 -0.33357 0.33143 -0.33214 0.43286 -0.33214 0.33714 -0.33071 0.23000 -0.32929 "
"0.12643 -0.32000 0.37143 -0.31786 0.21786 -0.31286 0.47714 -0.31071 0.39143 -0.30786 "
"0.50000 -0.29643 0.42000 -0.28786 0.52000 -0.28071 0.45500 -0.25286 0.55357 -0.24714 "
"0.46357 -0.24143 0.56786 -0.22571 0.57500 -0.21429 0.48357 -0.20571 0.58214 -0.20000 "
"0.49357 -0.17714 0.59071 -0.17571 0.49786 -0.15714 0.59500 -0.15714 0.49929 -0.14857 "
"0.59786 -0.13857 0.59929 -0.12286 0.50214 -0.10571 0.60071 -0.08571 0.50071 -0.07429 "
"0.49929 -0.06000 0.49786 -0.04857 0.59643 -0.04143 0.49357 -0.02429 0.59071 -0.01286 "
"0.48643 0.00286 0.57929 0.01857 0.47357 0.03571 0.56929 0.04143 0.46357 0.05429 "
"0.45071 0.07286 0.54643 0.07429 0.42429 0.09929 0.12786 0.10857 0.41000 0.10929 "
"0.50143 0.11357 0.21786 0.12143 0.38714 0.12071 0.12357 0.12286 0.36429 0.12786 "
"0.35000 0.13071 0.08714 0.13214 0.10143 0.13214 0.22857 0.13214 0.33857 0.13214 "
"0.46571 0.13214 0.11571 0.13357 0.08000 0.13500 0.07357 0.14000 0.07357 0.14857 "
"0.16714 0.15071 0.31286 0.15357 0.38571 0.15357 0.35571 0.15643 0.08143 0.15786 "
"0.09143 0.16071 0.10857 0.16214 82 14 2 "
"5 5 6 20 9 7 12 14 0 2 "
"7 3 12 12 0 13 24 10 11 4 1 "
"16 19 8 4 0 12 3 10 21 1 "
"14 13 0 19 4 15 6 8 19 18 1 "
"21 14 5 20 15 4 16 1 18 16 "
"10 24 21 11 17 26 20 22 58 22 6 "
"19 24 11 26 26 17 23 20 6 22 "
"26 23 28 30 28 25 27 30 25 23 25 "
"28 29 30 27 30 29 33 32 35 31 "
"33 31 35 35 34 37 31 33 29 36 37 "
"34 35 32 34 36 39 37 39 41 42 "
"38 39 36 39 40 41 40 39 38 43 42 "
"41 47 45 44 47 44 42 47 46 45 "
"46 49 48 47 42 43 48 49 50 46 47 "
"49 50 51 52 51 50 49 54 56 55 "
"52 51 53 52 56 54 55 70 57 56 52 "
"53 57 70 59 62 59 70 75 63 58 "
"71 63 75 55 60 70 55 56 60 79 67 "
"80 77 69 65 72 74 73 62 77 64 "
"66 74 72 74 67 79 64 77 65 68 69 "
"76 81 80 67 61 58 22 75 68 76 "
"68 75 61 76 69 78 77 62 70 61 75 "
"58 78 69 77 66 67 74 81 67 71 "
"81 71 75 "
;

char *VTK_VECTOR_TEXT_69 = "83 0.505000 "
"0.46000 -0.39357 0.45500 -0.38714 0.46929 -0.38714 0.45214 -0.36571 0.47500 -0.36429 "
"0.44857 -0.36071 0.08429 -0.35786 0.43714 -0.35786 0.08071 -0.34571 0.08571 -0.34071 "
"0.11571 -0.33786 0.12143 -0.33643 0.24714 -0.33500 0.29143 -0.33357 0.22571 -0.33214 "
"0.22071 -0.33000 0.32286 -0.32929 0.36143 -0.32214 0.13357 -0.32000 0.37714 -0.31786 "
"0.48214 -0.30857 0.41714 -0.29929 0.43429 -0.28929 0.44571 -0.28214 0.46429 -0.26929 "
"0.47214 -0.25714 0.50214 -0.23286 0.50357 -0.22429 0.48500 -0.21714 0.50500 -0.21000 "
"0.49143 -0.20214 0.49857 -0.20214 0.35714 -0.19786 0.36571 -0.19786 0.34929 -0.18571 "
"0.37357 -0.18286 0.34357 -0.13857 0.33929 -0.13000 0.32714 -0.11929 0.22071 -0.11143 "
"0.31000 -0.11214 0.24571 -0.10929 0.36929 -0.08571 0.27857 -0.08500 0.22071 -0.08286 "
"0.29857 -0.08214 0.31857 -0.07643 0.37071 -0.06429 0.34071 -0.06143 0.37214 -0.04857 "
"0.34786 -0.04571 0.37500 -0.00857 0.35071 -0.00286 0.36857 0.00214 0.46143 0.00214 "
"0.46714 0.00214 0.35857 0.00357 0.45500 0.01000 0.47071 0.01143 0.45357 0.04857 "
"0.44643 0.06429 0.42571 0.08643 0.40571 0.09786 0.36286 0.11357 0.22071 0.11571 "
"0.13357 0.11857 0.13071 0.12429 0.23143 0.12643 0.30571 0.12643 0.08571 0.12929 "
"0.24143 0.12929 0.27857 0.13071 0.07929 0.13286 0.11857 0.13214 0.46643 0.14000 "
"0.07643 0.14286 0.12143 0.14929 0.43571 0.15071 0.08857 0.15500 0.10714 0.15643 "
"0.46929 0.15714 0.46286 0.16786 0.45000 0.16929 81 3 "
"1 2 2 1 0 20 7 5 4 3 2 5 3 4 9 6 10 7 11 6 6 "
"9 8 7 20 21 12 7 13 20 5 4 7 12 11 11 10 6 12 14 11 14 "
"15 11 11 15 18 19 7 21 17 7 19 13 7 16 16 7 17 21 20 22 22 "
"20 23 24 23 20 25 24 20 26 28 25 26 25 20 26 27 28 29 28 27 28 "
"31 30 28 29 31 35 34 32 35 32 33 40 43 41 38 42 40 39 18 15 45 "
"40 46 37 42 38 42 37 36 34 42 36 41 43 39 40 42 46 43 40 45 42 "
"34 35 44 18 39 44 39 43 46 42 48 42 47 48 48 47 50 47 49 50 50 "
"51 52 50 49 51 51 56 52 56 51 53 58 57 54 57 58 59 58 54 55 77 "
"81 82 61 74 77 74 61 60 62 61 77 76 73 70 68 77 71 18 64 65 64 "
"18 44 77 80 81 65 64 66 74 59 58 63 77 68 67 70 73 67 66 64 79 "
"73 76 59 74 60 76 70 71 75 69 78 69 75 72 66 67 73 62 77 63 76 "
"71 77 73 79 78 73 78 69 77 74 80 "
;

char *VTK_VECTOR_TEXT_70 = "75 0.470714 "
"0.27286 -0.36071 0.08143 -0.35786 0.11571 -0.35786 0.24000 -0.35786 0.27786 -0.35714 "
"0.12286 -0.35500 0.21714 -0.35357 0.13857 -0.35214 0.20714 -0.35214 0.15000 -0.35071 "
"0.19571 -0.35071 0.07643 -0.34857 0.17857 -0.34929 0.27786 -0.34429 0.08429 -0.33786 "
"0.26857 -0.33643 0.25000 -0.33500 0.10714 -0.33357 0.12000 -0.32643 0.22429 -0.32214 "
"0.22071 -0.31714 0.13357 -0.31286 0.36429 -0.19786 0.35214 -0.19286 0.37357 -0.18286 "
"0.34500 -0.14286 0.34214 -0.13429 0.32571 -0.11786 0.22071 -0.11143 0.31143 -0.11214 "
"0.30429 -0.11071 0.23429 -0.10929 0.36929 -0.10571 0.22071 -0.08286 0.28714 -0.08357 "
"0.30286 -0.08071 0.31714 -0.07643 0.32857 -0.07071 0.34214 -0.05857 0.37214 -0.04857 "
"0.34786 -0.04429 0.37500 -0.00857 0.35071 -0.00286 0.46714 0.00214 0.35714 0.00357 "
"0.36714 0.00357 0.45643 0.00714 0.46929 0.00857 0.45357 0.05000 0.47071 0.05143 "
"0.44357 0.06857 0.42571 0.08643 0.46643 0.09286 0.40286 0.09929 0.37286 0.11071 "
"0.22071 0.11571 0.13357 0.11857 0.34000 0.11929 0.13071 0.12429 0.23143 0.12643 "
"0.29857 0.12786 0.24143 0.12929 0.08143 0.13071 0.12286 0.13071 0.28000 0.13071 "
"0.11857 0.13214 0.07643 0.14286 0.12143 0.14929 0.46786 0.15000 0.43571 0.15071 "
"0.08857 0.15500 0.10714 0.15643 0.46786 0.16286 0.46286 0.16786 0.45000 0.16929 73 2 14 1 4 13 0 2 "
"5 17 7 18 5 3 13 6 14 2 17 0 13 3 1 14 11 16 8 6 16 "
"6 13 16 10 8 16 13 15 21 7 9 17 5 18 12 21 9 19 21 12 19 "
"12 10 18 7 21 20 21 19 19 10 16 23 24 25 22 24 23 25 32 26 26 "
"32 27 27 32 29 30 34 31 28 21 20 33 28 31 30 29 32 34 30 35 24 "
"32 25 33 31 34 30 32 36 30 36 35 33 21 28 36 32 37 37 32 38 38 "
"39 40 39 38 32 40 41 42 40 39 41 42 45 44 45 42 41 46 47 48 43 "
"47 46 47 49 48 52 50 48 50 52 51 52 48 49 60 57 69 60 69 64 53 "
"51 69 21 55 56 55 21 33 67 65 61 69 52 68 57 54 69 69 68 74 68 "
"73 74 56 55 58 51 52 69 61 63 59 59 58 55 65 63 61 67 61 64 71 "
"65 67 63 58 59 66 62 70 67 64 69 65 71 70 65 70 62 54 53 69 68 "
"72 73 "
;

char *VTK_VECTOR_TEXT_71 = "103 0.623571 "
"0.38857 -0.35786 0.30857 -0.35500 0.28429 -0.35214 0.43714 -0.35214 0.26000 -0.34786 "
"0.46000 -0.34786 0.23714 -0.34214 0.48286 -0.34071 0.38286 -0.33786 0.33429 -0.33643 "
"0.39286 -0.33643 0.20429 -0.33071 0.41286 -0.33071 0.30000 -0.32929 0.50857 -0.32929 "
"0.28714 -0.32500 0.44000 -0.31786 0.53286 -0.31214 0.16571 -0.30929 0.25429 -0.30786 "
"0.45929 -0.30286 0.15286 -0.29929 0.56786 -0.28286 0.22071 -0.27571 0.48500 -0.26857 "
"0.12071 -0.26714 0.11500 -0.25714 0.20357 -0.24857 0.10643 -0.24286 0.09786 -0.22571 "
"0.19214 -0.22429 0.18643 -0.20857 0.08929 -0.20143 0.18214 -0.19429 0.08214 -0.17000 "
"0.17643 -0.16857 0.48357 -0.16714 0.56786 -0.16571 0.17500 -0.16000 0.57071 -0.15571 "
"0.47571 -0.15500 0.07929 -0.14857 0.46714 -0.14786 0.58000 -0.14643 0.46000 -0.14500 "
"0.58429 -0.14500 0.45286 -0.14357 0.60857 -0.14357 0.43000 -0.14071 0.42071 -0.13571 "
"0.62071 -0.13429 0.07786 -0.13000 0.41929 -0.12857 0.62357 -0.12714 0.54714 -0.12500 "
"0.43000 -0.12357 0.56714 -0.12357 0.61000 -0.12071 0.07643 -0.08286 0.17214 -0.08143 "
"0.08214 -0.04143 0.17643 -0.03857 0.52429 -0.01643 0.18214 -0.01000 0.53214 -0.00857 "
"0.08786 -0.00714 0.51786 -0.00714 0.09071 -0.00143 0.18643 0.00571 0.09643 0.01571 "
"0.10786 0.04286 0.20071 0.04429 0.51643 0.04429 0.51357 0.05429 0.53786 0.05714 "
"0.21214 0.06714 0.13071 0.07571 0.22357 0.08571 0.49643 0.08571 0.54786 0.08714 "
"0.16000 0.10500 0.46714 0.11500 0.25429 0.11643 0.53714 0.11929 0.18857 0.12214 "
"0.26286 0.12214 0.44714 0.12643 0.56643 0.12857 0.20857 0.13214 0.29143 0.13500 "
"0.41857 0.13643 0.55000 0.13929 0.23143 0.14071 0.32000 0.14214 0.39286 0.14214 "
"0.33000 0.14357 0.56857 0.14357 0.34714 0.14500 0.49000 0.14500 0.27714 0.15214 "
"0.30143 0.15643 0.43857 0.16071 0.36714 0.16500 101 3 12 0 5 16 3 0 "
"8 1 1 9 13 1 13 2 10 8 0 2 13 4 13 6 4 12 10 0 7 "
"14 20 11 6 19 1 8 9 12 3 16 11 23 18 19 6 15 23 11 19 16 "
"5 20 7 20 5 18 27 21 25 27 26 14 17 24 20 14 24 6 13 15 27 "
"25 21 27 28 26 23 27 18 29 30 32 30 29 28 34 35 41 30 28 27 31 "
"32 30 32 31 33 24 37 36 35 34 32 35 32 33 36 37 40 22 37 24 22 "
"24 17 38 51 41 40 37 54 41 35 38 42 54 44 39 54 37 52 49 55 48 "
"55 49 59 51 38 46 44 54 55 46 54 55 48 46 57 56 45 42 40 54 56 "
"54 39 56 43 45 43 56 39 47 57 45 57 50 53 50 57 47 59 58 51 58 "
"59 60 60 61 65 59 61 60 67 63 69 63 67 61 61 67 65 64 66 62 76 "
"70 68 69 68 70 69 63 68 66 64 72 72 74 73 73 74 78 64 74 72 75 "
"76 71 80 76 75 80 77 84 78 83 98 71 76 68 78 79 83 78 98 81 74 "
"79 78 77 80 75 87 91 83 81 98 86 92 85 99 84 77 88 86 101 90 92 "
"82 85 87 83 79 77 82 88 88 82 92 85 89 99 91 87 96 100 93 95 93 "
"100 89 102 97 94 90 101 94 99 89 100 100 95 102 102 95 97 102 94 101 86 "
"98 101 "
;

char *VTK_VECTOR_TEXT_72 = "76 0.649286 "
"0.09429 -0.35786 0.11143 -0.35786 0.48000 -0.35786 0.27857 -0.35643 0.45786 -0.35571 "
"0.64714 -0.35643 0.08929 -0.35429 0.12286 -0.35500 0.49143 -0.35500 0.24286 -0.35357 "
"0.61143 -0.35357 0.23143 -0.35214 0.28071 -0.35143 0.64929 -0.35143 0.45786 -0.35000 "
"0.59000 -0.35071 0.16429 -0.34929 0.53286 -0.34929 0.57571 -0.34929 0.18286 -0.34786 "
"0.55429 -0.34786 0.09429 -0.34500 0.27143 -0.34214 0.64000 -0.34214 0.10714 -0.33929 "
"0.47571 -0.33929 0.11429 -0.33786 0.48286 -0.33786 0.24714 -0.33643 0.61571 -0.33643 "
"0.12429 -0.33357 0.49286 -0.33357 0.60857 -0.33214 0.23500 -0.32857 0.22929 -0.31857 "
"0.50643 -0.31714 0.59786 -0.31714 0.13786 -0.31571 0.50786 -0.09000 0.22857 -0.08929 "
"0.22786 -0.06429 0.50786 -0.06429 0.59643 0.11571 0.13786 0.12143 0.22929 0.12143 "
"0.50643 0.12143 0.60071 0.12714 0.13214 0.13286 0.50071 0.13286 0.60857 0.13643 "
"0.12286 0.14071 0.24571 0.14071 0.49143 0.14071 0.61857 0.14214 0.09857 0.14643 "
"0.46714 0.14643 0.27357 0.15000 0.64357 0.15143 0.18143 0.15214 0.55143 0.15214 "
"0.08786 0.15429 0.16143 0.15357 0.20000 0.15357 0.45643 0.15429 0.53000 0.15357 "
"0.56857 0.15357 0.22429 0.15786 0.59286 0.15786 0.27643 0.16000 0.64643 0.16000 "
"0.12000 0.16071 0.09000 0.16214 0.45857 0.16214 0.63000 0.16214 0.27000 0.16357 "
"0.63857 0.16357 74 14 4 2 24 21 1 "
"14 2 25 27 2 8 6 0 21 26 1 "
"7 28 11 9 10 32 15 22 3 12 "
"23 5 13 21 0 1 26 24 1 3 22 "
"9 28 9 22 27 25 2 5 23 10 "
"26 7 30 33 16 19 27 8 31 16 30 "
"7 33 19 11 17 31 8 29 10 23 "
"10 29 32 33 11 28 30 16 37 31 17 "
"35 36 20 18 36 17 20 36 18 15 "
"34 39 43 39 40 43 35 17 38 37 34 "
"43 41 42 45 36 15 32 39 38 41 "
"42 41 38 37 16 34 16 33 34 40 39 "
"41 58 47 43 45 42 48 42 38 17 "
"42 17 36 44 62 58 66 44 51 67 49 "
"53 65 46 67 50 70 54 72 55 52 "
"62 44 66 44 58 40 46 65 42 47 58 "
"50 40 58 43 51 56 74 48 59 52 "
"59 48 42 65 59 42 50 61 70 57 73 "
"53 54 71 60 55 72 63 46 49 67 "
"66 51 74 72 52 64 67 53 73 50 58 "
"61 71 54 70 68 74 56 52 59 64 "
"75 57 69 75 73 57 "
;

char *VTK_VECTOR_TEXT_73 = "43 0.280714 "
"0.09429 -0.35786 0.11143 -0.35786 0.27857 -0.35643 0.08929 -0.35429 0.12286 -0.35500 "
"0.24286 -0.35357 0.14286 -0.35214 0.23286 -0.35214 0.28071 -0.35143 0.15429 -0.35071 "
"0.16429 -0.34929 0.18286 -0.34786 0.09429 -0.34500 0.27143 -0.34214 0.11857 -0.33643 "
"0.24714 -0.33643 0.13357 -0.32429 0.23214 -0.32429 0.22786 -0.31286 0.13929 -0.31000 "
"0.22786 0.11714 0.13786 0.12143 0.23214 0.12714 0.13214 0.13286 0.12286 0.14071 "
"0.24571 0.14071 0.11857 0.14214 0.10286 0.14500 0.09857 0.14643 0.27500 0.15143 "
"0.18143 0.15214 0.08786 0.15429 0.16143 0.15357 0.20000 0.15357 0.20857 0.15500 "
"0.21429 0.15643 0.22429 0.15786 0.27786 0.15857 0.23571 0.15929 0.12000 0.16071 "
"0.24857 0.16071 0.09000 0.16214 0.27429 0.16214 41 6 14 4 12 0 1 3 0 12 4 "
"14 1 15 7 5 12 1 14 13 2 8 2 13 5 15 5 13 17 10 11 6 "
"16 14 6 9 16 9 10 16 17 11 7 18 19 10 18 10 17 16 10 19 17 "
"7 15 21 20 23 19 20 21 19 18 20 22 33 20 25 38 22 26 39 27 30 "
"26 24 23 30 24 30 23 20 33 30 20 32 26 30 28 41 31 35 34 22 34 "
"33 22 39 28 27 29 40 25 36 35 22 38 36 22 38 25 40 39 26 32 40 "
"29 42 41 28 39 37 42 29 "
;

char *VTK_VECTOR_TEXT_74 = "42 0.343571 "
"0.15571 -0.49500 0.12143 -0.49214 0.10714 -0.48786 0.18571 -0.48643 0.09429 -0.48071 "
"0.08214 -0.47000 0.14857 -0.47071 0.16857 -0.46929 0.22429 -0.46786 0.14643 -0.46571 "
"0.15500 -0.45857 0.07500 -0.45571 0.25143 -0.44786 0.19500 -0.44571 0.06929 -0.44000 "
"0.16643 -0.43000 0.27643 -0.42429 0.20357 -0.42286 0.06786 -0.41571 0.28643 -0.40571 "
"0.16929 -0.40143 0.29071 -0.39143 0.08071 -0.38571 0.15714 -0.37643 0.09429 -0.37357 "
"0.10571 -0.36929 0.12429 -0.36643 0.20500 0.11714 0.29357 0.11714 0.29786 0.12714 "
"0.19786 0.13286 0.18857 0.14071 0.31429 0.14214 0.16714 0.14500 0.34071 0.15143 "
"0.15214 0.15429 0.22714 0.15357 0.27429 0.15500 0.34357 0.15857 0.31429 0.16071 "
"0.15429 0.16214 0.34000 0.16214 40 "
"6 4 2 0 3 7 6 1 0 1 6 "
"2 7 3 13 11 9 14 6 0 7 "
"3 8 13 5 9 11 9 5 4 13 12 "
"17 9 4 6 14 9 18 13 8 12 "
"27 17 21 17 19 21 17 12 16 17 16 "
"19 18 10 22 15 26 10 25 22 10 "
"20 26 15 25 10 26 24 22 25 18 9 "
"10 26 20 23 27 28 30 28 27 21 "
"28 29 37 37 32 39 30 36 31 34 39 "
"32 36 30 28 36 28 37 31 40 33 "
"33 40 35 31 36 40 37 29 32 38 41 "
"34 39 34 41 "
;

char *VTK_VECTOR_TEXT_75 = "97 0.577857 "
"0.09286 -0.35786 0.11429 -0.35786 0.35714 -0.35786 0.39286 -0.35786 0.28000 -0.35643 "
"0.54000 -0.35643 0.57786 -0.35571 0.08929 -0.35429 0.12571 -0.35500 0.35071 -0.35429 "
"0.40714 -0.35500 0.24000 -0.35357 0.42286 -0.35357 0.22857 -0.35214 0.28071 -0.35143 "
"0.44286 -0.35214 0.15571 -0.35071 0.16714 -0.34929 0.57286 -0.34929 0.09714 -0.34357 "
"0.35714 -0.34357 0.26857 -0.34071 0.10857 -0.33929 0.37143 -0.33929 0.12000 -0.33643 "
"0.24714 -0.33643 0.38714 -0.33643 0.54857 -0.33643 0.39143 -0.33500 0.12929 -0.33000 "
"0.52714 -0.33071 0.40071 -0.32571 0.51857 -0.32500 0.23071 -0.32143 0.13643 -0.32000 "
"0.22786 -0.31286 0.13929 -0.31143 0.39929 -0.30429 0.49357 -0.29857 0.39357 -0.29429 "
"0.41929 -0.18714 0.22786 -0.12857 0.25857 -0.12071 0.25286 -0.11786 0.24143 -0.11643 "
"0.22857 -0.10357 0.32214 -0.06286 0.31786 -0.05429 0.31786 -0.04571 0.32643 -0.03429 "
"0.36929 0.03714 0.39643 0.07000 0.44714 0.07786 0.47000 0.09643 0.41786 0.09857 "
"0.42071 0.10571 0.22786 0.11714 0.49714 0.11643 0.13786 0.12143 0.42214 0.12143 "
"0.23214 0.12714 0.52000 0.12929 0.13214 0.13286 0.41786 0.13286 0.12143 0.14071 "
"0.24714 0.14071 0.40429 0.14071 0.39429 0.14214 0.56286 0.14357 0.09857 0.14500 "
"0.27143 0.14786 0.37500 0.15000 0.19143 0.15214 0.57214 0.15286 0.08786 0.15429 "
"0.20286 0.15357 0.27643 0.15429 0.45286 0.15357 0.49000 0.15500 0.13571 0.15643 "
"0.21714 0.15643 0.42857 0.15643 0.49857 0.15643 0.22714 0.15786 0.50857 0.15786 "
"0.08786 0.16000 0.12571 0.15929 0.24000 0.15929 0.37214 0.16000 0.52143 0.15929 "
"0.57214 0.16000 0.53571 0.16071 0.27429 0.16214 0.54857 0.16214 0.37571 0.16357 "
"0.56429 0.16357 0.39143 0.16500 95 7 "
"0 19 6 18 5 16 29 8 8 24 1 12 15 31 0 1 19 20 2 23 2 "
"20 9 28 3 10 10 12 31 4 21 11 5 32 15 19 1 22 25 13 11 2 "
"3 23 4 14 21 22 1 24 25 11 21 23 3 26 33 17 13 18 27 5 28 "
"26 3 29 24 8 28 10 31 5 30 32 30 5 27 29 16 34 34 17 36 34 "
"16 17 33 36 17 31 15 37 33 13 25 32 38 15 35 36 33 38 37 15 39 "
"37 38 39 40 42 40 39 38 43 45 44 41 36 35 43 46 47 47 48 45 40 "
"46 42 36 56 58 36 45 56 44 45 41 43 47 45 49 45 48 46 43 42 45 "
"49 50 50 52 51 51 52 54 49 52 50 55 54 52 53 55 52 55 53 59 58 "
"56 62 36 41 45 59 81 63 59 53 81 63 81 66 61 89 84 61 84 82 65 "
"83 60 70 87 65 75 60 80 83 80 60 81 53 77 85 74 69 82 78 57 67 "
"96 71 62 56 72 62 72 64 75 72 56 75 56 60 96 66 81 77 53 57 64 "
"79 86 77 57 78 79 64 72 61 82 57 65 87 83 87 70 92 85 69 86 91 "
"89 61 68 93 91 95 93 68 95 73 90 69 64 86 76 92 70 96 67 66 71 "
"94 88 73 95 68 68 91 61 96 94 71 "
;

char *VTK_VECTOR_TEXT_76 = "45 0.500714 "
"0.44286 -0.38786 0.45214 -0.38286 0.43714 -0.36071 0.08714 -0.35929 0.42429 -0.35786 "
"0.08071 -0.35429 0.08071 -0.34571 0.46357 -0.34429 0.08571 -0.34071 0.28857 -0.33929 "
"0.11714 -0.33786 0.25143 -0.33786 0.12143 -0.33643 0.32429 -0.33500 0.22714 -0.33357 "
"0.22071 -0.33143 0.34429 -0.33214 0.13357 -0.32000 0.38143 -0.32071 0.41429 -0.30643 "
"0.47214 -0.30571 0.44571 -0.28643 0.46786 -0.26571 0.47214 -0.25429 0.49786 -0.22857 "
"0.48071 -0.22000 0.48643 -0.20571 0.50071 -0.20571 0.49714 -0.20214 0.22071 0.11714 "
"0.13357 0.12429 0.23714 0.13071 0.28000 0.13071 0.08857 0.13357 0.10286 0.13357 "
"0.28357 0.13571 0.11286 0.13643 0.11857 0.13643 0.07786 0.14143 0.07643 0.14857 "
"0.28071 0.15000 0.08143 0.15643 0.25429 0.15643 0.09143 0.15929 0.26857 0.15929 43 0 1 2 2 7 4 4 9 3 10 8 3 8 6 3 6 5 3 9 "
"4 13 9 11 3 7 2 1 12 14 15 11 14 3 14 10 3 19 4 7 12 "
"15 17 18 4 19 13 4 16 16 4 18 14 12 10 19 20 21 19 7 20 22 "
"21 20 23 22 20 23 24 25 24 23 20 27 25 24 25 27 26 27 28 26 17 "
"29 30 29 17 15 30 42 37 41 38 33 41 33 43 39 38 41 30 29 42 31 "
"42 29 36 37 42 43 33 34 42 40 44 42 31 40 40 31 32 36 43 34 40 "
"32 35 43 36 42 "
;

char *VTK_VECTOR_TEXT_77 = "66 0.742143 "
"0.53857 -0.36071 0.74000 -0.35929 0.09000 -0.35786 0.24000 -0.35786 0.53357 -0.35714 "
"0.71000 -0.35643 0.74214 -0.35571 0.24357 -0.35429 0.08929 -0.35286 0.14571 -0.35071 "
"0.18571 -0.35071 0.16571 -0.34929 0.67286 -0.34929 0.62143 -0.34643 0.73143 -0.34643 "
"0.54000 -0.34357 0.23429 -0.34214 0.10143 -0.33929 0.69714 -0.33929 0.57143 -0.33643 "
"0.11571 -0.33500 0.20429 -0.33500 0.58143 -0.33071 0.68357 -0.32571 0.19357 -0.32429 "
"0.13214 -0.32286 0.58929 -0.31714 0.68071 -0.31429 0.18643 -0.30714 0.14071 -0.30286 "
"0.17929 -0.27429 0.39000 -0.27214 0.37643 -0.25857 0.17643 -0.25143 0.14929 -0.24286 "
"0.42071 -0.22571 0.33643 -0.19571 0.32500 -0.17714 0.42000 -0.16500 0.41214 -0.15714 "
"0.30643 -0.14571 0.43786 -0.14143 0.28357 -0.10571 0.48786 -0.04857 0.33643 -0.02571 "
"0.22357 0.00286 0.17714 0.08786 0.58857 0.08929 0.15071 0.12429 0.68071 0.12571 "
"0.14643 0.13286 0.09429 0.14214 0.13714 0.14214 0.69429 0.14357 0.72286 0.14500 "
"0.08643 0.14857 0.66000 0.15214 0.73929 0.15571 0.16857 0.15643 0.24429 0.15643 "
"0.08714 0.15929 0.59000 0.16071 0.09571 0.16214 0.20000 0.16214 0.73714 0.16214 "
"0.22429 0.16357 64 20 17 2 "
"19 15 0 4 0 15 9 11 25 8 2 "
"17 9 20 2 3 16 10 1 14 5 "
"16 3 7 14 1 6 5 18 12 27 26 "
"13 13 12 23 18 5 14 13 26 22 "
"16 21 10 9 25 20 28 29 11 13 22 "
"19 24 10 21 18 23 12 13 19 0 "
"11 10 24 25 11 29 27 13 23 34 29 "
"30 28 11 24 29 28 30 32 35 36 "
"33 34 30 34 46 48 36 35 37 38 39 "
"37 35 32 31 38 37 35 38 35 41 "
"44 42 40 42 44 45 40 37 39 43 41 "
"35 47 61 43 44 40 39 26 27 47 "
"34 33 46 47 43 35 46 65 63 47 56 "
"61 58 50 48 58 46 63 55 51 62 "
"56 49 53 56 53 64 60 55 62 49 47 "
"27 62 52 58 52 62 51 50 58 52 "
"53 54 64 58 48 46 45 59 46 59 65 "
"46 49 56 47 57 64 54 59 45 44 "
;

char *VTK_VECTOR_TEXT_78 = "62 0.655000 "
"0.08929 -0.35714 0.11286 -0.35786 0.56857 -0.35786 0.57571 -0.35786 0.24357 -0.35571 "
"0.21429 -0.35500 0.12857 -0.35357 0.13714 -0.35214 0.19571 -0.35214 0.09071 -0.35000 "
"0.58357 -0.35000 0.23143 -0.34071 0.10143 -0.33929 0.21000 -0.33786 0.58643 -0.33714 "
"0.12429 -0.33071 0.19643 -0.32857 0.13357 -0.32000 0.18929 -0.31571 0.13929 -0.30714 "
"0.18500 -0.30143 0.14214 -0.29429 0.17929 -0.27429 0.17643 -0.25143 0.14929 -0.24143 "
"0.56286 -0.22214 0.34500 -0.10857 0.56071 0.03143 0.55929 0.04429 0.58786 0.05286 "
"0.58929 0.06429 0.17714 0.08929 0.55214 0.09571 0.55071 0.10286 0.59643 0.10286 "
"0.54071 0.12143 0.60500 0.12143 0.15071 0.12429 0.53143 0.12929 0.61286 0.12929 "
"0.14500 0.13571 0.63000 0.13643 0.63857 0.13643 0.51143 0.13786 0.13714 0.14214 "
"0.09429 0.14357 0.50214 0.14429 0.65214 0.14429 0.58429 0.14500 0.54286 0.14786 "
"0.60714 0.14786 0.08500 0.15143 0.23786 0.15143 0.49929 0.15143 0.65500 0.15286 "
"0.50286 0.15500 0.08500 0.15714 0.64714 0.15643 0.18286 0.15786 0.19714 0.16071 "
"0.09429 0.16214 0.21571 0.16214 60 1 9 0 1 6 15 "
"15 6 7 14 2 10 12 1 15 11 5 "
"4 5 13 8 1 12 9 2 25 26 "
"13 5 11 2 14 25 8 17 7 17 15 "
"7 16 8 13 16 18 17 17 18 19 "
"8 16 17 19 20 21 20 19 18 24 31 "
"37 22 21 20 2 3 10 21 23 24 "
"21 22 23 26 52 31 29 28 27 29 27 "
"25 28 30 32 29 25 14 28 29 30 "
"52 59 31 34 33 32 24 23 31 58 37 "
"31 33 34 35 30 34 32 35 36 39 "
"48 35 39 35 48 38 37 58 40 58 31 "
"59 38 49 43 36 35 34 48 39 50 "
"50 39 41 41 42 57 45 60 51 50 41 "
"57 40 58 44 38 48 49 56 51 60 "
"42 47 57 55 43 49 43 55 46 46 55 "
"53 54 57 47 44 60 45 26 25 52 "
"60 44 58 61 59 52 "
;

char *VTK_VECTOR_TEXT_79 = "87 0.685000 "
"0.40714 -0.35786 0.35000 -0.35500 0.32143 -0.35071 0.45571 -0.35071 0.28286 -0.34071 "
"0.50286 -0.33786 0.37143 -0.33500 0.41286 -0.33357 0.34286 -0.32929 0.43857 -0.32786 "
"0.24714 -0.32643 0.54429 -0.32071 0.31571 -0.31929 0.46429 -0.31786 0.21000 -0.30500 "
"0.28286 -0.29929 0.49429 -0.29929 0.58000 -0.29786 0.18000 -0.28214 0.25071 -0.26714 "
"0.16214 -0.26571 0.62214 -0.26286 0.53643 -0.25571 0.63786 -0.24429 0.22643 -0.23143 "
"0.55214 -0.23143 0.12929 -0.22571 0.65929 -0.20857 0.21357 -0.20429 0.56500 -0.20429 "
"0.11643 -0.20000 0.20643 -0.18429 0.57214 -0.18429 0.67357 -0.17143 0.20071 -0.16143 "
"0.57786 -0.16143 0.10214 -0.15857 0.67929 -0.14714 0.19786 -0.14429 0.58071 -0.14429 "
"0.09786 -0.13714 0.68214 -0.13000 0.09500 -0.11571 0.68357 -0.11571 0.09357 -0.09143 "
"0.68500 -0.08857 0.58071 -0.07000 0.19786 -0.06571 0.57786 -0.05143 0.10214 -0.04000 "
"0.67643 -0.03429 0.20357 -0.03286 0.10643 -0.02429 0.57071 -0.02000 0.11071 -0.01143 "
"0.21071 -0.00714 0.66643 -0.00714 0.22071 0.01857 0.55643 0.01857 0.12643 0.02286 "
"0.65071 0.02714 0.13929 0.04286 0.54071 0.04857 0.24071 0.05571 0.15786 0.06571 "
"0.62071 0.06714 0.52357 0.07429 0.25500 0.07571 0.18571 0.09214 0.59286 0.09214 "
"0.49000 0.10786 0.29571 0.11500 0.56143 0.11500 0.21714 0.11643 0.46857 0.12214 "
"0.45000 0.13071 0.32714 0.13214 0.25571 0.13643 0.42857 0.13786 0.35714 0.14071 "
"0.41429 0.14071 0.51429 0.14071 0.29429 0.15071 0.47714 0.15357 0.33143 0.15929 "
"0.35286 0.16214 0.40714 0.16500 87 7 0 3 6 0 7 6 1 0 2 8 4 5 13 3 7 3 9 15 "
"10 4 1 8 2 8 1 6 9 3 13 12 4 8 10 19 14 13 5 16 11 "
"22 16 17 22 11 10 15 19 11 16 5 15 4 12 28 30 26 20 28 26 14 "
"19 18 25 22 17 18 24 20 21 25 17 29 23 32 21 23 29 24 18 19 25 "
"21 29 30 31 36 20 24 28 32 27 35 30 28 31 27 32 23 33 39 35 33 "
"35 27 36 38 40 34 36 31 40 38 42 39 45 46 46 45 48 36 34 38 39 "
"43 45 39 33 37 39 37 41 44 47 49 48 45 53 51 52 49 47 44 42 39 "
"41 43 51 49 47 47 42 38 60 58 53 51 54 52 50 53 45 55 59 51 54 "
"51 59 56 53 50 61 57 64 62 69 66 60 53 56 58 65 62 57 59 55 66 "
"81 70 57 61 59 63 64 57 68 64 63 67 68 63 65 58 60 73 68 67 77 "
"73 67 62 65 69 81 66 72 86 80 78 71 77 67 80 86 79 70 81 74 76 "
"82 71 77 71 82 66 69 72 78 75 83 79 84 76 82 76 84 75 74 83 81 "
"83 74 79 85 84 86 78 83 86 85 79 "
;

char *VTK_VECTOR_TEXT_80 = "76 0.470714 "
"0.08429 -0.35786 0.10429 -0.35786 0.26714 -0.35786 0.07786 -0.35429 0.11429 -0.35500 "
"0.23571 -0.35500 0.26929 -0.35286 0.20143 -0.34929 0.15857 -0.34786 0.25714 -0.34357 "
"0.23571 -0.34214 0.08429 -0.34071 0.22286 -0.33786 0.10857 -0.33643 0.11286 -0.33500 "
"0.21643 -0.33143 0.21357 -0.32143 0.12643 -0.32000 0.21357 -0.15286 0.24000 -0.15071 "
"0.34714 -0.14786 0.36571 -0.14071 0.22714 -0.12357 0.40143 -0.12357 0.21929 -0.12143 "
"0.27286 -0.12214 0.28143 -0.12071 0.21786 -0.11714 0.29286 -0.11786 0.31000 -0.11214 "
"0.41714 -0.11214 0.21643 -0.10571 0.33143 -0.10071 0.43786 -0.09286 0.45071 -0.07571 "
"0.35929 -0.07286 0.36929 -0.05571 0.46214 -0.05000 0.46643 -0.03429 0.37786 -0.03000 "
"0.46786 -0.02714 0.37929 -0.02143 0.46929 -0.01714 0.47071 -0.00286 0.38071 0.01857 "
"0.47071 0.02286 0.37929 0.02714 0.37786 0.03286 0.46929 0.03857 0.46357 0.05571 "
"0.36786 0.06000 0.46071 0.06286 0.45071 0.08429 0.35071 0.08857 0.43786 0.10143 "
"0.12786 0.10857 0.32286 0.11643 0.21786 0.11857 0.12357 0.12286 0.30571 0.12500 "
"0.23143 0.12786 0.29429 0.12786 0.23571 0.12929 0.28571 0.12929 0.08714 0.13071 "
"0.10286 0.13071 0.27286 0.13071 0.40286 0.13214 0.11429 0.13357 0.07571 0.13643 "
"0.37857 0.14500 0.07357 0.14857 0.16571 0.15071 0.34143 0.15500 0.08429 0.15929 "
"0.10857 0.16214 76 11 1 13 2 9 5 "
"4 13 1 10 5 9 3 0 11 9 2 "
"6 5 12 7 11 0 1 5 10 12 "
"14 8 17 7 16 8 4 14 13 12 15 "
"7 8 16 17 17 16 55 8 14 4 "
"7 15 16 16 18 55 20 25 19 22 18 "
"19 21 32 20 32 21 23 22 19 25 "
"18 31 55 22 24 18 29 20 32 28 20 "
"29 26 20 28 20 26 25 18 24 27 "
"18 27 31 32 23 35 35 30 36 30 35 "
"23 36 30 33 34 41 39 36 34 39 "
"37 41 34 36 33 34 41 43 44 41 40 "
"42 41 38 40 38 41 37 41 42 43 "
"46 44 43 47 46 43 47 45 48 50 51 "
"53 49 50 47 47 43 45 49 47 48 "
"50 49 51 53 70 56 53 51 52 56 73 "
"59 72 58 55 58 72 68 53 52 54 "
"68 75 65 57 72 55 60 72 57 70 73 "
"56 69 64 71 72 60 62 53 67 70 "
"66 73 72 57 55 31 66 63 73 66 72 "
"62 59 73 61 63 61 73 74 64 75 "
"75 68 72 53 54 67 74 71 64 75 64 "
"65 "
;

char *VTK_VECTOR_TEXT_81 = "152 0.669286 "
"0.18000 -0.50929 0.23857 -0.50929 0.52857 -0.50786 0.16143 -0.50643 0.49000 -0.50500 "
"0.15286 -0.50357 0.45714 -0.50071 0.55143 -0.50071 0.42857 -0.49500 0.13643 -0.49143 "
"0.18571 -0.48786 0.22571 -0.48786 0.28286 -0.48786 0.57857 -0.48786 0.23714 -0.48500 "
"0.16857 -0.48071 0.26571 -0.47214 0.60286 -0.47071 0.15643 -0.46857 0.32571 -0.46500 "
"0.31429 -0.46357 0.27643 -0.46143 0.27429 -0.45643 0.15500 -0.45429 0.13071 -0.45286 "
"0.51429 -0.44929 0.56286 -0.44929 0.25143 -0.44643 0.48571 -0.44357 0.59000 -0.44214 "
"0.16857 -0.44071 0.17286 -0.43929 0.21857 -0.43929 0.64071 -0.43571 0.61286 -0.42929 "
"0.14071 -0.42143 0.39857 -0.40786 0.63500 -0.40714 0.38143 -0.40357 0.15857 -0.40214 "
"0.37643 -0.40000 0.66643 -0.39571 0.17571 -0.39357 0.35286 -0.39214 0.66929 -0.38571 "
"0.20714 -0.38357 0.21714 -0.38214 0.25571 -0.38071 0.36643 -0.37571 0.66929 -0.37571 "
"0.65857 -0.37071 0.36929 -0.36571 0.40000 -0.36071 0.36857 -0.35929 0.41857 -0.35929 "
"0.35286 -0.35500 0.45857 -0.35357 0.31143 -0.34929 0.49714 -0.34214 0.38357 -0.33571 "
"0.24429 -0.33214 0.41929 -0.33143 0.33857 -0.33071 0.42857 -0.32929 0.32143 -0.32643 "
"0.53857 -0.32214 0.21000 -0.31929 0.29429 -0.31643 0.45857 -0.31357 0.38929 -0.31000 "
"0.56000 -0.30786 0.42500 -0.30429 0.26286 -0.29929 0.16857 -0.29500 0.49143 -0.29071 "
"0.24857 -0.28786 0.38929 -0.28429 0.38500 -0.27571 0.59786 -0.27571 0.37143 -0.26643 "
"0.13071 -0.26143 0.35857 -0.26214 0.52786 -0.25143 0.21500 -0.24857 0.42786 -0.24857 "
"0.33357 -0.24714 0.62357 -0.24429 0.11214 -0.23857 0.53929 -0.23429 0.42357 -0.23143 "
"0.32357 -0.22714 0.09929 -0.21571 0.41929 -0.21571 0.19214 -0.20429 0.41500 -0.20429 "
"0.32357 -0.20143 0.64643 -0.20143 0.55643 -0.19714 0.18786 -0.19000 0.33071 -0.18714 "
"0.08786 -0.18571 0.40286 -0.18357 0.34286 -0.17357 0.65643 -0.17286 0.35714 -0.16929 "
"0.37571 -0.16786 0.56500 -0.16714 0.08214 -0.16143 0.18071 -0.15429 0.66214 -0.14857 "
"0.56929 -0.14143 0.07786 -0.12429 0.66643 -0.11571 0.07643 -0.09143 0.66786 -0.09143 "
"0.17786 -0.08571 0.56929 -0.06714 0.18071 -0.05714 0.56643 -0.04857 0.66071 -0.04714 "
"0.08500 -0.04286 0.08929 -0.02714 0.18929 -0.01857 0.65214 -0.01714 0.55786 -0.01429 "
"0.10643 0.01286 0.20214 0.01571 0.63500 0.02000 0.53357 0.03857 0.21500 0.04000 "
"0.12929 0.04857 0.61214 0.05286 0.51643 0.06429 0.23214 0.06571 0.59571 0.07214 "
"0.15571 0.07643 0.48000 0.10071 0.55714 0.10357 0.27429 0.10643 0.20000 0.11071 "
"0.29571 0.11929 0.44429 0.12214 0.42000 0.13071 0.33143 0.13214 0.34571 0.13500 "
"0.40000 0.13500 0.49857 0.13500 0.25143 0.13643 0.28143 0.14643 0.30571 0.15214 "
"0.33571 0.15643 0.41714 0.15643 154 11 10 "
"0 0 10 3 25 2 7 27 47 32 "
"5 3 10 20 22 21 2 25 4 11 1 "
"14 1 11 0 5 15 9 8 36 19 "
"15 5 10 16 14 1 7 13 26 12 16 "
"1 9 18 24 16 12 21 15 18 9 "
"22 20 43 20 19 43 35 24 23 4 28 "
"6 6 28 8 25 7 26 26 13 17 "
"23 24 18 47 46 32 26 17 29 25 28 "
"4 29 17 34 35 30 31 32 45 31 "
"34 33 37 8 28 36 30 35 23 35 31 "
"39 36 38 19 34 17 33 39 31 42 "
"41 50 37 40 43 19 20 21 12 42 31 "
"45 47 27 22 38 40 19 41 37 33 "
"48 43 40 52 51 48 44 50 41 47 22 "
"43 46 45 32 44 49 50 52 53 51 "
"52 48 40 56 63 54 61 52 54 62 52 "
"59 57 67 60 53 62 55 55 62 57 "
"61 54 63 59 61 69 60 75 66 53 52 "
"62 63 56 68 67 57 64 59 52 61 "
"58 68 56 57 62 64 68 58 74 66 83 "
"73 69 71 76 65 74 58 71 69 61 "
"78 82 70 72 60 67 70 82 65 93 87 "
"80 82 74 65 60 72 75 76 84 77 "
"79 84 81 77 84 79 93 80 73 84 76 "
"71 83 66 75 88 82 78 95 101 99 "
"89 85 81 88 86 97 88 78 86 89 81 "
"84 85 89 90 96 97 86 91 93 100 "
"87 93 91 95 90 101 97 96 106 94 90 "
"92 90 94 101 101 104 99 100 98 107 "
"93 73 83 100 93 98 102 99 104 90 89 "
"92 105 104 101 106 103 110 107 108 111 "
"106 96 103 108 107 98 110 114 116 110 112 "
"114 109 110 103 115 111 108 112 110 109 "
"115 113 111 113 115 120 117 120 115 120 117 "
"121 119 118 116 118 119 123 118 123 124 "
"121 122 125 124 131 128 119 116 114 121 117 "
"122 125 122 130 127 124 123 124 127 131 "
"134 128 131 126 129 130 122 126 130 135 133 "
"139 133 135 129 135 130 129 132 137 136 "
"128 137 132 137 128 134 141 151 142 138 139 "
"133 142 151 145 140 147 138 139 138 147 "
"150 144 145 143 149 140 137 146 136 144 150 "
"143 136 146 141 148 140 149 140 148 147 "
"149 143 150 150 145 151 141 146 151 "
;

char *VTK_VECTOR_TEXT_82 = "103 0.535000 "
"0.53143 -0.35929 0.08429 -0.35786 0.39571 -0.35786 0.09714 -0.35643 0.40000 -0.35643 "
"0.53500 -0.35571 0.07786 -0.35429 0.11000 -0.35500 0.28786 -0.35429 0.41714 -0.35500 "
"0.12429 -0.35357 0.24286 -0.35357 0.43571 -0.35357 0.13714 -0.35214 0.14857 -0.35071 "
"0.07786 -0.34857 0.19429 -0.34929 0.52571 -0.34643 0.08429 -0.34214 0.27000 -0.33929 "
"0.09857 -0.33786 0.24571 -0.33786 0.50714 -0.33786 0.11143 -0.33643 0.24143 -0.33643 "
"0.49143 -0.33643 0.11571 -0.33500 0.23071 -0.32857 0.12929 -0.32286 0.13357 -0.31429 "
"0.22214 -0.31429 0.36929 -0.30857 0.36214 -0.29571 0.35214 -0.27857 0.34643 -0.26857 "
"0.34071 -0.25857 0.33500 -0.24857 0.43071 -0.24000 0.32500 -0.23143 0.31643 -0.21714 "
"0.30214 -0.19571 0.28357 -0.17143 0.37643 -0.16429 0.26429 -0.15071 0.24571 -0.13786 "
"0.22071 -0.13429 0.23714 -0.13500 0.34214 -0.12571 0.37000 -0.11500 0.24429 -0.11071 "
"0.28429 -0.10929 0.38286 -0.10929 0.29143 -0.10786 0.22214 -0.10429 0.39429 -0.10500 "
"0.30429 -0.10357 0.32429 -0.09357 0.42000 -0.08929 0.33714 -0.08500 0.43286 -0.07929 "
"0.35929 -0.06143 0.45214 -0.06143 0.45786 -0.05286 0.36786 -0.04714 0.46643 -0.04000 "
"0.37643 -0.02143 0.47500 -0.02143 0.37786 -0.01286 0.47929 -0.00429 0.48071 0.00714 "
"0.37929 0.01429 0.37786 0.02714 0.48214 0.03429 0.37643 0.03571 0.37357 0.04714 "
"0.47929 0.05143 0.36643 0.06571 0.36071 0.07571 0.46786 0.07857 0.35500 0.08429 "
"0.45929 0.08857 0.22214 0.10714 0.32857 0.11071 0.43429 0.11214 0.13357 0.11429 "
"0.22357 0.11571 0.23143 0.12357 0.30286 0.12357 0.12786 0.12571 0.24143 0.12643 "
"0.29143 0.12643 0.28286 0.12786 0.40143 0.12786 0.12000 0.13214 0.08571 0.13643 "
"0.36714 0.14071 0.07643 0.14286 0.18000 0.14357 0.07500 0.14714 0.20000 0.14643 "
"0.08000 0.15071 0.22857 0.15214 0.30000 0.15357 103 2 4 31 1 15 6 11 "
"24 16 1 3 15 23 10 13 8 19 11 18 3 20 23 7 10 23 3 7 17 "
"0 5 0 25 12 18 15 3 0 22 25 21 11 19 22 0 17 4 9 31 26 "
"23 13 20 3 23 11 21 24 24 27 16 26 13 28 29 28 14 28 13 14 35 "
"34 37 30 29 16 30 16 27 16 29 14 34 33 37 36 35 37 38 42 39 32 "
"37 33 37 31 9 37 32 31 36 42 38 37 9 12 37 12 25 47 52 43 41 "
"47 43 39 42 40 40 47 41 49 46 44 42 36 37 58 56 47 44 43 50 45 "
"29 30 53 29 45 40 42 47 58 51 54 48 58 47 51 58 48 49 44 50 53 "
"45 46 53 46 49 52 50 43 56 55 47 52 47 55 57 60 54 58 54 60 60 "
"57 63 63 59 62 62 59 61 63 62 65 66 67 64 63 57 59 67 65 62 67 "
"66 70 64 67 62 68 70 66 70 69 72 77 83 79 70 68 69 74 83 76 75 "
"70 72 73 83 74 83 73 71 83 71 80 78 80 70 79 95 82 78 70 75 71 "
"70 80 84 29 81 81 29 53 76 83 77 84 81 88 102 91 90 79 92 95 99 "
"85 86 101 86 89 88 97 93 99 86 101 99 81 85 87 102 90 82 95 87 88 "
"81 97 100 94 93 94 100 96 100 93 97 79 83 92 98 96 100 97 81 99 91 "
"102 89 95 102 87 101 89 102 "
;

char *VTK_VECTOR_TEXT_83 = "118 0.439286 "
"0.11286 -0.36643 0.27857 -0.36500 0.10429 -0.36357 0.25571 -0.36357 0.24429 -0.36214 "
"0.30286 -0.36214 0.23000 -0.35929 0.33857 -0.35214 0.09786 -0.34857 0.18857 -0.34786 "
"0.16714 -0.34071 0.36857 -0.33929 0.13429 -0.33786 0.28571 -0.33786 0.14857 -0.33643 "
"0.24143 -0.33643 0.29571 -0.33643 0.09786 -0.33429 0.22571 -0.33357 0.31000 -0.33357 "
"0.32286 -0.32929 0.10071 -0.32571 0.20143 -0.32643 0.19143 -0.32214 0.34429 -0.31786 "
"0.10214 -0.31571 0.17143 -0.30929 0.40357 -0.30857 0.10357 -0.30429 0.36071 -0.30286 "
"0.14929 -0.28857 0.10500 -0.28714 0.37071 -0.28571 0.42643 -0.26857 0.37643 -0.26714 "
"0.37786 -0.26000 0.12786 -0.25429 0.10214 -0.25000 0.10071 -0.24286 0.43500 -0.24000 "
"0.09643 -0.22714 0.43786 -0.22429 0.37929 -0.22000 0.09500 -0.21714 0.37786 -0.21143 "
"0.43929 -0.21000 0.09500 -0.20286 0.37357 -0.19857 0.36929 -0.19143 0.10571 -0.18214 "
"0.35571 -0.17643 0.34571 -0.16929 0.43929 -0.16429 0.31857 -0.15643 0.29143 -0.14786 "
"0.43214 -0.14000 0.22286 -0.13500 0.42929 -0.13286 0.20000 -0.12929 0.42357 -0.12143 "
"0.17143 -0.11929 0.41643 -0.11143 0.14857 -0.10786 0.13286 -0.09786 0.11643 -0.08429 "
"0.38571 -0.08357 0.10643 -0.06857 0.35286 -0.06643 0.09929 -0.05429 0.27000 -0.04214 "
"0.09357 -0.03571 0.20714 -0.02643 0.09071 -0.02000 0.18857 -0.01929 0.08929 -0.00714 "
"0.16714 -0.00643 0.39857 -0.00214 0.39071 0.00286 0.40500 0.00571 0.15071 0.01143 "
"0.14357 0.02571 0.38500 0.03286 0.08929 0.03714 0.14071 0.04000 0.38071 0.05000 "
"0.09786 0.06857 0.14357 0.07143 0.37357 0.07143 0.14500 0.07714 0.36500 0.08571 "
"0.11071 0.09714 0.15357 0.09714 0.40071 0.10143 0.16071 0.10714 0.33857 0.11071 "
"0.40214 0.11714 0.32143 0.12071 0.18286 0.12357 0.31000 0.12500 0.13714 0.12786 "
"0.19714 0.12929 0.29286 0.12929 0.28429 0.13071 0.20857 0.13214 0.21857 0.13357 "
"0.37429 0.13643 0.40500 0.13714 0.16714 0.14500 0.32857 0.14500 0.31286 0.15071 "
"0.19000 0.15214 0.40500 0.15429 0.20429 0.15500 0.39286 0.15500 0.21429 0.15643 "
"0.23000 0.15786 0.40143 0.15786 0.26000 0.15929 116 6 15 9 16 5 19 "
"5 13 1 8 2 0 4 15 6 9 18 "
"10 5 16 13 20 19 5 4 3 15 "
"15 3 13 13 3 1 17 12 21 20 7 "
"24 9 15 18 10 22 14 22 10 18 "
"7 20 5 12 8 0 11 24 7 17 8 "
"12 25 21 12 14 30 12 14 26 30 "
"26 14 23 24 11 29 29 27 32 28 25 "
"12 31 28 12 33 35 34 27 29 11 "
"31 12 30 14 22 23 35 33 42 31 36 "
"37 32 33 34 36 31 30 38 37 36 "
"33 32 27 40 38 36 39 42 33 43 40 "
"36 41 42 39 44 42 41 46 43 36 "
"44 41 47 47 41 48 48 45 52 49 46 "
"36 50 48 52 48 41 45 51 61 53 "
"55 50 52 62 60 69 63 62 69 50 61 "
"51 61 50 59 60 58 69 56 69 58 "
"54 69 56 59 50 57 69 53 67 53 69 "
"54 57 50 55 64 73 66 71 63 69 "
"53 61 67 70 75 72 64 63 73 63 71 "
"73 66 73 68 68 73 70 61 65 67 "
"74 72 75 70 73 75 80 82 74 81 77 "
"78 76 78 77 79 74 75 80 74 79 "
"82 83 85 83 82 80 92 84 81 89 92 "
"94 92 87 84 86 88 90 86 90 85 "
"86 85 83 87 92 89 91 99 90 91 90 "
"88 92 81 78 108 102 101 99 93 107 "
"108 101 98 93 99 91 108 98 96 92 95 "
"94 93 97 107 114 103 104 103 114 100 "
"106 105 94 113 111 116 108 94 105 108 96 "
"94 107 97 110 102 117 104 106 111 113 "
"97 100 110 110 100 112 117 115 104 114 112 "
"100 117 102 109 105 106 113 114 104 115 "
"102 108 109 106 94 95 "
;

char *VTK_VECTOR_TEXT_84 = "62 0.590714 "
"0.24143 -0.36214 0.43000 -0.36214 0.39000 -0.36071 0.23500 -0.35857 0.43500 -0.35857 "
"0.33429 -0.35643 0.23786 -0.34714 0.43000 -0.34643 0.25000 -0.33929 0.39714 -0.33929 "
"0.27286 -0.33786 0.28500 -0.32857 0.38214 -0.32571 0.28929 -0.31857 0.37929 -0.31714 "
"0.55571 0.00643 0.56500 0.01143 0.55071 0.01429 0.10286 0.01643 0.09214 0.02000 "
"0.56786 0.02143 0.10786 0.02429 0.08929 0.02857 0.10929 0.03000 0.08786 0.03714 "
"0.11071 0.03857 0.11214 0.04857 0.57500 0.05286 0.08643 0.05571 0.11357 0.06000 "
"0.57643 0.06143 0.08929 0.06429 0.54929 0.06857 0.57786 0.07143 0.12429 0.07214 "
"0.13429 0.07786 0.53857 0.08071 0.16286 0.08929 0.09643 0.09857 0.20286 0.10214 "
"0.09786 0.10714 0.21857 0.10643 0.47143 0.10786 0.38071 0.11143 0.24143 0.11214 "
"0.28929 0.11286 0.45571 0.11214 0.44286 0.11500 0.38857 0.11643 0.43429 0.11643 "
"0.27000 0.11786 0.39571 0.11786 0.28429 0.11929 0.58214 0.12286 0.12714 0.14214 "
"0.56286 0.14214 0.59071 0.14714 0.09643 0.15429 0.58571 0.15357 0.57857 0.15500 "
"0.10000 0.15929 0.10714 0.15929 60 8 6 0 3 0 6 "
"1 7 2 7 9 2 7 1 4 12 5 "
"2 10 5 11 8 0 10 5 10 0 "
"5 14 13 11 5 13 14 5 12 12 2 "
"9 16 17 15 21 22 19 18 21 19 "
"20 17 16 22 21 23 24 22 23 24 23 "
"25 26 24 25 28 24 26 28 26 29 "
"28 29 31 32 17 20 31 29 38 27 32 "
"20 27 30 32 32 30 33 29 34 38 "
"34 35 38 37 40 35 36 53 55 36 55 "
"42 40 38 35 54 50 52 55 56 59 "
"57 40 37 54 41 44 45 13 14 47 46 "
"55 54 44 50 52 51 55 52 45 43 "
"54 39 41 54 37 39 49 47 55 52 43 "
"48 51 49 55 52 48 51 36 32 53 "
"32 33 53 46 42 55 43 45 14 54 52 "
"55 55 53 56 56 58 59 54 57 37 "
"57 61 60 61 57 54 "
;

char *VTK_VECTOR_TEXT_85 = "72 0.625000 "
"0.39571 -0.35643 0.31714 -0.35500 0.40714 -0.35357 0.42143 -0.35214 0.28714 -0.35071 "
"0.44286 -0.34500 0.25000 -0.34214 0.47571 -0.32929 0.39143 -0.32786 0.35143 -0.32643 "
"0.40429 -0.32643 0.20429 -0.32500 0.41429 -0.32500 0.33000 -0.32214 0.43429 -0.32071 "
"0.32000 -0.31929 0.49429 -0.31643 0.30429 -0.31357 0.45857 -0.31214 0.17571 -0.30500 "
"0.48429 -0.29643 0.52214 -0.29000 0.25714 -0.28500 0.15071 -0.27857 0.50929 -0.27143 "
"0.23214 -0.25714 0.13929 -0.25000 0.54643 -0.24857 0.13643 -0.23286 0.55214 -0.23286 "
"0.21929 -0.22857 0.53357 -0.21857 0.21643 -0.21714 0.55643 -0.21571 0.21500 -0.20714 "
"0.53214 0.06286 0.55929 0.09000 0.56214 0.10286 0.52214 0.10714 0.56786 0.11857 "
"0.13357 0.12000 0.21643 0.12286 0.51357 0.12286 0.13071 0.12714 0.21929 0.12857 "
"0.49857 0.13643 0.49286 0.13786 0.59000 0.13929 0.11571 0.14071 0.23143 0.14214 "
"0.08857 0.14500 0.26714 0.14500 0.47857 0.14500 0.61857 0.14643 0.55571 0.15071 "
"0.52143 0.15214 0.56857 0.15214 0.28214 0.15429 0.46929 0.15429 0.62500 0.15429 "
"0.07643 0.15571 0.19571 0.15500 0.20857 0.15643 0.13000 0.15786 0.28214 0.15857 "
"0.46929 0.15857 0.59714 0.15786 0.49143 0.15929 0.07643 0.16143 0.62286 0.16071 "
"0.27571 0.16214 0.08429 0.16500 70 14 5 18 3 10 2 0 9 1 "
"3 5 14 4 15 6 2 10 0 6 15 "
"11 12 10 3 0 10 8 0 8 9 "
"1 13 15 1 15 4 5 7 18 13 1 "
"9 12 3 14 17 11 15 11 22 19 "
"18 7 20 7 16 20 20 21 24 21 20 "
"16 22 11 17 26 30 28 19 25 23 "
"23 25 26 24 27 31 19 22 25 27 24 "
"21 29 31 27 26 25 30 33 31 29 "
"32 28 30 28 32 34 28 34 40 31 33 "
"35 36 38 35 36 37 38 38 54 42 "
"38 37 54 61 43 40 55 42 54 41 61 "
"40 42 55 45 63 43 61 46 55 52 "
"71 50 48 50 71 60 44 62 61 46 45 "
"55 47 56 39 41 40 34 39 54 37 "
"56 54 39 44 61 41 36 35 33 56 47 "
"66 53 66 47 43 63 48 70 62 49 "
"49 62 44 57 70 51 58 52 67 65 58 "
"67 66 53 69 67 52 55 59 69 53 "
"68 60 71 71 48 63 70 57 64 51 70 "
"49 "
;

char *VTK_VECTOR_TEXT_86 = "42 0.647857 "
"0.36714 -0.35500 0.35429 -0.35214 0.38357 -0.34143 0.34071 -0.33857 0.38643 -0.33286 "
"0.39643 -0.31143 0.40286 -0.22929 0.39357 -0.22714 0.40786 -0.22143 0.39071 -0.21857 "
"0.40929 -0.21143 0.46643 -0.08714 0.49357 -0.01714 0.51071 0.03571 0.52214 0.08000 "
"0.24929 0.11286 0.52929 0.11286 0.15500 0.12000 0.60357 0.12857 0.53071 0.13286 "
"0.24929 0.13429 0.13857 0.13643 0.52286 0.13929 0.25357 0.14143 0.29571 0.14071 "
"0.61714 0.14071 0.09500 0.14286 0.49143 0.14214 0.64786 0.14286 0.12143 0.14357 "
"0.62571 0.14357 0.11143 0.14500 0.26286 0.14786 0.28714 0.14786 0.53714 0.15214 "
"0.60714 0.15357 0.61714 0.15500 0.26143 0.15643 0.29286 0.15929 0.48929 0.16000 "
"0.09429 0.16071 0.64786 0.16143 40 "
"0 2 1 1 2 3 17 3 9 2 4 "
"3 6 7 5 10 8 11 8 6 5 "
"8 5 11 3 4 5 3 7 9 7 3 "
"5 12 18 13 13 18 14 14 18 16 "
"11 18 12 16 18 19 15 17 9 17 23 "
"37 17 37 21 40 31 29 20 17 15 "
"39 27 22 21 37 29 23 17 20 22 19 "
"34 35 25 36 30 36 25 5 18 11 "
"33 38 37 33 37 32 38 33 24 32 37 "
"23 34 19 18 34 18 35 25 35 18 "
"37 40 29 36 30 41 39 22 34 26 31 "
"40 30 28 41 "
;

char *VTK_VECTOR_TEXT_87 = "55 0.845000 "
"0.35571 -0.35500 0.34857 -0.35357 0.55429 -0.35357 0.57143 -0.35214 0.33786 -0.34571 "
"0.37500 -0.34143 0.58214 -0.34000 0.53786 -0.33714 0.59429 -0.22929 0.60143 -0.22929 "
"0.38571 -0.22357 0.39643 -0.21429 0.44071 -0.17143 0.47214 -0.16857 0.44929 -0.14571 "
"0.46500 -0.14571 0.46000 -0.14214 0.43929 -0.12143 0.43929 -0.08857 0.66500 -0.08571 "
"0.69214 -0.01571 0.71214 0.04857 0.44786 0.11143 0.14357 0.11571 0.72786 0.11714 "
"0.35357 0.11857 0.24214 0.12286 0.13000 0.13071 0.72929 0.13143 0.80357 0.13143 "
"0.44643 0.13286 0.24643 0.13857 0.33429 0.13786 0.72143 0.13929 0.27643 0.14143 "
"0.45143 0.14071 0.49357 0.14143 0.29357 0.14286 0.32429 0.14214 0.69000 0.14214 "
"0.81857 0.14214 0.84500 0.14286 0.07214 0.14429 0.10429 0.14357 0.26143 0.14357 "
"0.46429 0.14500 0.75857 0.15214 0.80429 0.15357 0.23000 0.15786 0.49143 0.15929 "
"0.29286 0.16071 0.68857 0.16071 0.84500 0.16143 0.07429 0.16214 0.27571 0.16214 53 5 "
"4 1 13 7 6 5 1 0 7 2 6 3 6 2 4 5 23 8 13 6 9 "
"6 19 9 8 6 10 5 11 23 5 10 12 11 5 17 11 12 18 15 8 15 "
"13 8 18 17 15 14 16 17 17 16 15 14 17 12 22 25 18 29 28 24 21 "
"29 24 20 29 21 29 20 19 46 29 47 23 26 48 27 23 48 22 18 8 38 "
"50 37 26 23 10 31 48 26 30 32 25 38 32 30 43 27 48 50 38 30 29 "
"19 6 40 47 29 53 43 48 44 48 31 36 49 45 50 35 49 35 45 49 33 "
"51 39 29 46 28 30 25 22 28 46 33 47 40 52 43 53 42 44 54 48 34 "
"54 44 50 30 35 33 46 51 40 41 52 "
;

char *VTK_VECTOR_TEXT_88 = "83 0.629286 "
"0.08286 -0.35643 0.10286 -0.35643 0.23429 -0.35643 0.43143 -0.35500 0.11286 -0.35357 "
"0.20000 -0.35357 0.24071 -0.35286 0.62286 -0.35357 0.13286 -0.35071 0.62929 -0.35000 "
"0.07500 -0.34857 0.16143 -0.34929 0.41786 -0.34857 0.24071 -0.34571 0.07643 -0.34143 "
"0.42000 -0.34071 0.62000 -0.33929 0.11286 -0.33786 0.08429 -0.33643 0.23143 -0.33500 "
"0.59143 -0.33500 0.44286 -0.33357 0.21857 -0.33214 0.58143 -0.33071 0.20929 -0.32571 "
"0.45786 -0.32429 0.20929 -0.31286 0.45786 -0.31286 0.55929 -0.31000 0.14500 -0.30714 "
"0.21929 -0.28714 0.23929 -0.25143 0.20071 -0.24429 0.47929 -0.20143 0.36071 -0.17857 "
"0.29357 -0.16857 0.34357 -0.15143 0.32143 -0.14071 0.33286 -0.14071 0.30500 -0.12000 "
"0.30500 -0.10714 0.30071 -0.09571 0.29500 -0.08571 0.37643 -0.05286 0.26786 -0.04571 "
"0.38071 -0.04429 0.25643 -0.03000 0.36714 -0.02786 0.36143 -0.02643 0.37214 -0.02429 "
"0.24500 -0.01429 0.38214 -0.01143 0.40786 0.02857 0.30786 0.04000 0.43357 0.07571 "
"0.48786 0.08286 0.15214 0.10714 0.25357 0.12286 0.45643 0.12571 0.14214 0.12714 "
"0.25500 0.13000 0.53143 0.12929 0.57071 0.13000 0.42143 0.13214 0.53714 0.13214 "
"0.56429 0.13214 0.45286 0.13357 0.13000 0.13643 0.28857 0.13929 0.09000 0.14071 "
"0.26857 0.14071 0.11571 0.14214 0.28429 0.14214 0.10714 0.14357 0.52571 0.15071 "
"0.45429 0.15214 0.54000 0.15214 0.55143 0.15357 0.13429 0.15500 0.57071 0.15714 "
"0.08643 0.15857 0.28714 0.15786 0.41643 0.15857 81 15 "
"3 21 4 17 1 6 13 2 5 22 11 3 15 12 10 0 14 8 17 4 0 "
"18 14 0 1 18 3 7 20 11 24 8 2 22 5 18 1 17 9 16 7 17 "
"8 29 23 3 20 13 19 2 21 3 25 2 19 22 20 7 16 11 22 24 24 "
"26 8 8 26 29 30 32 29 28 25 23 25 3 23 30 29 26 32 31 39 27 "
"33 34 27 25 28 31 32 30 33 27 28 41 43 42 42 43 44 35 39 31 39 "
"37 38 37 39 35 34 33 36 43 38 36 43 39 38 44 43 46 43 36 33 40 "
"43 41 43 40 39 47 48 43 45 47 43 49 47 45 46 43 50 51 49 45 52 "
"51 45 50 43 48 53 50 48 55 54 52 54 55 58 56 57 59 55 52 45 61 "
"74 75 50 57 56 57 50 53 67 78 71 80 73 78 64 74 61 82 63 75 73 "
"71 78 60 78 57 78 60 70 66 75 63 59 78 67 58 75 66 61 75 55 74 "
"64 76 65 77 64 58 55 75 77 76 64 77 65 79 65 62 79 69 73 80 78 "
"70 81 81 72 68 59 57 78 70 72 81 "
;

char *VTK_VECTOR_TEXT_89 = "72 0.560714 "
"0.25571 -0.35500 0.41643 -0.35429 0.22571 -0.35357 0.37429 -0.35357 0.28714 -0.35071 "
"0.31000 -0.34929 0.41643 -0.34714 0.22214 -0.34429 0.41000 -0.33929 0.40429 -0.33786 "
"0.23286 -0.33643 0.24714 -0.33643 0.38857 -0.33643 0.26143 -0.33500 0.38000 -0.33500 "
"0.36857 -0.33071 0.27357 -0.32286 0.36071 -0.31714 0.27786 -0.31429 0.27929 -0.14714 "
"0.27786 -0.14000 0.35929 -0.13714 0.36357 -0.12429 0.26786 -0.11714 0.35286 -0.08929 "
"0.36500 -0.07857 0.24214 -0.06714 0.23643 -0.05714 0.23071 -0.04714 0.38500 -0.04429 "
"0.31643 -0.03429 0.22071 -0.03000 0.21500 -0.02000 0.20500 -0.00286 0.43786 0.00143 "
"0.19500 0.01429 0.19071 0.02143 0.27786 0.03429 0.42357 0.03714 0.18071 0.03857 "
"0.16357 0.06714 0.43643 0.06857 0.15357 0.08429 0.14643 0.09571 0.24643 0.09571 "
"0.14214 0.10286 0.44786 0.10571 0.23786 0.11286 0.50786 0.11286 0.13357 0.12143 "
"0.23643 0.12571 0.44929 0.12857 0.52286 0.12786 0.56071 0.13000 0.41714 0.13214 "
"0.53286 0.13214 0.55143 0.13214 0.44286 0.13357 0.11857 0.13500 0.24571 0.13643 "
"0.27214 0.14000 0.07857 0.14071 0.25571 0.14071 0.10143 0.14214 0.46143 0.15071 "
"0.53286 0.15214 0.18714 0.15357 0.54286 0.15357 0.27071 0.15714 0.55857 0.15643 "
"0.07643 0.15857 0.41214 0.15857 70 0 11 2 4 5 16 4 13 0 "
"1 8 9 9 12 3 10 7 2 15 5 "
"3 1 9 3 1 6 8 11 10 2 "
"13 11 0 3 12 14 4 16 13 15 3 "
"14 16 5 18 18 17 19 17 21 19 "
"17 5 15 21 20 19 20 21 23 18 5 "
"17 23 30 26 25 24 22 23 22 24 "
"23 21 22 29 25 22 34 29 22 37 32 "
"31 32 37 33 29 34 38 28 37 31 "
"30 23 24 27 30 28 33 37 35 26 30 "
"27 36 37 39 37 36 35 28 30 37 "
"39 44 40 38 34 41 45 47 49 48 51 "
"46 47 45 43 47 43 42 40 47 42 "
"39 37 44 48 46 41 48 41 34 49 66 "
"58 54 57 71 52 64 48 52 55 65 "
"47 40 44 57 64 71 70 61 63 59 66 "
"50 64 52 65 51 64 57 67 55 56 "
"64 51 48 67 65 55 50 66 47 68 66 "
"59 67 56 69 70 63 66 66 49 47 "
"56 53 69 63 58 66 62 68 59 60 68 "
"62 "
;

char *VTK_VECTOR_TEXT_90 = "65 0.546429 "
"0.49143 -0.38071 0.48571 -0.37929 0.49929 -0.37429 0.46857 -0.36071 0.46286 -0.35929 "
"0.10143 -0.35643 0.08571 -0.35357 0.07929 -0.34571 0.28429 -0.33500 0.08214 -0.33286 "
"0.24571 -0.33214 0.31571 -0.33071 0.23857 -0.32929 0.22714 -0.32786 0.33286 -0.32786 "
"0.20929 -0.32286 0.36000 -0.32214 0.37571 -0.31786 0.21643 -0.31286 0.50786 -0.31000 "
"0.10643 -0.30571 0.40857 -0.30500 0.44571 -0.28643 0.51643 -0.27857 0.47714 -0.26929 "
"0.49214 -0.25286 0.50357 -0.23286 0.54071 -0.20571 0.54643 -0.18000 0.53286 -0.17214 "
"0.54143 -0.17214 0.09857 -0.01214 0.11929 0.00429 0.09929 0.01571 0.13071 0.04000 "
"0.13929 0.06143 0.11357 0.06857 0.16000 0.08357 0.11786 0.09143 0.49500 0.09286 "
"0.11929 0.10286 0.19857 0.10357 0.21429 0.10929 0.22857 0.11357 0.40357 0.11429 "
"0.12071 0.11857 0.25143 0.11929 0.40143 0.11929 0.27143 0.12357 0.39000 0.12357 "
"0.52643 0.12571 0.37857 0.12643 0.37000 0.12786 0.30286 0.12929 0.31286 0.13071 "
"0.53071 0.13714 0.52286 0.14786 0.47714 0.14929 0.15286 0.15071 0.48571 0.15500 "
"0.50286 0.15643 0.14500 0.15857 0.11929 0.16000 0.12286 0.16643 0.13714 0.16929 63 1 2 3 2 "
"1 0 7 6 9 5 9 6 4 8 5 4 22 21 24 22 19 5 20 9 5 "
"15 20 13 10 12 8 4 11 20 15 18 4 21 17 4 14 11 4 16 14 4 "
"17 16 5 8 10 22 4 3 19 22 3 5 13 15 19 3 2 5 10 13 23 "
"25 24 20 18 44 23 24 19 26 25 23 26 28 29 27 26 23 28 30 29 26 "
"27 28 32 33 31 33 34 36 34 33 32 34 35 36 36 35 38 35 37 38 45 "
"40 37 40 38 37 61 62 45 53 58 48 44 57 47 39 44 18 39 57 44 41 "
"58 37 58 46 48 58 45 37 58 42 43 56 50 55 58 41 42 57 39 59 58 "
"43 46 52 57 54 39 60 59 58 53 54 57 52 51 49 57 51 58 54 57 50 "
"60 39 47 57 49 50 56 60 62 61 64 63 62 64 61 45 58 "
;

char *VTK_VECTOR_TEXT_91 = "14 0.269286 "
"0.13000 -0.46500 0.26857 -0.46500 0.26929 -0.44857 0.20286 -0.44643 0.19286 -0.44214 "
"0.18357 -0.43143 0.18071 -0.42286 0.18071 0.05857 0.18500 0.06857 0.19429 0.07643 "
"0.19857 0.07786 0.26857 0.07929 0.26929 0.09571 0.13000 0.09643 12 "
"3 0 1 3 1 2 4 0 3 5 0 "
"4 13 0 6 6 0 5 9 13 8 "
"11 12 10 8 13 7 7 13 6 13 9 "
"10 12 13 10 "
;

char *VTK_VECTOR_TEXT_92 = "7 0.317143 "
"0.26857 -0.35786 0.31714 -0.35786 0.30500 -0.33429 0.25071 -0.32429 0.02500 0.09000 "
"0.01571 0.10929 0.06286 0.10929 5 0 2 3 0 1 2 3 6 4 3 2 6 6 5 4 "
;

char *VTK_VECTOR_TEXT_93 = "15 0.232857 "
"0.09429 -0.46500 0.23286 -0.46500 0.09429 -0.44786 0.16000 -0.44643 0.16571 -0.44500 "
"0.17643 -0.43857 0.18071 -0.42857 0.18357 0.04857 0.18214 0.06143 0.18071 0.06714 "
"0.17429 0.07500 0.09429 0.07929 0.16429 0.07929 0.09429 0.09643 0.23286 0.09643 13 2 0 3 5 1 6 4 1 5 1 "
"4 3 0 1 3 6 1 7 14 8 7 14 7 1 14 9 8 13 11 12 9 "
"14 10 13 12 14 10 14 12 "
;

char *VTK_VECTOR_TEXT_94 = "108 0.383571 "
"0.07929 -0.18143 0.13000 -0.18214 0.33286 -0.18214 0.38357 -0.18143 0.13071 -0.17857 "
"0.33214 -0.17857 0.13357 -0.17286 0.32929 -0.17286 0.13500 -0.16857 0.32786 -0.16857 "
"0.13929 -0.16000 0.32357 -0.16000 0.14071 -0.15571 0.32214 -0.15571 0.31929 -0.15000 "
"0.14500 -0.14714 0.36643 -0.14714 0.31786 -0.14571 0.36643 -0.14429 0.14643 -0.14286 "
"0.31357 -0.13714 0.15071 -0.13429 0.31214 -0.13286 0.15214 -0.13000 0.35786 -0.12857 "
"0.35786 -0.12571 0.30786 -0.12429 0.15643 -0.12143 0.30643 -0.12000 0.15786 -0.11714 "
"0.30357 -0.11429 0.30214 -0.11000 0.16214 -0.10857 0.34786 -0.10714 0.16357 -0.10429 "
"0.34786 -0.10429 0.29786 -0.10143 0.29643 -0.09714 0.16786 -0.09571 0.16929 -0.09143 "
"0.29357 -0.09143 0.33929 -0.08857 0.29214 -0.08714 0.33929 -0.08571 0.17357 -0.08286 "
"0.17500 -0.07857 0.28786 -0.07857 0.28643 -0.07429 0.17786 -0.07286 0.17929 -0.06857 "
"0.32929 -0.06714 0.28214 -0.06571 0.32929 -0.06429 0.28071 -0.06143 0.18357 -0.06000 "
"0.18500 -0.05571 0.27786 -0.05571 0.27643 -0.05143 0.18929 -0.04714 0.31929 -0.04571 "
"0.19071 -0.04286 0.27214 -0.04286 0.31929 -0.04286 0.27071 -0.03857 0.19500 -0.03429 "
"0.19643 -0.03000 0.26643 -0.03000 0.31071 -0.02714 0.26500 -0.02571 0.31071 -0.02429 "
"0.20071 -0.02143 0.26214 -0.02000 0.20214 -0.01714 0.26071 -0.01571 0.20643 -0.00857 "
"0.25643 -0.00714 0.30071 -0.00571 0.20786 -0.00429 0.25500 -0.00286 0.30071 -0.00286 "
"0.25214 0.00286 0.21214 0.00429 0.25071 0.00714 0.21357 0.00857 0.29214 0.01286 "
"0.24643 0.01571 0.29214 0.01571 0.21786 0.01714 0.24500 0.02000 0.21929 0.02143 "
"0.22214 0.02714 0.24071 0.02857 0.22357 0.03143 0.23929 0.03286 0.28214 0.03429 "
"0.28214 0.03714 0.23643 0.03857 0.22786 0.04000 0.23500 0.04286 0.22929 0.04429 "
"0.23143 0.04786 0.27357 0.05286 0.27357 0.05571 0.26357 0.07429 0.26357 0.07714 "
"0.25500 0.09286 0.21000 0.09643 0.25429 0.09643 106 0 55 106 "
"16 14 13 16 17 14 0 6 8 16 13 "
"11 17 16 20 0 1 4 6 0 4 "
"16 11 9 15 19 0 16 9 7 10 0 "
"8 5 2 3 0 10 12 16 7 5 "
"16 5 3 28 26 24 24 26 22 22 20 "
"18 21 23 0 20 16 18 15 0 12 "
"24 22 18 21 0 19 31 30 24 34 0 "
"29 28 24 30 31 33 36 0 27 29 "
"31 24 25 0 34 39 37 36 33 31 25 "
"33 42 40 33 27 0 23 32 34 29 "
"42 41 46 37 33 40 0 39 45 42 33 "
"35 41 42 35 47 41 43 47 46 41 "
"38 39 34 50 51 47 44 45 39 48 49 "
"45 53 51 50 50 47 43 55 60 106 "
"53 50 56 57 56 50 59 61 57 57 50 "
"52 0 49 55 63 61 59 59 57 52 "
"0 45 49 54 55 49 63 62 66 63 59 "
"62 58 60 55 60 65 106 68 66 62 "
"68 67 71 67 68 62 73 71 67 65 72 "
"106 73 69 75 64 65 60 73 67 69 "
"78 76 80 76 78 75 72 77 106 76 75 "
"69 70 72 65 88 85 84 82 80 76 "
"82 79 85 74 77 72 82 76 79 84 85 "
"79 77 83 106 88 86 91 81 83 77 "
"88 84 86 93 91 86 83 87 89 93 94 "
"96 83 89 106 98 94 95 94 93 86 "
"89 90 106 98 95 100 98 96 94 90 92 "
"106 101 100 95 101 102 100 92 97 106 "
"97 99 106 99 100 106 100 102 106 102 103 "
"106 105 107 106 103 105 106 103 104 105 "
;

char *VTK_VECTOR_TEXT_95 = "4 0.413571 "
"0.07143 -0.44929 0.41357 -0.44857 0.07143 -0.41500 0.41286 -0.41500 2 1 3 2 1 2 0 "
;

char *VTK_VECTOR_TEXT_96 = "73 0.236429 "
"0.21000 -0.01071 0.23643 -0.01000 0.20714 -0.00786 0.20286 -0.00643 0.20429 -0.00643 "
"0.19857 -0.00357 0.20000 -0.00357 0.19571 -0.00071 0.19143 0.00071 0.19286 0.00071 "
"0.18714 0.00357 0.18857 0.00357 0.18429 0.00643 0.18000 0.00786 0.18143 0.00786 "
"0.17571 0.01071 0.17714 0.01071 0.17286 0.01357 0.21214 0.01429 0.16857 0.01500 "
"0.17000 0.01500 0.21214 0.01571 0.16429 0.01786 0.16571 0.01786 0.16000 0.02071 "
"0.16143 0.02071 0.15714 0.02357 0.15286 0.02500 0.15429 0.02500 0.14857 0.02786 "
"0.15000 0.02786 0.14571 0.03071 0.14143 0.03214 0.14286 0.03214 0.13714 0.03500 "
"0.13857 0.03500 0.13429 0.03786 0.13000 0.03929 0.13143 0.03929 0.12571 0.04214 "
"0.12714 0.04214 0.12286 0.04500 0.11857 0.04643 0.12000 0.04643 0.11429 0.04929 "
"0.11571 0.04929 0.11000 0.05214 0.11143 0.05214 0.10571 0.05500 0.10714 0.05500 "
"0.10000 0.05929 0.10143 0.05929 0.09143 0.06643 0.09286 0.06643 0.08357 0.07429 "
"0.08357 0.07714 0.08214 0.07857 0.14071 0.08714 0.14071 0.08857 0.08214 0.09000 "
"0.08357 0.09143 0.08500 0.09714 0.13143 0.09643 0.13286 0.09643 0.12714 0.10071 "
"0.11857 0.10357 0.12143 0.10357 0.09286 0.10500 0.09571 0.10500 0.11286 0.10500 "
"0.11714 0.10500 0.09714 0.10643 0.11143 0.10643 71 18 4 2 3 4 6 5 6 7 18 6 4 8 9 11 16 14 21 10 "
"11 12 18 2 0 13 14 16 18 9 7 6 18 7 28 26 57 15 16 17 19 "
"20 23 9 18 21 1 18 0 22 23 25 14 12 21 24 25 26 17 16 21 26 "
"25 57 27 28 30 25 21 57 25 23 21 29 30 31 20 17 21 23 20 21 32 "
"33 35 33 31 57 34 35 36 30 28 57 31 30 57 36 35 57 35 33 57 37 "
"38 40 12 11 21 39 40 41 38 36 57 42 43 45 38 57 40 44 45 47 11 "
"9 21 46 47 49 48 49 51 50 51 53 52 53 55 57 49 47 57 47 45 52 "
"55 54 57 51 49 57 55 51 45 43 41 57 41 40 55 53 51 57 45 41 61 "
"68 67 59 55 60 55 59 56 63 57 58 60 68 61 62 55 57 55 62 64 60 "
"55 68 72 68 69 63 62 57 69 68 55 65 55 64 72 71 68 65 69 55 65 "
"64 66 70 69 65 "
;

char *VTK_VECTOR_TEXT_97 = "134 0.389286 "
"0.18571 -0.35786 0.32143 -0.35786 0.14857 -0.35643 0.29857 -0.35643 0.13857 -0.35500 "
"0.29286 -0.35500 0.13286 -0.35357 0.28714 -0.35357 0.12857 -0.35214 0.22714 -0.35214 "
"0.12429 -0.35071 0.34857 -0.35071 0.12000 -0.34929 0.35714 -0.34500 0.10857 -0.34357 "
"0.36286 -0.34214 0.10429 -0.34071 0.25286 -0.34071 0.27214 -0.33857 0.10000 -0.33786 "
"0.36857 -0.33786 0.26571 -0.33071 0.20429 -0.32786 0.21571 -0.32786 0.34571 -0.32786 "
"0.19429 -0.32643 0.22429 -0.32643 0.34143 -0.32643 0.35000 -0.32643 0.38071 -0.32571 "
"0.08643 -0.32429 0.18857 -0.32500 0.23000 -0.32500 0.35286 -0.32500 0.23429 -0.32357 "
"0.18143 -0.32214 0.23857 -0.32214 0.33786 -0.32143 0.35714 -0.32214 0.38214 -0.32143 "
"0.17571 -0.31929 0.08357 -0.31714 0.25000 -0.31643 0.08214 -0.31286 0.38643 -0.31286 "
"0.16643 -0.31000 0.38786 -0.30857 0.08071 -0.30714 0.26071 -0.30571 0.16214 -0.30143 "
"0.26357 -0.30000 0.26500 -0.29571 0.38929 -0.29571 0.38286 -0.29357 0.16071 -0.28857 "
"0.08071 -0.28286 0.16214 -0.27857 0.16357 -0.27429 0.08500 -0.27286 0.16643 -0.26857 "
"0.09357 -0.25714 0.17571 -0.25786 0.18000 -0.25500 0.18857 -0.25071 0.19286 -0.24929 "
"0.19714 -0.24786 0.26500 -0.24714 0.20143 -0.24643 0.10857 -0.24500 0.20857 -0.24500 "
"0.26286 -0.24500 0.11286 -0.24357 0.12143 -0.23929 0.13000 -0.23500 0.13429 -0.23357 "
"0.13857 -0.23214 0.14286 -0.23071 0.14714 -0.22929 0.15143 -0.22786 0.15714 -0.22643 "
"0.16286 -0.22500 0.17000 -0.22357 0.17857 -0.22214 0.18857 -0.22071 0.20286 -0.21929 "
"0.26500 -0.21714 0.16286 -0.20214 0.14571 -0.20071 0.14000 -0.19929 0.13571 -0.19786 "
"0.18857 -0.19500 0.12714 -0.19357 0.19357 -0.19000 0.11643 -0.18429 0.19500 -0.18429 "
"0.11500 -0.18000 0.19643 -0.17714 0.11357 -0.17429 0.11214 -0.16000 0.33643 -0.16000 "
"0.33357 -0.15429 0.19643 -0.15143 0.26500 -0.15143 0.26357 -0.14714 0.19500 -0.14286 "
"0.11929 -0.14143 0.32786 -0.14143 0.25429 -0.13643 0.18786 -0.13286 0.24286 -0.13071 "
"0.19429 -0.12929 0.23857 -0.12929 0.19857 -0.12786 0.23286 -0.12786 0.31286 -0.12786 "
"0.20286 -0.12643 0.22714 -0.12643 0.13571 -0.12500 0.21857 -0.12500 0.14000 -0.12357 "
"0.14857 -0.11929 0.15286 -0.11786 0.15714 -0.11643 0.16286 -0.11500 0.28000 -0.11500 "
"0.28429 -0.11500 0.16714 -0.11357 0.17286 -0.11214 0.27429 -0.11214 0.18000 -0.11071 "
"0.26143 -0.11071 0.18857 -0.10929 0.20143 -0.10786 0.25143 -0.10786 134 9 23 22 9 22 "
"0 37 21 18 11 24 27 12 10 14 "
"25 4 2 25 16 10 15 33 13 36 17 "
"42 7 5 18 17 32 9 13 24 11 "
"11 27 1 30 19 41 18 5 3 25 8 "
"6 0 25 2 22 25 0 4 25 6 "
"25 10 8 26 23 9 20 38 15 19 16 "
"25 10 16 14 27 37 1 13 28 24 "
"33 28 13 38 46 53 19 25 31 17 34 "
"32 32 26 9 17 36 34 15 38 33 "
"35 19 31 47 49 55 18 3 1 47 43 "
"19 19 43 41 48 42 17 38 44 46 "
"40 19 35 49 19 45 37 50 21 21 48 "
"17 44 38 39 46 52 53 49 47 19 "
"37 18 1 38 29 39 45 19 40 51 50 "
"37 48 21 50 38 20 29 49 58 55 "
"54 56 60 58 49 60 59 71 57 49 54 "
"60 72 71 59 56 68 60 61 73 72 "
"76 75 61 56 71 68 61 74 73 81 61 "
"62 84 63 64 63 82 62 84 64 65 "
"66 51 37 84 65 67 84 67 69 84 69 "
"70 71 56 57 61 75 74 61 72 59 "
"70 66 85 77 76 61 78 77 61 79 78 "
"61 80 79 61 81 80 61 82 81 62 "
"83 82 63 84 83 63 84 70 85 66 37 "
"85 89 95 91 94 96 86 89 88 95 "
"90 94 86 93 91 95 94 90 92 95 87 "
"86 95 88 87 96 97 86 97 95 86 "
"100 103 102 97 96 105 98 97 105 100 102 "
"85 99 100 85 105 108 119 107 124 109 "
"119 108 120 99 85 37 105 96 101 104 108 "
"101 105 119 117 105 101 108 114 103 106 "
"106 103 100 103 124 107 132 110 112 110 129 "
"108 132 112 115 110 131 129 121 120 108 "
"124 111 109 122 121 108 124 113 111 123 122 "
"108 124 116 113 126 123 108 125 103 114 "
"125 124 103 127 126 108 116 124 128 118 116 "
"133 129 127 108 132 115 118 130 116 128 "
"131 110 132 132 118 133 133 116 130 "
;

char *VTK_VECTOR_TEXT_98 = "63 0.402143 "
"0.27429 -0.35786 0.13429 -0.35643 0.14000 -0.35500 0.23286 -0.35500 0.29429 -0.35500 "
"0.12500 -0.34429 0.32286 -0.34500 0.20286 -0.34357 0.34000 -0.33786 0.23714 -0.33643 "
"0.26286 -0.33643 0.23000 -0.33357 0.27143 -0.33214 0.16000 -0.33071 0.18143 -0.33071 "
"0.21714 -0.32500 0.36143 -0.32214 0.20786 -0.31429 0.28929 -0.31286 0.20357 -0.30429 "
"0.38071 -0.30429 0.29929 -0.28857 0.39500 -0.27714 0.30357 -0.27143 0.30500 -0.26286 "
"0.40071 -0.25714 0.30643 -0.24714 0.30357 -0.20571 0.40214 -0.20143 0.29929 -0.18857 "
"0.20214 -0.17429 0.29214 -0.17000 0.39357 -0.16857 0.20643 -0.16143 0.28500 -0.15857 "
"0.27143 -0.14643 0.22714 -0.14214 0.23571 -0.13929 0.25429 -0.13929 0.37000 -0.13643 "
"0.20786 -0.13429 0.21429 -0.13357 0.24714 -0.12214 0.34857 -0.12214 0.26143 -0.11929 "
"0.27143 -0.11786 0.28714 -0.11643 0.31714 -0.11500 0.08000 0.15071 0.08857 0.15071 "
"0.12500 0.15286 0.11714 0.15500 0.10143 0.15643 0.07214 0.15857 0.07214 0.17000 "
"0.13143 0.17929 0.15000 0.18071 0.08429 0.18500 0.16714 0.18500 0.20786 0.18571 "
"0.09714 0.18643 0.18286 0.19071 0.19429 0.19357 63 4 12 0 3 9 7 9 3 10 1 2 5 3 0 10 6 "
"18 4 10 0 12 11 7 9 13 5 2 18 12 4 19 14 17 14 19 13 15 "
"7 11 18 6 21 7 17 14 6 8 21 8 16 21 13 19 5 17 7 15 21 "
"16 23 24 23 16 24 16 20 22 24 20 26 24 22 25 26 22 26 28 27 39 "
"43 31 27 28 29 39 31 29 28 26 25 32 29 28 30 5 19 34 46 35 41 "
"36 37 36 41 33 37 38 42 35 45 38 35 46 45 41 40 33 33 40 30 40 "
"5 30 41 37 42 31 47 34 39 29 32 42 38 44 45 44 38 47 46 34 47 "
"31 43 50 5 40 48 49 53 50 40 56 57 54 49 55 52 51 52 57 49 54 "
"53 49 60 52 55 55 51 50 55 50 56 60 57 52 56 40 58 58 59 61 59 "
"58 40 61 59 62 "
;

char *VTK_VECTOR_TEXT_99 = "166 0.325000 "
"0.19571 -0.36071 0.22286 -0.36071 0.18286 -0.35929 0.19429 -0.35929 0.18143 -0.35786 "
"0.17286 -0.35643 0.24714 -0.35643 0.16571 -0.35500 0.16000 -0.35357 0.25286 -0.35357 "
"0.15571 -0.35214 0.25714 -0.35214 0.15143 -0.35071 0.26143 -0.35071 0.14714 -0.34929 "
"0.14429 -0.34786 0.14000 -0.34643 0.27143 -0.34643 0.27429 -0.34643 0.13714 -0.34500 "
"0.13286 -0.34214 0.13000 -0.34071 0.28857 -0.33786 0.12429 -0.33643 0.29286 -0.33500 "
"0.29714 -0.33214 0.22000 -0.32357 0.24429 -0.32357 0.21429 -0.32214 0.25000 -0.32214 "
"0.10643 -0.32000 0.25429 -0.32071 0.20857 -0.31929 0.25857 -0.31929 0.20143 -0.31786 "
"0.26286 -0.31786 0.26857 -0.31643 0.27286 -0.31500 0.19143 -0.31357 0.27571 -0.31357 "
"0.18857 -0.31214 0.28000 -0.31214 0.31929 -0.31143 0.09929 -0.31000 0.28286 -0.31071 "
"0.18429 -0.30929 0.28714 -0.30929 0.29000 -0.30786 0.09786 -0.30571 0.29429 -0.30643 "
"0.29714 -0.30500 0.09643 -0.30286 0.30143 -0.30357 0.30429 -0.30214 0.32500 -0.30143 "
"0.09500 -0.30000 0.30857 -0.30071 0.17357 -0.29857 0.09357 -0.29714 0.32286 -0.29643 "
"0.09214 -0.29429 0.09071 -0.29000 0.16643 -0.28857 0.08929 -0.28571 0.16500 -0.28571 "
"0.16357 -0.28286 0.08786 -0.28143 0.16214 -0.28000 0.16071 -0.27714 0.08643 -0.27571 "
"0.15929 -0.27286 0.08500 -0.26857 0.08357 -0.26714 0.15786 -0.26714 0.15643 -0.25857 "
"0.08357 -0.25714 0.08214 -0.25571 0.08214 -0.23000 0.08357 -0.22857 0.15643 -0.22143 "
"0.15786 -0.22000 0.25571 -0.22071 0.27429 -0.21929 0.08357 -0.21714 0.24143 -0.21643 "
"0.24429 -0.21643 0.28000 -0.21643 0.23857 -0.21357 0.29000 -0.21214 0.15786 -0.21000 "
"0.08643 -0.20857 0.22643 -0.20429 0.08643 -0.20286 0.15929 -0.20286 0.22357 -0.19857 "
"0.08929 -0.19714 0.16071 -0.19714 0.22071 -0.19571 0.08929 -0.19286 0.30786 -0.19286 "
"0.16214 -0.19143 0.21929 -0.19143 0.21643 -0.18857 0.30929 -0.18857 0.16357 -0.18714 "
"0.21643 -0.18571 0.16500 -0.18429 0.31071 -0.18429 0.21500 -0.18286 0.16643 -0.18143 "
"0.09500 -0.17857 0.21357 -0.17857 0.31214 -0.17857 0.16786 -0.17714 0.31357 -0.17714 "
"0.09786 -0.17571 0.16929 -0.17429 0.09929 -0.17286 0.17071 -0.17143 0.10071 -0.17000 "
"0.21214 -0.17000 0.17214 -0.16857 0.21071 -0.16857 0.17500 -0.16571 0.17643 -0.16143 "
"0.10786 -0.15857 0.17929 -0.15714 0.31357 -0.15429 0.21214 -0.15000 0.31071 -0.14857 "
"0.18857 -0.14786 0.19143 -0.14643 0.19429 -0.14500 0.19714 -0.14357 0.20000 -0.14214 "
"0.20286 -0.14071 0.20571 -0.13929 0.30643 -0.13857 0.20857 -0.13786 0.21786 -0.13714 "
"0.13143 -0.13643 0.21143 -0.13643 0.21714 -0.13500 0.13714 -0.13357 0.14143 -0.13071 "
"0.14429 -0.12786 0.29571 -0.12786 0.14857 -0.12643 0.15143 -0.12500 0.15429 -0.12357 "
"0.15714 -0.12214 0.16000 -0.12071 0.28429 -0.12071 0.16429 -0.11929 0.16714 -0.11786 "
"0.17143 -0.11643 0.17714 -0.11500 0.18143 -0.11357 0.18857 -0.11214 0.19571 -0.11071 "
"0.19714 -0.10929 0.20714 -0.10929 0.24000 -0.10929 0.24857 -0.10929 0.20857 -0.10786 "
"0.23857 -0.10786 164 2 3 "
"4 6 29 27 6 27 26 7 5 26 "
"6 26 1 12 10 26 13 31 29 9 29 "
"6 10 8 26 8 7 26 11 13 29 "
"15 26 20 15 14 12 9 11 29 15 12 "
"26 19 16 15 17 33 13 21 20 26 "
"19 15 20 5 4 26 4 3 26 26 3 "
"1 3 0 1 41 22 24 13 33 31 "
"30 57 43 22 33 18 28 21 26 22 41 "
"39 34 21 28 22 39 37 34 28 32 "
"23 21 34 22 37 36 57 48 43 30 45 "
"57 22 36 35 38 23 34 22 35 33 "
"33 17 18 46 24 25 46 44 24 30 23 "
"45 44 41 24 49 47 25 42 52 25 "
"47 46 25 23 40 45 65 55 51 65 63 "
"61 50 49 25 52 50 25 62 48 57 "
"65 69 66 53 52 42 56 42 59 65 61 "
"60 65 66 63 65 60 58 56 53 42 "
"65 58 55 42 54 59 65 51 48 23 38 "
"40 64 65 48 62 64 48 71 69 65 "
"71 65 67 71 75 72 75 71 70 75 70 "
"73 71 67 68 71 68 70 77 75 74 "
"75 73 74 75 77 76 83 78 79 77 74 "
"79 83 79 90 77 79 78 84 85 87 "
"86 120 111 92 90 95 80 89 79 87 85 "
"94 90 79 95 87 94 91 98 95 115 "
"82 86 94 95 89 93 97 94 101 111 108 "
"105 86 111 105 88 120 86 98 115 110 "
"119 96 100 86 105 101 119 93 96 101 105 "
"102 95 93 115 95 79 89 82 94 85 "
"86 101 94 117 115 93 106 109 125 146 152 "
"139 100 104 125 120 139 128 119 117 93 "
"99 103 88 88 107 112 119 100 125 104 106 "
"125 81 82 85 124 149 148 122 120 128 "
"116 118 125 125 121 124 120 88 112 114 127 "
"112 113 116 125 125 124 140 109 113 125 "
"129 112 127 124 144 143 125 118 121 150 149 "
"130 158 133 134 157 130 131 157 131 132 "
"158 132 133 158 134 135 124 148 147 159 135 "
"136 103 107 88 144 124 147 161 136 138 "
"163 142 139 120 112 129 145 144 147 161 138 "
"141 120 137 139 137 120 129 140 124 143 "
"126 149 124 124 121 123 151 150 130 130 149 "
"126 137 146 139 153 151 130 154 153 130 "
"155 154 130 156 155 130 157 156 130 158 157 "
"132 159 158 135 142 163 141 159 161 160 "
"161 159 136 163 139 152 162 165 141 161 141 "
"164 165 164 141 163 162 141 "
;

char *VTK_VECTOR_TEXT_100 = "64 0.409286 "
"0.22857 -0.35786 0.18143 -0.35643 0.29286 -0.35643 0.39000 -0.35357 0.39857 -0.35357 "
"0.16143 -0.35214 0.37143 -0.35071 0.32143 -0.34786 0.35571 -0.34643 0.40786 -0.34571 "
"0.14286 -0.34500 0.26286 -0.34071 0.27857 -0.33929 0.40929 -0.33857 0.13143 -0.33786 "
"0.40429 -0.33214 0.38143 -0.33071 0.21429 -0.32643 0.24286 -0.32643 0.37357 -0.32571 "
"0.11500 -0.32429 0.20286 -0.32214 0.25714 -0.32071 0.36929 -0.31571 0.18643 -0.30571 "
"0.27929 -0.29857 0.09357 -0.29143 0.28500 -0.28571 0.17643 -0.28429 0.08643 -0.26714 "
"0.17071 -0.26286 0.08500 -0.25857 0.08357 -0.24429 0.08357 -0.20857 0.17071 -0.20286 "
"0.08929 -0.19000 0.17500 -0.18429 0.18071 -0.16857 0.28500 -0.16857 0.09929 -0.16571 "
"0.28214 -0.16143 0.18643 -0.15857 0.11214 -0.14857 0.26571 -0.14500 0.20000 -0.14357 "
"0.21143 -0.13786 0.24714 -0.13786 0.28643 -0.12857 0.13857 -0.12500 0.15857 -0.11500 "
"0.17571 -0.10929 0.18286 -0.10786 0.23571 -0.10643 0.28643 0.15857 0.24000 0.15929 "
"0.23357 0.16429 0.26857 0.16500 0.23214 0.17571 0.30143 0.18786 0.36929 0.19286 "
"0.32571 0.19357 0.24714 0.19500 0.34571 0.20071 0.35714 0.20214 64 12 22 11 25 23 "
"27 1 17 5 9 15 4 18 11 22 "
"11 18 0 0 17 1 5 17 10 17 0 "
"18 3 15 6 4 15 3 6 15 8 "
"16 8 15 13 15 9 17 14 10 19 8 "
"16 21 14 17 22 12 25 8 23 7 "
"24 14 21 7 12 2 28 20 14 23 25 "
"12 8 19 23 23 12 7 27 23 38 "
"26 28 29 20 28 26 28 14 24 30 31 "
"29 32 31 30 30 29 28 34 35 33 "
"49 44 50 34 33 32 35 34 39 34 32 "
"30 40 47 43 36 42 39 48 44 49 "
"43 47 46 37 41 48 41 44 48 45 51 "
"44 38 47 40 38 23 47 23 53 47 "
"36 39 34 46 52 45 42 36 37 42 37 "
"48 51 50 44 47 52 46 51 45 52 "
"57 55 54 53 58 56 57 56 61 58 53 "
"60 53 59 60 61 56 58 57 54 56 "
"60 59 62 53 23 59 63 62 59 "
;

char *VTK_VECTOR_TEXT_101 = "162 0.332143 "
"0.20143 -0.35929 0.22571 -0.35929 0.19143 -0.35786 0.20000 -0.35786 0.19000 -0.35643 "
"0.18286 -0.35500 0.25000 -0.35500 0.17714 -0.35357 0.17286 -0.35214 0.25571 -0.35214 "
"0.16857 -0.35071 0.26000 -0.35071 0.26286 -0.35071 0.16429 -0.34929 0.16143 -0.34786 "
"0.15714 -0.34643 0.15429 -0.34500 0.27286 -0.34500 0.27571 -0.34357 0.15000 -0.34214 "
"0.27857 -0.34214 0.14714 -0.34071 0.28286 -0.33929 0.14286 -0.33786 0.28571 -0.33786 "
"0.13857 -0.33500 0.29000 -0.33500 0.29571 -0.33071 0.13143 -0.32929 0.24286 -0.32357 "
"0.25857 -0.32357 0.23429 -0.32214 0.26571 -0.32214 0.22857 -0.32071 0.26857 -0.32071 "
"0.27286 -0.31929 0.22000 -0.31786 0.22286 -0.31786 0.27571 -0.31643 0.21429 -0.31500 "
"0.28000 -0.31500 0.21000 -0.31214 0.28571 -0.31071 0.31929 -0.30714 0.29143 -0.30643 "
"0.10643 -0.30429 0.32214 -0.30143 0.10357 -0.29857 0.32500 -0.29857 0.10071 -0.29571 "
"0.30286 -0.29643 0.32643 -0.29429 0.09929 -0.29143 0.18929 -0.29143 0.32786 -0.29143 "
"0.09786 -0.28857 0.18643 -0.28714 0.33071 -0.28714 0.09643 -0.28571 0.09500 -0.28286 "
"0.18357 -0.28286 0.09357 -0.28000 0.32000 -0.27929 0.18071 -0.27714 0.33214 -0.27714 "
"0.09214 -0.27571 0.17929 -0.27429 0.33000 -0.27500 0.09071 -0.27143 0.17786 -0.27143 "
"0.08929 -0.26714 0.17643 -0.26714 0.08786 -0.26143 0.17643 -0.26143 0.08643 -0.25429 "
"0.17357 -0.25429 0.08500 -0.25286 0.17214 -0.24857 0.08500 -0.24429 0.08357 -0.24286 "
"0.17071 -0.24286 0.16929 -0.23571 0.16786 -0.22857 0.08357 -0.22714 0.08500 -0.22571 "
"0.16643 -0.22000 0.16714 -0.21357 0.33000 -0.21357 0.08643 -0.20857 0.33071 -0.20857 "
"0.08929 -0.20143 0.32786 -0.20143 0.08929 -0.19714 0.32786 -0.19714 0.16714 -0.19643 "
"0.22571 -0.19643 0.22714 -0.19500 0.23571 -0.19500 0.16643 -0.19286 0.24286 -0.19357 "
"0.09214 -0.19143 0.16786 -0.19143 0.24714 -0.19214 0.32500 -0.19143 0.32357 -0.18714 "
"0.25357 -0.18571 0.09500 -0.18429 0.16786 -0.18286 0.09500 -0.18143 0.25643 -0.18143 "
"0.25786 -0.17857 0.31929 -0.17714 0.16929 -0.17571 0.26071 -0.17429 0.31929 -0.17429 "
"0.17071 -0.16714 0.26357 -0.16714 0.17214 -0.16143 0.26500 -0.16143 0.17357 -0.15714 "
"0.11071 -0.15571 0.26500 -0.15429 0.17500 -0.15286 0.30500 -0.15143 0.17643 -0.15000 "
"0.26357 -0.14857 0.17786 -0.14714 0.26214 -0.14571 0.18071 -0.14286 0.18357 -0.13857 "
"0.25286 -0.13643 0.25000 -0.13500 0.24714 -0.13357 0.28714 -0.13357 0.19000 -0.13214 "
"0.24429 -0.13214 0.13714 -0.13071 0.24000 -0.13071 0.19429 -0.12929 0.23429 -0.12929 "
"0.14286 -0.12786 0.19857 -0.12786 0.21429 -0.12786 0.22714 -0.12786 0.20429 -0.12643 "
"0.21286 -0.12643 0.14571 -0.12500 0.15000 -0.12357 0.15286 -0.12214 0.15571 -0.12071 "
"0.15857 -0.11929 0.16143 -0.11786 0.16571 -0.11643 0.17000 -0.11500 0.17429 -0.11357 "
"0.18000 -0.11214 0.24286 -0.11214 0.18714 -0.11071 0.18857 -0.10929 0.19857 -0.10929 "
"0.20000 -0.10786 0.22000 -0.10786 162 35 17 18 29 21 "
"19 29 23 21 9 29 6 14 29 19 "
"2 3 4 29 14 10 6 29 1 29 5 "
"4 29 7 5 14 13 10 29 10 8 "
"30 11 12 16 15 14 29 8 7 16 14 "
"19 29 0 1 29 3 0 29 4 3 "
"32 30 12 29 9 11 34 32 12 35 20 "
"22 35 18 20 25 23 29 30 29 11 "
"31 25 29 35 22 24 38 35 26 25 31 "
"33 35 24 26 36 25 33 37 36 33 "
"40 26 27 39 25 36 35 34 12 38 26 "
"40 69 72 70 35 12 17 40 27 42 "
"41 25 39 42 27 44 53 47 45 43 50 "
"44 28 25 53 28 53 45 43 44 27 "
"69 59 58 62 64 67 69 61 59 46 50 "
"43 69 70 68 50 46 48 69 65 61 "
"69 68 65 56 47 53 56 60 47 53 25 "
"41 74 72 69 62 51 54 57 62 54 "
"51 50 48 69 55 52 51 62 50 69 58 "
"55 63 47 60 47 69 52 62 57 64 "
"49 47 52 63 66 47 66 69 47 78 74 "
"71 74 69 71 75 78 71 74 78 76 "
"75 71 73 84 78 80 78 75 77 78 77 "
"80 84 80 81 84 85 88 78 83 79 "
"83 78 84 84 81 82 84 82 85 97 95 "
"86 85 90 88 92 90 100 91 86 87 "
"91 87 89 90 85 100 94 86 95 95 97 "
"96 103 91 93 100 98 106 105 103 109 "
"97 86 91 101 107 98 103 105 91 105 102 "
"91 102 99 91 99 97 91 108 106 120 "
"86 100 85 110 109 103 113 110 104 86 94 "
"100 110 103 104 106 98 120 107 112 120 "
"98 100 94 98 107 120 113 104 111 121 118 "
"111 113 111 116 115 117 120 118 116 111 "
"120 122 136 125 121 111 123 125 111 112 115 "
"120 117 119 120 123 111 114 119 122 120 "
"140 126 128 123 133 125 126 140 124 140 122 "
"124 140 128 129 136 122 140 127 125 133 "
"153 152 134 157 134 138 156 137 135 146 140 "
"147 159 138 141 156 131 130 156 135 132 "
"130 127 133 140 129 147 148 147 129 161 145 "
"143 149 148 129 156 132 131 150 149 129 "
"152 151 129 151 150 129 154 153 134 134 152 "
"129 155 154 134 139 137 156 157 155 134 "
"156 130 133 157 159 158 143 139 156 161 143 "
"156 145 142 143 144 145 161 141 161 160 "
"157 138 159 159 141 160 141 144 161 "
;

char *VTK_VECTOR_TEXT_102 = "50 0.310714 "
"0.23000 -0.35786 0.08571 -0.35643 0.13000 -0.35500 0.20143 -0.35357 0.07857 -0.35214 "
"0.13714 -0.35214 0.24214 -0.34857 0.07643 -0.34286 0.24214 -0.34000 0.23714 -0.33643 "
"0.21571 -0.33500 0.11000 -0.33071 0.20357 -0.32286 0.11786 -0.32000 0.11929 -0.13857 "
"0.20214 -0.13857 0.08286 -0.13786 0.25429 -0.13786 0.26071 -0.13143 0.07500 -0.12571 "
"0.25857 -0.12071 0.08000 -0.11929 0.11929 -0.11857 0.20214 -0.11857 0.12071 0.07571 "
"0.12643 0.10000 0.12786 0.10571 0.13214 0.12143 0.14214 0.14714 0.27286 0.15500 "
"0.25143 0.15643 0.29000 0.16214 0.23071 0.16857 0.30500 0.18286 0.16071 0.18571 "
"0.20357 0.18714 0.22357 0.18857 0.20500 0.19429 0.22214 0.20571 0.31071 0.21143 "
"0.21357 0.21571 0.22786 0.21571 0.22143 0.22357 0.22857 0.22357 0.19857 0.23357 "
"0.29571 0.24071 0.22000 0.24643 0.28000 0.24929 0.23286 0.25071 0.25714 0.25357 48 7 4 1 7 1 "
"11 1 2 11 5 11 2 6 8 0 "
"0 8 3 3 12 5 3 8 9 10 3 "
"9 3 10 12 13 11 5 12 14 13 "
"12 13 5 14 23 22 15 14 12 16 21 "
"19 16 14 21 21 14 22 23 15 17 "
"20 17 18 23 17 20 14 15 23 22 23 "
"24 24 23 25 26 25 23 26 23 27 "
"27 23 28 29 31 36 35 34 28 30 36 "
"32 30 29 36 34 40 44 34 37 40 "
"38 36 41 49 43 41 35 28 23 36 33 "
"41 49 41 33 33 36 31 47 33 39 "
"34 35 37 49 42 43 44 42 46 44 40 "
"42 46 42 48 48 42 49 45 47 39 "
"49 33 47 "
;

char *VTK_VECTOR_TEXT_103 = "114 0.367857 "
"0.22571 -0.52643 0.19143 -0.52357 0.24857 -0.52214 0.17857 -0.52071 0.16571 -0.51500 "
"0.21571 -0.50357 0.28857 -0.50357 0.23429 -0.50214 0.24714 -0.49786 0.18571 -0.49643 "
"0.14357 -0.49429 0.30286 -0.49357 0.16214 -0.48143 0.27857 -0.48071 0.13786 -0.47857 "
"0.15500 -0.46714 0.13500 -0.46571 0.33643 -0.46286 0.30357 -0.45571 0.30643 -0.44857 "
"0.15500 -0.44714 0.16071 -0.43286 0.30643 -0.43143 0.35500 -0.43143 0.14071 -0.42714 "
"0.30143 -0.42500 0.20000 -0.42357 0.17000 -0.42214 0.22143 -0.42071 0.29143 -0.42071 "
"0.14143 -0.41357 0.36071 -0.41286 0.36214 -0.40571 0.12286 -0.40500 0.11214 -0.39429 "
"0.36357 -0.39000 0.10643 -0.37571 0.10500 -0.36857 0.34429 -0.36357 0.16571 -0.36214 "
"0.15286 -0.35786 0.31714 -0.35071 0.13786 -0.34429 0.13357 -0.33429 0.10357 -0.32429 "
"0.13500 -0.31571 0.13643 -0.31143 0.11214 -0.30571 0.23714 -0.30071 0.19286 -0.29786 "
"0.15143 -0.29643 0.18143 -0.29643 0.29571 -0.29500 0.12571 -0.29214 0.13500 -0.28714 "
"0.32000 -0.28643 0.21000 -0.27500 0.24143 -0.27500 0.34143 -0.27500 0.11286 -0.27214 "
"0.19714 -0.27071 0.26000 -0.26643 0.10214 -0.26286 0.18571 -0.26357 0.17643 -0.25286 "
"0.35786 -0.25286 0.27500 -0.25143 0.36071 -0.24714 0.27786 -0.24429 0.17214 -0.24000 "
"0.08929 -0.23714 0.36643 -0.23143 0.08643 -0.22429 0.08500 -0.21429 0.36786 -0.20000 "
"0.08357 -0.18714 0.08643 -0.17286 0.35929 -0.16714 0.27786 -0.16286 0.17500 -0.15571 "
"0.09786 -0.15000 0.27214 -0.15000 0.33714 -0.14071 0.25857 -0.13786 0.19286 -0.13643 "
"0.20571 -0.13071 0.24286 -0.13071 0.12286 -0.12786 0.14429 -0.11929 0.27857 -0.11500 "
"0.18571 -0.11071 0.26000 -0.11071 0.19571 -0.10929 0.20214 -0.10714 0.21714 -0.10786 "
"0.25000 -0.08071 0.26286 -0.08071 0.21500 -0.07429 0.27714 -0.07500 0.19786 -0.06857 "
"0.23286 -0.06786 0.22000 -0.06643 0.29071 -0.06286 0.29786 -0.05143 0.30071 -0.03714 "
"0.19929 -0.02000 0.30071 -0.01143 0.29500 0.00143 0.21071 0.00286 0.28286 0.01357 "
"0.22429 0.01500 0.23714 0.01929 0.24429 0.02071 0.26000 0.02214 116 7 2 8 1 9 3 5 0 7 "
"9 4 3 0 5 1 12 10 4 2 7 "
"0 6 8 2 9 1 5 6 13 8 "
"10 12 14 11 13 6 12 4 9 14 15 "
"16 13 11 18 16 20 24 14 12 15 "
"11 17 18 18 17 19 19 23 22 16 15 "
"20 23 25 22 21 24 20 24 21 30 "
"39 26 28 29 38 41 19 17 23 21 27 "
"30 39 27 26 33 30 36 34 33 36 "
"37 36 27 30 27 36 31 32 25 31 25 "
"23 38 25 32 41 39 28 40 37 27 "
"37 43 44 37 42 43 25 38 29 29 41 "
"28 38 32 35 37 40 42 40 27 39 "
"45 47 44 45 44 43 47 45 53 56 49 "
"48 50 54 46 54 53 46 53 45 46 "
"54 63 59 68 74 78 56 54 50 56 51 "
"49 51 56 50 56 48 57 57 48 61 "
"61 52 66 63 64 59 70 69 72 48 52 "
"61 62 69 70 55 66 52 69 59 64 "
"60 54 56 68 71 74 66 55 68 68 58 "
"65 58 68 55 62 59 69 54 60 63 "
"73 72 69 68 67 71 75 73 76 68 65 "
"67 79 87 80 79 88 87 74 77 78 "
"82 78 77 79 73 69 78 82 81 79 76 "
"73 88 79 84 83 89 86 94 93 85 "
"79 80 76 86 94 85 89 83 81 88 84 "
"90 89 81 82 86 91 94 85 93 92 "
"91 86 89 85 92 90 85 90 84 97 99 "
"93 97 93 94 101 99 97 96 98 100 "
"108 112 111 110 108 111 112 107 109 112 108 "
"98 112 102 103 98 108 100 100 108 101 "
"104 112 103 95 96 100 99 101 105 106 107 "
"112 106 112 104 112 98 102 105 101 108 "
"113 112 109 "
;

char *VTK_VECTOR_TEXT_104 = "53 0.420714 "
"0.40857 -0.35786 0.08286 -0.35643 0.22143 -0.35643 0.23857 -0.35643 0.26000 -0.35643 "
"0.39714 -0.35643 0.20857 -0.35500 0.41714 -0.35500 0.14143 -0.35357 0.31571 -0.35357 "
"0.25643 -0.35000 0.07929 -0.34714 0.24357 -0.34571 0.42071 -0.34571 0.26000 -0.34357 "
"0.08571 -0.34214 0.21714 -0.33929 0.23571 -0.33929 0.39429 -0.33929 0.41286 -0.33929 "
"0.11143 -0.33643 0.28714 -0.33643 0.38214 -0.32857 0.20643 -0.32714 0.29500 -0.32714 "
"0.12214 -0.32143 0.29786 -0.31857 0.20500 -0.18714 0.29643 -0.18000 0.38071 -0.17714 "
"0.29214 -0.16571 0.20571 -0.16214 0.23143 -0.15929 0.28286 -0.15500 0.25143 -0.15071 "
"0.27286 -0.15071 0.37214 -0.15000 0.36000 -0.13643 0.23714 -0.12786 0.32714 -0.11929 "
"0.26714 -0.11786 0.12214 0.15000 0.07571 0.15071 0.07071 0.15429 0.11000 0.15500 "
"0.07214 0.17571 0.14143 0.17929 0.11571 0.18071 0.16000 0.18357 0.20500 0.18571 "
"0.08571 0.18643 0.18571 0.19214 0.19714 0.19214 51 21 14 4 8 20 1 9 21 4 13 19 7 20 "
"15 1 3 12 2 4 14 10 19 5 0 15 11 1 22 26 5 17 2 12 18 "
"5 19 19 0 7 5 26 9 25 20 8 6 2 16 21 9 24 2 17 16 6 "
"25 8 24 9 26 23 6 16 22 5 18 6 23 25 27 25 23 26 29 28 30 "
"39 33 28 36 30 29 26 22 31 32 38 46 41 48 28 29 36 32 31 27 40 "
"35 33 38 34 40 30 37 39 34 38 32 35 40 34 40 33 39 30 36 37 43 "
"42 45 44 45 42 44 47 50 41 46 44 44 50 45 48 49 51 48 41 49 49 "
"41 25 44 46 47 25 27 31 49 25 31 51 49 52 "
;

char *VTK_VECTOR_TEXT_105 = "54 0.247857 "
"0.11143 -0.36214 0.23571 -0.36214 0.09143 -0.36071 0.22571 -0.36071 0.21714 -0.35929 "
"0.20857 -0.35786 0.08429 -0.35643 0.15143 -0.35500 0.24786 -0.35286 0.08214 -0.34857 "
"0.24786 -0.34429 0.08714 -0.34214 0.24000 -0.33929 0.10857 -0.33786 0.21857 -0.33786 "
"0.11286 -0.33643 0.21214 -0.33286 0.11929 -0.33143 0.20929 -0.32714 0.12500 -0.32000 "
"0.20786 -0.32000 0.08429 -0.15643 0.12500 -0.15571 0.10000 -0.15071 0.11286 -0.15071 "
"0.07214 -0.14857 0.07357 -0.13571 0.07500 -0.13000 0.14571 -0.12643 0.11857 -0.12500 "
"0.16286 -0.12214 0.08571 -0.12071 0.20786 -0.12000 0.09571 -0.11929 0.18714 -0.11357 "
"0.20000 -0.11357 0.15000 -0.01786 0.17143 -0.01786 0.14286 -0.01643 0.13000 -0.01071 "
"0.18857 -0.01071 0.10929 0.01000 0.20929 0.01000 0.21214 0.01857 0.10071 0.04286 "
"0.21643 0.04286 0.10643 0.06143 0.21071 0.06571 0.11214 0.07429 0.19286 0.08786 "
"0.12714 0.08929 0.14143 0.09500 0.14714 0.09643 0.17571 0.09643 50 11 2 "
"0 7 15 0 6 11 9 10 3 1 "
"8 10 1 10 4 3 10 5 4 5 16 "
"7 11 0 13 11 6 2 5 12 14 "
"15 13 0 5 14 16 7 17 15 17 7 "
"19 5 10 12 19 7 18 18 7 16 "
"19 18 20 22 19 20 21 26 25 28 23 "
"24 28 22 20 33 23 29 23 27 26 "
"22 28 24 28 20 30 33 31 23 29 23 "
"28 31 27 23 23 26 21 30 32 34 "
"30 20 32 34 32 35 52 48 46 41 39 "
"46 39 38 46 44 41 46 38 36 46 "
"42 43 40 52 46 36 43 52 40 45 52 "
"43 52 36 37 40 52 37 49 52 47 "
"52 51 48 52 49 53 47 52 45 50 48 "
"51 "
;

char *VTK_VECTOR_TEXT_106 = "53 0.230714 "
"0.13000 -0.49929 0.09286 -0.49786 0.07000 -0.48786 0.16000 -0.48786 0.05214 -0.47143 "
"0.13571 -0.46357 0.18929 -0.46143 0.13929 -0.46000 0.19786 -0.44857 0.04929 -0.44571 "
"0.20500 -0.43714 0.05786 -0.42714 0.12357 -0.42286 0.21357 -0.41714 0.11429 -0.41357 "
"0.07429 -0.41214 0.08000 -0.41071 0.10286 -0.40929 0.22214 -0.38571 0.13929 -0.15571 "
"0.09286 -0.15500 0.10429 -0.15500 0.13143 -0.15214 0.11429 -0.15071 0.08643 -0.14857 "
"0.08643 -0.13571 0.15714 -0.12643 0.12714 -0.12357 0.09857 -0.12071 0.12000 -0.12071 "
"0.18143 -0.12071 0.22214 -0.12000 0.18857 -0.11786 0.20143 -0.11357 0.21429 -0.11357 "
"0.16429 -0.01929 0.18571 -0.01929 0.15714 -0.01786 0.20286 -0.01214 0.14000 -0.00929 "
"0.21643 -0.00143 0.12500 0.00571 0.22500 0.01286 0.11929 0.01714 0.23071 0.04143 "
"0.11500 0.04286 0.22643 0.05714 0.12071 0.06000 0.22071 0.07143 0.12786 0.07429 "
"0.20857 0.08500 0.15286 0.09357 0.18143 0.09643 49 0 5 1 5 4 2 4 12 9 5 2 1 3 "
"5 0 3 7 5 6 7 3 9 12 11 12 4 5 8 7 6 10 7 8 11 "
"16 15 17 16 11 17 11 14 11 12 14 13 7 10 18 7 13 23 27 29 25 "
"24 20 23 28 21 22 26 23 25 20 21 23 29 28 19 26 22 26 7 30 26 "
"19 7 27 23 26 28 25 21 31 30 7 18 31 7 30 31 32 33 31 34 32 "
"31 33 37 35 39 41 35 43 49 47 35 39 35 41 35 47 45 43 35 45 51 "
"35 52 46 40 42 44 46 42 51 49 35 52 48 50 46 38 40 46 48 38 52 "
"35 48 38 48 36 48 35 36 "
;

char *VTK_VECTOR_TEXT_107 = "74 0.419286 "
"0.23714 -0.35786 0.09286 -0.35643 0.30714 -0.35643 0.32286 -0.35643 0.41429 -0.35643 "
"0.13714 -0.35500 0.38286 -0.35500 0.21000 -0.35357 0.33000 -0.35357 0.08571 -0.35214 "
"0.14429 -0.35214 0.15429 -0.35071 0.24929 -0.34857 0.41929 -0.34857 0.08357 -0.34429 "
"0.30643 -0.34286 0.24929 -0.34000 0.41143 -0.34071 0.08714 -0.33929 0.39143 -0.33929 "
"0.38714 -0.33786 0.10286 -0.33643 0.24429 -0.33643 0.22286 -0.33500 0.11571 -0.33214 "
"0.21714 -0.33214 0.21071 -0.32286 0.12500 -0.32000 0.24500 -0.26143 0.31929 -0.25286 "
"0.21571 -0.24929 0.23429 -0.24929 0.21000 -0.24500 0.34000 -0.24357 0.20929 -0.23286 "
"0.27000 -0.23214 0.27857 -0.23071 0.29286 -0.22643 0.37214 -0.21857 0.31214 -0.21429 "
"0.38214 -0.20571 0.31786 -0.20286 0.31929 -0.19429 0.38786 -0.19143 0.38929 -0.18429 "
"0.31786 -0.18143 0.20929 -0.16857 0.39071 -0.16857 0.31214 -0.16571 0.22000 -0.16357 "
"0.29857 -0.15357 0.26429 -0.15071 0.29143 -0.15071 0.20929 -0.13714 0.37786 -0.13714 "
"0.22143 -0.13500 0.36857 -0.12786 0.25286 -0.11929 0.27857 -0.11071 0.33286 -0.11071 "
"0.28714 -0.10929 0.31857 -0.10786 0.08143 0.15357 0.12643 0.15429 0.11286 0.15929 "
"0.07357 0.16143 0.07500 0.17714 0.14857 0.18357 0.11857 0.18500 0.08429 0.18786 "
"0.20929 0.18857 0.09571 0.19071 0.17714 0.19214 0.20000 0.19643 74 18 14 9 24 10 11 5 21 "
"1 15 2 3 10 24 5 0 16 7 "
"12 16 0 9 1 21 8 15 3 6 20 "
"8 17 4 13 6 17 19 4 17 6 "
"7 25 11 18 9 21 7 16 22 15 29 "
"28 6 19 20 5 24 21 23 7 22 "
"7 23 25 24 11 27 27 53 63 27 46 "
"53 26 11 25 27 34 46 36 35 28 "
"8 20 29 15 8 29 31 28 35 29 36 "
"28 36 29 37 30 31 34 29 33 39 "
"30 34 32 27 32 34 32 27 26 37 29 "
"39 39 33 41 38 41 33 42 41 38 "
"54 45 42 40 42 38 45 54 48 43 42 "
"40 43 44 42 27 11 26 34 31 35 "
"54 42 47 42 44 47 53 46 49 50 59 "
"52 52 59 61 53 49 55 51 60 58 "
"55 51 57 48 54 56 55 49 51 57 51 "
"58 48 59 50 59 48 56 52 60 51 "
"52 61 60 67 63 53 64 69 62 65 69 "
"66 63 67 64 69 65 62 64 71 69 "
"71 64 68 67 70 72 68 64 67 67 53 "
"70 72 70 73 "
;

char *VTK_VECTOR_TEXT_108 = "25 0.255000 "
"0.24286 -0.35786 0.09143 -0.35643 0.08786 -0.35143 0.25500 -0.35143 0.09571 -0.34214 "
"0.25000 -0.34071 0.11286 -0.33929 0.22714 -0.33929 0.12143 -0.33643 0.21929 -0.33429 "
"0.12929 -0.32714 0.21500 -0.32429 0.13214 -0.32000 0.13214 0.14857 0.09429 0.14929 "
"0.08143 0.15214 0.10714 0.15500 0.11857 0.15500 0.07786 0.16714 0.13143 0.17929 "
"0.16000 0.18071 0.21500 0.18286 0.09286 0.18500 0.19000 0.19071 0.20571 0.19214 23 2 1 4 9 12 10 0 9 1 0 7 9 3 "
"5 0 6 4 1 0 5 7 9 10 8 8 6 1 9 8 1 11 12 9 13 "
"12 11 13 11 20 19 16 17 16 18 14 13 19 17 15 14 18 18 16 22 22 "
"16 19 19 13 20 20 21 23 20 11 21 24 23 21 "
;

char *VTK_VECTOR_TEXT_109 = "91 0.592143 "
"0.23286 -0.35786 0.26571 -0.35786 0.40857 -0.35786 0.44143 -0.35786 0.58429 -0.35786 "
"0.08286 -0.35643 0.28714 -0.35643 0.46143 -0.35643 0.31429 -0.35500 0.48714 -0.35500 "
"0.23929 -0.35286 0.25929 -0.35286 0.41357 -0.35286 0.43500 -0.35286 0.59214 -0.35286 "
"0.07929 -0.34714 0.41357 -0.34429 0.23929 -0.34286 0.08571 -0.34214 0.26286 -0.34214 "
"0.43857 -0.34214 0.59000 -0.34214 0.10286 -0.33929 0.40857 -0.33929 0.56714 -0.33929 "
"0.21571 -0.33786 0.23000 -0.33786 0.39000 -0.33786 0.11143 -0.33643 0.28714 -0.33643 "
"0.46143 -0.33643 0.38500 -0.33429 0.55929 -0.33429 0.20643 -0.32714 0.29500 -0.32714 "
"0.46929 -0.32714 0.38071 -0.32429 0.55500 -0.32429 0.12214 -0.32143 0.29786 -0.31857 "
"0.47214 -0.31857 0.29786 -0.19000 0.47214 -0.19000 0.20500 -0.18714 0.38214 -0.18429 "
"0.29643 -0.18000 0.47071 -0.18000 0.55500 -0.18000 0.29214 -0.16571 0.46643 -0.16571 "
"0.20571 -0.15929 0.23143 -0.15929 0.38000 -0.15786 0.40857 -0.15786 0.08286 -0.15643 "
"0.12214 -0.15571 0.07429 -0.15500 0.28286 -0.15500 0.45714 -0.15500 0.54786 -0.15286 "
"0.09857 -0.15071 0.11000 -0.15071 0.25143 -0.15071 0.27286 -0.15071 0.42571 -0.15071 "
"0.44857 -0.15071 0.06929 -0.14857 0.44143 -0.14929 0.06929 -0.13714 0.35714 -0.13786 "
"0.40286 -0.13357 0.53143 -0.13357 0.34143 -0.12929 0.23571 -0.12786 0.14000 -0.12643 "
"0.41714 -0.12500 0.07857 -0.12357 0.15857 -0.12214 0.25000 -0.12214 0.20500 -0.12000 "
"0.25571 -0.12071 0.43143 -0.12071 0.08429 -0.11929 0.26429 -0.11929 0.43857 -0.11929 "
"0.27714 -0.11786 0.45143 -0.11786 0.49571 -0.11786 0.30000 -0.11643 0.18286 -0.11357 "
"0.19857 -0.11357 89 2 27 8 19 1 29 20 7 30 12 16 2 30 7 9 25 "
"33 28 25 0 26 29 6 8 4 24 9 18 5 22 0 28 5 11 1 19 13 "
"3 20 18 15 5 1 6 29 27 2 23 24 4 21 14 21 4 0 10 26 27 "
"31 8 20 3 7 17 26 10 0 25 28 24 32 9 29 8 34 30 9 35 34 "
"8 39 35 32 40 9 32 35 33 38 28 36 39 8 22 5 28 2 16 23 36 "
"8 31 37 40 32 41 39 36 42 40 37 43 38 33 45 52 48 52 45 41 46 "
"42 47 47 42 37 46 71 49 48 88 57 49 87 58 52 53 70 67 65 87 51 "
"50 43 77 79 89 55 79 77 50 51 73 44 41 36 55 74 61 52 44 53 48 "
"52 69 79 55 38 62 73 51 48 72 88 64 70 53 60 76 68 74 60 61 57 "
"88 63 60 82 76 74 55 77 65 58 87 67 86 64 87 49 71 66 56 54 71 "
"46 47 71 47 59 63 85 62 48 69 72 62 78 73 79 38 50 75 64 81 60 "
"68 54 50 38 43 64 75 70 68 66 54 62 80 78 82 60 74 83 80 62 85 "
"83 62 84 81 64 86 84 64 67 87 86 63 88 85 44 52 41 89 79 90 "
;

char *VTK_VECTOR_TEXT_110 = "94 0.419286 "
"0.11143 -0.35786 0.23571 -0.35786 0.28714 -0.35786 0.40857 -0.35786 0.08286 -0.35643 "
"0.26429 -0.35643 0.39429 -0.35643 0.13857 -0.35500 0.20143 -0.35500 0.31429 -0.35500 "
"0.07929 -0.35286 0.24214 -0.35286 0.41786 -0.35286 0.25786 -0.35143 0.07929 -0.34714 "
"0.41929 -0.34714 0.24214 -0.34429 0.08571 -0.34214 0.26143 -0.34214 0.10286 -0.33929 "
"0.21857 -0.33929 0.23571 -0.33929 0.39429 -0.33929 0.41286 -0.33929 0.10714 -0.33786 "
"0.21429 -0.33786 0.28286 -0.33786 0.39000 -0.33786 0.11143 -0.33643 0.28857 -0.33500 "
"0.20929 -0.33286 0.11786 -0.33000 0.38214 -0.32857 0.20643 -0.32714 0.29500 -0.32714 "
"0.38071 -0.32429 0.29643 -0.32286 0.12214 -0.32143 0.20500 -0.32143 0.29786 -0.31857 "
"0.29786 -0.19000 0.20500 -0.18714 0.38071 -0.18286 0.29643 -0.18000 0.29500 -0.17429 "
"0.29357 -0.17000 0.29214 -0.16571 0.37786 -0.16571 0.20571 -0.15929 0.23143 -0.15929 "
"0.08286 -0.15643 0.12214 -0.15571 0.07429 -0.15500 0.28286 -0.15500 0.11714 -0.15357 "
"0.24286 -0.15357 0.09429 -0.15214 0.11286 -0.15214 0.24714 -0.15214 0.27714 -0.15214 "
"0.09857 -0.15071 0.11000 -0.15071 0.25143 -0.15071 0.27286 -0.15071 0.37071 -0.15000 "
"0.06929 -0.14857 0.26000 -0.14929 0.26714 -0.14929 0.06929 -0.13714 0.35429 -0.13214 "
"0.23571 -0.12786 0.12857 -0.12643 0.14000 -0.12643 0.11857 -0.12500 0.14714 -0.12500 "
"0.07857 -0.12357 0.15286 -0.12357 0.24571 -0.12357 0.11000 -0.12214 0.15857 -0.12214 "
"0.25000 -0.12214 0.16286 -0.12071 0.20500 -0.12000 0.25571 -0.12071 0.08429 -0.11929 "
"0.16714 -0.11929 0.26429 -0.11929 0.17143 -0.11786 0.27714 -0.11786 0.32143 -0.11786 "
"0.17429 -0.11643 0.17857 -0.11500 0.18286 -0.11357 0.19857 -0.11357 92 4 14 10 "
"17 4 0 7 28 0 9 29 2 13 5 "
"18 1 21 8 5 2 26 17 0 19 "
"12 22 3 6 27 9 22 6 3 17 14 "
"4 23 12 15 11 16 1 1 16 21 "
"18 5 26 6 22 27 21 20 8 23 22 "
"12 24 19 0 20 25 8 29 26 2 "
"28 24 0 34 29 9 28 7 31 30 8 "
"25 7 8 30 36 34 9 31 7 37 "
"32 9 27 39 36 9 33 37 7 37 33 "
"38 35 39 9 32 35 9 33 7 30 "
"40 39 35 41 37 38 46 89 53 43 40 "
"42 42 40 35 82 87 85 47 46 45 "
"47 45 44 47 44 43 82 90 87 66 67 "
"89 82 85 81 79 76 54 49 48 41 "
"82 81 79 76 74 54 74 72 54 72 57 "
"54 72 61 57 48 49 70 51 82 54 "
"46 69 89 80 55 58 82 51 37 83 58 "
"62 68 56 75 72 60 61 68 65 56 "
"82 79 54 46 64 69 88 62 66 67 63 "
"89 65 52 50 55 70 49 47 43 42 "
"56 65 50 70 55 77 71 60 72 82 37 "
"48 80 77 55 59 53 89 63 59 89 "
"84 56 60 73 60 71 48 37 41 84 75 "
"56 78 60 73 83 80 58 84 60 78 "
"86 83 62 88 86 62 88 66 89 91 90 "
"82 46 47 64 92 91 82 92 82 93 "
;

char *VTK_VECTOR_TEXT_111 = "126 0.367857 "
"0.21143 -0.35786 0.24143 -0.35786 0.21000 -0.35643 0.19857 -0.35500 0.26000 -0.35500 "
"0.19143 -0.35357 0.18571 -0.35214 0.26714 -0.35214 0.27143 -0.35214 0.18000 -0.35071 "
"0.17571 -0.34929 0.27714 -0.34929 0.17143 -0.34786 0.16714 -0.34643 0.28429 -0.34643 "
"0.15857 -0.34214 0.21286 -0.34214 0.23857 -0.34214 0.24286 -0.34071 0.15286 -0.33929 "
"0.20286 -0.33929 0.24714 -0.33929 0.14714 -0.33643 0.30429 -0.33643 0.14286 -0.33357 "
"0.25857 -0.33357 0.30857 -0.33357 0.13857 -0.33071 0.31286 -0.33071 0.18571 -0.32929 "
"0.13286 -0.32643 0.31857 -0.32643 0.12571 -0.32071 0.27357 -0.31857 0.17357 -0.31714 "
"0.32857 -0.31786 0.27643 -0.31429 0.17071 -0.31286 0.27929 -0.30857 0.33929 -0.30857 "
"0.16643 -0.30429 0.28071 -0.30429 0.10500 -0.30000 0.16500 -0.30000 0.34500 -0.30000 "
"0.28214 -0.29857 0.34929 -0.29571 0.10214 -0.29429 0.16357 -0.29429 0.09929 -0.29143 "
"0.35071 -0.29143 0.28357 -0.28857 0.35357 -0.28857 0.09786 -0.28714 0.35500 -0.28429 "
"0.09357 -0.27857 0.35786 -0.27857 0.09214 -0.27429 0.35929 -0.27429 0.09071 -0.27000 "
"0.08929 -0.26571 0.36214 -0.26571 0.08786 -0.26000 0.36357 -0.26000 0.08643 -0.25286 "
"0.36500 -0.25286 0.08500 -0.24286 0.36643 -0.24286 0.36786 -0.22000 0.08357 -0.21857 "
"0.36500 -0.20857 0.08643 -0.20714 0.36357 -0.19714 0.08786 -0.19571 0.36071 -0.19143 "
"0.09071 -0.19000 0.28357 -0.18857 0.35929 -0.18714 0.16357 -0.17429 0.28214 -0.17429 "
"0.35214 -0.17000 0.28071 -0.16857 0.16500 -0.16714 0.27929 -0.16429 0.16643 -0.16286 "
"0.10500 -0.16143 0.34214 -0.15571 0.17071 -0.15429 0.27357 -0.15286 0.27071 -0.14857 "
"0.18143 -0.14071 0.13143 -0.13500 0.18857 -0.13500 0.25714 -0.13500 0.25429 -0.13357 "
"0.31857 -0.13357 0.13714 -0.13214 0.19286 -0.13214 0.25000 -0.13071 0.19857 -0.12929 "
"0.24714 -0.12929 0.20286 -0.12786 0.24286 -0.12786 0.14429 -0.12643 0.20714 -0.12643 "
"0.23857 -0.12643 0.14857 -0.12500 0.21286 -0.12500 0.23286 -0.12500 0.15143 -0.12214 "
"0.15571 -0.12071 0.15857 -0.11929 0.16286 -0.11786 0.16571 -0.11643 0.17000 -0.11500 "
"0.17429 -0.11357 0.17857 -0.11214 0.27286 -0.11214 0.27714 -0.11214 0.18286 -0.11071 "
"0.19000 -0.10929 0.26714 -0.10929 0.19714 -0.10786 0.20857 -0.10643 0.21000 -0.10500 "
"0.24143 -0.10500 126 "
"4 18 1 4 7 25 25 7 8 16 0 "
"17 11 25 8 17 0 1 25 11 14 "
"23 33 14 0 16 2 13 34 15 6 5 "
"29 9 6 29 10 9 29 20 2 16 "
"2 20 3 20 5 3 18 17 1 23 36 "
"33 21 4 25 4 21 18 25 14 33 "
"38 23 26 12 10 29 29 5 20 13 12 "
"34 44 51 39 41 26 28 41 28 31 "
"34 12 29 34 19 15 19 34 22 36 23 "
"38 34 27 24 34 24 22 41 38 26 "
"34 30 27 40 47 42 34 37 30 45 41 "
"31 32 40 42 32 30 40 40 30 37 "
"45 35 51 49 47 53 51 35 39 63 65 "
"51 53 43 48 50 51 44 65 67 51 "
"47 40 43 47 43 53 53 48 55 64 62 "
"48 59 57 48 57 55 48 60 59 48 "
"54 50 52 45 31 35 56 51 54 62 60 "
"48 56 58 51 61 51 58 61 63 51 "
"66 64 48 50 44 46 54 51 50 68 51 "
"67 76 51 70 69 66 48 69 48 71 "
"71 75 73 70 51 68 79 76 74 71 48 "
"75 74 76 70 72 74 70 81 79 77 "
"75 48 78 79 74 77 75 78 85 81 77 "
"80 86 83 81 83 95 88 95 89 88 "
"82 84 91 87 91 84 78 82 91 85 78 "
"91 96 87 103 86 81 80 83 86 95 "
"96 91 87 97 116 92 87 106 103 117 98 "
"94 92 116 90 123 99 101 117 102 100 "
"110 106 87 99 120 97 123 104 107 117 100 "
"98 123 101 104 117 105 102 109 106 110 "
"117 94 93 117 108 105 111 110 90 112 111 "
"90 90 110 87 114 113 90 113 112 90 "
"117 93 89 115 114 90 116 115 90 118 117 "
"89 119 116 97 118 89 95 120 119 97 "
"108 117 121 122 120 99 125 107 108 122 99 "
"123 125 108 121 123 107 124 124 107 125 "
;

char *VTK_VECTOR_TEXT_112 = "100 0.393571 "
"0.10429 -0.52786 0.08857 -0.52643 0.21286 -0.52500 0.23714 -0.52500 0.11429 -0.52357 "
"0.20429 -0.52357 0.19714 -0.52214 0.18857 -0.52071 0.08071 -0.51857 0.18000 -0.51929 "
"0.13429 -0.51786 0.07929 -0.51286 0.24500 -0.51286 0.24143 -0.50786 0.08714 -0.50357 "
"0.21143 -0.50357 0.20286 -0.50071 0.10000 -0.49929 0.19786 -0.49286 0.11929 -0.48857 "
"0.12214 -0.48429 0.29143 -0.35786 0.26571 -0.35643 0.25571 -0.35500 0.25000 -0.35357 "
"0.24429 -0.35214 0.31714 -0.35071 0.23571 -0.34929 0.32429 -0.34786 0.21714 -0.33929 "
"0.34143 -0.33929 0.25571 -0.33071 0.26571 -0.32929 0.23857 -0.32786 0.27429 -0.32643 "
"0.19786 -0.32429 0.28286 -0.32071 0.21286 -0.31643 0.36929 -0.31143 0.29357 -0.30857 "
"0.20214 -0.30429 0.19929 -0.29714 0.29929 -0.29714 0.19786 -0.28714 0.30357 -0.28429 "
"0.38357 -0.28429 0.30500 -0.27857 0.38643 -0.27571 0.30643 -0.27286 0.38786 -0.27000 "
"0.30786 -0.26571 0.38929 -0.26429 0.30929 -0.25714 0.39071 -0.25714 0.39214 -0.24571 "
"0.31071 -0.24143 0.39357 -0.22000 0.30929 -0.20857 0.39071 -0.20857 0.30786 -0.20000 "
"0.38929 -0.19571 0.30643 -0.19429 0.19786 -0.18857 0.30500 -0.18857 0.38500 -0.18571 "
"0.30357 -0.18286 0.38214 -0.17857 0.19929 -0.17571 0.20071 -0.17000 0.29643 -0.16429 "
"0.12214 -0.16286 0.20786 -0.15714 0.12071 -0.15571 0.29071 -0.15429 0.36643 -0.15000 "
"0.20000 -0.14643 0.11286 -0.14357 0.22571 -0.14214 0.10714 -0.14071 0.23143 -0.13929 "
"0.27571 -0.13929 0.08857 -0.13786 0.27000 -0.13643 0.24429 -0.13500 0.26429 -0.13500 "
"0.07929 -0.13000 0.34571 -0.12929 0.07786 -0.12429 0.16000 -0.12357 0.22429 -0.12357 "
"0.08286 -0.12071 0.17286 -0.11929 0.32714 -0.11786 0.24714 -0.11357 0.25286 -0.11214 "
"0.26000 -0.11071 0.19286 -0.10929 0.27143 -0.10929 0.29857 -0.10929 0.19857 -0.10500 100 2 3 13 4 17 0 4 10 19 "
"11 8 14 20 19 10 14 8 1 14 0 "
"17 15 9 7 15 5 2 15 6 5 "
"12 13 3 9 16 10 0 14 1 15 7 "
"6 9 15 16 15 2 13 17 4 19 "
"18 20 10 18 10 16 32 22 21 33 25 "
"24 32 21 34 27 33 29 25 33 27 "
"32 23 22 32 24 23 32 31 24 33 24 "
"31 34 21 36 35 20 18 36 30 39 "
"26 36 21 36 26 28 29 37 35 37 29 "
"33 30 36 28 40 35 37 38 46 44 "
"38 48 46 38 50 48 45 52 50 20 35 "
"41 42 38 44 41 35 40 20 41 43 "
"39 38 42 52 47 49 47 52 45 38 39 "
"30 45 50 38 55 52 51 52 49 51 "
"55 51 53 55 56 57 55 54 56 55 53 "
"54 58 63 61 58 61 59 58 59 57 "
"65 63 58 65 66 69 20 62 70 62 20 "
"43 58 57 56 65 58 60 62 67 70 "
"64 65 60 67 68 70 65 64 66 69 66 "
"73 73 74 86 75 77 89 71 75 68 "
"68 72 70 76 88 78 92 84 82 88 72 "
"68 77 75 71 73 92 80 72 88 76 "
"74 73 66 81 90 85 80 92 82 83 89 "
"79 87 85 90 79 89 77 88 68 75 "
"90 81 78 88 75 91 89 83 93 90 78 "
"88 91 75 96 92 73 86 95 94 83 "
"94 93 83 83 84 98 97 95 83 97 83 "
"98 98 84 92 99 96 75 "
;

char *VTK_VECTOR_TEXT_113 = "64 0.420714 "
"0.22857 -0.52357 0.25143 -0.52357 0.41714 -0.52214 0.22357 -0.52000 0.26429 -0.52071 "
"0.27571 -0.51929 0.42071 -0.51857 0.29000 -0.51786 0.23571 -0.50071 0.41000 -0.50071 "
"0.26000 -0.49643 0.37286 -0.49357 0.27214 -0.48429 0.27643 -0.47429 0.35500 -0.47429 "
"0.20143 -0.35786 0.18429 -0.35643 0.17571 -0.35500 0.15857 -0.35071 0.23286 -0.35071 "
"0.14571 -0.34500 0.13286 -0.33643 0.26000 -0.33357 0.21286 -0.32786 0.27643 -0.32714 "
"0.24000 -0.32643 0.19429 -0.32214 0.25286 -0.32071 0.11071 -0.31571 0.18286 -0.31500 "
"0.26929 -0.30571 0.17214 -0.30286 0.16929 -0.29429 0.27500 -0.29429 0.09214 -0.28429 "
"0.08500 -0.26143 0.08214 -0.24143 0.08214 -0.21143 0.08500 -0.20286 0.08929 -0.18714 "
"0.09357 -0.17714 0.16929 -0.17429 0.27500 -0.17000 0.27214 -0.16286 0.17500 -0.16143 "
"0.18857 -0.14929 0.11214 -0.14571 0.25286 -0.14500 0.20286 -0.14214 0.20857 -0.14071 "
"0.24000 -0.14071 0.27714 -0.13500 0.13286 -0.12643 0.28214 -0.12429 0.25286 -0.11643 "
"0.16286 -0.11214 0.17571 -0.10929 0.22286 -0.10786 0.31071 -0.04714 0.35643 -0.02857 "
"0.33786 0.00857 0.37643 0.02857 0.35714 0.03500 0.37000 0.03786 64 1 4 10 3 0 "
"8 2 11 7 8 1 10 4 5 10 "
"2 9 11 0 1 8 5 7 10 10 7 "
"12 9 2 6 12 7 13 14 13 7 "
"11 14 7 17 26 18 26 16 15 26 20 "
"18 26 17 16 26 21 20 22 25 19 "
"23 19 25 19 23 15 24 13 14 25 22 "
"27 28 32 34 26 15 23 24 30 27 "
"29 21 26 24 14 33 30 24 33 31 21 "
"29 24 27 22 34 32 35 32 21 31 "
"33 14 42 35 32 36 28 21 32 32 38 "
"37 36 32 37 38 32 39 39 32 40 "
"41 40 32 42 51 43 40 41 46 43 51 "
"47 47 51 50 52 44 55 14 51 42 "
"51 14 53 44 52 46 44 46 41 56 48 "
"57 59 60 58 55 45 56 50 57 49 "
"54 50 51 57 48 49 56 45 48 44 45 "
"55 50 54 57 53 59 58 59 53 14 "
"60 61 62 60 59 61 62 61 63 "
;

char *VTK_VECTOR_TEXT_114 = "109 0.330714 "
"0.24000 -0.36071 0.25571 -0.36071 0.09857 -0.35929 0.23857 -0.35929 0.25786 -0.35857 "
"0.08857 -0.35786 0.10000 -0.35786 0.11143 -0.35786 0.23000 -0.35786 0.22286 -0.35643 "
"0.08500 -0.35429 0.20571 -0.35500 0.21429 -0.35500 0.25786 -0.35429 0.13000 -0.35357 "
"0.14000 -0.35357 0.19429 -0.35357 0.20429 -0.35357 0.08643 -0.35143 0.14143 -0.35214 "
"0.15571 -0.35214 0.18143 -0.35214 0.19286 -0.35214 0.15714 -0.35071 0.18000 -0.35071 "
"0.09286 -0.34357 0.24571 -0.34357 0.09714 -0.34214 0.22714 -0.34214 0.10286 -0.34071 "
"0.22143 -0.34071 0.11143 -0.33929 0.21857 -0.33929 0.11571 -0.33786 0.21214 -0.33286 "
"0.12357 -0.33000 0.21071 -0.33000 0.12500 -0.32714 0.20929 -0.32571 0.12643 -0.32429 "
"0.27571 -0.20500 0.29571 -0.20500 0.27429 -0.20357 0.27000 -0.20214 0.26714 -0.20071 "
"0.30571 -0.20071 0.30857 -0.20071 0.26429 -0.19929 0.25500 -0.19286 0.32357 -0.18857 "
"0.20929 -0.18714 0.25071 -0.18429 0.32786 -0.18143 0.21071 -0.18000 0.24929 -0.18000 "
"0.24786 -0.17857 0.21214 -0.17571 0.21357 -0.17286 0.32929 -0.17286 0.33071 -0.17143 "
"0.21500 -0.17000 0.24786 -0.16000 0.23000 -0.15500 0.12643 -0.15143 0.23429 -0.15214 "
"0.23857 -0.14929 0.32929 -0.14857 0.12500 -0.14714 0.24286 -0.14786 0.25500 -0.14714 "
"0.24714 -0.14643 0.21071 -0.14429 0.25429 -0.14500 0.12000 -0.14357 0.21357 -0.14286 "
"0.32643 -0.14286 0.10429 -0.14214 0.11571 -0.14214 0.09429 -0.14071 0.10286 -0.14071 "
"0.21500 -0.14000 0.32643 -0.14000 0.32357 -0.13714 0.08643 -0.13571 0.21786 -0.13571 "
"0.32214 -0.13429 0.08643 -0.13143 0.09143 -0.12357 0.22857 -0.12357 0.09571 -0.12071 "
"0.31000 -0.12071 0.13857 -0.11929 0.15714 -0.11929 0.23857 -0.11929 0.10857 -0.11786 "
"0.13714 -0.11786 0.15857 -0.11786 0.17000 -0.11786 0.17857 -0.11643 0.24286 -0.11643 "
"0.18571 -0.11500 0.18714 -0.11357 0.19571 -0.11357 0.21071 -0.11286 0.25571 -0.11357 "
"0.26571 -0.11357 0.19714 -0.11214 0.26714 -0.11214 0.28857 -0.11214 107 14 31 7 10 5 18 2 18 5 31 6 7 0 "
"1 26 25 18 6 2 6 18 19 14 15 23 19 20 1 13 26 1 4 13 21 "
"22 24 28 9 8 28 8 26 16 17 22 28 12 9 25 6 27 11 12 17 3 "
"0 26 8 3 26 29 27 6 31 29 6 30 12 28 33 31 14 32 12 30 33 "
"14 35 17 12 32 36 23 24 36 22 17 36 24 22 35 14 19 19 23 37 35 "
"19 37 39 37 23 39 23 38 34 36 17 34 17 32 23 36 38 42 40 41 48 "
"44 42 45 51 48 44 43 42 45 54 51 48 47 44 50 39 38 63 39 50 48 "
"42 41 45 48 41 92 77 73 75 90 54 54 61 55 56 102 53 61 54 69 67 "
"63 50 49 58 54 105 70 72 71 57 60 71 56 57 90 69 54 58 49 52 74 "
"62 64 84 65 68 105 72 69 71 60 62 80 64 65 84 68 70 98 97 50 49 "
"45 46 97 92 50 49 54 45 92 67 50 80 74 64 67 92 73 84 80 65 66 "
"58 59 82 75 81 89 79 94 76 77 79 88 84 70 78 86 83 75 54 58 88 "
"70 93 78 87 86 66 75 58 78 79 87 75 82 90 89 87 79 79 77 94 94 "
"77 95 91 77 92 95 77 91 92 97 96 99 93 70 100 98 50 102 100 50 99 "
"70 104 71 62 74 100 102 101 56 71 102 70 105 104 105 69 90 102 50 53 82 "
"85 90 105 108 107 102 103 106 103 102 71 108 105 90 "
;

char *VTK_VECTOR_TEXT_115 = "191 0.307857 "
"0.18429 -0.35929 0.20571 -0.35929 0.17286 -0.35786 0.18286 -0.35786 0.20714 -0.35786 "
"0.21571 -0.35786 0.17143 -0.35643 0.16286 -0.35500 0.15714 -0.35357 0.15143 -0.35214 "
"0.14714 -0.35071 0.14286 -0.34929 0.24571 -0.34929 0.13857 -0.34786 0.13429 -0.34643 "
"0.25000 -0.34643 0.13143 -0.34500 0.25286 -0.34500 0.25571 -0.34500 0.12714 -0.34357 "
"0.20714 -0.34357 0.12429 -0.34214 0.18857 -0.34214 0.20857 -0.34214 0.22000 -0.34214 "
"0.25857 -0.34214 0.12143 -0.34071 0.17857 -0.34071 0.18714 -0.34071 0.22571 -0.34071 "
"0.26143 -0.34071 0.11857 -0.33929 0.16857 -0.33929 0.17714 -0.33929 0.23000 -0.33929 "
"0.26429 -0.33929 0.15857 -0.33786 0.16714 -0.33786 0.23429 -0.33786 0.11429 -0.33643 "
"0.15071 -0.33571 0.23714 -0.33643 0.26857 -0.33643 0.11000 -0.33357 0.27286 -0.33357 "
"0.27857 -0.32929 0.24643 -0.32714 0.24786 -0.32429 0.16357 -0.32286 0.24929 -0.32143 "
"0.09357 -0.31857 0.16500 -0.31714 0.25071 -0.31571 0.09214 -0.31429 0.29643 -0.31143 "
"0.08929 -0.31000 0.16643 -0.31000 0.16786 -0.30857 0.29786 -0.30714 0.29929 -0.30429 "
"0.30071 -0.30143 0.30214 -0.29857 0.25071 -0.29714 0.08929 -0.29429 0.30357 -0.29429 "
"0.16786 -0.29143 0.24929 -0.29143 0.16643 -0.29000 0.09214 -0.28857 0.24786 -0.28857 "
"0.30500 -0.28857 0.09214 -0.28571 0.24643 -0.28571 0.16500 -0.28429 0.24357 -0.28143 "
"0.30643 -0.28000 0.30786 -0.27857 0.15714 -0.27643 0.10143 -0.27500 0.10571 -0.27357 "
"0.23571 -0.27357 0.10857 -0.27214 0.23286 -0.27214 0.11286 -0.27071 0.11857 -0.26929 "
"0.22857 -0.26929 0.12000 -0.26786 0.13714 -0.26786 0.22429 -0.26786 0.22143 -0.26643 "
"0.21857 -0.26500 0.30786 -0.26429 0.21429 -0.26357 0.21000 -0.26214 0.20714 -0.26071 "
"0.20143 -0.25929 0.19714 -0.25786 0.19143 -0.25643 0.18571 -0.25500 0.17857 -0.25357 "
"0.17000 -0.25214 0.16429 -0.25071 0.15857 -0.24929 0.15286 -0.24786 0.14857 -0.24643 "
"0.14286 -0.24500 0.14000 -0.24357 0.13571 -0.24214 0.13143 -0.24071 0.29929 -0.24000 "
"0.12857 -0.23929 0.12571 -0.23786 0.12286 -0.23643 0.12000 -0.23500 0.11714 -0.23357 "
"0.11286 -0.23071 0.28857 -0.22929 0.27571 -0.22214 0.10071 -0.21857 0.09929 -0.21286 "
"0.09786 -0.20857 0.22857 -0.20786 0.23429 -0.20786 0.22143 -0.20500 0.09643 -0.20286 "
"0.09500 -0.20143 0.18571 -0.19500 0.17571 -0.19071 0.17000 -0.18786 0.09500 -0.18571 "
"0.16571 -0.18500 0.24857 -0.18500 0.24714 -0.18357 0.27000 -0.18357 0.24143 -0.18214 "
"0.23714 -0.18071 0.23429 -0.17929 0.27714 -0.17929 0.23143 -0.17786 0.15643 -0.17571 "
"0.22857 -0.17643 0.22571 -0.17500 0.28357 -0.17429 0.09786 -0.17286 0.15500 -0.17286 "
"0.15357 -0.17000 0.28500 -0.16857 0.10071 -0.16714 0.15214 -0.16714 0.28643 -0.16714 "
"0.21643 -0.16571 0.10071 -0.16429 0.15071 -0.16143 0.21786 -0.15143 0.28643 -0.15143 "
"0.11071 -0.14714 0.15071 -0.14714 0.15214 -0.14143 0.22357 -0.14000 0.15357 -0.13857 "
"0.15500 -0.13571 0.27929 -0.13429 0.12857 -0.12929 0.16143 -0.12929 0.23500 -0.12857 "
"0.16429 -0.12786 0.23000 -0.12643 0.16857 -0.12500 0.22286 -0.12500 0.17286 -0.12357 "
"0.21429 -0.12357 0.13857 -0.12214 0.17714 -0.12214 0.20571 -0.12214 0.14286 -0.12071 "
"0.18286 -0.12071 0.19714 -0.12071 0.14571 -0.11929 0.26143 -0.11929 0.14857 -0.11786 "
"0.15143 -0.11643 0.15429 -0.11500 0.15857 -0.11357 0.16286 -0.11214 0.16714 -0.11071 "
"0.17429 -0.10929 0.18286 -0.10786 0.21571 -0.10786 0.22571 -0.10786 0.18429 -0.10643 "
"0.21429 -0.10643 189 24 4 5 4 "
"0 1 2 3 6 27 13 11 27 10 9 27 9 8 20 24 23 27 11 10 20 "
"4 24 3 0 20 0 4 20 7 27 8 7 6 27 25 17 18 6 3 20 6 "
"22 28 6 20 22 40 21 19 6 28 27 12 34 29 47 25 30 33 32 27 40 "
"26 21 40 19 16 13 27 32 12 38 34 36 13 32 40 16 14 29 24 5 12 "
"46 41 49 47 42 47 30 35 37 36 32 40 14 13 40 13 36 31 26 40 15 "
"46 12 12 41 38 47 35 42 46 17 25 12 29 5 46 15 17 49 42 44 47 "
"46 25 52 49 44 52 44 45 51 43 39 51 39 31 51 31 40 63 43 68 50 "
"43 53 53 63 55 51 56 67 63 53 43 51 68 43 54 62 52 58 72 69 54 "
"52 45 58 69 66 58 66 62 59 72 58 72 59 60 67 57 65 71 68 79 57 "
"67 56 74 70 75 48 51 40 54 58 62 71 79 78 68 51 67 74 72 60 74 "
"60 61 67 73 77 74 61 64 68 67 79 81 79 67 74 64 70 83 81 67 84 "
"83 67 122 88 85 87 84 67 122 96 94 84 87 86 122 89 88 87 67 77 122 "
"90 89 122 85 82 75 76 91 122 80 74 122 92 90 96 95 94 122 82 80 74 "
"75 91 122 93 92 122 94 93 101 100 99 109 74 91 74 116 117 74 109 116 104 "
"103 102 119 113 112 106 105 104 110 108 107 119 112 111 119 111 110 119 110 107 96 "
"121 123 115 114 119 114 113 119 122 74 117 97 96 123 98 97 123 115 119 118 119 "
"107 106 99 98 123 126 124 104 119 106 104 122 121 96 104 102 123 102 101 123 101 "
"99 123 124 120 104 120 119 104 126 104 123 127 124 126 129 124 145 124 129 125 128 "
"124 127 129 145 143 144 124 139 130 124 128 139 124 130 136 135 134 145 147 143 150 "
"140 138 144 145 124 150 136 134 150 138 136 146 154 158 154 164 158 154 161 164 137 "
"146 133 146 137 142 150 141 140 133 132 131 150 134 132 151 147 155 133 158 153 133 "
"146 158 147 145 148 147 152 155 147 148 152 149 154 146 162 156 171 157 159 171 156 "
"157 171 162 152 156 162 155 152 150 132 133 182 163 165 183 167 169 171 159 174 177 "
"174 159 167 183 165 185 169 172 177 159 160 186 172 175 188 168 166 163 177 160 164 "
"161 178 179 177 163 180 179 163 181 180 163 150 133 153 189 175 176 188 187 170 182 "
"181 163 188 170 168 183 182 165 184 183 169 184 169 185 187 173 170 185 172 186 189 "
"176 190 186 175 189 188 164 178 188 166 164 190 176 173 190 173 187 "
;

char *VTK_VECTOR_TEXT_116 = "59 0.302143 "
"0.20000 -0.36214 0.18714 -0.36071 0.18000 -0.35929 0.17429 -0.35786 0.17000 -0.35643 "
"0.16571 -0.35500 0.22571 -0.35500 0.15429 -0.34929 0.14571 -0.34357 0.25000 -0.34071 "
"0.25857 -0.33500 0.26429 -0.33071 0.12786 -0.32714 0.12357 -0.31571 0.24571 -0.31357 "
"0.25000 -0.31214 0.22857 -0.31071 0.25429 -0.31071 0.12214 -0.30857 0.22286 -0.30786 "
"0.26143 -0.30643 0.26714 -0.30214 0.29643 -0.30143 0.20929 -0.29571 0.27714 -0.29357 "
"0.30214 -0.29286 0.28143 -0.29214 0.28571 -0.28929 0.20500 -0.28714 0.30000 -0.28786 "
"0.20357 -0.28286 0.12071 -0.14857 0.07571 -0.14786 0.20429 -0.14786 0.28500 -0.14714 "
"0.07571 -0.12357 0.12071 -0.12286 0.20357 -0.12286 0.28429 -0.12357 0.20357 -0.02429 "
"0.12071 -0.02143 0.12571 -0.01929 0.20643 -0.01857 0.13000 -0.01786 0.13429 -0.01643 "
"0.13857 -0.01500 0.14286 -0.01357 0.14714 -0.01214 0.15143 -0.01071 0.20929 -0.01000 "
"0.15571 -0.00929 0.16000 -0.00786 0.16429 -0.00643 0.17000 -0.00500 0.17429 -0.00357 "
"0.18000 -0.00214 0.20429 -0.00214 0.18714 -0.00071 0.19714 0.00071 57 14 16 6 5 4 7 28 18 23 6 16 19 12 8 13 19 23 18 6 "
"19 0 7 18 8 9 14 6 15 10 11 10 14 9 18 13 8 10 15 14 17 "
"15 11 21 20 11 19 1 0 19 2 1 17 11 20 7 4 18 21 22 24 22 "
"21 11 22 26 24 19 3 2 26 22 27 25 29 27 19 4 3 19 18 4 25 "
"27 22 18 28 30 18 30 31 37 31 38 35 31 36 35 32 31 33 38 31 33 "
"31 30 34 38 33 31 37 36 39 36 37 36 39 41 40 36 41 43 41 39 44 "
"43 39 45 44 39 46 45 39 47 46 39 48 47 39 50 48 39 51 50 39 52 "
"51 39 53 52 39 54 53 39 55 54 39 57 55 39 56 58 42 58 57 42 42 "
"57 39 49 56 42 "
;

char *VTK_VECTOR_TEXT_117 = "97 0.425000 "
"0.21429 -0.36071 0.19571 -0.35929 0.30071 -0.35857 0.30571 -0.35929 0.41857 -0.35929 "
"0.18571 -0.35786 0.23000 -0.35786 0.40571 -0.35786 0.18000 -0.35643 0.31286 -0.35643 "
"0.39714 -0.35643 0.17571 -0.35500 0.31857 -0.35500 0.39000 -0.35500 0.42500 -0.35429 "
"0.17143 -0.35357 0.32571 -0.35357 0.38000 -0.35357 0.16714 -0.35214 0.33714 -0.35214 "
"0.15571 -0.34643 0.42071 -0.34429 0.26571 -0.34071 0.14286 -0.33786 0.27000 -0.33786 "
"0.41286 -0.33786 0.39429 -0.33643 0.38857 -0.33357 0.38357 -0.32714 0.38214 -0.32429 "
"0.24857 -0.32214 0.25857 -0.32071 0.38071 -0.32000 0.12357 -0.31857 0.23143 -0.31929 "
"0.26286 -0.31929 0.26714 -0.31786 0.27000 -0.31643 0.22286 -0.31500 0.12071 -0.31000 "
"0.30000 -0.31071 0.11929 -0.30429 0.20643 -0.30000 0.28786 -0.30000 0.29071 -0.29571 "
"0.20214 -0.29143 0.29500 -0.28714 0.20071 -0.28429 0.29643 -0.28286 0.29786 -0.27714 "
"0.11786 -0.14857 0.29786 -0.14857 0.11143 -0.14643 0.29143 -0.14643 0.10571 -0.14500 "
"0.28286 -0.14500 0.10000 -0.14357 0.27857 -0.14357 0.08000 -0.14214 0.09714 -0.14214 "
"0.25857 -0.14214 0.27571 -0.14214 0.25500 -0.13857 0.07500 -0.13429 0.25357 -0.13286 "
"0.25214 -0.12286 0.07500 -0.12143 0.13857 -0.12214 0.31571 -0.12214 0.11286 -0.12071 "
"0.14429 -0.12071 0.29000 -0.12071 0.32286 -0.12071 0.15000 -0.11929 0.32857 -0.11929 "
"0.08000 -0.11786 0.10143 -0.11786 0.15571 -0.11786 0.20071 -0.11714 0.25714 -0.11786 "
"0.28000 -0.11786 0.33286 -0.11786 0.16000 -0.11643 0.33714 -0.11643 0.37929 -0.11571 "
"0.16429 -0.11500 0.34143 -0.11500 0.16714 -0.11357 0.34429 -0.11357 0.17143 -0.11214 "
"0.34857 -0.11214 0.17571 -0.11071 0.19571 -0.11071 0.35286 -0.11071 0.18143 -0.10929 "
"0.36000 -0.10929 0.36429 -0.10786 95 22 "
"24 31 34 11 8 2 9 12 26 17 13 6 34 0 34 15 11 9 2 3 34 "
"8 5 17 27 19 25 10 7 24 35 31 34 5 1 34 1 0 26 13 10 7 "
"4 21 18 34 20 21 4 14 25 7 21 26 10 25 22 30 6 18 15 34 17 "
"26 27 28 2 12 28 16 19 28 12 16 22 31 30 33 42 39 34 6 30 20 "
"34 23 42 41 39 38 23 34 36 35 24 37 36 24 37 40 43 28 19 27 2 "
"32 40 2 28 29 2 29 32 42 23 38 33 23 42 40 32 43 37 24 40 44 "
"43 32 44 32 46 48 46 32 49 48 32 41 45 47 45 41 42 41 47 50 51 "
"49 32 67 50 47 50 67 52 59 56 54 67 54 52 61 55 53 61 57 55 68 "
"51 32 68 61 53 58 59 63 62 60 64 60 61 64 65 64 79 67 59 54 51 "
"68 53 70 67 47 80 64 61 72 68 32 75 66 63 59 75 63 73 70 47 80 "
"61 71 71 61 68 74 72 32 59 76 75 69 59 67 77 73 47 79 64 80 84 "
"90 88 76 59 69 84 95 93 78 82 77 85 82 78 78 77 47 84 93 90 87 "
"85 78 89 87 78 84 88 86 94 91 78 91 89 78 84 86 83 84 81 74 94 "
"78 92 84 83 81 96 95 84 84 74 32 "
;

char *VTK_VECTOR_TEXT_118 = "88 0.425000 "
"0.24714 -0.35643 0.24286 -0.35500 0.24000 -0.35357 0.23357 -0.34857 0.25786 -0.34857 "
"0.22929 -0.34143 0.26214 -0.34143 0.22500 -0.33571 0.26643 -0.33571 0.26929 -0.33143 "
"0.21929 -0.32857 0.27500 -0.32429 0.21071 -0.31143 0.28500 -0.30571 0.20643 -0.30429 "
"0.28929 -0.29857 0.29500 -0.28857 0.29929 -0.28000 0.30357 -0.27286 0.18500 -0.26143 "
"0.18357 -0.25714 0.27571 -0.25500 0.28500 -0.24714 0.17643 -0.24286 0.28929 -0.24143 "
"0.17500 -0.23857 0.29071 -0.23857 0.29643 -0.23000 0.16929 -0.22714 0.25643 -0.22571 "
"0.16786 -0.22286 0.25214 -0.21857 0.33500 -0.21714 0.24929 -0.21286 0.16214 -0.21143 "
"0.24643 -0.20857 0.16071 -0.20714 0.31214 -0.19857 0.15500 -0.19571 0.15357 -0.19143 "
"0.31643 -0.18857 0.14929 -0.18286 0.35643 -0.18286 0.14786 -0.17857 0.32071 -0.17857 "
"0.23071 -0.17714 0.23071 -0.17429 0.32357 -0.17143 0.36643 -0.16714 0.32643 -0.16429 "
"0.32786 -0.16000 0.13643 -0.15571 0.32929 -0.15571 0.33071 -0.15143 0.12714 -0.14214 "
"0.21357 -0.14143 0.12429 -0.14071 0.33071 -0.14000 0.11857 -0.13929 0.11286 -0.13786 "
"0.10714 -0.13643 0.10286 -0.13500 0.09857 -0.13357 0.21571 -0.13357 0.09286 -0.13071 "
"0.22143 -0.13071 0.22714 -0.12929 0.23143 -0.12929 0.24071 -0.12286 0.08214 -0.12143 "
"0.30929 -0.12000 0.42500 -0.11714 0.08071 -0.11571 0.24214 -0.11429 0.31071 -0.11429 "
"0.35714 -0.11357 0.38286 -0.11357 0.18286 -0.11214 0.34714 -0.11214 0.39286 -0.11214 "
"0.08429 -0.11071 0.34000 -0.11071 0.40143 -0.11071 0.41714 -0.11071 0.23571 -0.10929 "
"0.31857 -0.10786 0.33286 -0.10786 0.10857 -0.10643 86 4 2 1 5 3 4 4 3 "
"2 4 1 0 6 5 4 10 9 12 "
"5 6 7 7 8 10 7 6 8 10 8 "
"9 21 19 14 21 20 19 14 12 11 "
"9 11 12 21 18 22 17 21 16 29 28 "
"25 15 21 13 16 21 15 29 25 23 "
"21 17 18 24 22 18 13 21 11 29 30 "
"28 29 23 20 26 24 18 27 26 18 "
"21 14 11 32 37 27 29 20 21 31 30 "
"29 30 33 34 32 27 18 33 36 34 "
"33 30 31 40 37 32 36 33 35 43 45 "
"51 45 41 39 42 44 40 45 43 41 "
"42 47 44 42 40 32 49 47 42 45 39 "
"38 45 38 36 48 52 50 50 49 42 "
"45 36 35 53 52 48 48 50 42 87 64 "
"62 57 53 48 54 51 77 55 45 46 "
"87 56 54 87 58 56 87 61 60 55 51 "
"45 87 62 61 77 65 84 86 70 81 "
"69 80 72 73 84 68 80 69 64 76 57 "
"48 75 57 76 57 75 78 77 63 65 "
"87 60 59 63 77 55 86 85 70 57 81 "
"70 79 76 48 82 71 83 51 55 77 "
"84 67 68 84 65 66 57 78 81 82 79 "
"48 71 82 48 80 64 87 84 66 67 "
"74 70 85 87 54 77 87 59 58 "
;

char *VTK_VECTOR_TEXT_119 = "81 0.565000 "
"0.24714 -0.35786 0.25143 -0.35786 0.39857 -0.35786 0.39286 -0.35643 0.40929 -0.34857 "
"0.26357 -0.34429 0.23214 -0.33857 0.37786 -0.32857 0.43214 -0.30857 0.20929 -0.30000 "
"0.20071 -0.28429 0.29786 -0.26286 0.41714 -0.26071 0.26714 -0.25929 0.27286 -0.25786 "
"0.34357 -0.25571 0.40786 -0.24857 0.43214 -0.24429 0.28786 -0.24143 0.33357 -0.23714 "
"0.24786 -0.23571 0.31214 -0.23286 0.31857 -0.22643 0.32429 -0.22643 0.23500 -0.21429 "
"0.38786 -0.21286 0.30786 -0.21000 0.45357 -0.21000 0.30929 -0.19857 0.15357 -0.19143 "
"0.30643 -0.19000 0.49500 -0.18286 0.14357 -0.17286 0.21357 -0.17000 0.13643 -0.16000 "
"0.28786 -0.15429 0.48214 -0.15429 0.51357 -0.15286 0.20500 -0.14857 0.12786 -0.14714 "
"0.48500 -0.14571 0.28214 -0.14429 0.20214 -0.14000 0.35214 -0.13857 0.48643 -0.13714 "
"0.25143 -0.13500 0.35571 -0.13500 0.53143 -0.13500 0.20429 -0.13357 0.08857 -0.13214 "
"0.11286 -0.13214 0.27000 -0.13214 0.36429 -0.13214 0.10571 -0.13071 0.47714 -0.13071 "
"0.08357 -0.12857 0.47000 -0.12929 0.45286 -0.12786 0.55143 -0.12786 0.44500 -0.12571 "
"0.55857 -0.12643 0.08357 -0.12143 0.56500 -0.11857 0.39643 -0.11571 0.09000 -0.11357 "
"0.27286 -0.11357 0.44786 -0.11286 0.49571 -0.11357 0.30143 -0.11214 0.39643 -0.11143 "
"0.52429 -0.11214 0.09857 -0.11071 0.32571 -0.11071 0.53429 -0.11071 0.56286 -0.11071 "
"0.54571 -0.10929 0.14429 -0.10786 0.39000 -0.10786 0.45429 -0.10786 0.47286 -0.10786 "
"0.55714 -0.10786 81 3 2 4 0 5 6 3 4 7 7 12 15 11 "
"13 10 0 1 5 11 14 13 10 24 29 11 9 6 8 12 4 17 12 8 7 "
"4 12 19 15 16 18 14 11 11 6 5 20 10 13 26 23 28 12 16 15 27 "
"17 8 18 21 26 11 10 9 21 18 11 21 22 26 26 22 23 24 10 20 25 "
"28 23 25 19 16 25 23 19 27 31 36 43 41 35 31 27 8 33 34 32 30 "
"28 25 33 32 29 35 30 25 38 39 34 33 29 24 37 40 36 37 36 31 39 "
"76 50 40 37 44 41 68 51 39 42 76 41 72 68 67 37 47 42 39 38 72 "
"46 52 76 53 50 51 68 45 49 61 55 43 35 25 72 43 46 64 53 71 45 "
"68 48 68 65 48 57 66 59 44 67 54 67 44 37 64 61 53 57 56 66 56 "
"54 67 63 77 52 76 42 48 58 73 47 38 34 33 67 47 70 53 61 49 41 "
"43 72 66 56 78 73 70 47 77 63 69 58 75 73 60 62 74 71 53 76 76 "
"48 65 77 72 52 78 56 79 79 56 67 60 80 75 60 75 58 60 74 80 "
;

char *VTK_VECTOR_TEXT_120 = "166 0.392143 "
"0.09000 -0.35786 0.10286 -0.35786 0.18714 -0.35786 0.18143 -0.35643 0.19071 -0.35571 "
"0.25286 -0.35643 0.39000 -0.35643 0.08500 -0.35429 0.11143 -0.35500 0.17714 -0.35500 "
"0.23571 -0.35500 0.37286 -0.35500 0.39214 -0.35429 0.11857 -0.35357 0.17143 -0.35357 "
"0.27000 -0.35357 0.36714 -0.35357 0.12714 -0.35214 0.16571 -0.35214 0.23214 -0.35143 "
"0.36143 -0.35214 0.13857 -0.35071 0.15857 -0.35071 0.27714 -0.35071 0.28286 -0.35071 "
"0.35714 -0.35071 0.35143 -0.34929 0.29000 -0.34786 0.34429 -0.34786 0.23357 -0.34571 "
"0.29571 -0.34643 0.33714 -0.34643 0.08643 -0.34429 0.19071 -0.34429 0.30429 -0.34500 "
"0.32571 -0.34500 0.38786 -0.34143 0.24429 -0.33500 0.09857 -0.33357 0.24857 -0.33357 "
"0.38000 -0.33357 0.10286 -0.33214 0.18000 -0.33214 0.17571 -0.33071 0.10714 -0.32929 "
"0.12000 -0.32786 0.35714 -0.32786 0.12286 -0.32643 0.25643 -0.32571 0.16929 -0.32286 "
"0.25643 -0.32143 0.13143 -0.31929 0.25500 -0.31857 0.16929 -0.31714 0.17071 -0.31429 "
"0.17357 -0.31000 0.24929 -0.30857 0.17643 -0.30571 0.24500 -0.30143 0.24214 -0.29714 "
"0.23929 -0.29286 0.23500 -0.28714 0.22929 -0.28000 0.20429 -0.27357 0.17929 -0.27000 "
"0.21143 -0.26786 0.21714 -0.26786 0.18643 -0.26143 0.30214 -0.25857 0.19214 -0.25429 "
"0.29786 -0.25286 0.19500 -0.25000 0.29500 -0.24857 0.19643 -0.24714 0.29071 -0.24286 "
"0.19643 -0.24000 0.28786 -0.23857 0.19500 -0.23571 0.28357 -0.23286 0.28071 -0.22857 "
"0.27643 -0.22286 0.18786 -0.22143 0.18500 -0.21714 0.27214 -0.21714 0.18214 -0.21286 "
"0.26929 -0.21286 0.17929 -0.20857 0.26643 -0.20857 0.17643 -0.20429 0.26500 -0.20286 "
"0.26786 -0.19714 0.16929 -0.19571 0.27214 -0.19143 0.16643 -0.19000 0.16214 -0.18571 "
"0.27786 -0.18429 0.25143 -0.18357 0.24571 -0.18214 0.15929 -0.18000 0.25714 -0.17929 "
"0.15500 -0.17429 0.23500 -0.17143 0.15071 -0.16857 0.22786 -0.16286 0.21786 -0.15143 "
"0.31286 -0.14786 0.13000 -0.14500 0.21071 -0.14286 0.28929 -0.14286 0.12429 -0.14071 "
"0.32143 -0.14071 0.12000 -0.13929 0.29214 -0.13857 0.11571 -0.13786 0.20643 -0.13714 "
"0.32571 -0.13786 0.10857 -0.13643 0.32857 -0.13643 0.09714 -0.13500 0.33286 -0.13500 "
"0.09286 -0.13357 0.20357 -0.13286 0.33714 -0.13357 0.09000 -0.13214 0.29214 -0.13143 "
"0.34143 -0.13214 0.34571 -0.13071 0.35143 -0.12929 0.35571 -0.12929 0.20857 -0.12786 "
"0.28857 -0.12786 0.08357 -0.12571 0.21286 -0.12643 0.21714 -0.12643 0.27286 -0.12643 "
"0.26857 -0.12500 0.22214 -0.12286 0.26286 -0.12357 0.36786 -0.12286 0.22357 -0.11714 "
"0.26071 -0.11571 0.15143 -0.11500 0.16571 -0.11500 0.30286 -0.11500 0.08357 -0.11286 "
"0.17429 -0.11357 0.28571 -0.11357 0.31429 -0.11357 0.36786 -0.11286 0.13286 -0.11214 "
"0.14000 -0.11214 0.18286 -0.11214 0.32143 -0.11214 0.19000 -0.11071 0.26571 -0.11071 "
"0.27857 -0.11071 0.33143 -0.11071 0.12429 -0.10929 0.19714 -0.10929 0.34143 -0.10929 "
"0.08714 -0.10786 0.20571 -0.10786 0.21714 -0.10786 0.36143 -0.10786 0.09286 -0.10643 "
"0.10286 -0.10500 164 10 5 "
"29 32 0 1 42 22 18 19 10 29 "
"7 0 32 50 27 30 15 39 5 6 36 "
"11 42 18 14 39 37 5 27 50 24 "
"33 3 2 23 39 15 46 31 28 50 30 "
"34 36 16 11 38 32 1 46 26 25 "
"46 25 20 46 20 16 42 14 9 33 42 "
"9 46 28 26 33 2 4 33 9 3 "
"8 45 1 41 38 1 16 36 40 5 37 "
"29 46 35 31 44 41 1 36 6 12 "
"45 44 1 47 17 21 47 45 17 45 8 "
"13 45 13 17 39 23 48 46 16 40 "
"50 48 23 43 22 42 34 35 46 49 22 "
"43 21 49 51 52 34 56 51 53 54 "
"50 23 24 47 21 51 52 50 34 68 58 "
"56 49 21 22 64 51 57 51 49 53 "
"68 61 60 51 54 55 51 55 57 68 62 "
"61 68 59 58 68 34 46 68 60 59 "
"65 67 63 63 67 64 63 64 57 69 67 "
"65 97 88 86 97 86 84 68 56 34 "
"97 84 82 73 71 65 71 69 65 97 82 "
"81 88 97 91 62 68 70 62 70 72 "
"62 72 74 62 74 76 62 76 78 62 78 "
"79 97 93 91 62 79 80 73 83 85 "
"66 62 80 73 80 83 73 65 66 73 66 "
"80 97 89 96 77 89 97 87 73 85 "
"77 97 81 87 89 73 90 96 89 92 96 "
"90 89 75 73 96 92 99 101 93 97 "
"89 77 75 99 95 108 121 113 111 103 93 "
"101 95 99 92 121 111 109 93 103 98 "
"107 102 104 94 93 98 102 100 103 100 98 "
"103 104 102 103 106 121 109 112 108 110 "
"121 116 113 95 105 108 115 124 110 124 112 "
"110 156 117 119 102 121 106 114 102 107 "
"110 108 105 159 119 122 121 102 114 159 122 "
"125 159 126 127 131 123 164 144 131 164 "
"123 120 164 117 124 115 153 151 121 155 130 "
"146 143 124 117 161 132 162 116 142 141 "
"150 116 141 116 121 142 130 124 143 147 143 "
"117 159 125 126 160 144 164 150 149 116 "
"145 142 121 151 145 121 146 130 143 155 135 "
"134 130 155 134 152 147 117 154 140 137 "
"156 152 117 159 127 163 158 153 129 129 153 "
"121 135 154 137 154 135 155 159 156 119 "
"138 148 163 157 116 149 120 118 164 161 158 "
"129 161 129 132 162 133 139 127 138 163 "
"138 127 128 164 118 116 133 136 139 162 132 "
"133 165 116 157 165 164 116 "
;

char *VTK_VECTOR_TEXT_121 = "130 0.396429 "
"0.12000 -0.48214 0.14857 -0.48214 0.11143 -0.48071 0.15571 -0.47929 0.17143 -0.47500 "
"0.09643 -0.46857 0.19000 -0.46357 0.09214 -0.45857 0.09071 -0.45429 0.08929 -0.44857 "
"0.21357 -0.43714 0.22071 -0.42143 0.08929 -0.42000 0.19000 -0.41929 0.22214 -0.41714 "
"0.09214 -0.41429 0.22500 -0.41143 0.09357 -0.40857 0.22643 -0.40714 0.22786 -0.40286 "
"0.22929 -0.40000 0.10429 -0.39786 0.20500 -0.39714 0.11286 -0.39643 0.13571 -0.39643 "
"0.23071 -0.39571 0.23214 -0.39143 0.23357 -0.38714 0.23500 -0.38286 0.23643 -0.37857 "
"0.23786 -0.37286 0.21786 -0.37000 0.23929 -0.36714 0.21786 -0.36571 0.24071 -0.36143 "
"0.22071 -0.36000 0.24214 -0.35714 0.22214 -0.35286 0.24357 -0.35143 0.24500 -0.34714 "
"0.24643 -0.34286 0.22214 -0.33857 0.24786 -0.33857 0.22071 -0.33429 0.24929 -0.33286 "
"0.25071 -0.32857 0.25214 -0.32286 0.25357 -0.31857 0.25500 -0.31286 0.20643 -0.30857 "
"0.25643 -0.30857 0.25929 -0.30286 0.20071 -0.29857 0.26071 -0.29857 0.19500 -0.28857 "
"0.18929 -0.27857 0.18786 -0.27571 0.18214 -0.26571 0.17643 -0.25571 0.26857 -0.24929 "
"0.17071 -0.24571 0.26357 -0.24571 0.28786 -0.24571 0.27643 -0.23857 0.25786 -0.23714 "
"0.16500 -0.23571 0.15929 -0.22571 0.28357 -0.22429 0.15357 -0.21571 0.24643 -0.21571 "
"0.24357 -0.21143 0.30929 -0.20857 0.14786 -0.20571 0.14643 -0.20286 0.29214 -0.20286 "
"0.29357 -0.19857 0.31643 -0.19714 0.14071 -0.19286 0.13500 -0.18286 0.12929 -0.17286 "
"0.22071 -0.16571 0.12357 -0.16286 0.34071 -0.16286 0.21786 -0.16143 0.30643 -0.15429 "
"0.11786 -0.15286 0.21071 -0.14714 0.20786 -0.14000 0.11071 -0.13857 0.30643 -0.13429 "
"0.37143 -0.13214 0.20643 -0.13000 0.10286 -0.12786 0.38000 -0.12786 0.07571 -0.12643 "
"0.10000 -0.12643 0.29571 -0.12643 0.21143 -0.12500 0.22429 -0.12500 0.28571 -0.12500 "
"0.39143 -0.12357 0.06929 -0.12000 0.27929 -0.12000 0.22929 -0.11857 0.39643 -0.11714 "
"0.27929 -0.11571 0.06929 -0.11286 0.15571 -0.11357 0.39643 -0.11286 0.17000 -0.11214 "
"0.31429 -0.11214 0.34286 -0.11214 0.11143 -0.11071 0.18000 -0.11071 0.22929 -0.11000 "
"0.35000 -0.11071 0.18714 -0.10929 0.28571 -0.10929 0.30286 -0.10929 0.35714 -0.10929 "
"0.19429 -0.10786 0.36857 -0.10786 0.07571 -0.10643 0.09286 -0.10643 0.20143 -0.10643 "
"0.38000 -0.10643 0.39143 -0.10643 0.21000 -0.10500 0.22286 -0.10500 0.38571 -0.10500 128 3 9 8 1 5 0 2 0 "
"5 3 8 7 5 3 7 24 9 4 "
"4 6 13 23 15 12 23 9 24 17 23 "
"21 4 9 3 10 13 6 13 14 22 "
"13 11 14 23 17 15 11 13 10 1 3 "
"5 14 16 22 16 18 22 22 26 31 "
"9 23 12 24 4 13 22 19 20 22 20 "
"25 22 18 19 26 27 31 22 25 26 "
"27 28 31 28 29 31 29 30 31 33 32 "
"35 31 30 32 33 31 32 37 35 36 "
"35 32 34 35 34 36 41 37 39 37 36 "
"38 37 38 39 43 41 40 43 46 49 "
"41 39 40 43 40 42 43 42 44 43 44 "
"45 43 45 46 52 48 54 49 47 52 "
"49 46 47 52 47 48 54 48 55 51 55 "
"50 56 55 51 55 48 50 51 53 58 "
"56 51 57 57 51 58 73 72 70 77 73 "
"70 78 77 70 59 61 53 62 63 59 "
"79 78 70 69 58 64 69 60 58 67 63 "
"62 62 59 53 64 58 61 71 74 67 "
"72 68 70 61 58 53 69 70 60 71 67 "
"62 81 79 70 75 74 71 75 76 84 "
"75 71 76 65 60 70 66 65 70 68 66 "
"70 76 82 84 86 85 83 81 83 85 "
"80 83 81 85 86 88 80 81 70 88 107 "
"92 90 110 89 90 111 110 95 92 107 "
"89 84 82 90 115 111 106 101 94 89 110 "
"96 93 121 90 86 87 107 88 86 107 "
"99 105 102 96 117 99 97 116 91 96 110 "
"118 103 114 97 126 100 108 112 95 107 "
"91 116 113 109 107 87 113 109 87 90 89 "
"82 106 95 122 123 122 95 91 113 87 "
"96 118 117 90 121 119 123 95 112 103 97 "
"98 117 105 99 90 119 115 104 108 100 "
"100 125 93 120 116 97 124 120 97 128 97 "
"114 93 125 121 129 100 126 95 106 94 "
"124 97 127 127 97 128 129 125 100 "
;

char *VTK_VECTOR_TEXT_122 = "139 0.335000 "
"0.30429 -0.37643 0.30857 -0.37643 0.31071 -0.37143 0.29571 -0.36929 0.31214 -0.36714 "
"0.29000 -0.36500 0.28571 -0.36214 0.31357 -0.36143 0.08000 -0.35786 0.11571 -0.35786 "
"0.28000 -0.35786 0.27143 -0.35643 0.14571 -0.35500 0.25571 -0.35500 0.07786 -0.35286 "
"0.17714 -0.35357 0.31500 -0.35143 0.31643 -0.34000 0.08643 -0.33857 0.19286 -0.33643 "
"0.17714 -0.33500 0.20429 -0.33500 0.17357 -0.33286 0.21000 -0.33357 0.21714 -0.33214 "
"0.22286 -0.33071 0.22714 -0.32929 0.09643 -0.32714 0.23286 -0.32786 0.17643 -0.32571 "
"0.23714 -0.32643 0.31786 -0.32571 0.24143 -0.32500 0.24571 -0.32357 0.17929 -0.32143 "
"0.25000 -0.32214 0.25429 -0.32071 0.26000 -0.31786 0.18357 -0.31571 0.26429 -0.31643 "
"0.31929 -0.31571 0.18643 -0.31143 0.32071 -0.31000 0.19071 -0.30571 0.32214 -0.30429 "
"0.29000 -0.30357 0.11500 -0.30143 0.19643 -0.30000 0.29429 -0.30071 0.32357 -0.30000 "
"0.29857 -0.29786 0.32500 -0.29429 0.20071 -0.29286 0.32643 -0.29000 0.30786 -0.28857 "
"0.20643 -0.28571 0.30929 -0.28429 0.32786 -0.28429 0.21214 -0.28000 0.30929 -0.28000 "
"0.32929 -0.28000 0.33071 -0.27571 0.21643 -0.27286 0.33214 -0.27000 0.22214 -0.26571 "
"0.31786 -0.26143 0.22786 -0.26000 0.33500 -0.25571 0.23214 -0.25286 0.32714 -0.25357 "
"0.33286 -0.25214 0.23643 -0.24714 0.24214 -0.24143 0.24643 -0.23429 0.25214 -0.22857 "
"0.25643 -0.22143 0.08571 -0.22071 0.08857 -0.22071 0.26071 -0.21571 0.09500 -0.21429 "
"0.07786 -0.21286 0.26500 -0.21000 0.09929 -0.20714 0.10214 -0.20429 0.26929 -0.20429 "
"0.10357 -0.20000 0.27357 -0.19857 0.07786 -0.19571 0.10929 -0.19286 0.27786 -0.19286 "
"0.08071 -0.19000 0.11071 -0.18857 0.28214 -0.18714 0.08214 -0.18571 0.11357 -0.18571 "
"0.28500 -0.18286 0.11500 -0.18143 0.08357 -0.18000 0.11786 -0.17714 0.28929 -0.17714 "
"0.21786 -0.17571 0.08500 -0.17429 0.29214 -0.17286 0.08643 -0.16714 0.22357 -0.16714 "
"0.29643 -0.16714 0.12857 -0.16643 0.13286 -0.16357 0.29929 -0.16286 0.13714 -0.16071 "
"0.22786 -0.15857 0.30214 -0.15857 0.14571 -0.15643 0.30500 -0.15429 0.15286 -0.15357 "
"0.22929 -0.15286 0.15714 -0.15214 0.16143 -0.15071 0.30786 -0.15000 0.16714 -0.14929 "
"0.22429 -0.14929 0.08786 -0.14714 0.17571 -0.14786 0.21286 -0.14786 0.31071 -0.14571 "
"0.31643 -0.13857 0.31786 -0.13429 0.32071 -0.12857 0.32357 -0.11714 0.11143 -0.11357 "
"0.31714 -0.11214 0.10571 -0.11071 0.20429 -0.10929 0.28857 -0.10929 0.10214 -0.10571 "
"0.10071 -0.10286 0.08929 -0.10000 0.10071 -0.09857 0.09571 -0.08929 137 0 "
"2 3 2 0 1 6 16 10 2 4 3 11 10 16 4 7 3 14 8 18 13 "
"32 30 16 5 3 16 3 7 6 5 16 13 11 17 18 22 27 18 8 22 13 "
"19 15 11 16 17 22 15 20 20 15 19 22 12 15 12 22 9 13 28 26 13 "
"30 28 13 26 25 22 8 9 13 24 23 13 25 24 13 23 21 13 17 35 13 "
"35 33 13 33 32 13 21 19 27 22 46 36 35 17 36 17 37 39 37 17 29 "
"46 22 39 31 45 29 34 46 39 17 31 31 40 45 34 38 46 46 62 100 50 "
"42 44 48 45 40 46 52 55 50 40 42 50 48 40 46 38 41 50 44 54 46 "
"41 43 54 44 49 54 49 51 54 51 53 59 61 65 56 54 53 62 64 100 56 "
"53 57 59 56 57 59 57 60 46 55 62 59 60 61 61 63 65 69 67 70 69 "
"65 67 46 43 47 67 65 63 55 58 62 46 47 52 64 68 100 64 66 68 68 "
"71 100 71 72 100 73 74 100 76 77 80 75 78 100 80 77 79 72 73 100 74 "
"75 100 78 81 100 87 82 85 81 84 100 87 80 79 82 87 79 84 86 100 85 "
"82 83 90 87 85 97 93 85 100 89 104 88 97 85 93 90 85 89 92 104 101 "
"91 94 86 89 100 101 97 91 91 97 88 103 101 98 101 96 98 95 99 110 96 "
"101 94 110 99 102 92 95 104 121 103 107 104 95 110 115 102 105 110 102 115 115 "
"105 108 122 123 132 106 103 98 103 106 107 129 114 116 112 121 109 121 107 109 129 "
"121 112 129 116 117 124 120 118 129 119 122 129 117 119 113 120 111 115 108 120 118 "
"120 113 126 120 124 133 120 127 120 108 111 129 122 132 129 112 114 133 123 120 121 "
"134 136 131 121 129 128 130 127 132 123 133 125 126 124 133 127 130 127 120 126 136 "
"137 138 134 135 136 121 131 134 136 135 137 "
;

char *VTK_VECTOR_TEXT_123 = "41 0.297857 "
"0.26429 -0.46929 0.29000 -0.46929 0.24714 -0.46643 0.28143 -0.46643 0.23429 -0.46214 "
"0.22429 -0.45643 0.25500 -0.44429 0.20643 -0.43857 0.25071 -0.43714 0.20071 -0.42286 "
"0.24357 -0.41571 0.19643 -0.40286 0.24071 -0.23857 0.19214 -0.23000 0.18643 -0.20857 "
"0.22929 -0.20571 0.17429 -0.19500 0.21429 -0.19214 0.16286 -0.18786 0.14357 -0.18143 "
"0.18786 -0.18143 0.16143 -0.17500 0.21429 -0.17071 0.17286 -0.16786 0.18500 -0.15429 "
"0.23071 -0.15429 0.18929 -0.14429 0.19214 -0.13286 0.23786 -0.13000 0.23929 -0.12143 "
"0.19357 0.03143 0.19643 0.05143 0.24357 0.05714 0.24929 0.07429 0.20786 0.08000 "
"0.25500 0.08429 0.22429 0.09643 0.27000 0.09929 0.24429 0.10357 0.26714 0.10929 "
"0.29786 0.11000 39 1 "
"3 0 6 0 3 6 2 0 4 6 5 2 6 4 8 5 6 9 10 11 10 "
"9 7 7 5 8 10 7 8 11 12 13 12 11 10 13 15 14 15 13 12 17 "
"14 15 14 20 16 21 18 20 14 17 20 16 20 18 19 18 21 21 20 23 23 "
"20 24 24 22 26 22 24 20 26 25 27 27 29 30 25 26 22 28 27 25 27 "
"28 29 32 31 30 32 34 31 32 30 29 34 33 36 33 34 32 36 35 38 36 "
"33 35 38 35 37 40 39 37 38 37 39 "
;

char *VTK_VECTOR_TEXT_124 = "4 0.159286 "
"0.11571 -0.35786 0.15929 -0.35714 0.11571 0.10929 0.15857 0.10929 2 0 1 2 3 2 1 "
;

char *VTK_VECTOR_TEXT_125 = "37 0.316429 "
"0.20571 -0.46929 0.17429 -0.46786 0.19000 -0.46071 0.23429 -0.45929 0.20643 -0.44429 "
"0.25214 -0.44286 0.21500 -0.42429 0.25929 -0.42429 0.21786 -0.41000 0.26357 -0.40429 "
"0.21929 -0.24429 0.26786 -0.22857 0.22643 -0.21857 0.23214 -0.20571 0.27643 -0.20571 "
"0.24857 -0.19071 0.29286 -0.19071 0.27214 -0.18143 0.31643 -0.18143 0.29571 -0.17214 "
"0.24571 -0.16929 0.27929 -0.15857 0.23071 -0.15571 0.27071 -0.14286 0.22357 -0.13857 "
"0.26786 -0.13286 0.22071 -0.12571 0.26643 0.03429 0.21643 0.05429 0.21357 0.06714 "
"0.25500 0.07714 0.20786 0.08143 0.23857 0.09500 0.19000 0.09929 0.17857 0.10500 "
"0.19286 0.10929 0.16286 0.11071 35 2 0 4 1 "
"0 2 4 3 6 6 7 8 3 4 0 3 5 6 6 5 7 8 9 10 9 "
"8 7 11 12 10 9 11 10 12 11 13 15 14 17 15 13 11 16 17 14 17 "
"21 20 14 15 11 18 19 16 19 17 16 17 19 21 22 23 24 22 20 21 23 "
"22 21 24 25 26 24 23 25 26 27 28 26 25 27 29 32 31 28 30 29 31 "
"35 33 30 28 27 29 30 32 33 35 34 36 34 35 31 32 35 "
;

char *VTK_VECTOR_TEXT_126 = "70 0.429286 "
"0.10571 -0.23643 0.10929 -0.23143 0.34286 -0.22214 0.31857 -0.22071 0.31000 -0.21929 "
"0.35143 -0.21929 0.35571 -0.21929 0.30429 -0.21786 0.30000 -0.21643 0.12071 -0.21429 "
"0.29571 -0.21500 0.29143 -0.21357 0.08357 -0.21143 0.28714 -0.21214 0.28429 -0.21071 "
"0.12500 -0.20857 0.28000 -0.20929 0.27714 -0.20786 0.27286 -0.20643 0.38286 -0.20500 "
"0.12929 -0.20286 0.26429 -0.20214 0.26000 -0.20071 0.25429 -0.19786 0.25000 -0.19500 "
"0.23571 -0.18786 0.23143 -0.18643 0.22857 -0.18500 0.22429 -0.18357 0.15143 -0.18214 "
"0.22143 -0.18214 0.21714 -0.18071 0.15571 -0.17929 0.21143 -0.17929 0.32429 -0.17929 "
"0.34000 -0.17929 0.16000 -0.17786 0.20714 -0.17786 0.31857 -0.17786 0.34571 -0.17786 "
"0.41071 -0.17714 0.16429 -0.17643 0.20000 -0.17643 0.35000 -0.17643 0.16857 -0.17500 "
"0.19286 -0.17500 0.31286 -0.17500 0.35429 -0.17500 0.30571 -0.17357 0.41500 -0.17000 "
"0.36429 -0.16929 0.11214 -0.16571 0.28714 -0.16643 0.41786 -0.16571 0.37000 -0.16500 "
"0.42357 -0.15857 0.42643 -0.15143 0.42929 -0.14714 0.13571 -0.14357 0.14000 -0.14214 "
"0.39357 -0.14000 0.14857 -0.13786 0.15143 -0.13643 0.15571 -0.13500 0.16143 -0.13357 "
"0.20714 -0.13357 0.17000 -0.13214 0.39929 -0.13143 0.19000 -0.13071 0.40429 -0.12214 68 "
"0 1 12 34 24 23 22 34 23 9 12 "
"1 12 15 51 18 17 34 17 16 14 "
"34 17 14 18 34 21 14 13 11 22 21 "
"34 24 34 25 34 4 3 34 11 10 "
"34 14 11 34 8 7 34 3 2 34 7 "
"4 34 10 8 35 34 2 5 35 2 "
"39 35 5 43 39 6 52 31 30 29 32 "
"58 54 19 60 39 5 6 34 26 25 "
"54 50 19 27 26 34 28 27 34 15 20 "
"51 30 28 38 28 34 38 52 30 48 "
"48 30 38 19 43 6 19 47 43 48 38 "
"46 37 33 31 52 37 31 65 45 42 "
"47 19 50 32 59 58 29 51 20 12 9 "
"15 65 42 37 49 53 60 19 40 60 "
"65 44 45 40 49 60 51 29 58 67 56 "
"57 59 32 61 60 53 55 60 55 56 "
"62 61 32 63 62 32 66 41 44 64 63 "
"32 66 36 41 66 32 36 68 66 44 "
"68 44 65 66 64 32 65 37 52 67 57 "
"69 60 56 67 "
;


// Description:
// Construct object with no string set and backing enabled.
vtkVectorText::vtkVectorText()
{
  this->Text = NULL;

  this->Letters[33] = VTK_VECTOR_TEXT_33;
  this->Letters[34] = VTK_VECTOR_TEXT_34;
  this->Letters[35] = VTK_VECTOR_TEXT_35;
  this->Letters[36] = VTK_VECTOR_TEXT_36;
  this->Letters[37] = VTK_VECTOR_TEXT_37;
  this->Letters[38] = VTK_VECTOR_TEXT_38;
  this->Letters[39] = VTK_VECTOR_TEXT_39;
  this->Letters[40] = VTK_VECTOR_TEXT_40;
  this->Letters[41] = VTK_VECTOR_TEXT_41;
  this->Letters[42] = VTK_VECTOR_TEXT_42;
  this->Letters[43] = VTK_VECTOR_TEXT_43;
  this->Letters[44] = VTK_VECTOR_TEXT_44;
  this->Letters[45] = VTK_VECTOR_TEXT_45;
  this->Letters[46] = VTK_VECTOR_TEXT_46;
  this->Letters[47] = VTK_VECTOR_TEXT_47;
  this->Letters[48] = VTK_VECTOR_TEXT_48;
  this->Letters[49] = VTK_VECTOR_TEXT_49;
  this->Letters[50] = VTK_VECTOR_TEXT_50;
  this->Letters[51] = VTK_VECTOR_TEXT_51;
  this->Letters[52] = VTK_VECTOR_TEXT_52;
  this->Letters[53] = VTK_VECTOR_TEXT_53;
  this->Letters[54] = VTK_VECTOR_TEXT_54;
  this->Letters[55] = VTK_VECTOR_TEXT_55;
  this->Letters[56] = VTK_VECTOR_TEXT_56;
  this->Letters[57] = VTK_VECTOR_TEXT_57;
  this->Letters[58] = VTK_VECTOR_TEXT_58;
  this->Letters[59] = VTK_VECTOR_TEXT_59;
  this->Letters[60] = VTK_VECTOR_TEXT_60;
  this->Letters[61] = VTK_VECTOR_TEXT_61;
  this->Letters[62] = VTK_VECTOR_TEXT_62;
  this->Letters[63] = VTK_VECTOR_TEXT_63;
  this->Letters[64] = VTK_VECTOR_TEXT_64;
  this->Letters[65] = VTK_VECTOR_TEXT_65;
  this->Letters[66] = VTK_VECTOR_TEXT_66;
  this->Letters[67] = VTK_VECTOR_TEXT_67;
  this->Letters[68] = VTK_VECTOR_TEXT_68;
  this->Letters[69] = VTK_VECTOR_TEXT_69;
  this->Letters[70] = VTK_VECTOR_TEXT_70;
  this->Letters[71] = VTK_VECTOR_TEXT_71;
  this->Letters[72] = VTK_VECTOR_TEXT_72;
  this->Letters[73] = VTK_VECTOR_TEXT_73;
  this->Letters[74] = VTK_VECTOR_TEXT_74;
  this->Letters[75] = VTK_VECTOR_TEXT_75;
  this->Letters[76] = VTK_VECTOR_TEXT_76;
  this->Letters[77] = VTK_VECTOR_TEXT_77;
  this->Letters[78] = VTK_VECTOR_TEXT_78;
  this->Letters[79] = VTK_VECTOR_TEXT_79;
  this->Letters[80] = VTK_VECTOR_TEXT_80;
  this->Letters[81] = VTK_VECTOR_TEXT_81;
  this->Letters[82] = VTK_VECTOR_TEXT_82;
  this->Letters[83] = VTK_VECTOR_TEXT_83;
  this->Letters[84] = VTK_VECTOR_TEXT_84;
  this->Letters[85] = VTK_VECTOR_TEXT_85;
  this->Letters[86] = VTK_VECTOR_TEXT_86;
  this->Letters[87] = VTK_VECTOR_TEXT_87;
  this->Letters[88] = VTK_VECTOR_TEXT_88;
  this->Letters[89] = VTK_VECTOR_TEXT_89;
  this->Letters[90] = VTK_VECTOR_TEXT_90;
  this->Letters[91] = VTK_VECTOR_TEXT_91;
  this->Letters[92] = VTK_VECTOR_TEXT_92;
  this->Letters[93] = VTK_VECTOR_TEXT_93;
  this->Letters[94] = VTK_VECTOR_TEXT_94;
  this->Letters[95] = VTK_VECTOR_TEXT_95;
  this->Letters[96] = VTK_VECTOR_TEXT_96;
  this->Letters[97] = VTK_VECTOR_TEXT_97;
  this->Letters[98] = VTK_VECTOR_TEXT_98;
  this->Letters[99] = VTK_VECTOR_TEXT_99;
  this->Letters[100] = VTK_VECTOR_TEXT_100;
  this->Letters[101] = VTK_VECTOR_TEXT_101;
  this->Letters[102] = VTK_VECTOR_TEXT_102;
  this->Letters[103] = VTK_VECTOR_TEXT_103;
  this->Letters[104] = VTK_VECTOR_TEXT_104;
  this->Letters[105] = VTK_VECTOR_TEXT_105;
  this->Letters[106] = VTK_VECTOR_TEXT_106;
  this->Letters[107] = VTK_VECTOR_TEXT_107;
  this->Letters[108] = VTK_VECTOR_TEXT_108;
  this->Letters[109] = VTK_VECTOR_TEXT_109;
  this->Letters[110] = VTK_VECTOR_TEXT_110;
  this->Letters[111] = VTK_VECTOR_TEXT_111;
  this->Letters[112] = VTK_VECTOR_TEXT_112;
  this->Letters[113] = VTK_VECTOR_TEXT_113;
  this->Letters[114] = VTK_VECTOR_TEXT_114;
  this->Letters[115] = VTK_VECTOR_TEXT_115;
  this->Letters[116] = VTK_VECTOR_TEXT_116;
  this->Letters[117] = VTK_VECTOR_TEXT_117;
  this->Letters[118] = VTK_VECTOR_TEXT_118;
  this->Letters[119] = VTK_VECTOR_TEXT_119;
  this->Letters[120] = VTK_VECTOR_TEXT_120;
  this->Letters[121] = VTK_VECTOR_TEXT_121;
  this->Letters[122] = VTK_VECTOR_TEXT_122;
  this->Letters[123] = VTK_VECTOR_TEXT_123;
  this->Letters[124] = VTK_VECTOR_TEXT_124;
  this->Letters[125] = VTK_VECTOR_TEXT_125;
  this->Letters[126] = VTK_VECTOR_TEXT_126;
  
}

void vtkVectorText::Execute()
{
  int idx;
  vtkPolyData *output=(vtkPolyData *)this->Output;
  vtkFloatPoints *newPoints;
  vtkCellArray *newPolys;
  int ptOffset = 0;
  int aPoint, i;
  int pos = 0;
  float xpos = 0;
  float ypos = 0;
  int ptCount, triCount;
  char *aLetter;
  istream *IS;
  float width;
  float ftmp[3];
  
  // Set things up; allocate memory
  newPoints = new vtkFloatPoints();
  newPolys = new vtkCellArray;
  ftmp[2] = 0.0;
  
  // Create Text
  while (this->Text[pos])
    {
    switch (this->Text[pos])
      {
      case 32: 
	xpos += 0.4;
	break;
	
      case 10:
	ypos -= 1.0;
	xpos = 0;
	break;
	
      default:
	// if we have a valid character
	if ((this->Text[pos] > 32)&&(this->Text[pos] < 127))
	  {
	  // add the result to our output
	  aLetter = this->Letters[this->Text[pos]];
	  IS = new istrstream(aLetter,strlen(aLetter));
	  *IS >> ptCount;
	  *IS >> width;
	  for (i = 0; i < ptCount; i++)
	    {
	    *IS >> ftmp[0];
	    *IS >> ftmp[1];
	    ftmp[0] += xpos;
	    ftmp[1] += ypos;
	    newPoints->InsertNextPoint(ftmp);
	    }
	  *IS >> triCount;
	  for (i = 0; i < triCount; i++)
	    {
	    newPolys->InsertNextCell(3);
	    *IS >> aPoint; newPolys->InsertCellPoint(aPoint + ptOffset);
	    *IS >> aPoint; newPolys->InsertCellPoint(aPoint + ptOffset);
	    *IS >> aPoint; newPolys->InsertCellPoint(aPoint + ptOffset);
	    }
	  ptOffset += ptCount;
	  xpos += width;
	  // handle special characters
	  switch (idx) 
	    {
	    case 42: case 51: case 52: case 60:
	      // trans.Translate(0,8,0); break;
	    case 26: //trans.Translate(0,10,0); break;
	      break;
	    }
	  delete IS;
	  }
	break;
      }
    pos++;
    }
  
  //
  // Update ourselves and release memory
  //
  output->SetPoints(newPoints);
  newPoints->Delete();
  
  output->SetPolys(newPolys);
  newPolys->Delete();
}
  
void vtkVectorText::PrintSelf(ostream& os, vtkIndent indent)
{
  vtkPolySource::PrintSelf(os,indent);

  os << indent << "Text: " << (this->Text ? this->Text : "(none)") << "\n";
}
