# this is a tcl version of plate vibration
# get the interactor ui
source vtkInt.tcl
# First create the render master
#
vtkRenderMaster rm;

# Now create the RenderWindow, Renderer and both Actors
#
set renWin [rm MakeRenderWindow];
set ren1   [$renWin MakeRenderer];
set iren [$renWin MakeRenderWindowInteractor];

# read a vtk file
#
vtkPolyReader plate;
plate ReadFromInputStringOn;
plate SetInputString {# vtk DataFile Version 1.0
Vibrational modes of plate
ASCII

DATASET POLYDATA
POINTS 315 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 5.000000e-01 0.000000e+00 0.000000e+00
 5.000000e-01 5.000000e-01 0.000000e+00 0.000000e+00 5.000000e-01 0.000000e+00
 0.000000e+00 5.000000e-01 5.000000e-01 0.000000e+00 0.000000e+00 5.000000e-01
 5.000000e-01 0.000000e+00 5.000000e-01 0.000000e+00 5.000000e-01 1.000000e+00
 0.000000e+00 0.000000e+00 1.000000e+00 5.000000e-01 0.000000e+00 1.000000e+00
 0.000000e+00 5.000000e-01 1.500000e+00 0.000000e+00 0.000000e+00 1.500000e+00
 5.000000e-01 0.000000e+00 1.500000e+00 0.000000e+00 5.000000e-01 2.000000e+00
 0.000000e+00 0.000000e+00 2.000000e+00 5.000000e-01 0.000000e+00 2.000000e+00
 0.000000e+00 5.000000e-01 2.500000e+00 0.000000e+00 0.000000e+00 2.500000e+00
 5.000000e-01 0.000000e+00 2.500000e+00 0.000000e+00 5.000000e-01 3.000000e+00
 0.000000e+00 0.000000e+00 3.000000e+00 5.000000e-01 0.000000e+00 3.000000e+00
 0.000000e+00 5.000000e-01 3.500000e+00 0.000000e+00 0.000000e+00 3.500000e+00
 5.000000e-01 0.000000e+00 3.500000e+00 0.000000e+00 5.000000e-01 4.000000e+00
 0.000000e+00 0.000000e+00 4.000000e+00 5.000000e-01 0.000000e+00 4.000000e+00
 0.000000e+00 5.000000e-01 4.500000e+00 0.000000e+00 0.000000e+00 4.500000e+00
 5.000000e-01 0.000000e+00 4.500000e+00 0.000000e+00 5.000000e-01 5.000000e+00
 0.000000e+00 0.000000e+00 5.000000e+00 5.000000e-01 0.000000e+00 5.000000e+00
 0.000000e+00 5.000000e-01 5.500000e+00 0.000000e+00 0.000000e+00 5.500000e+00
 5.000000e-01 0.000000e+00 5.500000e+00 0.000000e+00 5.000000e-01 6.000000e+00
 0.000000e+00 0.000000e+00 6.000000e+00 5.000000e-01 0.000000e+00 6.000000e+00
 0.000000e+00 5.000000e-01 6.500000e+00 0.000000e+00 0.000000e+00 6.500000e+00
 5.000000e-01 0.000000e+00 6.500000e+00 0.000000e+00 5.000000e-01 7.000000e+00
 0.000000e+00 0.000000e+00 7.000000e+00 5.000000e-01 0.000000e+00 7.000000e+00
 0.000000e+00 5.000000e-01 7.500000e+00 0.000000e+00 0.000000e+00 7.500000e+00
 5.000000e-01 0.000000e+00 7.500000e+00 0.000000e+00 5.000000e-01 8.000000e+00
 0.000000e+00 0.000000e+00 8.000000e+00 5.000000e-01 0.000000e+00 8.000000e+00
 0.000000e+00 5.000000e-01 8.500000e+00 0.000000e+00 0.000000e+00 8.500000e+00
 5.000000e-01 0.000000e+00 8.500000e+00 0.000000e+00 5.000000e-01 9.000000e+00
 0.000000e+00 0.000000e+00 9.000000e+00 5.000000e-01 0.000000e+00 9.000000e+00
 5.000000e-01 5.000000e-01 9.000000e+00 5.000000e-01 1.000000e+00 0.000000e+00
 0.000000e+00 1.000000e+00 0.000000e+00 0.000000e+00 1.000000e+00 5.000000e-01
 5.000000e-01 1.000000e+00 5.000000e-01 0.000000e+00 1.000000e+00 1.000000e+00
 5.000000e-01 1.000000e+00 1.000000e+00 0.000000e+00 1.000000e+00 1.500000e+00
 5.000000e-01 1.000000e+00 1.500000e+00 0.000000e+00 1.000000e+00 2.000000e+00
 5.000000e-01 1.000000e+00 2.000000e+00 0.000000e+00 1.000000e+00 2.500000e+00
 5.000000e-01 1.000000e+00 2.500000e+00 0.000000e+00 1.000000e+00 3.000000e+00
 5.000000e-01 1.000000e+00 3.000000e+00 0.000000e+00 1.000000e+00 3.500000e+00
 5.000000e-01 1.000000e+00 3.500000e+00 0.000000e+00 1.000000e+00 4.000000e+00
 5.000000e-01 1.000000e+00 4.000000e+00 0.000000e+00 1.000000e+00 4.500000e+00
 5.000000e-01 1.000000e+00 4.500000e+00 0.000000e+00 1.000000e+00 5.000000e+00
 5.000000e-01 1.000000e+00 5.000000e+00 0.000000e+00 1.000000e+00 5.500000e+00
 5.000000e-01 1.000000e+00 5.500000e+00 0.000000e+00 1.000000e+00 6.000000e+00
 5.000000e-01 1.000000e+00 6.000000e+00 0.000000e+00 1.000000e+00 6.500000e+00
 5.000000e-01 1.000000e+00 6.500000e+00 0.000000e+00 1.000000e+00 7.000000e+00
 5.000000e-01 1.000000e+00 7.000000e+00 0.000000e+00 1.000000e+00 7.500000e+00
 5.000000e-01 1.000000e+00 7.500000e+00 0.000000e+00 1.000000e+00 8.000000e+00
 5.000000e-01 1.000000e+00 8.000000e+00 0.000000e+00 1.000000e+00 8.500000e+00
 5.000000e-01 1.000000e+00 8.500000e+00 0.000000e+00 1.000000e+00 9.000000e+00
 5.000000e-01 1.000000e+00 9.000000e+00 1.000000e+00 0.000000e+00 0.000000e+00
 1.000000e+00 5.000000e-01 0.000000e+00 1.000000e+00 0.000000e+00 5.000000e-01
 1.000000e+00 0.000000e+00 1.000000e+00 1.000000e+00 0.000000e+00 1.500000e+00
 1.000000e+00 0.000000e+00 2.000000e+00 1.000000e+00 0.000000e+00 2.500000e+00
 1.000000e+00 0.000000e+00 3.000000e+00 1.000000e+00 0.000000e+00 3.500000e+00
 1.000000e+00 0.000000e+00 4.000000e+00 1.000000e+00 0.000000e+00 4.500000e+00
 1.000000e+00 0.000000e+00 5.000000e+00 1.000000e+00 0.000000e+00 5.500000e+00
 1.000000e+00 0.000000e+00 6.000000e+00 1.000000e+00 0.000000e+00 6.500000e+00
 1.000000e+00 0.000000e+00 7.000000e+00 1.000000e+00 0.000000e+00 7.500000e+00
 1.000000e+00 0.000000e+00 8.000000e+00 1.000000e+00 0.000000e+00 8.500000e+00
 1.000000e+00 0.000000e+00 9.000000e+00 1.000000e+00 5.000000e-01 9.000000e+00
 1.000000e+00 1.000000e+00 0.000000e+00 1.000000e+00 1.000000e+00 5.000000e-01
 1.000000e+00 1.000000e+00 1.000000e+00 1.000000e+00 1.000000e+00 1.500000e+00
 1.000000e+00 1.000000e+00 2.000000e+00 1.000000e+00 1.000000e+00 2.500000e+00
 1.000000e+00 1.000000e+00 3.000000e+00 1.000000e+00 1.000000e+00 3.500000e+00
 1.000000e+00 1.000000e+00 4.000000e+00 1.000000e+00 1.000000e+00 4.500000e+00
 1.000000e+00 1.000000e+00 5.000000e+00 1.000000e+00 1.000000e+00 5.500000e+00
 1.000000e+00 1.000000e+00 6.000000e+00 1.000000e+00 1.000000e+00 6.500000e+00
 1.000000e+00 1.000000e+00 7.000000e+00 1.000000e+00 1.000000e+00 7.500000e+00
 1.000000e+00 1.000000e+00 8.000000e+00 1.000000e+00 1.000000e+00 8.500000e+00
 1.000000e+00 1.000000e+00 9.000000e+00 1.500000e+00 0.000000e+00 0.000000e+00
 1.500000e+00 5.000000e-01 0.000000e+00 1.500000e+00 0.000000e+00 5.000000e-01
 1.500000e+00 0.000000e+00 1.000000e+00 1.500000e+00 0.000000e+00 1.500000e+00
 1.500000e+00 0.000000e+00 2.000000e+00 1.500000e+00 0.000000e+00 2.500000e+00
 1.500000e+00 0.000000e+00 3.000000e+00 1.500000e+00 0.000000e+00 3.500000e+00
 1.500000e+00 0.000000e+00 4.000000e+00 1.500000e+00 0.000000e+00 4.500000e+00
 1.500000e+00 0.000000e+00 5.000000e+00 1.500000e+00 0.000000e+00 5.500000e+00
 1.500000e+00 0.000000e+00 6.000000e+00 1.500000e+00 0.000000e+00 6.500000e+00
 1.500000e+00 0.000000e+00 7.000000e+00 1.500000e+00 0.000000e+00 7.500000e+00
 1.500000e+00 0.000000e+00 8.000000e+00 1.500000e+00 0.000000e+00 8.500000e+00
 1.500000e+00 0.000000e+00 9.000000e+00 1.500000e+00 5.000000e-01 9.000000e+00
 1.500000e+00 1.000000e+00 0.000000e+00 1.500000e+00 1.000000e+00 5.000000e-01
 1.500000e+00 1.000000e+00 1.000000e+00 1.500000e+00 1.000000e+00 1.500000e+00
 1.500000e+00 1.000000e+00 2.000000e+00 1.500000e+00 1.000000e+00 2.500000e+00
 1.500000e+00 1.000000e+00 3.000000e+00 1.500000e+00 1.000000e+00 3.500000e+00
 1.500000e+00 1.000000e+00 4.000000e+00 1.500000e+00 1.000000e+00 4.500000e+00
 1.500000e+00 1.000000e+00 5.000000e+00 1.500000e+00 1.000000e+00 5.500000e+00
 1.500000e+00 1.000000e+00 6.000000e+00 1.500000e+00 1.000000e+00 6.500000e+00
 1.500000e+00 1.000000e+00 7.000000e+00 1.500000e+00 1.000000e+00 7.500000e+00
 1.500000e+00 1.000000e+00 8.000000e+00 1.500000e+00 1.000000e+00 8.500000e+00
 1.500000e+00 1.000000e+00 9.000000e+00 2.000000e+00 0.000000e+00 0.000000e+00
 2.000000e+00 5.000000e-01 0.000000e+00 2.000000e+00 0.000000e+00 5.000000e-01
 2.000000e+00 0.000000e+00 1.000000e+00 2.000000e+00 0.000000e+00 1.500000e+00
 2.000000e+00 0.000000e+00 2.000000e+00 2.000000e+00 0.000000e+00 2.500000e+00
 2.000000e+00 0.000000e+00 3.000000e+00 2.000000e+00 0.000000e+00 3.500000e+00
 2.000000e+00 0.000000e+00 4.000000e+00 2.000000e+00 0.000000e+00 4.500000e+00
 2.000000e+00 0.000000e+00 5.000000e+00 2.000000e+00 0.000000e+00 5.500000e+00
 2.000000e+00 0.000000e+00 6.000000e+00 2.000000e+00 0.000000e+00 6.500000e+00
 2.000000e+00 0.000000e+00 7.000000e+00 2.000000e+00 0.000000e+00 7.500000e+00
 2.000000e+00 0.000000e+00 8.000000e+00 2.000000e+00 0.000000e+00 8.500000e+00
 2.000000e+00 0.000000e+00 9.000000e+00 2.000000e+00 5.000000e-01 9.000000e+00
 2.000000e+00 1.000000e+00 0.000000e+00 2.000000e+00 1.000000e+00 5.000000e-01
 2.000000e+00 1.000000e+00 1.000000e+00 2.000000e+00 1.000000e+00 1.500000e+00
 2.000000e+00 1.000000e+00 2.000000e+00 2.000000e+00 1.000000e+00 2.500000e+00
 2.000000e+00 1.000000e+00 3.000000e+00 2.000000e+00 1.000000e+00 3.500000e+00
 2.000000e+00 1.000000e+00 4.000000e+00 2.000000e+00 1.000000e+00 4.500000e+00
 2.000000e+00 1.000000e+00 5.000000e+00 2.000000e+00 1.000000e+00 5.500000e+00
 2.000000e+00 1.000000e+00 6.000000e+00 2.000000e+00 1.000000e+00 6.500000e+00
 2.000000e+00 1.000000e+00 7.000000e+00 2.000000e+00 1.000000e+00 7.500000e+00
 2.000000e+00 1.000000e+00 8.000000e+00 2.000000e+00 1.000000e+00 8.500000e+00
 2.000000e+00 1.000000e+00 9.000000e+00 2.500000e+00 0.000000e+00 0.000000e+00
 2.500000e+00 5.000000e-01 0.000000e+00 2.500000e+00 0.000000e+00 5.000000e-01
 2.500000e+00 0.000000e+00 1.000000e+00 2.500000e+00 0.000000e+00 1.500000e+00
 2.500000e+00 0.000000e+00 2.000000e+00 2.500000e+00 0.000000e+00 2.500000e+00
 2.500000e+00 0.000000e+00 3.000000e+00 2.500000e+00 0.000000e+00 3.500000e+00
 2.500000e+00 0.000000e+00 4.000000e+00 2.500000e+00 0.000000e+00 4.500000e+00
 2.500000e+00 0.000000e+00 5.000000e+00 2.500000e+00 0.000000e+00 5.500000e+00
 2.500000e+00 0.000000e+00 6.000000e+00 2.500000e+00 0.000000e+00 6.500000e+00
 2.500000e+00 0.000000e+00 7.000000e+00 2.500000e+00 0.000000e+00 7.500000e+00
 2.500000e+00 0.000000e+00 8.000000e+00 2.500000e+00 0.000000e+00 8.500000e+00
 2.500000e+00 0.000000e+00 9.000000e+00 2.500000e+00 5.000000e-01 9.000000e+00
 2.500000e+00 1.000000e+00 0.000000e+00 2.500000e+00 1.000000e+00 5.000000e-01
 2.500000e+00 1.000000e+00 1.000000e+00 2.500000e+00 1.000000e+00 1.500000e+00
 2.500000e+00 1.000000e+00 2.000000e+00 2.500000e+00 1.000000e+00 2.500000e+00
 2.500000e+00 1.000000e+00 3.000000e+00 2.500000e+00 1.000000e+00 3.500000e+00
 2.500000e+00 1.000000e+00 4.000000e+00 2.500000e+00 1.000000e+00 4.500000e+00
 2.500000e+00 1.000000e+00 5.000000e+00 2.500000e+00 1.000000e+00 5.500000e+00
 2.500000e+00 1.000000e+00 6.000000e+00 2.500000e+00 1.000000e+00 6.500000e+00
 2.500000e+00 1.000000e+00 7.000000e+00 2.500000e+00 1.000000e+00 7.500000e+00
 2.500000e+00 1.000000e+00 8.000000e+00 2.500000e+00 1.000000e+00 8.500000e+00
 2.500000e+00 1.000000e+00 9.000000e+00 3.000000e+00 0.000000e+00 0.000000e+00
 3.000000e+00 5.000000e-01 0.000000e+00 3.000000e+00 5.000000e-01 5.000000e-01
 3.000000e+00 0.000000e+00 5.000000e-01 3.000000e+00 5.000000e-01 1.000000e+00
 3.000000e+00 0.000000e+00 1.000000e+00 3.000000e+00 5.000000e-01 1.500000e+00
 3.000000e+00 0.000000e+00 1.500000e+00 3.000000e+00 5.000000e-01 2.000000e+00
 3.000000e+00 0.000000e+00 2.000000e+00 3.000000e+00 5.000000e-01 2.500000e+00
 3.000000e+00 0.000000e+00 2.500000e+00 3.000000e+00 5.000000e-01 3.000000e+00
 3.000000e+00 0.000000e+00 3.000000e+00 3.000000e+00 5.000000e-01 3.500000e+00
 3.000000e+00 0.000000e+00 3.500000e+00 3.000000e+00 5.000000e-01 4.000000e+00
 3.000000e+00 0.000000e+00 4.000000e+00 3.000000e+00 5.000000e-01 4.500000e+00
 3.000000e+00 0.000000e+00 4.500000e+00 3.000000e+00 5.000000e-01 5.000000e+00
 3.000000e+00 0.000000e+00 5.000000e+00 3.000000e+00 5.000000e-01 5.500000e+00
 3.000000e+00 0.000000e+00 5.500000e+00 3.000000e+00 5.000000e-01 6.000000e+00
 3.000000e+00 0.000000e+00 6.000000e+00 3.000000e+00 5.000000e-01 6.500000e+00
 3.000000e+00 0.000000e+00 6.500000e+00 3.000000e+00 5.000000e-01 7.000000e+00
 3.000000e+00 0.000000e+00 7.000000e+00 3.000000e+00 5.000000e-01 7.500000e+00
 3.000000e+00 0.000000e+00 7.500000e+00 3.000000e+00 5.000000e-01 8.000000e+00
 3.000000e+00 0.000000e+00 8.000000e+00 3.000000e+00 5.000000e-01 8.500000e+00
 3.000000e+00 0.000000e+00 8.500000e+00 3.000000e+00 5.000000e-01 9.000000e+00
 3.000000e+00 0.000000e+00 9.000000e+00 3.000000e+00 1.000000e+00 0.000000e+00
 3.000000e+00 1.000000e+00 5.000000e-01 3.000000e+00 1.000000e+00 1.000000e+00
 3.000000e+00 1.000000e+00 1.500000e+00 3.000000e+00 1.000000e+00 2.000000e+00
 3.000000e+00 1.000000e+00 2.500000e+00 3.000000e+00 1.000000e+00 3.000000e+00
 3.000000e+00 1.000000e+00 3.500000e+00 3.000000e+00 1.000000e+00 4.000000e+00
 3.000000e+00 1.000000e+00 4.500000e+00 3.000000e+00 1.000000e+00 5.000000e+00
 3.000000e+00 1.000000e+00 5.500000e+00 3.000000e+00 1.000000e+00 6.000000e+00
 3.000000e+00 1.000000e+00 6.500000e+00 3.000000e+00 1.000000e+00 7.000000e+00
 3.000000e+00 1.000000e+00 7.500000e+00 3.000000e+00 1.000000e+00 8.000000e+00
 3.000000e+00 1.000000e+00 8.500000e+00 3.000000e+00 1.000000e+00 9.000000e+00

POLYGONS 312 1560
4 1 2 3 4
4 4 5 6 1
4 7 6 1 2
4 5 8 9 6
4 10 9 6 7
4 8 11 12 9
4 13 12 9 10
4 11 14 15 12
4 16 15 12 13
4 14 17 18 15
4 19 18 15 16
4 17 20 21 18
4 22 21 18 19
4 20 23 24 21
4 25 24 21 22
4 23 26 27 24
4 28 27 24 25
4 26 29 30 27
4 31 30 27 28
4 29 32 33 30
4 34 33 30 31
4 32 35 36 33
4 37 36 33 34
4 35 38 39 36
4 40 39 36 37
4 38 41 42 39
4 43 42 39 40
4 41 44 45 42
4 46 45 42 43
4 44 47 48 45
4 49 48 45 46
4 47 50 51 48
4 52 51 48 49
4 50 53 54 51
4 55 54 51 52
4 53 56 57 54
4 57 58 59 56
4 58 57 54 55
4 4 3 60 61
4 60 61 62 63
4 61 62 5 4
4 63 62 64 65
4 62 64 8 5
4 65 64 66 67
4 64 66 11 8
4 67 66 68 69
4 66 68 14 11
4 69 68 70 71
4 68 70 17 14
4 71 70 72 73
4 70 72 20 17
4 73 72 74 75
4 72 74 23 20
4 75 74 76 77
4 74 76 26 23
4 77 76 78 79
4 76 78 29 26
4 79 78 80 81
4 78 80 32 29
4 81 80 82 83
4 80 82 35 32
4 83 82 84 85
4 82 84 38 35
4 85 84 86 87
4 84 86 41 38
4 87 86 88 89
4 86 88 44 41
4 89 88 90 91
4 88 90 47 44
4 91 90 92 93
4 90 92 50 47
4 93 92 94 95
4 92 94 53 50
4 95 94 96 97
4 94 96 56 53
4 56 59 97 96
4 2 98 99 3
4 100 7 2 98
4 101 10 7 100
4 102 13 10 101
4 103 16 13 102
4 104 19 16 103
4 105 22 19 104
4 106 25 22 105
4 107 28 25 106
4 108 31 28 107
4 109 34 31 108
4 110 37 34 109
4 111 40 37 110
4 112 43 40 111
4 113 46 43 112
4 114 49 46 113
4 115 52 49 114
4 116 55 52 115
4 58 117 118 59
4 117 58 55 116
4 3 99 119 60
4 119 60 63 120
4 120 63 65 121
4 121 65 67 122
4 122 67 69 123
4 123 69 71 124
4 124 71 73 125
4 125 73 75 126
4 126 75 77 127
4 127 77 79 128
4 128 79 81 129
4 129 81 83 130
4 130 83 85 131
4 131 85 87 132
4 132 87 89 133
4 133 89 91 134
4 134 91 93 135
4 135 93 95 136
4 136 95 97 137
4 59 118 137 97
4 98 138 139 99
4 140 100 98 138
4 141 101 100 140
4 142 102 101 141
4 143 103 102 142
4 144 104 103 143
4 145 105 104 144
4 146 106 105 145
4 147 107 106 146
4 148 108 107 147
4 149 109 108 148
4 150 110 109 149
4 151 111 110 150
4 152 112 111 151
4 153 113 112 152
4 154 114 113 153
4 155 115 114 154
4 156 116 115 155
4 117 157 158 118
4 157 117 116 156
4 99 139 159 119
4 159 119 120 160
4 160 120 121 161
4 161 121 122 162
4 162 122 123 163
4 163 123 124 164
4 164 124 125 165
4 165 125 126 166
4 166 126 127 167
4 167 127 128 168
4 168 128 129 169
4 169 129 130 170
4 170 130 131 171
4 171 131 132 172
4 172 132 133 173
4 173 133 134 174
4 174 134 135 175
4 175 135 136 176
4 176 136 137 177
4 118 158 177 137
4 138 178 179 139
4 180 140 138 178
4 181 141 140 180
4 182 142 141 181
4 183 143 142 182
4 184 144 143 183
4 185 145 144 184
4 186 146 145 185
4 187 147 146 186
4 188 148 147 187
4 189 149 148 188
4 190 150 149 189
4 191 151 150 190
4 192 152 151 191
4 193 153 152 192
4 194 154 153 193
4 195 155 154 194
4 196 156 155 195
4 157 197 198 158
4 197 157 156 196
4 139 179 199 159
4 199 159 160 200
4 200 160 161 201
4 201 161 162 202
4 202 162 163 203
4 203 163 164 204
4 204 164 165 205
4 205 165 166 206
4 206 166 167 207
4 207 167 168 208
4 208 168 169 209
4 209 169 170 210
4 210 170 171 211
4 211 171 172 212
4 212 172 173 213
4 213 173 174 214
4 214 174 175 215
4 215 175 176 216
4 216 176 177 217
4 158 198 217 177
4 178 218 219 179
4 220 180 178 218
4 221 181 180 220
4 222 182 181 221
4 223 183 182 222
4 224 184 183 223
4 225 185 184 224
4 226 186 185 225
4 227 187 186 226
4 228 188 187 227
4 229 189 188 228
4 230 190 189 229
4 231 191 190 230
4 232 192 191 231
4 233 193 192 232
4 234 194 193 233
4 235 195 194 234
4 236 196 195 235
4 197 237 238 198
4 237 197 196 236
4 179 219 239 199
4 239 199 200 240
4 240 200 201 241
4 241 201 202 242
4 242 202 203 243
4 243 203 204 244
4 244 204 205 245
4 245 205 206 246
4 246 206 207 247
4 247 207 208 248
4 248 208 209 249
4 249 209 210 250
4 250 210 211 251
4 251 211 212 252
4 252 212 213 253
4 253 213 214 254
4 254 214 215 255
4 255 215 216 256
4 256 216 217 257
4 198 238 257 217
4 218 258 259 219
4 258 259 260 261
4 261 220 218 258
4 261 260 262 263
4 263 221 220 261
4 263 262 264 265
4 265 222 221 263
4 265 264 266 267
4 267 223 222 265
4 267 266 268 269
4 269 224 223 267
4 269 268 270 271
4 271 225 224 269
4 271 270 272 273
4 273 226 225 271
4 273 272 274 275
4 275 227 226 273
4 275 274 276 277
4 277 228 227 275
4 277 276 278 279
4 279 229 228 277
4 279 278 280 281
4 281 230 229 279
4 281 280 282 283
4 283 231 230 281
4 283 282 284 285
4 285 232 231 283
4 285 284 286 287
4 287 233 232 285
4 287 286 288 289
4 289 234 233 287
4 289 288 290 291
4 291 235 234 289
4 291 290 292 293
4 293 236 235 291
4 293 292 294 295
4 237 295 294 238
4 295 237 236 293
4 219 259 296 239
4 259 296 297 260
4 296 239 240 297
4 260 297 298 262
4 297 240 241 298
4 262 298 299 264
4 298 241 242 299
4 264 299 300 266
4 299 242 243 300
4 266 300 301 268
4 300 243 244 301
4 268 301 302 270
4 301 244 245 302
4 270 302 303 272
4 302 245 246 303
4 272 303 304 274
4 303 246 247 304
4 274 304 305 276
4 304 247 248 305
4 276 305 306 278
4 305 248 249 306
4 278 306 307 280
4 306 249 250 307
4 280 307 308 282
4 307 250 251 308
4 282 308 309 284
4 308 251 252 309
4 284 309 310 286
4 309 252 253 310
4 286 310 311 288
4 310 253 254 311
4 288 311 312 290
4 311 254 255 312
4 290 312 313 292
4 312 255 256 313
4 292 313 314 294
4 313 256 257 314
4 238 294 314 257

POINT_DATA 315
VECTORS mode1 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 -2.991500e-08 1.270800e-03 -3.973200e-08 5.008800e-03 3.376800e-03 9.288000e-03
 2.328300e-03 6.541400e-03 8.890100e-03 -8.646300e-08 1.484100e-02 -1.192100e-07
 6.047200e-03 1.610000e-02 1.870100e-02 3.503300e-03 2.062000e-02 1.872300e-02
 -2.226300e-07 3.808400e-02 -1.456300e-07 6.380200e-03 3.946500e-02 2.751000e-02
 3.890200e-03 4.446800e-02 2.759400e-02 -4.262400e-07 7.046700e-02 1.080000e-06
 6.255200e-03 7.165500e-02 3.565700e-02 3.961900e-03 7.669700e-02 3.572700e-02
 -1.229900e-06 1.108000e-01 -1.386100e-07 5.885200e-03 1.118700e-01 4.296900e-02
 3.803500e-03 1.166800e-01 4.303100e-02 -3.756800e-07 1.581700e-01 2.463500e-07
 5.374800e-03 1.591100e-01 4.946400e-02 3.519900e-03 1.635400e-01 4.952100e-02
 -1.192800e-06 2.116800e-01 -7.105400e-07 4.789100e-03 2.125000e-01 5.515100e-02
 3.160000e-03 2.164700e-01 5.520400e-02 -8.357800e-07 2.705000e-01 -2.532600e-06
 4.173400e-03 2.712000e-01 6.005800e-02 2.772900e-03 2.746800e-01 6.010800e-02
 -1.026800e-06 3.338200e-01 2.508200e-06 3.556800e-03 3.344200e-01 6.421300e-02
 2.371400e-03 3.373800e-01 6.426000e-02 -2.465100e-06 4.009000e-01 -2.159400e-07
 2.960500e-03 4.013800e-01 6.765500e-02 1.981900e-03 4.038600e-01 6.769800e-02
 -6.974300e-07 4.710000e-01 7.503200e-08 2.399600e-03 4.713800e-01 7.042400e-02
 1.615800e-03 4.734000e-01 7.046500e-02 -3.260700e-06 5.434700e-01 -2.071600e-06
 1.887200e-03 5.437700e-01 7.257400e-02 1.278400e-03 5.453600e-01 7.261200e-02
 -2.377600e-06 6.177100e-01 -1.123900e-05 1.425000e-03 6.179200e-01 7.417100e-02
 9.748800e-04 6.191400e-01 7.420500e-02 -4.131400e-07 6.931700e-01 -6.560800e-07
 1.015300e-03 6.933900e-01 7.527800e-02 7.146500e-04 6.942100e-01 7.530600e-02
 -3.107000e-06 7.693900e-01 6.025000e-06 7.215100e-04 7.695000e-01 7.598200e-02
 5.079100e-04 7.701300e-01 7.600300e-02 -2.481400e-06 8.460200e-01 1.554300e-06
 4.883400e-04 8.460600e-01 7.636900e-02 3.532700e-04 8.465100e-01 7.637800e-02
 -2.622100e-06 9.227800e-01 5.871800e-07 2.954700e-04 9.228700e-01 7.653900e-02
 2.688400e-04 9.230900e-01 7.655000e-02 -3.401800e-06 9.994100e-01 -2.385800e-07
 2.904600e-04 9.993900e-01 7.658200e-02 2.412000e-04 9.997200e-01 7.660400e-02
 -1.153000e-06 9.997900e-01 -1.568100e-07 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -5.008900e-03 3.376800e-03 -9.288100e-03
 -2.328400e-03 6.541400e-03 -8.890200e-03 -6.047300e-03 1.610000e-02 -1.870100e-02
 -3.503400e-03 2.062000e-02 -1.872300e-02 -6.381000e-03 3.946500e-02 -2.751000e-02
 -3.890700e-03 4.446800e-02 -2.759400e-02 -6.255500e-03 7.165400e-02 -3.565800e-02
 -3.962200e-03 7.669700e-02 -3.572800e-02 -5.881600e-03 1.118800e-01 -4.296900e-02
 -3.806000e-03 1.166800e-01 -4.303100e-02 -5.374100e-03 1.591100e-01 -4.946400e-02
 -3.519700e-03 1.635400e-01 -4.952200e-02 -4.782900e-03 2.125200e-01 -5.515200e-02
 -3.160300e-03 2.164700e-01 -5.520600e-02 -4.175100e-03 2.712000e-01 -6.005900e-02
 -2.775100e-03 2.746800e-01 -6.010900e-02 -3.558200e-03 3.344100e-01 -6.421500e-02
 -2.373700e-03 3.373800e-01 -6.426200e-02 -2.950600e-03 4.014200e-01 -6.765500e-02
 -1.984000e-03 4.038500e-01 -6.770000e-02 -2.398000e-03 4.713800e-01 -7.042600e-02
 -1.617800e-03 4.734000e-01 -7.046700e-02 -1.872500e-03 5.438100e-01 -7.258000e-02
 -1.281600e-03 5.453500e-01 -7.261500e-02 -1.431700e-03 6.179200e-01 -7.417300e-02
 -9.844600e-04 6.191400e-01 -7.420300e-02 -1.047100e-03 6.933200e-01 -7.528000e-02
 -7.296100e-04 6.942200e-01 -7.530600e-02 -7.319100e-04 7.695000e-01 -7.598200e-02
 -5.203700e-04 7.701300e-01 -7.600400e-02 -4.933700e-04 8.460600e-01 -7.636600e-02
 -3.619200e-04 8.465100e-01 -7.637500e-02 -3.013800e-04 9.228700e-01 -7.653700e-02
 -2.776500e-04 9.230900e-01 -7.654700e-02 -2.983200e-04 9.993900e-01 -7.657900e-02
 -2.527300e-04 9.997200e-01 -7.660000e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 9.272800e-04 7.678700e-03 9.612000e-03
 1.464300e-03 2.271500e-02 1.914700e-02 1.786100e-03 4.711600e-02 2.778800e-02
 1.880400e-03 7.952100e-02 3.573700e-02 1.844900e-03 1.194600e-01 4.292000e-02
 1.723800e-03 1.661300e-01 4.934000e-02 1.558700e-03 2.188200e-01 5.499400e-02
 1.375000e-03 2.767500e-01 5.988100e-02 1.175200e-03 3.391600e-01 6.402900e-02
 9.905100e-04 4.053500e-01 6.748000e-02 8.095000e-04 4.746300e-01 7.026200e-02
 6.415500e-04 5.463400e-01 7.242800e-02 4.917500e-04 6.199000e-01 7.404100e-02
 3.635300e-04 6.947800e-01 7.516800e-02 2.579400e-04 7.705300e-01 7.589300e-02
 1.658100e-04 8.467900e-01 7.632800e-02 1.332400e-04 9.233300e-01 7.653100e-02
 1.112300e-04 9.999300e-01 7.658100e-02 -6.288400e-06 1.000000e+00 4.433300e-06
 0.000000e+00 0.000000e+00 0.000000e+00 -9.273200e-04 7.678700e-03 -9.612100e-03
 -1.464500e-03 2.271500e-02 -1.914700e-02 -1.786500e-03 4.711600e-02 -2.778800e-02
 -1.881100e-03 7.952100e-02 -3.573700e-02 -1.845700e-03 1.194600e-01 -4.292100e-02
 -1.724500e-03 1.661300e-01 -4.934100e-02 -1.559900e-03 2.188200e-01 -5.499500e-02
 -1.377100e-03 2.767500e-01 -5.988300e-02 -1.178600e-03 3.391600e-01 -6.403100e-02
 -9.948401e-04 4.053500e-01 -6.748300e-02 -8.147500e-04 4.746300e-01 -7.026400e-02
 -6.492900e-04 5.463400e-01 -7.242900e-02 -5.019900e-04 6.199000e-01 -7.404000e-02
 -3.751900e-04 6.947900e-01 -7.516600e-02 -2.697700e-04 7.705300e-01 -7.589100e-02
 -1.763800e-04 8.467900e-01 -7.632400e-02 -1.415300e-04 9.233300e-01 -7.652400e-02
 -1.228600e-04 9.999300e-01 -7.657500e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -2.383000e-07 7.958600e-03 9.794400e-03
 -8.369000e-07 2.329600e-02 1.936400e-02 -3.024400e-07 4.792900e-02 2.787400e-02
 -3.614500e-06 8.041600e-02 3.574900e-02 -4.773900e-06 1.203500e-01 4.288100e-02
 -3.428400e-06 1.669800e-01 4.927300e-02 -6.407100e-06 2.195900e-01 5.491300e-02
 -1.405200e-05 2.774200e-01 5.979000e-02 -1.323800e-05 3.397400e-01 6.394400e-02
 -1.875200e-05 4.058400e-01 6.740000e-02 -2.529000e-05 4.750300e-01 7.017900e-02
 -3.221000e-05 5.466600e-01 7.235500e-02 -3.394600e-05 6.201400e-01 7.397900e-02
 -3.639300e-05 6.949600e-01 7.511900e-02 -3.682200e-05 7.706500e-01 7.584100e-02
 -3.386800e-05 8.468600e-01 7.627900e-02 -2.187100e-05 9.233800e-01 7.651100e-02
 -1.914900e-05 9.999900e-01 7.660100e-02 -7.414400e-06 9.999600e-01 5.513100e-09
 0.000000e+00 0.000000e+00 0.000000e+00 2.050300e-07 7.958600e-03 -9.794400e-03
 7.150800e-07 2.329600e-02 -1.936400e-02 6.650100e-09 4.792900e-02 -2.787400e-02
 3.149600e-06 8.041600e-02 -3.574900e-02 4.207400e-06 1.203500e-01 -4.288200e-02
 2.687400e-06 1.669800e-01 -4.927400e-02 5.132100e-06 2.195900e-01 -5.491400e-02
 1.156700e-05 2.774200e-01 -5.979200e-02 8.964600e-06 3.397400e-01 -6.394600e-02
 1.228600e-05 4.058400e-01 -6.740200e-02 1.608700e-05 4.750300e-01 -7.018100e-02
 1.989200e-05 5.466600e-01 -7.235600e-02 1.871600e-05 6.201400e-01 -7.397900e-02
 1.943800e-05 6.949600e-01 -7.511600e-02 1.999100e-05 7.706500e-01 -7.583700e-02
 1.828300e-05 8.468600e-01 -7.627300e-02 7.937200e-06 9.233900e-01 -7.650100e-02
 5.195500e-06 9.999800e-01 -7.656900e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -9.275000e-04 7.677700e-03 9.611500e-03
 -1.464800e-03 2.271400e-02 1.914700e-02 -1.787900e-03 4.711400e-02 2.778600e-02
 -1.882800e-03 7.951200e-02 3.573200e-02 -1.849400e-03 1.194500e-01 4.292200e-02
 -1.728800e-03 1.661300e-01 4.934000e-02 -1.569700e-03 2.188000e-01 5.498500e-02
 -1.386500e-03 2.767200e-01 5.987600e-02 -1.200400e-03 3.391300e-01 6.402700e-02
 -1.016300e-03 4.053200e-01 6.747100e-02 -8.571100e-04 4.745700e-01 7.025100e-02
 -7.015900e-04 5.462600e-01 7.242300e-02 -5.578500e-04 6.198300e-01 7.404000e-02
 -4.158300e-04 6.947300e-01 7.516600e-02 -3.320200e-04 7.704500e-01 7.589400e-02
 -2.362900e-04 8.467100e-01 7.634500e-02 -1.806100e-04 9.232800e-01 7.654400e-02
 -1.686100e-04 9.999000e-01 7.657700e-02 -7.126100e-06 1.000000e+00 3.894000e-06
 0.000000e+00 0.000000e+00 0.000000e+00 9.274900e-04 7.677700e-03 -9.611500e-03
 1.464700e-03 2.271400e-02 -1.914700e-02 1.787700e-03 4.711400e-02 -2.778600e-02
 1.882400e-03 7.951200e-02 -3.573300e-02 1.848800e-03 1.194500e-01 -4.292200e-02
 1.728100e-03 1.661300e-01 -4.934000e-02 1.568400e-03 2.188000e-01 -5.498600e-02
 1.383600e-03 2.767200e-01 -5.987800e-02 1.195200e-03 3.391300e-01 -6.402800e-02
 1.007400e-03 4.053200e-01 -6.747300e-02 8.442400e-04 4.745700e-01 -7.025200e-02
 6.842100e-04 5.462600e-01 -7.242300e-02 5.370500e-04 6.198300e-01 -7.403900e-02
 3.936000e-04 6.947300e-01 -7.516300e-02 3.103100e-04 7.704500e-01 -7.589000e-02
 2.155100e-04 8.467100e-01 -7.634000e-02 1.610500e-04 9.232800e-01 -7.653600e-02
 1.531800e-04 9.999000e-01 -7.656700e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -2.328100e-03 6.541100e-03 8.890000e-03
 -3.502200e-03 2.061900e-02 1.872200e-02 -3.890000e-03 4.446600e-02 2.759300e-02
 -3.958700e-03 7.669200e-02 3.572500e-02 -3.805800e-03 1.166700e-01 4.302800e-02
 -3.523500e-03 1.635300e-01 4.951700e-02 -3.160400e-03 2.164600e-01 5.520200e-02
 -2.765100e-03 2.746500e-01 6.009700e-02 -2.383300e-03 3.373500e-01 6.424900e-02
 -2.005900e-03 4.038000e-01 6.768300e-02 -1.638000e-03 4.733200e-01 7.044400e-02
 -1.283400e-03 5.452500e-01 7.260200e-02 -1.016100e-03 6.190400e-01 7.421100e-02
 -7.715500e-04 6.941100e-01 7.530200e-02 -5.469600e-04 7.700000e-01 7.599200e-02
 -3.557600e-04 8.464000e-01 7.640300e-02 -3.065800e-04 9.230200e-01 7.656600e-02
 -2.592400e-04 9.996600e-01 7.661700e-02 -9.194000e-06 9.996100e-01 1.335100e-06
 0.000000e+00 0.000000e+00 0.000000e+00 2.328100e-03 6.541000e-03 -8.890000e-03
 3.502200e-03 2.061900e-02 -1.872200e-02 3.889900e-03 4.446600e-02 -2.759300e-02
 3.958400e-03 7.669200e-02 -3.572500e-02 3.804000e-03 1.166700e-01 -4.302800e-02
 3.522900e-03 1.635300e-01 -4.951600e-02 3.158700e-03 2.164600e-01 -5.520200e-02
 2.762800e-03 2.746500e-01 -6.009700e-02 2.370200e-03 3.373500e-01 -6.424800e-02
 1.997700e-03 4.038000e-01 -6.768200e-02 1.613300e-03 4.733200e-01 -7.044100e-02
 1.266500e-03 5.452500e-01 -7.260000e-02 9.740800e-04 6.190400e-01 -7.420900e-02
 7.501200e-04 6.941100e-01 -7.529900e-02 5.087400e-04 7.700000e-01 -7.599000e-02
 3.365500e-04 8.464000e-01 -7.640000e-02 2.600100e-04 9.230200e-01 -7.656300e-02
 2.483500e-04 9.996600e-01 -7.661300e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -1.910900e-08 1.270900e-03 3.913300e-08
 -5.008200e-03 3.377300e-03 9.287900e-03 -4.362100e-08 1.484200e-02 9.210900e-08
 -6.046300e-03 1.610000e-02 1.870000e-02 -7.563700e-08 3.808500e-02 1.698500e-07
 -6.376900e-03 3.946600e-02 2.751000e-02 -2.274400e-07 7.047600e-02 2.785000e-07
 -6.253300e-03 7.165600e-02 3.565500e-02 -4.637700e-07 1.107900e-01 3.769900e-07
 -5.885500e-03 1.118600e-01 4.296400e-02 -4.794200e-07 1.581500e-01 5.116500e-07
 -5.379400e-03 1.590900e-01 4.946000e-02 -7.553000e-07 2.116700e-01 1.190200e-06
 -4.779700e-03 2.125000e-01 5.515400e-02 -1.830700e-06 2.705300e-01 1.719000e-06
 -4.169400e-03 2.712000e-01 6.005000e-02 -3.366000e-06 3.337900e-01 2.472800e-06
 -3.554400e-03 3.343800e-01 6.419400e-02 -5.579500e-06 4.008100e-01 3.131100e-06
 -2.990900e-03 4.013100e-01 6.763800e-02 -8.408800e-06 4.709000e-01 3.402000e-06
 -2.398900e-03 4.713100e-01 7.042900e-02 -1.114600e-05 5.435300e-01 3.080600e-06
 -1.872600e-03 5.436900e-01 7.256800e-02 -1.328700e-05 6.175800e-01 2.199800e-06
 -1.440200e-03 6.178200e-01 7.415000e-02 -1.364500e-05 6.930100e-01 1.508700e-06
 -1.105000e-03 6.931800e-01 7.527600e-02 -1.356500e-05 7.692600e-01 7.716700e-07
 -7.264600e-04 7.693800e-01 7.600800e-02 -1.225300e-05 8.461200e-01 -4.560800e-07
 -4.650000e-04 8.459800e-01 7.638100e-02 -1.086600e-05 9.226300e-01 -2.754800e-07
 -3.336900e-04 9.226900e-01 7.655500e-02 -8.779800e-06 9.995100e-01 2.475200e-07
 -2.884400e-04 9.993500e-01 7.661100e-02 0.000000e+00 0.000000e+00 0.000000e+00
 5.008200e-03 3.377200e-03 -9.287800e-03 6.046200e-03 1.610000e-02 -1.870000e-02
 6.376800e-03 3.946600e-02 -2.751000e-02 6.252800e-03 7.165600e-02 -3.565400e-02
 5.884600e-03 1.118600e-01 -4.296300e-02 5.378400e-03 1.590900e-01 -4.945900e-02
 4.778300e-03 2.125000e-01 -5.515200e-02 4.165700e-03 2.712000e-01 -6.004600e-02
 3.547500e-03 3.343800e-01 -6.419000e-02 2.979300e-03 4.013100e-01 -6.763200e-02
 2.382300e-03 4.713100e-01 -7.042300e-02 1.850100e-03 5.436900e-01 -7.256200e-02
 1.413300e-03 6.178200e-01 -7.414600e-02 1.077200e-03 6.931800e-01 -7.527400e-02
 6.996100e-04 7.693800e-01 -7.600700e-02 4.390900e-04 8.459900e-01 -7.638000e-02
 3.102500e-04 9.227000e-01 -7.655700e-02 2.706200e-04 9.993500e-01 -7.662000e-02

VECTORS mode2 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 1.973700e-02 2.114300e-06 2.776300e-02 1.826600e-02 1.000200e-02 2.952300e-02
 1.010300e-02 6.697000e-03 1.578900e-02 3.874900e-02 4.773500e-06 5.560600e-02
 3.730600e-02 7.904500e-03 5.492900e-02 3.128200e-02 5.441300e-03 3.331200e-02
 6.658300e-02 -4.803700e-06 7.951000e-02 6.547500e-02 7.087500e-03 7.921000e-02
 5.934400e-02 4.760700e-03 4.980700e-02 1.018300e-01 -1.258900e-05 1.016500e-01
 1.007700e-01 6.490700e-03 1.013800e-01 9.531700e-02 4.356000e-03 6.465500e-02
 1.440300e-01 -3.463200e-05 1.216400e-01 1.431300e-01 5.813600e-03 1.211100e-01
 1.384000e-01 3.859200e-03 7.791600e-02 1.923300e-01 3.433700e-05 1.390900e-01
 1.914900e-01 5.086500e-03 1.387800e-01 1.871600e-01 3.424000e-03 8.980300e-02
 2.460700e-01 8.497400e-05 1.544500e-01 2.452500e-01 4.629300e-03 1.542000e-01
 2.413900e-01 2.979800e-03 1.000800e-01 3.042900e-01 1.112100e-04 1.676600e-01
 3.035600e-01 4.082700e-03 1.674900e-01 3.001900e-01 2.534600e-03 1.091300e-01
 3.664400e-01 1.537500e-04 1.791100e-01 3.657400e-01 3.419000e-03 1.788400e-01
 3.630500e-01 2.236100e-03 1.167600e-01 4.319600e-01 2.057100e-04 1.886900e-01
 4.313300e-01 3.037600e-03 1.881800e-01 4.288500e-01 1.779200e-03 1.230300e-01
 5.000400e-01 2.325200e-04 1.959500e-01 4.994500e-01 2.493500e-03 1.957200e-01
 4.973500e-01 1.386700e-03 1.283300e-01 5.698000e-01 2.284700e-04 2.016100e-01
 5.692900e-01 2.057100e-03 2.014500e-01 5.675700e-01 1.058300e-03 1.323400e-01
 6.408500e-01 1.213100e-04 2.059300e-01 6.404400e-01 1.627400e-03 2.057200e-01
 6.390100e-01 7.317300e-04 1.355100e-01 7.126200e-01 2.111700e-05 2.087900e-01
 7.124300e-01 8.301200e-04 2.086700e-01 7.111500e-01 5.211100e-04 1.377200e-01
 7.846900e-01 6.442800e-05 2.106000e-01 7.844100e-01 9.641500e-04 2.105300e-01
 7.834800e-01 2.667200e-04 1.393300e-01 8.566500e-01 1.325900e-04 2.115900e-01
 8.563700e-01 8.037700e-04 2.114500e-01 8.556300e-01 1.451100e-04 1.402400e-01
 9.281400e-01 1.532400e-04 2.118500e-01 9.280500e-01 1.871300e-04 2.118200e-01
 9.273000e-01 8.562000e-05 1.407700e-01 9.993300e-01 1.729300e-04 2.119800e-01
 9.990400e-01 7.415300e-04 2.120000e-01 9.983300e-01 -3.660900e-05 1.410100e-01
 1.000000e+00 1.385900e-04 1.409700e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.826600e-02 -9.997100e-03 2.952000e-02
 1.010200e-02 -6.691300e-03 1.578500e-02 3.730200e-02 -7.896800e-03 5.492400e-02
 3.128900e-02 -5.428500e-03 3.330700e-02 6.546200e-02 -7.085900e-03 7.919900e-02
 5.932900e-02 -4.740400e-03 4.980400e-02 1.006800e-01 -6.530200e-03 1.013200e-01
 9.530400e-02 -4.333000e-03 6.465300e-02 1.430100e-01 -5.748100e-03 1.210900e-01
 1.380900e-01 -3.838900e-03 7.789200e-02 1.914500e-01 -5.052400e-03 1.387800e-01
 1.871800e-01 -3.355800e-03 8.975800e-02 2.453400e-01 -4.372600e-03 1.541700e-01
 2.414300e-01 -2.885600e-03 1.000500e-01 3.036400e-01 -3.878300e-03 1.674500e-01
 3.002600e-01 -2.399100e-03 1.091000e-01 3.658700e-01 -3.156000e-03 1.788000e-01
 3.631500e-01 -2.064000e-03 1.167200e-01 4.315600e-01 -2.483000e-03 1.881400e-01
 4.289800e-01 -1.591700e-03 1.230100e-01 4.996500e-01 -2.133900e-03 1.957100e-01
 4.975000e-01 -1.146700e-03 1.283200e-01 5.695300e-01 -1.413700e-03 2.014700e-01
 5.677000e-01 -8.490200e-04 1.323500e-01 6.404800e-01 -1.384300e-03 2.057500e-01
 6.390500e-01 -5.136200e-04 1.355500e-01 7.122600e-01 -1.058200e-03 2.086800e-01
 7.111200e-01 -2.754800e-04 1.377200e-01 7.843400e-01 -7.830900e-04 2.105000e-01
 7.834500e-01 -4.071700e-05 1.392900e-01 8.563800e-01 -5.601900e-04 2.114100e-01
 8.556300e-01 1.154400e-04 1.401900e-01 9.280900e-01 1.341300e-04 2.118000e-01
 9.273400e-01 1.828700e-04 1.407400e-01 9.991000e-01 -3.969700e-04 2.119900e-01
 9.984000e-01 3.163400e-04 1.409900e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 7.392300e-03 3.396400e-03 7.614000e-03
 2.707500e-02 2.751000e-03 1.555400e-02 5.572600e-02 2.416500e-03 2.396000e-02
 9.202600e-02 2.182700e-03 3.141500e-02 1.352800e-01 1.917200e-03 3.812300e-02
 1.845700e-01 1.719300e-03 4.407800e-02 2.392400e-01 1.431600e-03 4.925600e-02
 2.984100e-01 1.193400e-03 5.376500e-02 3.613800e-01 1.078700e-03 5.757300e-02
 4.276300e-01 7.430500e-04 6.075400e-02 4.963300e-01 5.082100e-04 6.342800e-02
 5.667600e-01 3.142600e-04 6.557800e-02 6.383900e-01 1.500000e-04 6.726000e-02
 7.106900e-01 1.191200e-05 6.851500e-02 7.832200e-01 -7.911900e-05 6.940600e-02
 8.555500e-01 -1.450300e-04 6.997200e-02 9.273600e-01 -1.951600e-04 7.029200e-02
 9.983200e-01 -2.670000e-04 7.044000e-02 9.983100e-01 1.084100e-04 7.061800e-02
 0.000000e+00 0.000000e+00 0.000000e+00 7.393600e-03 -3.390600e-03 7.610000e-03
 2.707600e-02 -2.734500e-03 1.554700e-02 5.572800e-02 -2.385000e-03 2.395800e-02
 9.199900e-02 -2.143500e-03 3.143400e-02 1.352300e-01 -1.866700e-03 3.810800e-02
 1.845600e-01 -1.643700e-03 4.402900e-02 2.392600e-01 -1.341000e-03 4.923500e-02
 2.984600e-01 -1.098100e-03 5.374600e-02 3.614400e-01 -9.548200e-04 5.755000e-02
 4.277300e-01 -6.060500e-04 6.074800e-02 4.964400e-01 -3.737700e-04 6.342700e-02
 5.668700e-01 -1.585600e-04 6.558100e-02 6.384900e-01 2.804400e-05 6.725700e-02
 7.107800e-01 1.899300e-04 6.849800e-02 7.832900e-01 3.254500e-04 6.937200e-02
 8.556000e-01 4.255500e-04 6.994600e-02 9.274000e-01 4.733700e-04 7.025600e-02
 9.983800e-01 5.836500e-04 7.036000e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 6.693800e-03 5.975900e-06 1.083300e-05
 2.586400e-02 1.048400e-05 1.961000e-05 5.443800e-02 1.786600e-05 1.581600e-05
 9.092900e-02 2.798500e-05 1.056300e-05 1.342400e-01 3.597200e-05 2.405800e-06
 1.836600e-01 4.568400e-05 -2.179600e-06 2.384200e-01 5.047100e-05 -1.533300e-05
 2.977100e-01 6.460100e-05 -4.318800e-05 3.608000e-01 4.878400e-05 -1.151900e-04
 4.269800e-01 4.047900e-05 -1.646200e-04 4.956300e-01 1.021100e-05 -1.513500e-04
 5.660500e-01 1.076800e-06 -7.850500e-05 6.377000e-01 1.786700e-06 -1.000300e-05
 7.100200e-01 2.275000e-06 7.423100e-05 7.826200e-01 4.558500e-05 1.704900e-04
 8.550500e-01 8.631300e-05 2.064000e-04 9.269500e-01 6.316400e-05 2.090600e-04
 9.978800e-01 1.965700e-04 3.017100e-04 9.978800e-01 2.555900e-04 2.790100e-06
 0.000000e+00 0.000000e+00 0.000000e+00 6.697000e-03 -1.427900e-07 7.839400e-06
 2.586900e-02 3.589300e-06 1.466500e-05 5.445000e-02 8.954200e-06 1.516300e-05
 9.093800e-02 2.098800e-05 5.098000e-06 1.342600e-01 3.049300e-05 -2.253700e-06
 1.837100e-01 4.354000e-05 -1.488900e-05 2.384700e-01 5.215300e-05 -8.448600e-06
 2.977900e-01 5.594900e-05 -5.059200e-05 3.609000e-01 9.784300e-05 -1.013000e-04
 4.271200e-01 9.909000e-05 -1.340600e-04 4.957800e-01 1.202800e-04 -1.283700e-04
 5.662400e-01 1.524800e-04 -7.179300e-05 6.378900e-01 1.683000e-04 -8.488000e-06
 7.102400e-01 1.792400e-04 5.839700e-05 7.828200e-01 1.999800e-04 1.160800e-04
 8.552700e-01 2.086500e-04 1.391300e-04 9.271500e-01 2.179600e-04 8.469000e-05
 9.981300e-01 2.268200e-04 -4.052000e-06 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 7.382000e-03 -3.386100e-03 -7.599200e-03
 2.707300e-02 -2.731600e-03 -1.551800e-02 5.576000e-02 -2.370900e-03 -2.392000e-02
 9.203500e-02 -2.117700e-03 -3.141900e-02 1.352200e-01 -1.869400e-03 -3.811900e-02
 1.845100e-01 -1.659500e-03 -4.404800e-02 2.391600e-01 -1.371100e-03 -4.925400e-02
 2.983700e-01 -1.186700e-03 -5.380200e-02 3.613400e-01 -8.993700e-04 -5.771700e-02
 4.273100e-01 -8.256800e-04 -6.100000e-02 4.957000e-01 -7.115000e-04 -6.362500e-02
 5.659800e-01 -5.607400e-04 -6.569000e-02 6.374900e-01 -4.237700e-04 -6.724900e-02
 7.097700e-01 -2.445600e-04 -6.837000e-02 7.823000e-01 -1.560200e-04 -6.912600e-02
 8.548300e-01 -4.113000e-05 -6.963200e-02 9.268900e-01 2.168800e-04 -6.994700e-02
 9.978700e-01 2.167500e-04 -7.006600e-02 9.981700e-01 4.636900e-05 -7.039300e-02
 0.000000e+00 0.000000e+00 0.000000e+00 7.387300e-03 3.389200e-03 -7.599700e-03
 2.708500e-02 2.736000e-03 -1.551500e-02 5.578100e-02 2.380700e-03 -2.391700e-02
 9.209500e-02 2.145600e-03 -3.140100e-02 1.353200e-01 1.906200e-03 -3.810100e-02
 1.846500e-01 1.707000e-03 -4.403100e-02 2.393400e-01 1.444700e-03 -4.925700e-02
 2.986000e-01 1.277900e-03 -5.376200e-02 3.616600e-01 1.011900e-03 -5.767900e-02
 4.276900e-01 9.398300e-04 -6.092700e-02 4.961600e-01 7.879000e-04 -6.359000e-02
 5.665300e-01 6.002700e-04 -6.563800e-02 6.380900e-01 5.265000e-04 -6.723700e-02
 7.103900e-01 4.034500e-04 -6.837400e-02 7.829400e-01 3.023000e-04 -6.915800e-02
 8.555100e-01 1.240900e-04 -6.965300e-02 9.275000e-01 -1.679000e-04 -7.008300e-02
 9.985000e-01 2.543800e-05 -7.054700e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.009300e-02 -6.691800e-03 -1.578100e-02
 3.122700e-02 -5.433700e-03 -3.328600e-02 5.937100e-02 -4.741500e-03 -4.976900e-02
 9.533200e-02 -4.342100e-03 -6.463300e-02 1.380800e-01 -3.873700e-03 -7.787500e-02
 1.870800e-01 -3.450000e-03 -8.974500e-02 2.412900e-01 -2.971800e-03 -1.000200e-01
 3.003200e-01 -2.504500e-03 -1.090700e-01 3.627500e-01 -2.174500e-03 -1.167200e-01
 4.285600e-01 -1.922900e-03 -1.231100e-01 4.966500e-01 -1.553800e-03 -1.281900e-01
 5.667000e-01 -1.195100e-03 -1.323700e-01 6.379100e-01 -1.049200e-03 -1.354600e-01
 7.099000e-01 -7.929200e-04 -1.375900e-01 7.823700e-01 -5.116100e-04 -1.391200e-01
 8.550100e-01 -3.332700e-04 -1.400000e-01 9.265700e-01 -1.443000e-04 -1.404700e-01
 9.981900e-01 5.842400e-05 -1.407000e-01 9.981200e-01 -1.539200e-04 -1.408500e-01
 0.000000e+00 0.000000e+00 0.000000e+00 1.009900e-02 6.689100e-03 -1.577700e-02
 3.123900e-02 5.424500e-03 -3.327900e-02 5.940000e-02 4.728600e-03 -4.975400e-02
 9.538400e-02 4.313600e-03 -6.459300e-02 1.384200e-01 3.802800e-03 -7.784000e-02
 1.872300e-01 3.342000e-03 -8.972100e-02 2.419500e-01 2.894400e-03 -1.000000e-01
 3.005000e-01 2.428800e-03 -1.090000e-01 3.639200e-01 1.995500e-03 -1.166200e-01
 4.290000e-01 1.637300e-03 -1.230300e-01 4.984900e-01 1.258100e-03 -1.281400e-01
 5.670500e-01 8.895000e-04 -1.322900e-01 6.403600e-01 6.369800e-04 -1.354000e-01
 7.106300e-01 3.123700e-04 -1.375800e-01 7.849900e-01 9.103500e-05 -1.391800e-01
 8.553800e-01 -5.421000e-06 -1.401000e-01 9.289100e-01 -1.874100e-04 -1.405700e-01
 9.984100e-01 -2.966100e-04 -1.409000e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.971900e-02 -4.106500e-06 -2.775400e-02
 1.824300e-02 -1.000500e-02 -2.951000e-02 3.874700e-02 -8.368100e-06 -5.561300e-02
 3.729000e-02 -7.917300e-03 -5.493100e-02 6.666100e-02 -2.743800e-05 -7.951400e-02
 6.552500e-02 -7.120900e-03 -7.919500e-02 1.019300e-01 -1.859100e-05 -1.015500e-01
 1.007700e-01 -6.552700e-03 -1.012700e-01 1.440600e-01 -1.536500e-04 -1.213100e-01
 1.429700e-01 -5.959200e-03 -1.210900e-01 1.923600e-01 -1.864900e-04 -1.390200e-01
 1.913200e-01 -5.288200e-03 -1.387100e-01 2.460500e-01 -2.632100e-04 -1.543300e-01
 2.450900e-01 -4.708500e-03 -1.540800e-01 3.043400e-01 -3.413400e-05 -1.676700e-01
 3.034600e-01 -3.985400e-03 -1.673900e-01 3.665200e-01 -4.907800e-04 -1.787800e-01
 3.655900e-01 -3.707100e-03 -1.786000e-01 4.316200e-01 -5.582100e-04 -1.879600e-01
 4.306600e-01 -3.147000e-03 -1.878100e-01 4.991100e-01 -7.569400e-04 -1.954600e-01
 4.982800e-01 -2.552600e-03 -1.952400e-01 5.686300e-01 -3.911800e-05 -2.014000e-01
 5.679100e-01 -2.075100e-03 -2.012200e-01 6.396100e-01 -1.009100e-03 -2.057200e-01
 6.387300e-01 -1.818500e-03 -2.056500e-01 7.112800e-01 -9.476700e-04 -2.086600e-01
 7.103500e-01 -1.668900e-03 -2.085700e-01 7.833500e-01 -1.072100e-03 -2.106300e-01
 7.826000e-01 -1.159900e-03 -2.104100e-01 8.558000e-01 -2.784400e-05 -2.117500e-01
 8.551200e-01 -7.719300e-04 -2.115000e-01 9.277400e-01 -8.753300e-04 -2.117500e-01
 9.270200e-01 -9.799200e-04 -2.117400e-01 9.988900e-01 -1.693900e-05 -2.119800e-01
 9.982400e-01 -3.927300e-04 -2.115000e-01 0.000000e+00 0.000000e+00 0.000000e+00
 1.824800e-02 9.997100e-03 -2.950700e-02 3.730300e-02 7.894700e-03 -5.492300e-02
 6.554700e-02 7.083300e-03 -7.919000e-02 1.008800e-01 6.437400e-03 -1.012600e-01
 1.431800e-01 5.708100e-03 -1.210500e-01 1.916600e-01 4.908100e-03 -1.387300e-01
 2.454600e-01 4.330400e-03 -1.541200e-01 3.039600e-01 3.535200e-03 -1.673800e-01
 3.662900e-01 2.934800e-03 -1.784500e-01 4.316900e-01 2.012700e-03 -1.878100e-01
 4.993100e-01 1.448600e-03 -1.953500e-01 5.690000e-01 9.801500e-04 -2.012100e-01
 6.401400e-01 2.842700e-04 -2.054400e-01 7.120900e-01 -2.333000e-04 -2.085900e-01
 7.840900e-01 -4.474900e-04 -2.106400e-01 8.563600e-01 -4.399700e-04 -2.115800e-01
 9.281800e-01 -6.931500e-05 -2.117300e-01 9.992400e-01 -6.942100e-04 -2.112300e-01

VECTORS mode3 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 6.244100e-06 -4.039400e-02 7.284700e-06 1.115700e-02 -4.582200e-02 -2.617000e-02
 1.806400e-02 -3.136200e-02 -2.560600e-02 2.174800e-05 -1.089000e-01 1.877200e-05
 3.597000e-02 -1.100100e-01 -4.273400e-02 3.887200e-02 -7.343100e-02 -4.139300e-02
 4.290100e-05 -1.869100e-01 3.337600e-05 6.213000e-02 -1.879900e-01 -5.021600e-02
 6.344300e-02 -1.255100e-01 -4.803300e-02 1.256600e-04 -2.696800e-01 -7.485900e-05
 8.970000e-02 -2.699000e-01 -5.291000e-02 9.008100e-02 -1.802100e-01 -5.051900e-02
 2.536300e-04 -3.531300e-01 8.314500e-05 1.176100e-01 -3.528500e-01 -5.335900e-02
 1.180600e-01 -2.356100e-01 -5.076900e-02 1.190300e-04 -4.345000e-01 -3.197000e-05
 1.443600e-01 -4.343000e-01 -5.218800e-02 1.440800e-01 -2.901100e-01 -4.957600e-02
 1.629900e-04 -5.130300e-01 1.169400e-05 1.701900e-01 -5.125800e-01 -4.981200e-02
 1.699700e-01 -3.425700e-01 -4.737300e-02 6.608900e-05 -5.871200e-01 1.863600e-04
 1.948400e-01 -5.868400e-01 -4.695900e-02 1.944600e-01 -3.921700e-01 -4.461600e-02
 6.495000e-05 -6.566200e-01 -1.530100e-04 2.179400e-01 -6.563000e-01 -4.344900e-02
 2.175700e-01 -4.384600e-01 -4.136600e-02 2.306000e-04 -7.208200e-01 1.439100e-04
 2.393000e-01 -7.201700e-01 -3.969600e-02 2.388400e-01 -4.811100e-01 -3.775800e-02
 1.841500e-04 -7.786800e-01 1.430200e-04 2.587100e-01 -7.780600e-01 -3.540800e-02
 2.581400e-01 -5.196500e-01 -3.372500e-02 3.799800e-04 -8.298300e-01 2.312400e-04
 2.757600e-01 -8.291400e-01 -3.086300e-02 2.752600e-01 -5.537100e-01 -2.946500e-02
 3.590100e-04 -8.740500e-01 7.889500e-04 2.908500e-01 -8.731900e-01 -2.632900e-02
 2.902100e-01 -5.831600e-01 -2.514300e-02 3.160400e-04 -9.109600e-01 2.437800e-04
 3.042700e-01 -9.137000e-01 -2.159900e-02 3.027700e-01 -6.073500e-01 -2.059400e-02
 5.159100e-04 -9.401000e-01 -1.047000e-04 3.130300e-01 -9.397100e-01 -1.730400e-02
 3.126800e-01 -6.275200e-01 -1.637800e-02 5.546900e-04 -9.629500e-01 2.067400e-04
 3.205700e-01 -9.623300e-01 -1.374900e-02 3.205600e-01 -6.426000e-01 -1.274900e-02
 5.997000e-04 -9.805400e-01 1.973400e-04 3.270000e-01 -9.833200e-01 -1.173100e-02
 3.261100e-01 -6.538900e-01 -1.066900e-02 6.381900e-04 -9.923700e-01 1.781700e-04
 3.269600e-01 -9.915000e-01 -1.097900e-02 3.272700e-01 -6.645100e-01 -9.878000e-03
 7.495700e-04 -6.661900e-01 1.198500e-04 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -1.114900e-02 -4.582800e-02 2.618600e-02
 -1.805700e-02 -3.136100e-02 2.560300e-02 -3.593200e-02 -1.100200e-01 4.276600e-02
 -3.883600e-02 -7.343000e-02 4.138400e-02 -6.202100e-02 -1.879600e-01 5.024500e-02
 -6.335000e-02 -1.254900e-01 4.801900e-02 -8.952200e-02 -2.698000e-01 5.310300e-02
 -8.998600e-02 -1.802200e-01 5.054000e-02 -1.177600e-01 -3.543300e-01 5.331700e-02
 -1.172200e-01 -2.353900e-01 5.075600e-02 -1.442700e-01 -4.340200e-01 5.213500e-02
 -1.440400e-01 -2.900800e-01 4.965300e-02 -1.707600e-01 -5.146400e-01 4.988000e-02
 -1.700000e-01 -3.423100e-01 4.738500e-02 -1.947900e-01 -5.867500e-01 4.694200e-02
 -1.945100e-01 -3.921100e-01 4.461800e-02 -2.179500e-01 -6.561300e-01 4.365800e-02
 -2.175800e-01 -4.384400e-01 4.149900e-02 -2.400600e-01 -7.229800e-01 3.985100e-02
 -2.389800e-01 -4.807500e-01 3.783700e-02 -2.586800e-01 -7.778700e-01 3.575000e-02
 -2.582100e-01 -5.195700e-01 3.391400e-02 -2.764100e-01 -8.322600e-01 3.143300e-02
 -2.752100e-01 -5.533200e-01 2.972300e-02 -2.902100e-01 -8.733700e-01 2.674500e-02
 -2.897700e-01 -5.830800e-01 2.526400e-02 -3.021300e-01 -9.102400e-01 2.212200e-02
 -3.019300e-01 -6.076500e-01 2.092800e-02 -3.119400e-01 -9.400400e-01 1.775100e-02
 -3.118200e-01 -6.274400e-01 1.678400e-02 -3.196100e-01 -9.625200e-01 1.405600e-02
 -3.197100e-01 -6.425600e-01 1.309000e-02 -3.258300e-01 -9.833200e-01 1.211900e-02
 -3.251300e-01 -6.538400e-01 1.100000e-02 -3.257400e-01 -9.916600e-01 1.144600e-02
 -3.262200e-01 -6.644800e-01 1.029600e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 2.094200e-02 -1.536400e-02 -1.310200e-02
 4.037900e-02 -3.648600e-02 -2.149500e-02 6.419500e-02 -6.278100e-02 -2.526500e-02
 9.052900e-02 -9.033200e-02 -2.672300e-02 1.175100e-01 -1.181600e-01 -2.674500e-02
 1.443000e-01 -1.455200e-01 -2.601500e-02 1.701200e-01 -1.718000e-01 -2.495500e-02
 1.947200e-01 -1.966300e-01 -2.347800e-02 2.176600e-01 -2.197400e-01 -2.172300e-02
 2.389500e-01 -2.409200e-01 -1.981900e-02 2.581900e-01 -2.600600e-01 -1.771200e-02
 2.753000e-01 -2.770100e-01 -1.546600e-02 2.901700e-01 -2.916100e-01 -1.310800e-02
 3.027000e-01 -3.038400e-01 -1.074400e-02 3.129400e-01 -3.136300e-01 -8.502800e-03
 3.209900e-01 -3.212800e-01 -6.736800e-03 3.268800e-01 -3.274300e-01 -5.745900e-03
 3.280700e-01 -3.329500e-01 -5.430400e-03 5.252300e-04 -3.332000e-01 2.160800e-04
 0.000000e+00 0.000000e+00 0.000000e+00 -2.092900e-02 -1.535900e-02 1.308600e-02
 -4.033900e-02 -3.647800e-02 2.145900e-02 -6.412400e-02 -6.276900e-02 2.521500e-02
 -9.037500e-02 -9.031000e-02 2.662500e-02 -1.173100e-01 -1.181700e-01 2.672200e-02
 -1.441700e-01 -1.454800e-01 2.605300e-02 -1.700500e-01 -1.717500e-01 2.494200e-02
 -1.947000e-01 -1.965500e-01 2.346700e-02 -2.177000e-01 -2.196800e-01 2.169000e-02
 -2.389500e-01 -2.408200e-01 1.979400e-02 -2.581300e-01 -2.599000e-01 1.770600e-02
 -2.751200e-01 -2.768700e-01 1.547700e-02 -2.898200e-01 -2.914300e-01 1.318500e-02
 -3.021800e-01 -3.036300e-01 1.090600e-02 -3.122600e-01 -3.134700e-01 8.756600e-03
 -3.201700e-01 -3.211300e-01 7.053000e-03 -3.259200e-01 -3.272900e-01 6.077400e-03
 -3.270200e-01 -3.328300e-01 5.779200e-03 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 2.130900e-02 -5.945300e-05 -5.364300e-05
 4.073600e-02 -1.240600e-04 -1.030700e-04 6.436800e-02 -2.255900e-04 -1.466500e-04
 9.052500e-02 -3.994500e-04 -1.380200e-04 1.175000e-01 -4.938800e-04 -1.048700e-04
 1.442900e-01 -5.003600e-04 -9.725800e-05 1.700200e-01 -5.533300e-04 -5.001900e-05
 1.945300e-01 -6.175600e-04 -8.288000e-05 2.174300e-01 -6.027700e-04 -3.818700e-05
 2.384600e-01 -4.840700e-04 3.163800e-05 2.575300e-01 -2.957700e-04 2.237900e-05
 2.745000e-01 -9.582300e-05 1.336300e-04 2.893700e-01 8.614300e-05 2.544400e-04
 3.019400e-01 3.157300e-04 3.213700e-04 3.122700e-01 5.681400e-04 3.297100e-04
 3.206100e-01 8.643100e-04 5.059300e-04 3.274500e-01 1.380200e-03 6.793700e-04
 3.283700e-01 2.072700e-03 7.951100e-04 4.365900e-04 1.895300e-03 4.433500e-06
 0.000000e+00 0.000000e+00 0.000000e+00 -2.128900e-02 -5.078300e-05 3.236300e-05
 -4.069100e-02 -1.143600e-04 5.693300e-05 -6.429500e-02 -2.123900e-04 6.610100e-05
 -9.043600e-02 -3.731500e-04 5.469400e-05 -1.174300e-01 -4.502700e-04 2.833600e-05
 -1.442600e-01 -4.637300e-04 3.659700e-05 -1.700400e-01 -5.126100e-04 -7.029600e-06
 -1.946000e-01 -5.770200e-04 -1.305900e-06 -2.175500e-01 -5.377700e-04 -8.280900e-05
 -2.386400e-01 -4.200800e-04 -1.738800e-04 -2.577100e-01 -2.083700e-04 -1.621100e-04
 -2.746200e-01 7.106700e-06 -2.312500e-04 -2.893700e-01 2.156300e-04 -2.914900e-04
 -3.017800e-01 4.525800e-04 -2.654000e-04 -3.119300e-01 6.993100e-04 -1.690000e-04
 -3.200600e-01 9.624700e-04 -2.708800e-04 -3.266700e-01 1.516500e-03 -3.947500e-04
 -3.274500e-01 2.048500e-03 -3.368300e-04 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 2.096800e-02 1.525800e-02 1.297700e-02
 4.040000e-02 3.622600e-02 2.133400e-02 6.422900e-02 6.229400e-02 2.501500e-02
 9.057400e-02 8.955600e-02 2.634800e-02 1.174400e-01 1.172900e-01 2.659200e-02
 1.442800e-01 1.445400e-01 2.590600e-02 1.700300e-01 1.705400e-01 2.470900e-02
 1.947100e-01 1.951200e-01 2.332100e-02 2.174300e-01 2.183000e-01 2.160000e-02
 2.386600e-01 2.396000e-01 1.968500e-02 2.573300e-01 2.584700e-01 1.769200e-02
 2.742300e-01 2.752700e-01 1.571900e-02 2.890700e-01 2.907300e-01 1.364700e-02
 3.020600e-01 3.039000e-01 1.138400e-02 3.119400e-01 3.137600e-01 9.311200e-03
 3.203000e-01 3.220000e-01 8.057000e-03 3.266400e-01 3.297100e-01 7.122600e-03
 3.276000e-01 3.364200e-01 6.482400e-03 4.158700e-04 3.373700e-01 6.195100e-05
 0.000000e+00 0.000000e+00 0.000000e+00 -2.094200e-02 1.526700e-02 -1.299800e-02
 -4.034900e-02 3.623700e-02 -2.137800e-02 -6.415200e-02 6.230400e-02 -2.508500e-02
 -9.052600e-02 8.955800e-02 -2.647000e-02 -1.174500e-01 1.172800e-01 -2.668300e-02
 -1.443400e-01 1.445600e-01 -2.599000e-02 -1.701000e-01 1.705100e-01 -2.479500e-02
 -1.948500e-01 1.951400e-01 -2.344600e-02 -2.176100e-01 2.182400e-01 -2.175100e-02
 -2.389800e-01 2.396500e-01 -1.988000e-02 -2.577400e-01 2.585200e-01 -1.788200e-02
 -2.746600e-01 2.753600e-01 -1.590300e-02 -2.894100e-01 2.908000e-01 -1.377500e-02
 -3.022900e-01 3.040000e-01 -1.145600e-02 -3.119600e-01 3.138300e-01 -9.299800e-03
 -3.200400e-01 3.220700e-01 -7.969700e-03 -3.260500e-01 3.296500e-01 -6.983000e-03
 -3.267700e-01 3.363500e-01 -6.177000e-03 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.815100e-02 3.133000e-02 2.554500e-02
 3.881600e-02 7.326800e-02 4.123300e-02 6.366500e-02 1.252000e-01 4.786800e-02
 9.041900e-02 1.797500e-01 5.027300e-02 1.173300e-01 2.348700e-01 5.048900e-02
 1.440100e-01 2.890000e-01 4.935000e-02 1.701300e-01 3.414400e-01 4.738500e-02
 1.951600e-01 3.910300e-01 4.437600e-02 2.175500e-01 4.370100e-01 4.109800e-02
 2.384900e-01 4.791400e-01 3.752100e-02 2.578400e-01 5.173500e-01 3.354500e-02
 2.756700e-01 5.513800e-01 2.974100e-02 2.895100e-01 5.814200e-01 2.588500e-02
 3.016400e-01 6.067700e-01 2.132300e-02 3.122000e-01 6.270200e-01 1.704200e-02
 3.211900e-01 6.432200e-01 1.413400e-02 3.258000e-01 6.564400e-01 1.186800e-02
 3.275800e-01 6.677900e-01 1.116200e-02 3.506000e-04 6.669400e-01 -1.014700e-04
 0.000000e+00 0.000000e+00 0.000000e+00 -1.812300e-02 3.133800e-02 -2.556200e-02
 -3.875000e-02 7.327400e-02 -4.126500e-02 -6.358800e-02 1.252000e-01 -4.791800e-02
 -9.036200e-02 1.797600e-01 -5.035000e-02 -1.178700e-01 2.348900e-01 -5.055300e-02
 -1.440000e-01 2.890200e-01 -4.942600e-02 -1.708200e-01 3.414400e-01 -4.744700e-02
 -1.951700e-01 3.910300e-01 -4.447200e-02 -2.186400e-01 4.370100e-01 -4.121200e-02
 -2.386900e-01 4.791800e-01 -3.767100e-02 -2.591900e-01 5.174100e-01 -3.370400e-02
 -2.760300e-01 5.514400e-01 -2.993100e-02 -2.910700e-01 5.814900e-01 -2.608600e-02
 -3.018200e-01 6.068500e-01 -2.152900e-02 -3.135400e-01 6.270900e-01 -1.724100e-02
 -3.208200e-01 6.432700e-01 -1.431600e-02 -3.265400e-01 6.564500e-01 -1.202600e-02
 -3.265100e-01 6.677900e-01 -1.130500e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.694900e-05 4.040100e-02 -1.350300e-05
 1.123100e-02 4.588200e-02 2.618500e-02 2.689100e-05 1.091900e-01 -2.012900e-05
 3.609500e-02 1.100400e-01 4.262000e-02 4.147200e-05 1.868800e-01 -1.460500e-05
 6.251500e-02 1.880300e-01 5.011300e-02 1.381100e-05 2.704900e-01 8.489900e-07
 8.992400e-02 2.698800e-01 5.282500e-02 -5.235500e-05 3.522000e-01 6.705100e-06
 1.174500e-01 3.522300e-01 5.291900e-02 -6.338200e-05 4.331700e-01 -3.127300e-05
 1.441000e-01 4.330800e-01 5.191700e-02 -7.444300e-05 5.121300e-01 -1.484800e-05
 1.708200e-01 5.120400e-01 5.009300e-02 -9.334900e-05 5.890200e-01 -2.557100e-05
 1.954800e-01 5.867800e-01 4.674700e-02 -1.302000e-04 6.555500e-01 -4.277500e-06
 2.185100e-01 6.552500e-01 4.290500e-02 -2.239000e-04 7.181300e-01 1.900700e-05
 2.386500e-01 7.180700e-01 3.947500e-02 -3.272800e-04 7.762800e-01 -3.589600e-05
 2.590000e-01 7.764200e-01 3.614900e-02 -3.516700e-04 8.333500e-01 -8.255600e-05
 2.766700e-01 8.283300e-01 3.131700e-02 -3.497300e-04 8.721100e-01 -1.300800e-04
 2.907200e-01 8.721600e-01 2.627800e-02 -2.882000e-04 9.087100e-01 -1.758000e-04
 3.016500e-01 9.088200e-01 2.238500e-02 -2.054300e-04 9.400300e-01 -2.258000e-04
 3.132300e-01 9.402000e-01 1.879500e-02 1.171300e-06 9.697500e-01 -3.024600e-04
 3.216500e-01 9.647100e-01 1.473500e-02 2.109400e-04 9.812800e-01 -2.729500e-04
 3.262800e-01 9.824500e-01 1.278200e-02 3.798500e-04 1.000000e+00 -1.722200e-04
 3.274600e-01 9.960000e-01 1.255800e-02 0.000000e+00 0.000000e+00 0.000000e+00
 -1.119600e-02 4.589000e-02 -2.621400e-02 -3.603600e-02 1.100300e-01 -4.265800e-02
 -6.242700e-02 1.880300e-01 -5.014400e-02 -8.992000e-02 2.699300e-01 -5.277400e-02
 -1.175800e-01 3.523300e-01 -5.293700e-02 -1.442600e-01 4.331200e-01 -5.195800e-02
 -1.709900e-01 5.121800e-01 -5.014600e-02 -1.957100e-01 5.868200e-01 -4.675900e-02
 -2.188200e-01 6.554800e-01 -4.292100e-02 -2.391500e-01 7.181400e-01 -3.947300e-02
 -2.596500e-01 7.765500e-01 -3.623200e-02 -2.773900e-01 8.284100e-01 -3.146300e-02
 -2.914200e-01 8.723100e-01 -2.654500e-02 -3.022600e-01 9.089100e-01 -2.273000e-02
 -3.136400e-01 9.403600e-01 -1.925300e-02 -3.217100e-01 9.648100e-01 -1.528100e-02
 -3.259300e-01 9.827100e-01 -1.334900e-02 -3.267100e-01 9.961800e-01 -1.343900e-02

VECTORS mode4 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 2.750600e-06 -2.566500e-02 1.285800e-06 -1.996000e-02 -3.657600e-02 -5.041200e-02
 -7.041400e-03 -4.729600e-02 -4.915100e-02 1.286300e-05 -1.133900e-01 9.416900e-06
 -1.559900e-02 -1.172100e-01 -8.908000e-02 -7.520500e-03 -1.275800e-01 -9.014500e-02
 3.773000e-05 -2.336100e-01 8.291300e-06 -7.823500e-03 -2.365400e-01 -1.115400e-01
 -3.477300e-03 -2.417600e-01 -1.128200e-01 8.096700e-05 -3.706900e-01 -2.092900e-04
 1.785400e-03 -3.706400e-01 -1.184400e-01 1.656200e-03 -3.690600e-01 -1.195200e-01
 2.138700e-04 -5.065600e-01 -3.612700e-07 1.192300e-02 -5.038100e-01 -1.106500e-01
 8.005400e-03 -4.948600e-01 -1.115400e-01 4.868100e-05 -6.245900e-01 -3.789300e-05
 2.037300e-02 -6.205700e-01 -8.958600e-02 1.288900e-02 -6.045100e-01 -9.034000e-02
 1.129400e-04 -7.129100e-01 -2.448900e-06 2.755300e-02 -7.074300e-01 -5.740700e-02
 1.775400e-02 -6.854400e-01 -5.794600e-02 1.561600e-05 -7.602600e-01 2.266100e-04
 3.278000e-02 -7.541100e-01 -1.741000e-02 2.077700e-02 -7.278900e-01 -1.770200e-02
 1.932900e-05 -7.606700e-01 -2.162300e-04 3.577000e-02 -7.541100e-01 2.761900e-02
 2.302800e-02 -7.252200e-01 2.749000e-02 1.044600e-04 -7.107900e-01 -1.491600e-05
 3.644900e-02 -7.039900e-01 7.418100e-02 2.356400e-02 -6.742500e-01 7.429600e-02
 -1.592200e-05 -6.101100e-01 6.239600e-05 3.492300e-02 -6.037700e-01 1.196400e-01
 2.254900e-02 -5.751900e-01 1.199400e-01 5.448500e-05 -4.621700e-01 -6.723200e-06
 3.146200e-02 -4.564700e-01 1.611900e-01 2.039200e-02 -4.307000e-01 1.616100e-01
 -9.756200e-06 -2.729700e-01 1.354100e-04 2.672200e-02 -2.682300e-01 1.965000e-01
 1.741400e-02 -2.462400e-01 1.970500e-01 -2.179700e-05 -5.066300e-02 -3.958300e-05
 2.131600e-02 -4.726800e-02 2.242300e-01 1.398500e-02 -2.943400e-02 2.248300e-01
 -2.845600e-05 1.950600e-01 -6.588400e-05 1.584700e-02 1.979100e-01 2.437500e-01
 1.053900e-02 2.111100e-01 2.443900e-01 -4.837000e-05 4.553900e-01 -6.277500e-05
 1.102200e-02 4.565600e-01 2.555200e-01 7.500600e-03 4.664600e-01 2.558700e-01
 -6.446400e-05 7.218500e-01 -4.769400e-05 6.587300e-03 7.245800e-01 2.611000e-01
 5.854700e-03 7.289400e-01 2.615400e-01 -6.078200e-05 9.856600e-01 -2.955400e-05
 6.897600e-03 9.853200e-01 2.625900e-01 5.454900e-03 9.933200e-01 2.631700e-01
 -5.552000e-05 9.957200e-01 -2.102800e-05 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.996400e-02 -3.657900e-02 5.041400e-02
 7.053300e-03 -4.729700e-02 4.915000e-02 1.562500e-02 -1.172100e-01 8.908900e-02
 7.530500e-03 -1.275800e-01 9.013000e-02 7.947400e-03 -2.364900e-01 1.115000e-01
 3.580200e-03 -2.417400e-01 1.128000e-01 -1.717600e-03 -3.704600e-01 1.185200e-01
 -1.600900e-03 -3.690500e-01 1.195500e-01 -1.253800e-02 -5.062100e-01 1.105500e-01
 -7.471200e-03 -4.945500e-01 1.115300e-01 -2.047200e-02 -6.202200e-01 8.948800e-02
 -1.294200e-02 -6.045100e-01 9.037000e-02 -2.842600e-02 -7.100100e-01 5.745000e-02
 -1.780500e-02 -6.851400e-01 5.797400e-02 -3.280100e-02 -7.538700e-01 1.733600e-02
 -2.073200e-02 -7.279000e-01 1.764900e-02 -3.577300e-02 -7.538800e-01 -2.754600e-02
 -2.298500e-02 -7.252100e-01 -2.742000e-02 -3.730400e-02 -7.064700e-01 -7.424700e-02
 -2.361000e-02 -6.739600e-01 -7.429500e-02 -3.511700e-02 -6.034700e-01 -1.196800e-01
 -2.260000e-02 -5.752100e-01 -1.199800e-01 -3.202100e-02 -4.580700e-01 -1.611600e-01
 -2.042800e-02 -4.305100e-01 -1.616500e-01 -2.679400e-02 -2.681000e-01 -1.965500e-01
 -1.740700e-02 -2.462500e-01 -1.971600e-01 -2.124500e-02 -4.704800e-02 -2.242700e-01
 -1.396300e-02 -2.944100e-02 -2.249200e-01 -1.590100e-02 1.979000e-01 -2.438500e-01
 -1.058700e-02 2.111100e-01 -2.444800e-01 -1.113300e-02 4.565400e-01 -2.556300e-01
 -7.636900e-03 4.664700e-01 -2.560000e-01 -6.719000e-03 7.245800e-01 -2.612000e-01
 -6.038000e-03 7.289500e-01 -2.616400e-01 -7.040300e-03 9.853000e-01 -2.626900e-01
 -5.632500e-03 9.933400e-01 -2.632900e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -1.855400e-03 -4.939100e-02 -5.040700e-02
 -2.027000e-03 -1.303700e-01 -8.880900e-02 -7.406200e-04 -2.428500e-01 -1.104400e-01
 1.670900e-03 -3.671600e-01 -1.168200e-01 4.171900e-03 -4.892600e-01 -1.083400e-01
 6.993800e-03 -5.945600e-01 -8.692500e-02 9.146900e-03 -6.722200e-01 -5.570300e-02
 1.039300e-02 -7.126300e-01 -1.616900e-02 1.174100e-02 -7.082000e-01 2.847300e-02
 1.146100e-02 -6.569500e-01 7.402200e-02 1.091300e-02 -5.589200e-01 1.188600e-01
 9.858200e-03 -4.158800e-01 1.599600e-01 8.388600e-03 -2.335100e-01 1.950200e-01
 6.676600e-03 -1.905300e-02 2.225800e-01 4.926500e-03 2.188700e-01 2.422200e-01
 3.152400e-03 4.720700e-01 2.548700e-01 2.401200e-03 7.338800e-01 2.611000e-01
 1.763100e-03 9.975300e-01 2.625400e-01 -1.013800e-04 1.000000e+00 -6.796000e-05
 0.000000e+00 0.000000e+00 0.000000e+00 1.866400e-03 -4.939100e-02 5.040700e-02
 2.063400e-03 -1.303700e-01 8.880600e-02 8.151000e-04 -2.428500e-01 1.104400e-01
 -1.533100e-03 -3.671600e-01 1.168100e-01 -4.000300e-03 -4.893200e-01 1.083900e-01
 -6.878000e-03 -5.945700e-01 8.700700e-02 -9.060600e-03 -6.722800e-01 5.574100e-02
 -1.029900e-02 -7.126600e-01 1.620800e-02 -1.162300e-02 -7.082300e-01 -2.845000e-02
 -1.133800e-02 -6.570200e-01 -7.400900e-02 -1.082100e-02 -5.589600e-01 -1.188900e-01
 -9.770400e-03 -4.159400e-01 -1.600500e-01 -8.329500e-03 -2.335400e-01 -1.951300e-01
 -6.664100e-03 -1.906300e-02 -2.227200e-01 -4.981200e-03 2.188700e-01 -2.423700e-01
 -3.289500e-03 4.721000e-01 -2.550300e-01 -2.637500e-03 7.339200e-01 -2.612700e-01
 -1.986600e-03 9.975900e-01 -2.626500e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -2.162200e-07 -4.944600e-02 -5.041900e-02
 7.048600e-05 -1.305500e-01 -8.860600e-02 -1.111700e-04 -2.425900e-01 -1.093800e-01
 3.784700e-04 -3.655000e-01 -1.153600e-01 4.415300e-04 -4.863100e-01 -1.070300e-01
 9.013600e-05 -5.905500e-01 -8.602500e-02 2.273700e-04 -6.670000e-01 -5.511200e-02
 7.058200e-04 -7.064500e-01 -1.548600e-02 3.060400e-04 -7.017800e-01 2.839200e-02
 2.866900e-04 -6.509700e-01 7.351100e-02 2.066100e-04 -5.535800e-01 1.186000e-01
 8.164500e-05 -4.110700e-01 1.594100e-01 -2.535200e-04 -2.295000e-01 1.942800e-01
 -6.710600e-04 -1.599300e-02 2.218600e-01 -1.050300e-03 2.207400e-01 2.413200e-01
 -1.267900e-03 4.730100e-01 2.537700e-01 -1.295400e-03 7.343600e-01 2.603200e-01
 -1.259600e-03 9.977800e-01 2.627800e-01 -1.838600e-04 9.967800e-01 -4.545400e-06
 0.000000e+00 0.000000e+00 0.000000e+00 1.211000e-05 -4.944500e-02 5.041800e-02
 -3.881000e-05 -1.305500e-01 8.860900e-02 1.800900e-04 -2.425900e-01 1.093900e-01
 -2.696100e-04 -3.655000e-01 1.153900e-01 -3.113600e-04 -4.863200e-01 1.070800e-01
 4.802200e-05 -5.905700e-01 8.608500e-02 -9.382800e-05 -6.670400e-01 5.517200e-02
 -5.517900e-04 -7.064800e-01 1.553600e-02 -1.148200e-04 -7.018200e-01 -2.834500e-02
 -6.451800e-05 -6.510200e-01 -7.349300e-02 2.061700e-05 -5.536400e-01 -1.186300e-01
 1.121600e-04 -4.111200e-01 -1.594900e-01 3.849300e-04 -2.295300e-01 -1.944100e-01
 7.214700e-04 -1.600400e-02 -2.220000e-01 9.946600e-04 2.207400e-01 -2.414900e-01
 1.093500e-03 4.730300e-01 -2.539300e-01 1.021700e-03 7.343700e-01 -2.605200e-01
 9.028700e-04 9.979600e-01 -2.633000e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 1.800400e-03 -4.926400e-02 -5.035000e-02
 1.933800e-03 -1.303500e-01 -8.899800e-02 7.558100e-04 -2.428300e-01 -1.102300e-01
 -1.730400e-03 -3.662500e-01 -1.162400e-01 -4.039900e-03 -4.882600e-01 -1.086700e-01
 -7.013000e-03 -5.944000e-01 -8.719900e-02 -8.810700e-03 -6.713800e-01 -5.512300e-02
 -1.049100e-02 -7.108600e-01 -1.611100e-02 -1.125800e-02 -7.070100e-01 2.808600e-02
 -1.148100e-02 -6.565100e-01 7.398100e-02 -1.049200e-02 -5.581200e-01 1.187300e-01
 -9.792700e-03 -4.151100e-01 1.595400e-01 -9.003000e-03 -2.337500e-01 1.943600e-01
 -8.058800e-03 -2.048500e-02 2.219100e-01 -7.012900e-03 2.163400e-01 2.417600e-01
 -5.807200e-03 4.692500e-01 2.548100e-01 -5.072600e-03 7.312300e-01 2.610200e-01
 -4.975600e-03 9.946000e-01 2.620100e-01 -2.597800e-04 9.982000e-01 -3.001800e-05
 0.000000e+00 0.000000e+00 0.000000e+00 -1.791300e-03 -4.926200e-02 5.034700e-02
 -1.909600e-03 -1.303500e-01 8.899700e-02 -7.102700e-04 -2.428300e-01 1.102400e-01
 1.824600e-03 -3.662400e-01 1.162800e-01 4.188200e-03 -4.882400e-01 1.087100e-01
 7.189500e-03 -5.944100e-01 8.723800e-02 8.993600e-03 -6.713700e-01 5.516100e-02
 1.071100e-02 -7.108800e-01 1.616000e-02 1.152100e-02 -7.070000e-01 -2.804400e-02
 1.183900e-02 -6.565400e-01 -7.393600e-02 1.089100e-02 -5.581400e-01 -1.187500e-01
 1.011800e-02 -4.151400e-01 -1.596300e-01 9.200500e-03 -2.337700e-01 -1.944400e-01
 8.152200e-03 -2.049600e-02 -2.220000e-01 6.977600e-03 2.163400e-01 -2.418600e-01
 5.585000e-03 4.692600e-01 -2.549600e-01 4.718400e-03 7.312100e-01 -2.611000e-01
 4.472400e-03 9.946000e-01 -2.619400e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 6.891600e-03 -4.738400e-02 -4.925000e-02
 7.161400e-03 -1.277100e-01 -9.016800e-02 3.121800e-03 -2.420300e-01 -1.129000e-01
 -2.687600e-03 -3.691400e-01 -1.194300e-01 -8.072300e-03 -4.947600e-01 -1.114400e-01
 -1.302200e-02 -6.042500e-01 -9.014300e-02 -1.844300e-02 -6.851800e-01 -5.817600e-02
 -2.268500e-02 -7.276300e-01 -1.758300e-02 -2.371700e-02 -7.247700e-01 2.767600e-02
 -2.368900e-02 -6.736000e-01 7.426500e-02 -2.297500e-02 -5.744800e-01 1.199300e-01
 -2.188300e-02 -4.305200e-01 1.606600e-01 -1.866300e-02 -2.474500e-01 1.959300e-01
 -1.535600e-02 -3.232000e-02 2.236800e-01 -1.207300e-02 2.066300e-01 2.434800e-01
 -9.026900e-03 4.614100e-01 2.555700e-01 -8.292400e-03 7.239800e-01 2.611500e-01
 -7.242800e-03 9.877800e-01 2.629300e-01 -3.021000e-04 9.860000e-01 3.476700e-05
 0.000000e+00 0.000000e+00 0.000000e+00 -6.883700e-03 -4.738100e-02 4.924300e-02
 -7.142100e-03 -1.277000e-01 9.015600e-02 -3.079500e-03 -2.420300e-01 1.128900e-01
 2.768700e-03 -3.691400e-01 1.194300e-01 8.486000e-03 -4.947700e-01 1.114400e-01
 1.316200e-02 -6.042500e-01 9.014200e-02 1.892800e-02 -6.851800e-01 5.817500e-02
 2.286000e-02 -7.276400e-01 1.758700e-02 2.444600e-02 -7.247800e-01 -2.766600e-02
 2.400400e-02 -6.736300e-01 -7.424200e-02 2.408200e-02 -5.745200e-01 -1.199200e-01
 2.219000e-02 -4.305500e-01 -1.606600e-01 1.904000e-02 -2.474700e-01 -1.959100e-01
 1.544300e-02 -3.233000e-02 -2.236400e-01 1.216400e-02 2.066200e-01 -2.434600e-01
 8.836400e-03 4.614300e-01 -2.555700e-01 7.152900e-03 7.240000e-01 -2.611100e-01
 6.821800e-03 9.877800e-01 -2.628500e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 5.176800e-06 -2.588500e-02 -5.580900e-06
 1.977800e-02 -3.692700e-02 -5.054400e-02 8.799100e-06 -1.143400e-01 -1.153000e-05
 1.524100e-02 -1.177700e-01 -8.917700e-02 1.213700e-05 -2.345700e-01 -2.090500e-05
 6.882000e-03 -2.375900e-01 -1.117700e-01 4.092000e-05 -3.736700e-01 -3.269900e-05
 -2.576600e-03 -3.722000e-01 -1.184500e-01 8.716200e-05 -5.067800e-01 -3.386100e-05
 -1.242300e-02 -5.048100e-01 -1.101800e-01 1.051100e-04 -6.241500e-01 -1.750400e-05
 -2.028800e-02 -6.205000e-01 -8.944700e-02 1.172300e-04 -7.136600e-01 -2.055700e-05
 -2.925200e-02 -7.087400e-01 -5.813100e-02 1.367800e-04 -7.661000e-01 -2.455300e-05
 -3.432100e-02 -7.566200e-01 -1.733100e-02 1.714400e-04 -7.617100e-01 -3.643900e-05
 -3.756000e-02 -7.553200e-01 2.835600e-02 2.369700e-04 -7.097200e-01 -3.863800e-05
 -3.619900e-02 -7.036700e-01 7.427100e-02 2.914300e-04 -6.102200e-01 1.997700e-05
 -3.617000e-02 -6.042400e-01 1.187800e-01 2.191200e-04 -4.680100e-01 7.115600e-05
 -3.347300e-02 -4.585300e-01 1.603500e-01 1.289700e-04 -2.754700e-01 8.164600e-05
 -2.847800e-02 -2.713400e-01 1.959200e-01 6.537000e-05 -5.502600e-02 8.730800e-05
 -2.264900e-02 -5.138200e-02 2.230700e-01 -6.301600e-06 1.892300e-01 1.102600e-04
 -1.698700e-02 1.923400e-01 2.433600e-01 -1.333700e-04 4.523900e-01 1.168100e-04
 -1.212900e-02 4.506200e-01 2.550900e-01 -2.642500e-04 7.131900e-01 8.953500e-05
 -9.213100e-03 7.148600e-01 2.612200e-01 -2.805500e-04 9.844900e-01 2.221500e-05
 -7.933000e-03 9.791800e-01 2.627900e-01 0.000000e+00 0.000000e+00 0.000000e+00
 -1.976800e-02 -3.692300e-02 5.053100e-02 -1.522300e-02 -1.177600e-01 8.915200e-02
 -6.854600e-03 -2.375900e-01 1.117300e-01 2.674300e-03 -3.722300e-01 1.183600e-01
 1.261200e-02 -5.048700e-01 1.101300e-01 2.051600e-02 -6.205200e-01 8.940600e-02
 2.949600e-02 -7.088000e-01 5.809300e-02 3.461300e-02 -7.566400e-01 1.726500e-02
 3.791900e-02 -7.554200e-01 -2.841800e-02 3.670100e-02 -7.037200e-01 -7.435100e-02
 3.676500e-02 -6.043500e-01 -1.187500e-01 3.392700e-02 -4.585800e-01 -1.601700e-01
 2.873000e-02 -2.713600e-01 -1.957700e-01 2.278600e-02 -5.139800e-02 -2.229000e-01
 1.698500e-02 1.923100e-01 -2.431600e-01 1.184100e-02 4.506500e-01 -2.547800e-01
 8.641800e-03 7.150200e-01 -2.610700e-01 7.316600e-03 9.792700e-01 -2.627900e-01

VECTORS mode8 float
 0.0 0.0 0.0
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00 0.000000e+00
 -6.850900e-04 1.131900e-01 -4.838000e-04 -3.533400e-02 1.260400e-01 6.314500e-02
 -5.096200e-02 8.419700e-02 6.382000e-02 -1.532600e-03 2.888500e-01 -7.648200e-04
 -1.012800e-01 2.897700e-01 9.690200e-02 -1.112700e-01 1.902300e-01 9.515600e-02
 -2.415500e-03 4.652500e-01 -8.931400e-04 -1.614200e-01 4.680000e-01 1.010500e-01
 -1.624200e-01 3.085600e-01 9.678100e-02 -4.346500e-03 6.263400e-01 1.661600e-03
 -2.175900e-01 6.249600e-01 8.391600e-02 -2.148700e-01 4.117400e-01 8.218100e-02
 -7.239800e-03 7.569500e-01 -5.494000e-04 -2.655700e-01 7.484800e-01 6.387200e-02
 -2.710500e-01 4.929100e-01 6.088600e-02 -4.554600e-03 8.292000e-01 7.871800e-04
 -2.836600e-01 8.255900e-01 3.516800e-02 -2.783400e-01 5.470700e-01 3.239600e-02
 -4.800800e-03 8.507600e-01 7.815300e-04 -2.841700e-01 8.448500e-01 -3.110600e-03
 -2.818700e-01 5.650100e-01 -2.949700e-03 -3.374700e-03 8.084300e-01 -1.512800e-03
 -2.676900e-01 8.050300e-01 -3.937400e-02 -2.641400e-01 5.415000e-01 -3.752900e-02
 -2.870900e-03 7.101500e-01 2.975600e-03 -2.319700e-01 7.085200e-01 -7.523400e-02
 -2.291500e-01 4.796700e-01 -7.106100e-02 -3.579100e-03 5.631100e-01 2.238100e-03
 -1.798700e-01 5.583300e-01 -1.057500e-01 -1.770600e-01 3.823200e-01 -1.008000e-01
 -2.456500e-03 3.687800e-01 9.296900e-04 -1.147600e-01 3.660300e-01 -1.303200e-01
 -1.119300e-01 2.547100e-01 -1.246500e-01 -1.974600e-03 1.426200e-01 2.522400e-03
 -3.996300e-02 1.413700e-01 -1.470700e-01 -3.767600e-02 1.041700e-01 -1.412400e-01
 -7.264900e-04 -9.993900e-02 4.038500e-03 3.970500e-02 -9.940100e-02 -1.534400e-01
 4.071400e-02 -5.941300e-02 -1.479900e-01 -6.846000e-06 -3.420400e-01 3.548000e-03
 1.201000e-01 -3.529400e-01 -1.499200e-01 1.171200e-01 -2.229600e-01 -1.450000e-01
 1.811800e-03 -5.632800e-01 2.989700e-03 1.849400e-01 -5.638900e-01 -1.385200e-01
 1.857400e-01 -3.806600e-01 -1.338600e-01 3.217900e-03 -7.604600e-01 4.379700e-03
 2.438800e-01 -7.562600e-01 -1.237500e-01 2.458700e-01 -5.175500e-01 -1.179200e-01
 4.587800e-03 -9.262000e-01 4.750700e-03 2.965600e-01 -9.507500e-01 -1.139500e-01
 2.901200e-01 -6.328000e-01 -1.071900e-01 6.194400e-03 -1.046200e+00 5.094400e-03
 2.960600e-01 -1.039800e+00 -1.099900e-01 3.000100e-01 -7.446100e-01 -1.024500e-01
 6.780000e-03 -7.614000e-01 3.544700e-03 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 3.407900e-02 1.263100e-01 -6.414200e-02
 4.983000e-02 8.423900e-02 -6.382800e-02 9.835100e-02 2.899400e-01 -9.826900e-02
 1.082300e-01 1.901800e-01 -9.503700e-02 1.561000e-01 4.674300e-01 -1.019600e-01
 1.573400e-01 3.082100e-01 -9.639200e-02 2.101400e-01 6.224400e-01 -8.744600e-02
 2.089800e-01 4.114600e-01 -8.210800e-02 2.643400e-01 7.780500e-01 -6.270900e-02
 2.497400e-01 4.884600e-01 -6.015600e-02 2.769100e-01 8.206000e-01 -3.211800e-02
 2.726200e-01 5.463600e-01 -3.231600e-02 2.879400e-01 8.756400e-01 4.032200e-03
 2.770700e-01 5.608700e-01 3.628400e-03 2.623500e-01 8.033400e-01 4.213600e-02
 2.592200e-01 5.409300e-01 3.948900e-02 2.265600e-01 7.061700e-01 7.700900e-02
 2.237400e-01 4.789200e-01 7.232400e-02 1.817100e-01 5.786100e-01 1.086700e-01
 1.733200e-01 3.796000e-01 1.028000e-01 1.112100e-01 3.648600e-01 1.349000e-01
 1.080800e-01 2.542900e-01 1.280600e-01 3.750800e-02 1.452700e-01 1.522700e-01
 3.417900e-02 1.031600e-01 1.443200e-01 -4.050300e-02 -1.009300e-01 1.597900e-01
 -4.236800e-02 -5.954400e-02 1.519100e-01 -1.147200e-01 -3.404300e-01 1.571600e-01
 -1.163900e-01 -2.244800e-01 1.494200e-01 -1.811200e-01 -5.654500e-01 1.468000e-01
 -1.831500e-01 -3.804800e-01 1.397100e-01 -2.381900e-01 -7.574700e-01 1.322200e-01
 -2.411000e-01 -5.174300e-01 1.237500e-01 -2.875200e-01 -9.507900e-01 1.233300e-01
 -2.825600e-01 -6.325500e-01 1.137600e-01 -2.843500e-01 -1.040900e+00 1.196700e-01
 -2.897100e-01 -7.441400e-01 1.093100e-01 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -5.919300e-02 3.836700e-02 3.022600e-02
 -1.114300e-01 8.773900e-02 4.536000e-02 -1.670100e-01 1.433900e-01 4.720400e-02
 -2.196200e-01 1.923500e-01 4.318900e-02 -2.590000e-01 2.316600e-01 3.186200e-02
 -2.827500e-01 2.603100e-01 1.722100e-02 -2.850300e-01 2.724400e-01 2.846000e-03
 -2.681900e-01 2.663700e-01 -1.401700e-02 -2.309300e-01 2.419100e-01 -3.162000e-02
 -1.781500e-01 1.988900e-01 -4.762300e-02 -1.116400e-01 1.397200e-01 -6.192800e-02
 -3.643600e-02 6.702600e-02 -7.289900e-02 4.218600e-02 -1.520000e-02 -7.937300e-02
 1.189500e-01 -1.018600e-01 -8.067200e-02 1.896400e-01 -1.869300e-01 -7.717400e-02
 2.506300e-01 -2.661400e-01 -7.210900e-02 2.980300e-01 -3.399000e-01 -6.855900e-02
 3.088100e-01 -4.096400e-01 -6.699900e-02 4.934100e-03 -4.130700e-01 2.420200e-03
 0.000000e+00 0.000000e+00 0.000000e+00 5.787400e-02 3.826200e-02 -2.990400e-02
 1.084100e-01 8.755400e-02 -4.460500e-02 1.623400e-01 1.431100e-01 -4.613700e-02
 2.124900e-01 1.918700e-01 -4.107300e-02 2.503100e-01 2.317500e-01 -3.119400e-02
 2.753700e-01 2.596000e-01 -1.782500e-02 2.788800e-01 2.718900e-01 -2.507100e-03
 2.625100e-01 2.654100e-01 1.441600e-02 2.257900e-01 2.413800e-01 3.235000e-02
 1.730900e-01 1.983800e-01 4.850800e-02 1.070700e-01 1.391500e-01 6.299900e-02
 3.273200e-02 6.683800e-02 7.409900e-02 -4.454200e-02 -1.515200e-02 8.092500e-02
 -1.195000e-01 -1.013600e-01 8.279400e-02 -1.878700e-01 -1.863600e-01 8.006000e-02
 -2.462200e-01 -2.653800e-01 7.566900e-02 -2.906900e-01 -3.390200e-01 7.263500e-02
 -2.988900e-01 -4.086300e-01 7.133500e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -6.051800e-02 -6.545300e-03 -5.592100e-03
 -1.120600e-01 -1.631300e-02 -8.085400e-03 -1.688500e-01 -2.694000e-02 -6.946500e-03
 -2.197500e-01 -3.329800e-02 -4.147200e-03 -2.595500e-01 -3.683300e-02 -7.718600e-05
 -2.837500e-01 -3.623000e-02 5.096500e-03 -2.844100e-01 -2.821400e-02 9.222200e-03
 -2.664300e-01 -1.509600e-02 1.286700e-02 -2.292500e-01 -3.370100e-04 1.365700e-02
 -1.752200e-01 1.354300e-02 1.137400e-02 -1.089500e-01 2.435700e-02 7.859800e-03
 -3.468600e-02 3.073100e-02 2.094300e-03 4.251200e-02 3.037900e-02 -4.151900e-03
 1.177500e-01 2.298900e-02 -9.943600e-03 1.874800e-01 9.525900e-03 -1.471300e-02
 2.495400e-01 -7.801000e-03 -1.671500e-02 3.040200e-01 -2.590500e-02 -1.722200e-02
 3.121900e-01 -4.377600e-02 -1.702700e-02 4.014300e-03 -4.507700e-02 5.619100e-04
 0.000000e+00 0.000000e+00 0.000000e+00 5.903000e-02 -6.713100e-03 5.997600e-03
 1.089600e-01 -1.650100e-02 8.959900e-03 1.641800e-01 -2.719200e-02 8.459800e-03
 2.139800e-01 -3.379800e-02 5.600000e-03 2.536600e-01 -3.765100e-02 1.167600e-03
 2.783100e-01 -3.684600e-02 -4.723900e-03 2.795200e-01 -2.879600e-02 -9.418200e-03
 2.618600e-01 -1.551400e-02 -1.307000e-02 2.248300e-01 -7.980200e-04 -1.393300e-02
 1.711400e-01 1.328400e-02 -1.168700e-02 1.051100e-01 2.415400e-02 -8.520300e-03
 3.114200e-02 3.072300e-02 -2.881400e-03 -4.545800e-02 3.062200e-02 3.377800e-03
 -1.195200e-01 2.339800e-02 9.708300e-03 -1.873600e-01 1.006000e-02 1.511000e-02
 -2.468700e-01 -7.292900e-03 1.787900e-02 -2.982600e-01 -2.506100e-02 1.906400e-02
 -3.038300e-01 -4.383600e-02 2.053400e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -6.003700e-02 -5.212400e-02 -4.114900e-02
 -1.126700e-01 -1.208300e-01 -6.301700e-02 -1.691600e-01 -1.975500e-01 -6.247200e-02
 -2.231600e-01 -2.610200e-01 -4.938900e-02 -2.599900e-01 -3.092900e-01 -3.311700e-02
 -2.846400e-01 -3.349200e-01 -7.969800e-03 -2.848800e-01 -3.276800e-01 1.875200e-02
 -2.693500e-01 -2.937400e-01 4.006500e-02 -2.297000e-01 -2.403100e-01 5.915500e-02
 -1.761700e-01 -1.693900e-01 7.179100e-02 -1.073000e-01 -8.757200e-02 7.748900e-02
 -3.348800e-02 -3.313800e-03 7.656100e-02 4.288000e-02 7.643300e-02 7.037700e-02
 1.195100e-01 1.470000e-01 5.997000e-02 1.869700e-01 2.009300e-01 4.840200e-02
 2.482600e-01 2.450000e-01 4.052900e-02 2.979400e-01 2.847900e-01 3.417300e-02
 3.057000e-01 3.166700e-01 2.921500e-02 3.627100e-03 3.257200e-01 -3.445400e-04
 0.000000e+00 0.000000e+00 0.000000e+00 5.847400e-02 -5.231000e-02 4.152200e-02
 1.094500e-01 -1.210000e-01 6.379300e-02 1.644100e-01 -1.976300e-01 6.367400e-02
 2.182800e-01 -2.609200e-01 5.145400e-02 2.559200e-01 -3.089900e-01 3.421400e-02
 2.812200e-01 -3.352800e-01 8.328800e-03 2.813800e-01 -3.271500e-01 -1.897300e-02
 2.658800e-01 -2.939300e-01 -4.086500e-02 2.259700e-01 -2.397500e-01 -5.991200e-02
 1.730000e-01 -1.695100e-01 -7.297200e-02 1.044500e-01 -8.754000e-02 -7.907300e-02
 3.013100e-02 -3.261200e-03 -7.915000e-02 -4.662200e-02 7.659900e-02 -7.262100e-02
 -1.227200e-01 1.474100e-01 -6.223400e-02 -1.886700e-01 2.012100e-01 -5.009500e-02
 -2.474900e-01 2.454200e-01 -4.191500e-02 -2.938300e-01 2.843000e-01 -3.473700e-02
 -2.985600e-01 3.162100e-01 -2.836000e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -5.241900e-02 -1.003500e-01 -7.663300e-02
 -1.101200e-01 -2.269600e-01 -1.134600e-01 -1.697700e-01 -3.691900e-01 -1.147600e-01
 -2.267100e-01 -4.909100e-01 -9.159600e-02 -2.610800e-01 -5.775200e-01 -5.884400e-02
 -2.799900e-01 -6.225400e-01 -1.964700e-02 -2.864700e-01 -6.232400e-01 2.190700e-02
 -2.753300e-01 -5.757700e-01 6.471600e-02 -2.316600e-01 -4.798500e-01 1.029400e-01
 -1.742300e-01 -3.484700e-01 1.272400e-01 -1.063900e-01 -1.971100e-01 1.425000e-01
 -3.305800e-02 -3.638700e-02 1.435900e-01 4.361700e-02 1.226200e-01 1.394600e-01
 1.186600e-01 2.699300e-01 1.241200e-01 1.898000e-01 3.953100e-01 1.038500e-01
 2.546300e-01 4.990800e-01 8.614800e-02 2.910100e-01 5.826300e-01 7.169100e-02
 3.059500e-01 6.533200e-01 6.702000e-02 2.961500e-03 6.450900e-01 -2.002900e-03
 0.000000e+00 0.000000e+00 0.000000e+00 5.088600e-02 -1.005600e-01 7.701200e-02
 1.066900e-01 -2.270400e-01 1.141800e-01 1.651400e-01 -3.691500e-01 1.157200e-01
 2.218200e-01 -4.909400e-01 9.280400e-02 2.680800e-01 -5.776200e-01 5.948700e-02
 2.755500e-01 -6.227400e-01 1.990300e-02 2.941900e-01 -6.233000e-01 -2.221300e-02
 2.707100e-01 -5.757600e-01 -6.535300e-02 2.354200e-01 -4.797700e-01 -1.038800e-01
 1.705200e-01 -3.484100e-01 -1.286000e-01 1.081000e-01 -1.971400e-01 -1.442500e-01
 2.979800e-02 -3.635800e-02 -1.462100e-01 -5.083500e-02 1.230400e-01 -1.424100e-01
 -1.215600e-01 2.703600e-01 -1.272300e-01 -1.984000e-01 3.956400e-01 -1.074900e-01
 -2.531300e-01 4.996100e-01 -9.003600e-02 -2.979100e-01 5.828100e-01 -7.536600e-02
 -2.970900e-01 6.531100e-01 -7.063100e-02 0.000000e+00 0.000000e+00 0.000000e+00
 0.000000e+00 0.000000e+00 0.000000e+00 -8.882900e-04 -1.257400e-01 6.167200e-04
 -3.323200e-02 -1.430800e-01 -7.802500e-02 -1.637600e-03 -3.378500e-01 8.286300e-04
 -1.036300e-01 -3.312300e-01 -1.157100e-01 -2.408900e-03 -5.348600e-01 5.522700e-04
 -1.736900e-01 -5.395700e-01 -1.196400e-01 -2.113100e-03 -7.422200e-01 -3.171900e-05
 -2.290100e-01 -7.191800e-01 -9.614600e-02 -9.364700e-04 -8.448800e-01 -3.591500e-04
 -2.704100e-01 -8.416500e-01 -5.811400e-02 -7.546800e-04 -9.056400e-01 1.063100e-04
 -2.839500e-01 -9.030800e-01 -2.092700e-02 -7.782800e-04 -9.177500e-01 -3.623600e-07
 -2.977200e-01 -9.144000e-01 1.848100e-02 -1.138000e-03 -8.853300e-01 -8.933200e-05
 -2.792400e-01 -8.563100e-01 6.724100e-02 -1.326300e-03 -7.169400e-01 -4.399400e-04
 -2.406300e-01 -7.161200e-01 1.101900e-01 -1.013800e-03 -5.226300e-01 -9.523000e-04
 -1.743300e-01 -5.226900e-01 1.326600e-01 -7.318400e-04 -3.047500e-01 -6.554900e-04
 -1.081300e-01 -3.034500e-01 1.471100e-01 -1.514000e-03 -7.074300e-02 -7.564900e-04
 -3.242100e-02 -6.809900e-02 1.514000e-01 -2.113700e-03 1.715100e-01 -1.268200e-03
 4.605400e-02 1.687500e-01 1.456300e-01 -2.123500e-03 3.906700e-01 -1.835600e-03
 1.190500e-01 3.911900e-01 1.301100e-01 -1.767800e-03 5.893400e-01 -2.636800e-03
 1.958700e-01 5.916600e-01 1.148800e-01 -2.701400e-04 7.903900e-01 -3.509100e-03
 2.574000e-01 7.554500e-01 9.069700e-02 1.308300e-03 8.656600e-01 -3.695800e-03
 2.941900e-01 8.749100e-01 7.973000e-02 3.350800e-03 1.000000e+00 -4.050200e-03
 3.050200e-01 9.645800e-01 7.822700e-02 0.000000e+00 0.000000e+00 0.000000e+00
 3.149600e-02 -1.434100e-01 7.927300e-02 1.002900e-01 -3.311400e-01 1.172400e-01
 1.688100e-01 -5.394200e-01 1.207500e-01 2.252600e-01 -7.199600e-01 9.507600e-02
 2.689700e-01 -8.435900e-01 5.795100e-02 2.830900e-01 -9.038200e-01 2.097800e-02
 2.966300e-01 -9.166500e-01 -1.848900e-02 2.774900e-01 -8.567100e-01 -6.712600e-02
 2.383500e-01 -7.177300e-01 -1.112200e-01 1.725900e-01 -5.229300e-01 -1.340300e-01
 1.067400e-01 -3.039700e-01 -1.488100e-01 2.946700e-02 -6.797700e-02 -1.523000e-01
 -5.046400e-02 1.695200e-01 -1.484100e-01 -1.235500e-01 3.918800e-01 -1.337200e-01
 -1.994000e-01 5.927800e-01 -1.203200e-01 -2.585600e-01 7.563500e-01 -9.703000e-02
 -2.922700e-01 8.774600e-01 -8.742600e-02 -2.987700e-01 9.658700e-01 -8.830600e-02
}
plate SetVectorsName "mode8";

vtkWarpVector warp;
    warp SetInput [plate GetOutput];
    warp SetScaleFactor 0.5;
vtkGeometryFilter ds2poly;
    ds2poly SetInput [warp GetOutput];
vtkCleanPolyData clean;
    clean SetInput [ds2poly GetOutput];
vtkPolyNormals normals;
    normals SetInput [clean GetOutput];
vtkVectorDot color;
    color SetInput [normals GetOutput];
vtkLookupTable lut;
    lut SetNumberOfColors 256;
    lut Build;
    for {set i 0} {$i<128} {incr i 1} {
        eval lut SetTableValue $i [expr (128.0-$i)/128.0] [expr (128.0-$i)/128.0] [expr (128.0-$i)/128.0] 1;
    }
    for {set i 128} {$i<256} {incr i 1} {
        eval lut SetTableValue $i [expr ($i-128.0)/128.0] [expr ($i-128.0)/128.0] [expr ($i-128.0)/128.0] 1;
    }

vtkDataSetMapper plateMapper;
    plateMapper SetInput [color GetOutput];
    plateMapper SetLookupTable lut;
    plateMapper SetScalarRange -1 1;
vtkActor plateActor;
    plateActor SetMapper plateMapper;

# Add the actors to the renderer, set the background and size
#
$ren1 AddActors plateActor;
$ren1 SetBackground 1 1 1;
$renWin SetSize 500 500;

# render the image
#
$iren SetUserMethod {wm deiconify .vtkInteract};
$iren Initialize;
$renWin Render;

#$renWin SetFileName InputStr.tcl.ppm;
#$renWin SaveImageAsPPM;

# prevent the tk window from showing up then start the event loop
wm withdraw .


