/*=========================================================================

  Program:   Visualization Library
  Module:    CScalars.hh
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

This file is part of the Visualization Library. No part of this file
or its contents may be copied, reproduced or altered in any way
without the express written consent of the authors.

Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen 1993, 1994 

=========================================================================*/
// .NAME vlCharScalars - unsigned char representation of scalar data
// .SECTION Description
// vlCharScalars is a concrete implementation of vlScalars. Scalars are
// represented using char values.

#ifndef __vlCharScalars_h
#define __vlCharScalars_h

#include "Scalars.hh"
#include "CArray.hh"

class vlCharScalars : public vlScalars 
{
public:
  vlCharScalars() {};
  vlCharScalars(const vlCharScalars& cs) {this->S = cs.S;};
  vlCharScalars(const int sz, const int ext=1000):S(sz,ext){};
  ~vlCharScalars() {};
  int Allocate(const int sz, const int ext=1000) {return this->S.Allocate(sz,ext);};
  void Initialize() {this->S.Initialize();};
  char *GetClassName() {return "vlCharScalars";};

  // vlScalar interface
  vlScalars *MakeObject(int sze, int ext=1000);
  int GetNumberOfScalars() {return (this->S.GetMaxId()+1);};
  void Squeeze() {this->S.Squeeze();};
  float GetScalar(int i) {return (float)this->S[i];};
  void SetScalar(int i, char s) {this->S[i] = s;};
  void SetScalar(int i, float s) {this->S[i] = (char)s;};
  void InsertScalar(int i, float s) {S.InsertValue(i,(char)s);};
  void InsertScalar(int i, char s) {S.InsertValue(i,s);};
  int InsertNextScalar(char s) {return S.InsertNextValue(s);};
  int InsertNextScalar(float s) {return S.InsertNextValue((char)s);};

  // miscellaneous
  vlCharScalars &operator=(const vlCharScalars& cs);
  void operator+=(const vlCharScalars& cs) {this->S += cs.S;};
  void Reset() {this->S.Reset();};

protected:
  vlCharArray S;
};

#endif
