/*=========================================================================

  Program:   Visualization Library
  Module:    StreamL.hh
  Language:  C++
  Date:      $Date$
  Version:   $Revision$

Description:
---------------------------------------------------------------------------
This file is part of the Visualization Library. No part of this file
or its contents may be copied, reproduced or altered in any way
without the express written consent of the authors.

Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen 1993, 1994 

=========================================================================*/
//
// Extracts geometry connected at common vertices.
//
#ifndef __vlStreamLine_h
#define __vlStreamLine_h

#include "DS2PolyF.hh"

#define INTEGRATE_FORWARD 0
#define INTEGRATE_BACKWARD 1
#define INTEGRATE_BOTH_DIRECTIONS 2

class vlStreamLine : public vlDataSetToPolyFilter
{
public:
  vlStreamLine();
  ~vlStreamLine() {};
  char *GetClassName() {return "vlStreamLine";};
  void PrintSelf(ostream& os, vlIndent indent);

  void SetStartLocation(int cellId, int subId, float pcoords[3]);
  int GetStartLocation(int& subId, float pcoords[3]);

  void SetStartPosition(float x[3]);
  float *GetStartPosition();

  vlSetClampMacro(MaximumPropagationTime,float,0.0,LARGE_FLOAT);
  vlGetMacro(MaximumPropagationTime,float);

  vlSetClampMacro(MaximumSteps,int,1,LARGE_INTEGER);
  vlGetMacro(MaximumSteps,int);

  vlSetClampMacro(IntegrationDirection,int,
                  INTEGRATE_FORWARD,INTEGRATE_BOTH_DIRECTIONS);
  vlGetMacro(IntegrationDirection,int);

  vlSetClampMacro(IntegrationStepLength,float,0.001,0.5);
  vlGetMacro(IntegrationStepLength,float);

  vlSetClampMacro(RepresentationStepLength,float,0.0001,0.1);
  vlGetMacro(RepresentationStepLength,float);
 
  vlSetMacro(Vorticity,int);
  vlGetMacro(Vorticity,int);
  vlBooleanMacro(Vorticity,int);

  vlSetClampMacro(DashTime,float,0.0,LARGE_FLOAT);
  vlGetMacro(DashTime,float);

  vlSetClampMacro(DashFactor,float,0.0,1.0);
  vlGetMacro(DashFactor,float);

protected:
  // Usual data generation method
  void Execute();

  // Starting from cell location
  int StartCell;
  int StartSubId;
  float StartPCoords[3];

  // starting from global x-y-z position
  float StartPosition[3];

  // length of streamline is generated by time, or by MaximumSteps
  float MaximumPropagationTime;

  // MaximumSteps prevents "nearly" infinite loops
  int MaximumSteps;

  // integration direction
  int IntegrationDirection;

  // the length (fraction of cell size) of integration steps
  float IntegrationStepLength;

  // the length of line segments used to represent stream line (expressed
  // as fraction of bounding box of input)
  float RepresentationStepLength;

  // boolean controls whether vorticity is computed
  int Vorticity;

  // the combined length of on/off portion of dash
  float DashTime;

  // the fraction of on versus off in dash
  float DashFactor;
  
};

#endif


