enable_language(C)

get_property(_multi_config GLOBAL PROPERTY GENERATOR_IS_MULTI_CONFIG)

function(assert_prop_eq tgt prop value)
  unset(actual_value)
  get_property(actual_value TARGET ${tgt} PROPERTY ${prop})
  if(NOT actual_value STREQUAL value)
    message(SEND_ERROR "Expected value of ${prop}:\n  ${value}\nActual value:\n  ${actual_value}")
  endif()
endfunction()

get_filename_component(export_build_dir "${CMAKE_BINARY_DIR}" DIRECTORY)
string(APPEND export_build_dir "/FileSetExport-build")

include("${export_build_dir}/export.cmake")
include("${export_build_dir}/install/lib/cmake/export.cmake")

assert_prop_eq(export::lib1 HEADER_SETS "")
assert_prop_eq(export::lib1 INTERFACE_HEADER_SETS "HEADERS;b;c;d;dir3;e;f;g")
assert_prop_eq(export::lib1 HEADER_SET "${CMAKE_CURRENT_SOURCE_DIR}/error.c")
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_DIRS "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}")
else ()
  assert_prop_eq(export::lib1 HEADER_DIRS "${CMAKE_CURRENT_SOURCE_DIR}")
endif ()
assert_prop_eq(export::lib1 HEADER_SET_b "${CMAKE_CURRENT_SOURCE_DIR}/h2.h")
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_DIRS_b "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}")
else ()
  assert_prop_eq(export::lib1 HEADER_DIRS_b "${CMAKE_CURRENT_SOURCE_DIR}")
endif ()
assert_prop_eq(export::lib1 HEADER_SET_c "${CMAKE_CURRENT_SOURCE_DIR}/dir/dir.h")
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_DIRS_c "${CMAKE_CURRENT_SOURCE_DIR}/dir;${CMAKE_CURRENT_SOURCE_DIR}/dir")
else ()
  assert_prop_eq(export::lib1 HEADER_DIRS_c "${CMAKE_CURRENT_SOURCE_DIR}/dir")
endif ()
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_SET_d "$<$<CONFIG:Debug>:${CMAKE_CURRENT_SOURCE_DIR}/debug/empty.h>;$<$<CONFIG:Release>:${CMAKE_CURRENT_SOURCE_DIR}/release/empty.h>")
  assert_prop_eq(export::lib1 HEADER_DIRS_d "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}")
else ()
  assert_prop_eq(export::lib1 HEADER_SET_d "${CMAKE_CURRENT_SOURCE_DIR}/debug/empty.h")
  assert_prop_eq(export::lib1 HEADER_DIRS_d "${CMAKE_CURRENT_SOURCE_DIR}")
endif ()
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_SET_e "$<$<CONFIG:Debug>:${CMAKE_CURRENT_SOURCE_DIR}/debug/empty2.h>;$<$<CONFIG:Release>:${CMAKE_CURRENT_SOURCE_DIR}/release/empty2.h>")
  assert_prop_eq(export::lib1 HEADER_DIRS_e "$<$<CONFIG:Debug>:${CMAKE_CURRENT_SOURCE_DIR}/debug>;$<$<CONFIG:Release>:${CMAKE_CURRENT_SOURCE_DIR}/release>")
else ()
  assert_prop_eq(export::lib1 HEADER_SET_e "${CMAKE_CURRENT_SOURCE_DIR}/debug/empty2.h")
  assert_prop_eq(export::lib1 HEADER_DIRS_e "${CMAKE_CURRENT_SOURCE_DIR}/debug")
endif ()
assert_prop_eq(export::lib1 HEADER_SET_f "${CMAKE_CURRENT_SOURCE_DIR}/empty3.h")
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_DIRS_f "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}")
else ()
  assert_prop_eq(export::lib1 HEADER_DIRS_f "${CMAKE_CURRENT_SOURCE_DIR}")
endif ()
assert_prop_eq(export::lib1 HEADER_SET_g "${CMAKE_CURRENT_SOURCE_DIR}/dir1/file1.h;${CMAKE_CURRENT_SOURCE_DIR}/dir2/file2.h")
if (_multi_config)
  assert_prop_eq(export::lib1 HEADER_DIRS_g "${CMAKE_CURRENT_SOURCE_DIR}/dir1;${CMAKE_CURRENT_SOURCE_DIR}/dir1")
else ()
  assert_prop_eq(export::lib1 HEADER_DIRS_g "${CMAKE_CURRENT_SOURCE_DIR}/dir1")
endif ()
if (_multi_config)
  assert_prop_eq(export::lib1 INTERFACE_INCLUDE_DIRECTORIES "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR};$<1:${CMAKE_CURRENT_SOURCE_DIR}/dir>;${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}/$<IF:$<CONFIG:Debug>,debug,release>;${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}/dir1;${CMAKE_CURRENT_SOURCE_DIR}/dir2;${CMAKE_CURRENT_SOURCE_DIR}/dir3;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:$<$<CONFIG:Debug>:${CMAKE_CURRENT_SOURCE_DIR}/debug>>;$<BUILD_INTERFACE:$<$<CONFIG:Release>:${CMAKE_CURRENT_SOURCE_DIR}/release>>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir1>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir1>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir3>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir3>")
else ()
  assert_prop_eq(export::lib1 INTERFACE_INCLUDE_DIRECTORIES "${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR};$<1:${CMAKE_CURRENT_SOURCE_DIR}/dir>;${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}/$<IF:$<CONFIG:Debug>,debug,release>;${CMAKE_CURRENT_SOURCE_DIR};${CMAKE_CURRENT_SOURCE_DIR}/dir1;${CMAKE_CURRENT_SOURCE_DIR}/dir2;${CMAKE_CURRENT_SOURCE_DIR}/dir3;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/debug>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir1>;$<BUILD_INTERFACE:${CMAKE_CURRENT_SOURCE_DIR}/dir3>")
endif ()

assert_prop_eq(install::lib1 HEADER_SETS "")
assert_prop_eq(install::lib1 INTERFACE_HEADER_SETS "HEADERS;b;c;d;dir3;e;f;g")
assert_prop_eq(install::lib1 HEADER_SET "${export_build_dir}/install/include/error.c")
assert_prop_eq(install::lib1 HEADER_DIRS "${export_build_dir}/install/include")
assert_prop_eq(install::lib1 HEADER_SET_b "${export_build_dir}/install/include/h2.h")
assert_prop_eq(install::lib1 HEADER_DIRS_b "${export_build_dir}/install/include")
assert_prop_eq(install::lib1 HEADER_SET_c "${export_build_dir}/install/include/dir/dir.h")
assert_prop_eq(install::lib1 HEADER_DIRS_c "${export_build_dir}/install/include/dir")
if(_multi_config)
  assert_prop_eq(install::lib1 HEADER_SET_d "$<$<CONFIG:Debug>:${export_build_dir}/install/include/debug/empty.h>;$<$<CONFIG:Release>:${export_build_dir}/install/include/release/empty.h>")
else()
  assert_prop_eq(install::lib1 HEADER_SET_d "${export_build_dir}/install/include/debug/empty.h")
endif()
assert_prop_eq(install::lib1 HEADER_DIRS_d "${export_build_dir}/install/include")
if(_multi_config)
  assert_prop_eq(install::lib1 HEADER_SET_e "$<$<CONFIG:Debug>:${export_build_dir}/install/include/empty2.h>;$<$<CONFIG:Release>:${export_build_dir}/install/include/empty2.h>")
else()
  assert_prop_eq(install::lib1 HEADER_SET_e "${export_build_dir}/install/include/empty2.h")
endif()
assert_prop_eq(install::lib1 HEADER_DIRS_e "${export_build_dir}/install/include")
if(_multi_config)
  assert_prop_eq(install::lib1 HEADER_SET_f "$<$<CONFIG:Debug>:${export_build_dir}/install/include/debug/empty3.h>;$<$<CONFIG:Release>:${export_build_dir}/install/include/release/empty3.h>")
  assert_prop_eq(install::lib1 HEADER_DIRS_f "$<$<CONFIG:Debug>:${export_build_dir}/install/include/debug>;$<$<CONFIG:Release>:${export_build_dir}/install/include/release>")
else()
  assert_prop_eq(install::lib1 HEADER_SET_f "${export_build_dir}/install/include/debug/empty3.h")
  assert_prop_eq(install::lib1 HEADER_DIRS_f "${export_build_dir}/install/include/debug")
endif()
assert_prop_eq(install::lib1 HEADER_SET_g "${export_build_dir}/install/include/file1.h;${export_build_dir}/install/include/file2.h")
assert_prop_eq(install::lib1 HEADER_DIRS_g "${export_build_dir}/install/include")
if(_multi_config)
  assert_prop_eq(install::lib1 INTERFACE_INCLUDE_DIRECTORIES "$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include/dir>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:$<$<CONFIG:Debug>:${export_build_dir}/install/include/debug>>;$<BUILD_INTERFACE:$<$<CONFIG:Release>:${export_build_dir}/install/include/release>>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include/dir3>")
else()
  assert_prop_eq(install::lib1 INTERFACE_INCLUDE_DIRECTORIES "$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include/dir>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include/debug>;$<BUILD_INTERFACE:${export_build_dir}/install/include>;$<BUILD_INTERFACE:${export_build_dir}/install/include/dir3>")
endif()

file(GLOB_RECURSE actual
  LIST_DIRECTORIES TRUE
  RELATIVE "${CMAKE_BINARY_DIR}/../FileSetExport-build/install/include"
  "${CMAKE_BINARY_DIR}/../FileSetExport-build/install/include/*"
  )
if(actual)
  list(SORT actual)
endif()
if(_multi_config)
  set(expect "^debug;debug/empty\\.h;debug/empty3\\.h;dir;dir/dir\\.h;dir3;dir3/dir3\.h;empty2\\.h;error\\.c;file1\\.h;file2\\.h;h2\\.h;release;release/empty\\.h;release/empty3\\.h$")
else()
  set(expect "^debug;debug/empty\\.h;debug/empty3\\.h;dir;dir/dir\\.h;dir3;dir3/dir3\.h;empty2\\.h;error\\.c;file1\\.h;file2\\.h;h2\\.h$")
endif()
if(NOT "${actual}" MATCHES "${expect}")
  message(SEND_ERROR "Installed files:
  ${actual}
do not match what we expected:
  ${expect}
in directory:
  ${CMAKE_INSTALL_PREFIX}")
endif()

add_library(lib2_export STATIC lib2.c)
target_link_libraries(lib2_export PRIVATE export::lib1)
add_library(lib2_install STATIC lib2.c)
target_link_libraries(lib2_install PRIVATE install::lib1)
