/*============================================================================
  CMake - Cross Platform Makefile Generator
  Copyright 2000-2009 Kitware, Inc., Insight Software Consortium

  Distributed under the OSI-approved BSD License (the "License");
  see accompanying file Copyright.txt for details.

  This software is distributed WITHOUT ANY WARRANTY; without even the
  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the License for more information.
============================================================================*/
#pragma once

#include "cmConfigure.h" // IWYU pragma: keep

#include "cmGlobalFASTBuildGenerator.h"
#include "cmLocalCommonGenerator.h"

class cmSourceFile;

/** \class cmLocalFASTBuildGenerator
 * \brief Create required FASTBuild build files for a directory
 *
 * Here, it does not generate anything, it populates structures into
 * the global generator since all is writen into only one general file.
 */
class cmLocalFASTBuildGenerator : public cmLocalCommonGenerator
{
public:
  /// Constructor
  cmLocalFASTBuildGenerator(cmGlobalGenerator* gg, cmMakefile* makefile);

  /// Destructor
  ~cmLocalFASTBuildGenerator() override;

  /// Override to create all target structures, 'all' and 'noop' targets.
  void Generate() override;

  /// Override to replace double dollars "$$" but now commented out.
  /// Should be removed if not needed since this is now the same as initial impl.
  void AppendFlagEscape(std::string& flags,
                        const std::string& rawFlag) const override;

  /**
   * @brief Get the relative path from the generator output directory to a per-target support directory.
   * Must be redefined from @see cmLocalGenerator
   */
  std::string GetTargetDirectory(const cmGeneratorTarget* gt) const override;

  /// Overriden since it was needed when initial generator was written years ago.
  /// Can be removed to use the override in cmLocalCommonGenerator as Ninja and Makefiles.
  /// Moreover, override in cmLocalCommonGenerator handles custom extension.
  void ComputeObjectFilenames(
    std::map<cmSourceFile const*, std::string>& mapping,
    cmGeneratorTarget const* gt) override;

  //@{
  /***
   * Get associated global generator
   */
  const cmGlobalFASTBuildGenerator* GetGlobalFASTBuildGenerator() const;
  cmGlobalFASTBuildGenerator* GetGlobalFASTBuildGenerator();
  //@}

  /// Populate a target to the global generator and add dependency to all is not excluded.
  void AddTarget(const cmGlobalFASTBuildGenerator::FASTBuildTarget& target);

private:
  /// All targets that are included by all.
  std::map<std::string, std::vector<std::string>> AllTargets;
};
