##============================================================================
##  Copyright (c) Kitware, Inc.
##  All rights reserved.
##  See LICENSE.txt for details.
##  This software is distributed WITHOUT ANY WARRANTY; without even
##  the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
##  PURPOSE.  See the above copyright notice for more information.
##
##  Copyright 2014 Sandia Corporation.
##  Copyright 2014 UT-Battelle, LLC.
##  Copyright 2014 Los Alamos National Security.
##
##  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
##  the U.S. Government retains certain rights in this software.
##
##  Under the terms of Contract DE-AC52-06NA25396 with Los Alamos National
##  Laboratory (LANL), the U.S. Government retains certain rights in
##  this software.
##============================================================================

if (VTKm_OpenMP_initialize_complete)
  return()
endif (VTKm_OpenMP_initialize_complete)

#-----------------------------------------------------------------------------
# Find OpenMP.
#-----------------------------------------------------------------------------
if (NOT VTKm_OpenMP_FOUND)
  find_package(OpenMP REQUIRED)
  set (VTKm_OpenMP_FOUND ${OPENMP_FOUND})
endif()

#-----------------------------------------------------------------------------
# Set up all these dependent packages (if they were all found).
#-----------------------------------------------------------------------------
if (VTKm_OpenMP_FOUND)
  include_directories(
    ${VTKm_INCLUDE_DIRS}
  )
  set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${OpenMP_CXX_FLAGS}")
  set(VTKm_OpenMP_initialize_complete TRUE)
endif()

