/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.parser.x3d;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.web3d.parser.x3d.ParseException;
import org.web3d.parser.x3d.X3DRelaxedParser;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.parser.BaseReader;
import org.web3d.vrml.parser.VRMLParserUtils;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.Locator;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.SAVException;
import org.web3d.vrml.sav.SAVNotSupportedException;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.web3d.x3d.jaxp.X3DErrorHandler;
import org.web3d.x3d.jaxp.X3DSAVAdapter;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class X3DReader
extends BaseReader {
    private static final String NAMESPACE_PROP = "useNamespaces";
    private static final String LEXICAL_HANDLER_PROP = "http://xml.org/sax/properties/lexical-handler";
    private X3DRelaxedParser relaxedParser;
    private SAXParserFactory parserFactory;
    private X3DSAVAdapter adapter;
    private X3DEntityResolver resolver;
    private X3DErrorHandler x3dErrors;

    public X3DReader() {
        this.properties.put(NAMESPACE_PROP, Boolean.FALSE);
        try {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new org.web3d.vrml.parser.FactoryConfigurationError("No SAX parser defined");
        }
        this.adapter = new X3DSAVAdapter();
        this.x3dErrors = new X3DErrorHandler();
        this.resolver = new X3DEntityResolver();
    }

    public void parse(InputSource inputSource) throws IOException, VRMLException {
        block18: {
            PushbackReader pushbackReader = new PushbackReader(inputSource.getCharacterStream());
            boolean bl = false;
            boolean bl2 = false;
            int n = 0;
            block10: while (!bl) {
                n = pushbackReader.read();
                switch (n) {
                    case 60: {
                        bl2 = true;
                        bl = true;
                        continue block10;
                    }
                    case 35: {
                        bl2 = false;
                        bl = true;
                        continue block10;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        continue block10;
                    }
                }
                bl = true;
            }
            pushbackReader.unread(n);
            String string = (String)this.properties.get("conformance");
            if (bl2) {
                Object object;
                boolean bl3 = string.equals("weak");
                Boolean bl4 = (Boolean)this.properties.get(NAMESPACE_PROP);
                this.parserFactory.setValidating(!bl3);
                this.parserFactory.setNamespaceAware(bl4);
                XMLReader xMLReader = null;
                try {
                    object = this.parserFactory.newSAXParser();
                    xMLReader = ((SAXParser)object).getXMLReader();
                    xMLReader.setContentHandler(this.adapter);
                    xMLReader.setProperty(LEXICAL_HANDLER_PROP, this.adapter);
                    xMLReader.setErrorHandler(this.x3dErrors);
                    xMLReader.setEntityResolver(this.resolver);
                }
                catch (Exception exception) {
                    throw new IOException("Unable to configure factory as required");
                }
                object = new org.xml.sax.InputSource();
                ((org.xml.sax.InputSource)object).setCharacterStream(pushbackReader);
                ((org.xml.sax.InputSource)object).setEncoding(inputSource.getEncoding());
                try {
                    xMLReader.parse((org.xml.sax.InputSource)object);
                }
                catch (SAXException sAXException) {
                    Exception exception = sAXException.getException();
                    if (exception != null) {
                        this.errorReporter.errorReport("Error parsing XML", exception);
                        break block18;
                    }
                    this.errorReporter.errorReport("Error parsing XML", sAXException);
                }
                catch (VRMLException vRMLException) {
                    this.errorReporter.errorReport("Error parsing XML", vRMLException);
                }
            } else {
                String string2 = inputSource.getBaseURL();
                String string3 = inputSource.getURL();
                if (string3 == null) {
                    string3 = "Unknown URL source. Base URL is " + string2;
                }
                if (string.equals("weak")) {
                    this.parseVRMLWeakly(pushbackReader, string2, string3);
                } else if (string.equals("strict")) {
                    this.parseVRMLStrictly(pushbackReader, string2, string3);
                }
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        this.x3dErrors.setErrorReporter(errorReporter);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        super.setContentHandler(contentHandler);
        this.adapter.setContentHandler(contentHandler);
    }

    public void setScriptHandler(ScriptHandler scriptHandler) {
        super.setScriptHandler(scriptHandler);
        this.adapter.setScriptHandler(scriptHandler);
    }

    public void setProtoHandler(ProtoHandler protoHandler) {
        super.setProtoHandler(protoHandler);
        this.adapter.setProtoHandler(protoHandler);
    }

    public void setRouteHandler(RouteHandler routeHandler) {
        super.setRouteHandler(routeHandler);
        this.adapter.setRouteHandler(routeHandler);
    }

    private void parseVRMLWeakly(Reader reader, String string, String string2) throws IOException, VRMLException {
        String[] stringArray;
        if (!this.ignoreHeader) {
            stringArray = VRMLParserUtils.parseFileHeader(reader);
            if (stringArray.length != 4) {
                throw new VRMLParseException(1, 1, "Header missing #X3D statement");
            }
            if (!stringArray[0].equals("#X3D")) {
                throw new VRMLParseException(1, 1, "Invalid header. Not a X3D file.");
            }
            if (stringArray[1] == null || !stringArray[1].equals("V3.0") && !stringArray[1].equals("V3.1")) {
                throw new VRMLParseException(1, 1, "Unsupported version " + stringArray[1]);
            }
            if (stringArray[2] == null || !stringArray[2].equals("utf8")) {
                throw new VRMLParseException(1, 1, "Unsupported encoding " + stringArray[2]);
            }
        } else {
            stringArray = new String[4];
            stringArray[0] = "#X3D";
            stringArray[1] = "V3.0";
            stringArray[2] = "utf8";
        }
        if (this.relaxedParser == null) {
            this.relaxedParser = new X3DRelaxedParser(reader);
            this.relaxedParser.initialize();
        } else {
            this.relaxedParser.ReInit(reader);
        }
        this.relaxedParser.setContentHandler(this.contentHandler);
        this.relaxedParser.setRouteHandler(this.routeHandler);
        this.relaxedParser.setScriptHandler(this.scriptHandler);
        this.relaxedParser.setProtoHandler(this.protoHandler);
        this.relaxedParser.setErrorReporter(this.errorReporter);
        this.relaxedParser.setDocumentUrl(string2);
        Locator locator = this.relaxedParser.getDocumentLocator();
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
            this.contentHandler.startDocument(string2, string, stringArray[2], stringArray[0], stringArray[1], stringArray[3]);
        }
        try {
            this.relaxedParser.Scene();
            if (this.contentHandler != null) {
                this.contentHandler.endDocument();
            }
        }
        catch (ParseException parseException) {
            throw new VRMLParseException(locator.getLineNumber(), locator.getColumnNumber(), parseException.getMessage());
        }
    }

    private void parseVRMLStrictly(Reader reader, String string, String string2) throws IOException, SAVException {
        throw new SAVNotSupportedException("Strict parsing not implemented yet");
    }
}

