#
# clip a textured plane
#

catch {load vtktcl}
if { [catch {set VTK_TCL $env(VTK_TCL)}] != 0} { set VTK_TCL "../../examplesTcl" }
if { [catch {set VTK_DATA $env(VTK_DATA)}] != 0} { set VTK_DATA "../../../vtkdata" }


# get the interactor ui
source $VTK_TCL/vtkInt.tcl

# Create the RenderWindow, Renderer and both Actors
vtkRenderer ren1
vtkRenderWindow renWin
    renWin AddRenderer ren1
vtkRenderWindowInteractor iren
    iren SetRenderWindow renWin

# Create a plane source
vtkPlaneSource plane

vtkTransform aTransform
  aTransform RotateX 30
  aTransform RotateY 30

vtkTransformPolyDataFilter transformPlane
  transformPlane SetInput [plane GetOutput]
  transformPlane SetTransform aTransform

vtkPlane clipPlane1
  clipPlane1 SetNormal  0 0 1

vtkDataSetMapper  planeMapper
  planeMapper SetInput [transformPlane GetOutput]
  planeMapper AddClippingPlane clipPlane1

vtkActor planeActor
  planeActor SetMapper planeMapper

vtkDataSetMapper  plane2Mapper
  plane2Mapper SetInput [plane GetOutput]

vtkActor plane2Actor
  plane2Actor SetMapper plane2Mapper


# load in the texture map
#
vtkTexture atext
vtkPNMReader pnmReader
  pnmReader SetFileName "$VTK_DATA/masonry.ppm"

atext SetInput [pnmReader GetOutput]
atext InterpolateOn
planeActor SetTexture atext

# Add the actors to the renderer, set the background and size
ren1 AddActor planeActor
ren1 AddActor plane2Actor
ren1 SetBackground 0.1 0.2 0.4
renWin SetSize 500 500

# render the image
iren Initialize
iren SetUserMethod {wm deiconify .vtkInteract}

renWin Render

set cam1 [ren1 GetActiveCamera]
$cam1 Elevation -30
$cam1 Roll -20
renWin Render

#renWin SetFileName "clipTexPlane.tcl.ppm"
#renWin SaveImageAsPPM

# prevent the tk window from showing up then start the event loop
wm withdraw .





