/*=========================================================================

  Program:   Visualization Toolkit
  Module:    vtkPLYReader.h
  Language:  C++
  Date:      $Date$
  Version:   $Revision$
  Thanks:    Mike Dresser MD/PhD
             Director of Core Facility for Imaging
             Program in Molecular and Cell Biology
             Oklahoma Medical Research Foundation


Copyright (c) 1993-2001 Ken Martin, Will Schroeder, Bill Lorensen 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

 * Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

 * Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

 * Neither name of Ken Martin, Will Schroeder, or Bill Lorensen nor the names
   of any contributors may be used to endorse or promote products derived
   from this software without specific prior written permission.

 * Modified source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
// .NAME vtkPLYReader - read Stanford University PLY polygonal file format
// .SECTION Description
// vtkPLYReader is a source object that reads polygonal data in
// Stanford University PLY file format (see 
// http://graphics.stanford.edu/data/3Dscanrep/). It requires that
// the elements "vertex" and "face" are defined. The "vertex" element
// must have the properties "x", "y", and "z". The "face" element must
// have the property "vertex_indices" defined. Optionally, if the "face"
// element has the properties "intensity" and/or the triplet "red",
// "green", and "blue"; these are read and added as scalars to the
// output data.

// .SECTION See Also
// vtkPLYWriter

#ifndef __vtkPLYReader_h
#define __vtkPLYReader_h

#include "vtkPolyDataSource.h"

class VTK_IO_EXPORT vtkPLYReader : public vtkPolyDataSource 
{
public:
  vtkTypeMacro(vtkPLYReader,vtkPolyDataSource);
  void PrintSelf(ostream& os, vtkIndent indent);

  // Description:
  // Construct object with merging set to true.
  static vtkPLYReader *New();

  // Description:
  // Specify file name of stereo lithography file.
  vtkSetStringMacro(FileName);
  vtkGetStringMacro(FileName);

protected:
  vtkPLYReader();
  ~vtkPLYReader();

  char *FileName;

  void Execute();
private:
  vtkPLYReader(const vtkPLYReader&);  // Not implemented.
  void operator=(const vtkPLYReader&);  // Not implemented.
};

#endif


