/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.extensions;

import java.util.HashMap;
import org.web3d.vrml.lang.FieldConstants;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.extensions.BaseHIDSensor;
import org.xj3d.device.DeviceState;
import org.xj3d.device.InputDevice;
import org.xj3d.device.JoystickDevice;
import org.xj3d.device.JoystickState;

public class BaseJoystickSensor
extends BaseHIDSensor {
    private static final int FIELD_TRIGGER_BUTTON = 19;
    private static final int FIELD_HAT_X = 20;
    private static final int FIELD_HAT_Y = 21;
    private static final int FIELD_STICK_X = 22;
    private static final int FIELD_STICK_Y = 23;
    private static final int FIELD_STICK_Z = 24;
    private static final int FIELD_THROTTLE_SLIDER = 25;
    private static final int FIELD_FEATURES_AVAILABLE = 26;
    private static final int LAST_GAMEPAD_SENSOR_INDEX = 26;
    private static final int NUM_FIELDS = 27;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    private String[] vfFeaturesAvailable;
    private float vfStickX;
    private float vfStickY;
    private float vfStickZ;
    private float vfHatX;
    private float vfHatY;
    private boolean vfTriggerButton;
    private float vfThrottleSlider;
    private JoystickDevice realdevice;

    public BaseJoystickSensor() {
        super("JoystickSensor");
        this.hasChanged = new boolean[27];
        this.vfFeaturesAvailable = FieldConstants.EMPTY_MFSTRING;
        this.vfStickX = 0.0f;
        this.vfStickY = 0.0f;
        this.vfStickZ = 0.0f;
        this.vfHatX = 0.0f;
        this.vfHatY = 0.0f;
        this.vfTriggerButton = false;
        this.vfThrottleSlider = -1.0f;
    }

    public BaseJoystickSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy(vRMLNodeType);
    }

    public void setDevice(InputDevice inputDevice) {
        this.realdevice = (JoystickDevice)inputDevice;
    }

    public void update(DeviceState deviceState) {
        JoystickState joystickState = (JoystickState)deviceState;
        if (joystickState.stickX_changed) {
            this.vfStickX = joystickState.stickX;
            this.hasChanged[22] = true;
            this.fireFieldChanged(22);
        }
        if (joystickState.stickY_changed) {
            this.vfStickY = joystickState.stickY;
            this.hasChanged[23] = true;
            this.fireFieldChanged(23);
        }
        if (joystickState.stickZ_changed) {
            this.vfStickZ = joystickState.stickZ;
            this.hasChanged[24] = true;
            this.fireFieldChanged(24);
        }
        if (joystickState.hatX_changed) {
            this.vfHatX = joystickState.hatX;
            this.hasChanged[20] = true;
            this.fireFieldChanged(20);
        }
        if (joystickState.hatY_changed) {
            this.vfHatY = joystickState.hatY;
            this.hasChanged[21] = true;
            this.fireFieldChanged(21);
        }
        if (joystickState.triggerButton_changed) {
            this.vfTriggerButton = joystickState.triggerButton;
            this.hasChanged[19] = true;
            this.fireFieldChanged(19);
        }
        if (joystickState.throttleSlider_changed) {
            this.vfThrottleSlider = joystickState.throttleSlider;
            this.hasChanged[25] = true;
            this.fireFieldChanged(25);
        }
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 26) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 26: {
                vRMLFieldData.clear();
                vRMLFieldData.stringArrayValue = this.vfFeaturesAvailable;
                vRMLFieldData.dataType = (short)14;
                vRMLFieldData.numElements = this.vfFeaturesAvailable.length;
                break;
            }
            case 22: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStickX;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 23: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStickY;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 24: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfStickZ;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 20: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfHatX;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 21: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfHatY;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 25: {
                vRMLFieldData.clear();
                vRMLFieldData.floatValue = this.vfThrottleSlider;
                vRMLFieldData.dataType = (short)4;
                break;
            }
            case 19: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfTriggerButton;
                vRMLFieldData.dataType = 1;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 22: {
                    vRMLNodeType.setValue(n2, this.vfStickX);
                    break;
                }
                case 23: {
                    vRMLNodeType.setValue(n2, this.vfStickY);
                    break;
                }
                case 24: {
                    vRMLNodeType.setValue(n2, this.vfStickZ);
                    break;
                }
                case 20: {
                    vRMLNodeType.setValue(n2, this.vfHatX);
                    break;
                }
                case 21: {
                    vRMLNodeType.setValue(n2, this.vfHatY);
                    break;
                }
                case 25: {
                    vRMLNodeType.setValue(n2, this.vfThrottleSlider);
                    break;
                }
                case 19: {
                    vRMLNodeType.setValue(n2, this.vfTriggerButton);
                    break;
                }
                case 26: {
                    vRMLNodeType.setValue(n2, this.vfFeaturesAvailable, this.vfFeaturesAvailable.length);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("sendRoute: No field! " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[27];
        fieldMap = new HashMap(27);
        BaseJoystickSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseJoystickSensor.fieldDecl[18] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseJoystickSensor.fieldDecl[1] = new VRMLFieldDeclaration(2, "SFString", "name");
        BaseJoystickSensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseJoystickSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "MFFloat", "axisValue");
        BaseJoystickSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "MFFloat", "axisMinValue");
        BaseJoystickSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "MFFloat", "axisMaxValue");
        BaseJoystickSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "MFString", "axisName");
        BaseJoystickSensor.fieldDecl[8] = new VRMLFieldDeclaration(4, "MFFloat", "axisResolution");
        BaseJoystickSensor.fieldDecl[9] = new VRMLFieldDeclaration(4, "MFBool", "axisWrap");
        BaseJoystickSensor.fieldDecl[14] = new VRMLFieldDeclaration(4, "MFFloat", "outputMinValue");
        BaseJoystickSensor.fieldDecl[15] = new VRMLFieldDeclaration(4, "MFFloat", "outputMaxValue");
        BaseJoystickSensor.fieldDecl[13] = new VRMLFieldDeclaration(4, "MFString", "outputName");
        BaseJoystickSensor.fieldDecl[16] = new VRMLFieldDeclaration(4, "MFFloat", "outputResolution");
        BaseJoystickSensor.fieldDecl[17] = new VRMLFieldDeclaration(4, "MFBool", "outputWrap");
        BaseJoystickSensor.fieldDecl[11] = new VRMLFieldDeclaration(4, "SFInt32", "numAxes");
        BaseJoystickSensor.fieldDecl[12] = new VRMLFieldDeclaration(4, "SFInt32", "numOutputs");
        BaseJoystickSensor.fieldDecl[10] = new VRMLFieldDeclaration(4, "SFString", "manufacturerName");
        BaseJoystickSensor.fieldDecl[22] = new VRMLFieldDeclaration(4, "SFFloat", "stickX");
        BaseJoystickSensor.fieldDecl[23] = new VRMLFieldDeclaration(4, "SFFloat", "stickY");
        BaseJoystickSensor.fieldDecl[24] = new VRMLFieldDeclaration(4, "SFFloat", "stickZ");
        BaseJoystickSensor.fieldDecl[20] = new VRMLFieldDeclaration(4, "SFFloat", "hatX");
        BaseJoystickSensor.fieldDecl[21] = new VRMLFieldDeclaration(4, "SFFloat", "hatY");
        BaseJoystickSensor.fieldDecl[19] = new VRMLFieldDeclaration(4, "SFBool", "triggerButton");
        BaseJoystickSensor.fieldDecl[25] = new VRMLFieldDeclaration(4, "SFFloat", "throttleSlider");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(1);
        fieldMap.put("name", n);
        n = new Integer(18);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        n = new Integer(3);
        fieldMap.put("isActive", n);
        fieldMap.put("isActive_changed", n);
        n = new Integer(2);
        fieldMap.put("outputValue", n);
        fieldMap.put("outputValue_changed", n);
        n = new Integer(4);
        fieldMap.put("axisValue", n);
        fieldMap.put("axisValue_changed", n);
        n = new Integer(5);
        fieldMap.put("axisMinValue", n);
        fieldMap.put("axisMinValue_changed", n);
        n = new Integer(6);
        fieldMap.put("axisMaxValue", n);
        fieldMap.put("axisMaxValue_changed", n);
        n = new Integer(7);
        fieldMap.put("axisName", n);
        fieldMap.put("axisName_changed", n);
        n = new Integer(8);
        fieldMap.put("axisResolution", n);
        fieldMap.put("axisResolution_changed", n);
        n = new Integer(9);
        fieldMap.put("axisWrap", n);
        fieldMap.put("axisWrap_changed", n);
        n = new Integer(14);
        fieldMap.put("outputMinValue", n);
        fieldMap.put("outputMinValue_changed", n);
        n = new Integer(15);
        fieldMap.put("outputMaxValue", n);
        fieldMap.put("outputMaxValue_changed", n);
        n = new Integer(13);
        fieldMap.put("outputName", n);
        fieldMap.put("outputName_changed", n);
        n = new Integer(16);
        fieldMap.put("outputResolution", n);
        fieldMap.put("outputResolution_changed", n);
        n = new Integer(17);
        fieldMap.put("outputWrap", n);
        fieldMap.put("outputWrap_changed", n);
        n = new Integer(11);
        fieldMap.put("numAxes", n);
        fieldMap.put("numAxes_changed", n);
        n = new Integer(12);
        fieldMap.put("numOutputs", n);
        fieldMap.put("numOutputs_changed", n);
        n = new Integer(26);
        fieldMap.put("featuresAvailable", n);
        fieldMap.put("featuresAvailable_changed", n);
        n = new Integer(10);
        fieldMap.put("manufacturerName", n);
        fieldMap.put("manufacturerName_changed", n);
        n = new Integer(22);
        fieldMap.put("stickX", n);
        fieldMap.put("stickX_changed", n);
        n = new Integer(23);
        fieldMap.put("stickY", n);
        fieldMap.put("leftStickY_changed", n);
        n = new Integer(24);
        fieldMap.put("stickZ", n);
        fieldMap.put("leftStickZ_changed", n);
        n = new Integer(20);
        fieldMap.put("hatX", n);
        fieldMap.put("hatX_changed", n);
        n = new Integer(21);
        fieldMap.put("hatY", n);
        fieldMap.put("hatY_changed", n);
        n = new Integer(19);
        fieldMap.put("triggerButton", n);
        fieldMap.put("triggerButton_changed", n);
        n = new Integer(25);
        fieldMap.put("throttleSlider", n);
        fieldMap.put("throttleSlider_changed", n);
    }
}

