/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.imageio.ImageTypeSpecifier;

public class SFImageUtils {
    public static void convertRenderedImageToData(RenderedImage renderedImage, int[] nArray, int n) {
        int n2 = renderedImage.getHeight();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getColorModel().getNumComponents();
        Raster raster = renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ColorModel colorModel = renderedImage.getColorModel();
        nArray[n] = n3;
        nArray[1 + n] = n2;
        nArray[2 + n] = n4;
        int n5 = n + 3;
        switch (n4) {
            case 1: {
                for (int i = n2 - 1; i >= 0; --i) {
                    int n6 = i * n3;
                    for (int j = 0; j < n3; ++j) {
                        nArray[n5++] = dataBuffer.getElem(n6++);
                    }
                }
                break;
            }
            case 2: {
                Object object = null;
                int[] nArray2 = null;
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = 0; j < n3; ++j) {
                        object = raster.getDataElements(j, i, object);
                        nArray2 = colorModel.getComponents(object, nArray2, 0);
                        nArray[n5++] = nArray2[0] << 8 | nArray2[1];
                    }
                }
                break;
            }
            case 3: {
                Object object = null;
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = 0; j < n3; ++j) {
                        object = raster.getDataElements(j, i, object);
                        nArray[n5++] = colorModel.getRGB(object);
                    }
                }
                break;
            }
            case 4: {
                Object object = null;
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = 0; j < n3; ++j) {
                        object = raster.getDataElements(j, i, object);
                        nArray[n5++] = colorModel.getRGB(object) << 8 | colorModel.getAlpha(object);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No idea how to deal with " + n4 + " components in an image.");
            }
        }
    }

    public static void convertSubRenderedImageToData(RenderedImage renderedImage, int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = nArray[n];
        int n9 = nArray[n + 1];
        int n10 = nArray[n + 2];
        if (n2 + n6 > n8 || n3 + n7 > n9) {
            throw new IllegalArgumentException("Exceeds bounds of destination");
        }
        int n11 = renderedImage.getWidth();
        int n12 = renderedImage.getHeight();
        if (n2 + n4 > n11 || n3 + n5 > n12) {
            throw new IllegalArgumentException("Exceeds bounds of source");
        }
        Raster raster = renderedImage.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        ColorModel colorModel = renderedImage.getColorModel();
        int n13 = n + 3;
        switch (n10) {
            case 1: {
                int n14 = n5 + n3 - 1;
                for (int i = n7; i < n7 + n3; ++i) {
                    int n15 = n14 * n11 + n4;
                    int n16 = i * n8 + n6 + n13;
                    for (int j = 0; j < n2; ++j) {
                        nArray[n16++] = dataBuffer.getElem(n15++);
                    }
                    --n14;
                }
                break;
            }
            case 2: {
                Object object = null;
                int n17 = n5 + n3 - 1;
                int[] nArray2 = null;
                for (int i = n7; i < n7 + n3; ++i) {
                    int n18 = i * n8 + n6 + n13;
                    for (int j = n4; j < n4 + n2; ++j) {
                        object = raster.getDataElements(j, n17, object);
                        nArray2 = colorModel.getComponents(object, nArray2, 0);
                        nArray[n18++] = nArray2[0] << 8 | nArray2[1];
                    }
                    --n17;
                }
                break;
            }
            case 3: {
                Object object = null;
                int n19 = n5 + n3 - 1;
                for (int i = n7; i < n7 + n3; ++i) {
                    int n20 = i * n8 + n6 + n13;
                    for (int j = 0; j < n2; ++j) {
                        object = raster.getDataElements(j, n19, object);
                        nArray[n20++] = colorModel.getRGB(object);
                    }
                    --n19;
                }
                break;
            }
            case 4: {
                Object object = null;
                int n21 = n5 + n3 - 1;
                for (int i = n7; i < n7 + n3; ++i) {
                    int n22 = i * n8 + n6 + n13;
                    for (int j = 0; j < n2; ++j) {
                        object = raster.getDataElements(j, n21, object);
                        nArray[n22++] = colorModel.getRGB(object) << 8 | colorModel.getAlpha(object);
                    }
                    --n21;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No idea how to deal with " + n10 + " components in an image.");
            }
        }
    }

    public static WritableRenderedImage convertDataToRenderedImage(int n, int n2, int n3, int[] nArray) {
        int[] nArray2;
        ImageTypeSpecifier imageTypeSpecifier = null;
        switch (n3) {
            case 1: {
                imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(8, 0, false);
                nArray2 = new int[]{255};
                break;
            }
            case 2: {
                imageTypeSpecifier = ImageTypeSpecifier.createGrayscale(8, 0, false, false);
                nArray2 = new int[]{65280, 255};
                break;
            }
            case 3: {
                imageTypeSpecifier = ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, 0, 3, false);
                nArray2 = new int[]{0xFF0000, 65280, 255};
                break;
            }
            case 4: {
                imageTypeSpecifier = ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false);
                nArray2 = new int[]{-16777216, 0xFF0000, 65280, 255};
                break;
            }
            default: {
                throw new RuntimeException("SFImage Unsupported #components: " + n3);
            }
        }
        int n4 = n2 - 1;
        int n5 = n2 / 2;
        for (int i = 0; i < n5; ++i) {
            int n6 = i * n;
            int n7 = n4 * n;
            for (int j = 0; j < n; ++j) {
                int n8 = n6 + j;
                int n9 = n7 + j;
                int n10 = nArray[n8];
                nArray[n8] = nArray[n9];
                nArray[n9] = n10;
            }
            --n4;
        }
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, nArray.length, 0);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n, n2, n, nArray2, null);
        BufferedImage bufferedImage = imageTypeSpecifier.createBufferedImage(n, n2);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }
}

