/*****************************************************************************/
/*                                    XDMF                                   */
/*                       eXtensible Data Model and Format                    */
/*                                                                           */
/*  Id : XdmfHeavyDataDescription.hpp                                        */
/*                                                                           */
/*  Author:                                                                  */
/*     Andrew Burns                                                          */
/*     andrew.j.burns2@us.army.mil                                           */
/*     US Army Research Laboratory                                           */
/*     Aberdeen Proving Ground, MD                                           */
/*                                                                           */
/*     Copyright @ 2013 US Army Research Laboratory                          */
/*     All Rights Reserved                                                   */
/*     See Copyright.txt for details                                         */
/*                                                                           */
/*     This software is distributed WITHOUT ANY WARRANTY; without            */
/*     even the implied warranty of MERCHANTABILITY or FITNESS               */
/*     FOR A PARTICULAR PURPOSE.  See the above copyright notice             */
/*     for more information.                                                 */
/*                                                                           */
/*****************************************************************************/
#ifndef XDMFHEAVYDATADESCRIPTION_HPP_
#define XDMFHEAVYDATADESCRIPTION_HPP_

// C Compatible Includes
#include "XdmfCore.hpp"
#include "XdmfItem.hpp"

#ifdef __cplusplus

/**
 * @brief Holds information about a dsm buffer so that a process can connect.
 *
 * XdmfDescription stores the information required to process
 * to a data format
 */
class XDMFCORE_EXPORT XdmfHeavyDataDescription : public XdmfItem {

public:

  /**
   * 
   */
  static shared_ptr<XdmfHeavyDataDescription> New();

  virtual ~XdmfHeavyDataDescription();

  LOKI_DEFINE_VISITABLE(XdmfHeavyDataDescription, XdmfItem)
  static const std::string ItemTag;

  std::map<std::string, std::string> getItemProperties() const;

  virtual std::string getItemTag() const;

  std::string getPortDescription() const;

  using XdmfItem::insert;

  void setPortDescription(std::string portDesc);

  virtual void traverse(const shared_ptr<XdmfBaseVisitor> visitor);

  XdmfHeavyDataDescription(XdmfHeavyDataDescription &);

protected:

  XdmfHeavyDataDescription();

  virtual void
  populateItem(const std::map<std::string, std::string> & itemProperties,
               const std::vector<shared_ptr<XdmfItem> > & childItems,
               const XdmfCoreReader * const reader);

private:

  XdmfHeavyDataDescription(const XdmfHeavyDataDescription &);  // Not implemented.
  void operator=(const XdmfHeavyDataDescription &);  // Not implemented.

  std::string mPortDescription;
};

#ifdef _WIN32
XDMFCORE_TEMPLATE template class XDMFCORE_EXPORT
shared_ptr<Loki::BaseVisitor>;
XDMFCORE_TEMPLATE template class XDMFCORE_EXPORT
Loki::Visitor<shared_ptr<XdmfHeavyDataDescription>,
              shared_ptr<XdmfItem> >;
#endif

#endif

#ifdef __cplusplus
extern "C" {
#endif

// C wrappers go here

struct XDMFHEAVYDATADESCRIPTION; // Simply as a typedef to ensure correct typing
typedef struct XDMFHEAVYDATADESCRIPTION XDMFHEAVYDATADESCRIPTION;

XDMFCORE_EXPORT XDMFHEAVYDATADESCRIPTION * XdmfHeavyDataDescriptionNew();

// C Wrappers for parent classes are generated by macros

XDMF_ITEM_C_CHILD_DECLARE(XdmfHeavyDataDescription, XDMFHEAVYDATADESCRIPTION, XDMFCORE)

#ifdef __cplusplus
}
#endif

#endif /* XDMFHeavyDataDESCRIPTION_HPP_ */
