
# - This module locates the Matlab Engine and Matlab mex.
# Defines the following:
# MATLAB_ROOT_DIR - Matlab installation directory
# MATLAB_INCLUDE_DIR - Path to Matlab include directory
# MATLAB_LIB_DIR - Path to Matlab library directory
# MATLAB_MEX_EXECUTABLE - Path to mex compiler executable
# MATLAB_EXECUTABLE - Path to the matlab executable

# Determine platform

IF(UNIX)
  IF(APPLE)
   SET(MATLAB_ROOT_SEARCH "/Applications")
   IF(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "maci")
   ELSE(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "maci64")
   ENDIF(CMAKE_SIZEOF_VOID_P EQUAL 4)
  ELSE(APPLE)
   SET(MATLAB_ROOT_SEARCH "/usr/local/")
   IF(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "glnx86")
   ELSE(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "glnxa64")
   ENDIF(CMAKE_SIZEOF_VOID_P EQUAL 4)
  ENDIF(APPLE)
ELSE(UNIX)
   SET(MATLAB_ROOT_SEARCH "C:/PROGRA~1/")
   IF(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "win32")
   ELSE(CMAKE_SIZEOF_VOID_P EQUAL 4)
    SET(MATLAB_DIR_PREFIX "win64")
   ENDIF(CMAKE_SIZEOF_VOID_P EQUAL 4)
ENDIF(UNIX)
FIND_PROGRAM(MATLAB_EXECUTABLE matlab PATHS ${MATLAB_ROOT_SEARCH})

IF(NOT MATLAB_EXECUTABLE)
  MESSAGE( FATAL_ERROR "Matlab program not found, please specify MATLAB_EXECUTABLE" )
ENDIF(NOT MATLAB_EXECUTABLE)

GET_FILENAME_COMPONENT(MATLAB_ROOT_DIR_WORK ${MATLAB_EXECUTABLE} PATH)

IF("${MATLAB_ROOT_DIR_WORK}" MATCHES "/${MATLAB_DIR_PREFIX}$")
  GET_FILENAME_COMPONENT(MATLAB_ROOT_DIR ${MATLAB_ROOT_DIR_WORK} PATH CACHE)
ENDIF("${MATLAB_ROOT_DIR_WORK}" MATCHES "/${MATLAB_DIR_PREFIX}$")

IF("${MATLAB_ROOT_DIR_WORK}" MATCHES "/bin$")
  GET_FILENAME_COMPONENT(MATLAB_ROOT_DIR ${MATLAB_ROOT_DIR_WORK} PATH CACHE)
ENDIF("${MATLAB_ROOT_DIR_WORK}" MATCHES "/bin$")

FIND_PATH(MATLAB_INCLUDE_DIR NAMES mex.h PATHS ${MATLAB_ROOT_DIR}/extern/include CACHE DOCSTRING)

#Find Library directory
IF(NOT WIN32)
  FIND_LIBRARY(MATLAB_LIB_DIR_WORK mex ${MATLAB_ROOT_DIR}/bin/${MATLAB_DIR_PREFIX})
ELSE(NOT WIN32)
  FIND_LIBRARY(MATLAB_LIB_DIR_WORK mex ${MATLAB_ROOT_DIR}/extern/lib/${MATLAB_DIR_PREFIX}/microsoft)
ENDIF(NOT WIN32)
GET_FILENAME_COMPONENT(MATLAB_LIB_DIR ${MATLAB_LIB_DIR_WORK} PATH CACHE)
UNSET(MATLAB_LIB_DIR_WORK CACHE)

# Find mex executable
IF(NOT WIN32)
  FIND_PROGRAM(MATLAB_MEX_EXECUTABLE NAMES mex PATHS ${MATLAB_ROOT_DIR} ${MATLAB_ROOT_DIR_WORK}  DOC "Path to Matlab mex compiler")
ELSE(NOT WIN32)
  FIND_FILE(MATLAB_MEX_EXECUTABLE NAMES mex.bat PATHS ${MATLAB_ROOT_DIR} ${MATLAB_ROOT_DIR_WORK} DOC "Path to Matlab mex compiler")
ENDIF(NOT WIN32)

SET(MATLAB_MEX_USE_FILE ${VTK_SOURCE_DIR}/CMake/UseMatlabMex.cmake)

