/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.cadgeometry;

import java.util.HashMap;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.LocalColorsListener;
import org.web3d.vrml.nodes.TexCoordGenModeListener;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseComponentGeometryNode;

public abstract class BaseQuadSet
extends BaseComponentGeometryNode {
    private static final int NUM_FIELDS = 11;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;

    protected BaseQuadSet() {
        super("QuadSet");
    }

    protected BaseQuadSet(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLComponentGeometryNodeType)vRMLNodeType);
    }

    public boolean hasLocalColors() {
        return this.localColors;
    }

    public void addLocalColorsListener(LocalColorsListener localColorsListener) {
        if (localColorsListener != null) {
            this.localColorsListeners.add(localColorsListener);
        }
    }

    public void removeLocalColorsListener(LocalColorsListener localColorsListener) {
        this.localColorsListeners.remove(localColorsListener);
    }

    public void addTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
        System.out.println("TexCoordGenMode changes not implemented");
    }

    public void removeTexCoordGenModeChanged(TexCoordGenModeListener texCoordGenModeListener) {
    }

    public boolean isSolid() {
        return false;
    }

    public boolean isCCW() {
        return true;
    }

    public boolean isLightingEnabled() {
        return true;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 10) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public void fieldChanged(VRMLNodeType vRMLNodeType, int n) {
    }

    static {
        nodeFields = new int[]{1, 3, 4, 2, 0};
        fieldDecl = new VRMLFieldDeclaration[11];
        fieldMap = new HashMap(33);
        BaseQuadSet.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseQuadSet.fieldDecl[2] = new VRMLFieldDeclaration(3, "SFNode", "color");
        BaseQuadSet.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFNode", "coord");
        BaseQuadSet.fieldDecl[3] = new VRMLFieldDeclaration(3, "SFNode", "normal");
        BaseQuadSet.fieldDecl[4] = new VRMLFieldDeclaration(3, "SFNode", "texCoord");
        BaseQuadSet.fieldDecl[5] = new VRMLFieldDeclaration(2, "SFBool", "solid");
        BaseQuadSet.fieldDecl[6] = new VRMLFieldDeclaration(2, "SFBool", "ccw");
        BaseQuadSet.fieldDecl[7] = new VRMLFieldDeclaration(2, "SFBool", "colorPerVertex");
        BaseQuadSet.fieldDecl[8] = new VRMLFieldDeclaration(2, "SFBool", "normalPerVertex");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(2);
        fieldMap.put("color", n);
        fieldMap.put("set_color", n);
        fieldMap.put("color_changed", n);
        n = new Integer(1);
        fieldMap.put("coord", n);
        fieldMap.put("set_coord", n);
        fieldMap.put("coord_changed", n);
        n = new Integer(3);
        fieldMap.put("normal", n);
        fieldMap.put("set_normal", n);
        fieldMap.put("normal_changed", n);
        n = new Integer(4);
        fieldMap.put("texCoord", n);
        fieldMap.put("set_texCoord", n);
        fieldMap.put("texCoord_changed", n);
        fieldMap.put("solid", new Integer(5));
        fieldMap.put("ccw", new Integer(6));
        fieldMap.put("colorPerVertex", new Integer(7));
        fieldMap.put("normalPerVertex", new Integer(8));
    }
}

