/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spline;

import org.j3d.geom.spline.PatchGenerator;

public class BezierPatchGenerator
extends PatchGenerator {
    private static final int DEFAULT_FACETS = 16;

    public BezierPatchGenerator() {
        this(16, 16);
    }

    public BezierPatchGenerator(int n, int n2) {
        if (n < 3) {
            throw new IllegalArgumentException("Number of width facets is < 3");
        }
        if (n2 < 3) {
            throw new IllegalArgumentException("Number of depth facets is < 3");
        }
        this.widthFacetCount = n;
        this.depthFacetCount = n2;
    }

    protected void regeneratePatch() {
        if (!this.patchChanged) {
            return;
        }
        this.patchChanged = false;
        this.numPatchValues = (this.widthFacetCount + 1) * 3;
        if (this.patchCoordinates == null || this.numPatchValues > this.patchCoordinates.length || this.numPatchValues > this.patchCoordinates[0].length) {
            this.patchCoordinates = new float[this.depthFacetCount + 1][this.numPatchValues];
        }
        if (this.useControlPointWeights) {
            this.regenerateWeightedPatch();
        } else {
            this.regenerateStandardPatch();
        }
    }

    private void regenerateStandardPatch() {
        double d;
        int n;
        double d2;
        int n2;
        float f;
        float f2;
        float f3;
        double d3;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < this.depthFacetCount; ++n5) {
            int n6;
            double d4 = (double)n5 / (double)this.depthFacetCount;
            n4 = 0;
            for (n3 = 0; n3 < this.widthFacetCount; ++n3) {
                d3 = (double)n3 / (double)this.widthFacetCount;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (n2 = 0; n2 < this.numWidthControlPoints; ++n2) {
                    d2 = this.bezierBlend(n2, d4, this.numWidthControlPoints - 1);
                    for (n = 0; n < this.numDepthControlPoints; ++n) {
                        d = this.bezierBlend(n, d3, this.numDepthControlPoints - 1);
                        n6 = n * 3;
                        f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n2][n6] * d2 * d);
                        f2 = (float)((double)f2 + (double)this.controlPointCoordinates[n2][n6 + 1] * d2 * d);
                        f = (float)((double)f + (double)this.controlPointCoordinates[n2][n6 + 2] * d2 * d);
                    }
                }
                this.patchCoordinates[n5][n4++] = f3;
                this.patchCoordinates[n5][n4++] = f2;
                this.patchCoordinates[n5][n4++] = f;
            }
            n3 = this.numDepthControlPoints * 3;
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
            for (n2 = 0; n2 < this.numWidthControlPoints; ++n2) {
                d2 = this.bezierBlend(n2, d4, this.numWidthControlPoints - 1);
                for (n = 0; n < this.numDepthControlPoints; ++n) {
                    d = this.bezierBlend(n, 1.0, this.numDepthControlPoints - 1);
                    n6 = n * 3;
                    f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n2][n6] * d2 * d);
                    f2 = (float)((double)f2 + (double)this.controlPointCoordinates[n2][n6 + 1] * d2 * d);
                    f = (float)((double)f + (double)this.controlPointCoordinates[n2][n6 + 2] * d2 * d);
                }
            }
            this.patchCoordinates[n5][n4++] = f3;
            this.patchCoordinates[n5][n4++] = f2;
            this.patchCoordinates[n5][n4++] = f;
        }
        n4 = 0;
        for (n5 = 0; n5 < this.widthFacetCount; ++n5) {
            d3 = (double)n5 / (double)this.widthFacetCount;
            f3 = 0.0f;
            f2 = 0.0f;
            f = 0.0f;
            for (n3 = 0; n3 < this.numWidthControlPoints; ++n3) {
                d2 = this.bezierBlend(n3, 1.0, this.numWidthControlPoints - 1);
                for (n2 = 0; n2 < this.numDepthControlPoints; ++n2) {
                    d = this.bezierBlend(n2, d3, this.numDepthControlPoints - 1);
                    n = n2 * 3;
                    f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n3][n] * d2 * d);
                    f2 = (float)((double)f2 + (double)this.controlPointCoordinates[n3][n + 1] * d2 * d);
                    f = (float)((double)f + (double)this.controlPointCoordinates[n3][n + 2] * d2 * d);
                }
            }
            this.patchCoordinates[this.depthFacetCount][n4++] = f3;
            this.patchCoordinates[this.depthFacetCount][n4++] = f2;
            this.patchCoordinates[this.depthFacetCount][n4++] = f;
        }
        n5 = this.numDepthControlPoints * 3;
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 3];
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 2];
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 1];
    }

    private void regenerateWeightedPatch() {
        float f;
        double d;
        int n;
        double d2;
        int n2;
        float f2;
        float f3;
        float f4;
        float f5;
        double d3;
        int n3;
        int n4;
        int n5;
        for (n5 = 0; n5 < this.depthFacetCount; ++n5) {
            int n6;
            double d4 = (double)n5 / (double)this.depthFacetCount;
            n4 = 0;
            for (n3 = 0; n3 < this.widthFacetCount; ++n3) {
                d3 = (double)n3 / (double)this.widthFacetCount;
                f5 = 0.0f;
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                for (n2 = 0; n2 < this.numWidthControlPoints; ++n2) {
                    d2 = this.bezierBlend(n2, d4, this.numWidthControlPoints - 1);
                    for (n6 = 0; n6 < this.numDepthControlPoints; ++n6) {
                        n = n6 * 3;
                        d = this.bezierBlend(n6, d3, this.numDepthControlPoints - 1);
                        f = this.controlPointWeights[n2][n6];
                        f5 = (float)((double)f5 + (double)this.controlPointCoordinates[n2][n] * d2 * d * (double)f);
                        f4 = (float)((double)f4 + (double)this.controlPointCoordinates[n2][n + 1] * d2 * d * (double)f);
                        f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n2][n + 2] * d2 * d * (double)f);
                        f2 = (float)((double)f2 + d2 * d * (double)f);
                    }
                }
                if (f2 != 0.0f) {
                    this.patchCoordinates[n5][n4++] = f5 / f2;
                    this.patchCoordinates[n5][n4++] = f4 / f2;
                    this.patchCoordinates[n5][n4++] = f3 / f2;
                    continue;
                }
                this.patchCoordinates[n5][n4++] = f5;
                this.patchCoordinates[n5][n4++] = f4;
                this.patchCoordinates[n5][n4++] = f3;
            }
            n3 = this.numDepthControlPoints * 3;
            f5 = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            for (n2 = 0; n2 < this.numWidthControlPoints; ++n2) {
                d2 = this.bezierBlend(n2, d4, this.numWidthControlPoints - 1);
                for (n6 = 0; n6 < this.numDepthControlPoints; ++n6) {
                    n = n6 * 3;
                    d = this.bezierBlend(n6, 1.0, this.numDepthControlPoints - 1);
                    f = this.controlPointWeights[n2][n6];
                    f5 = (float)((double)f5 + (double)this.controlPointCoordinates[n2][n] * d2 * d * (double)f);
                    f4 = (float)((double)f4 + (double)this.controlPointCoordinates[n2][n + 1] * d2 * d * (double)f);
                    f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n2][n + 2] * d2 * d * (double)f);
                    f2 = (float)((double)f2 + d2 * d * (double)f);
                }
            }
            if (f2 != 0.0f) {
                this.patchCoordinates[n5][n4++] = f5 / f2;
                this.patchCoordinates[n5][n4++] = f4 / f2;
                this.patchCoordinates[n5][n4++] = f3 / f2;
                continue;
            }
            this.patchCoordinates[n5][n4++] = f5;
            this.patchCoordinates[n5][n4++] = f4;
            this.patchCoordinates[n5][n4++] = f3;
        }
        n4 = 0;
        for (n5 = 0; n5 < this.widthFacetCount; ++n5) {
            d3 = (double)n5 / (double)this.widthFacetCount;
            f5 = 0.0f;
            f4 = 0.0f;
            f3 = 0.0f;
            f2 = 0.0f;
            for (n3 = 0; n3 < this.numWidthControlPoints; ++n3) {
                d2 = this.bezierBlend(n3, 1.0, this.numWidthControlPoints - 1);
                for (n2 = 0; n2 < this.numDepthControlPoints; ++n2) {
                    n = n2 * 3;
                    d = this.bezierBlend(n2, d3, this.numDepthControlPoints - 1);
                    f = this.controlPointWeights[n3][n2];
                    f5 = (float)((double)f5 + (double)this.controlPointCoordinates[n3][n] * d2 * d * (double)f);
                    f4 = (float)((double)f4 + (double)this.controlPointCoordinates[n3][n + 1] * d2 * d * (double)f);
                    f3 = (float)((double)f3 + (double)this.controlPointCoordinates[n3][n + 2] * d2 * d * (double)f);
                    f2 = (float)((double)f2 + d2 * d * (double)f);
                }
            }
            if (f2 != 0.0f) {
                this.patchCoordinates[this.depthFacetCount][n4++] = f5 / f2;
                this.patchCoordinates[this.depthFacetCount][n4++] = f4 / f2;
                this.patchCoordinates[this.depthFacetCount][n4++] = f3 / f2;
                continue;
            }
            this.patchCoordinates[this.depthFacetCount][n4++] = f5;
            this.patchCoordinates[this.depthFacetCount][n4++] = f4;
            this.patchCoordinates[this.depthFacetCount][n4++] = f3;
        }
        n5 = this.numDepthControlPoints * 3;
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 3];
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 2];
        this.patchCoordinates[this.depthFacetCount][n4++] = this.controlPointCoordinates[this.numWidthControlPoints - 1][n5 - 1];
    }

    private double bezierBlend(int n, double d, int n2) {
        int n3 = n2;
        int n4 = n;
        int n5 = n2 - n;
        double d2 = 1.0;
        while (n3 >= 1) {
            d2 *= (double)n3;
            --n3;
            if (n4 > 1) {
                d2 /= (double)n4;
                --n4;
            }
            if (n5 <= 1) continue;
            d2 /= (double)n5;
            --n5;
        }
        if (n > 0) {
            d2 *= Math.pow(d, n);
        }
        if (n2 - n > 0) {
            d2 *= Math.pow(1.0 - d, n2 - n);
        }
        return d2;
    }
}

