/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.spring;

import org.j3d.geom.spring.SpringEvaluatorCallback;
import org.j3d.geom.spring.SpringNode;

public class SpringSystem {
    private static final int[] DX = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private static final int[] DY = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private float[] gravity = new float[3];
    private SpringNode[] nodes;
    private int numNodes;
    private float springConstant;

    public SpringSystem() {
        this.gravity[1] = -9.8f;
        this.numNodes = 0;
        this.springConstant = 200.0f;
    }

    public void addRectField(int n, int n2, float[] fArray, float[] fArray2) {
        int n3;
        int n4;
        float[] fArray3 = fArray;
        float[] fArray4 = fArray2;
        int n5 = 0;
        this.incNodeListSize(n * n2);
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                this.nodes[this.numNodes++] = new SpringNode(fArray, fArray2, n5);
                n5 += 3;
            }
        }
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n; ++n3) {
                int n6;
                int n7;
                int n8;
                SpringNode springNode = this.nodes[n4 * n + n3];
                if (n3 == 0) {
                    if (n4 == 0) {
                        n8 = 0;
                        n7 = 3;
                    } else if (n4 == n2 - 1) {
                        n8 = 6;
                        n7 = 3;
                    } else {
                        n8 = 6;
                        n7 = 5;
                    }
                } else if (n3 == n - 1) {
                    if (n4 == 0) {
                        n8 = 2;
                        n7 = 3;
                    } else if (n4 == n2 - 1) {
                        n8 = 4;
                        n7 = 3;
                    } else {
                        n8 = 2;
                        n7 = 5;
                    }
                } else if (n4 == 0) {
                    n8 = 0;
                    n7 = 5;
                } else if (n4 == n2 - 1) {
                    n8 = 4;
                    n7 = 5;
                } else {
                    n8 = 0;
                    n7 = 8;
                }
                springNode.nNormal = n7;
                n7 += n8;
                for (n6 = n8; n6 < n7; ++n6) {
                    springNode.addSpring(this.nodes[(n4 + DY[n6 & 7]) * n + n3 + DX[n6 & 7]]);
                }
                if (n3 < 2) {
                    if (n4 < 2) {
                        n8 = 0;
                        n7 = 3;
                    } else if (n4 > n2 - 3) {
                        n8 = 6;
                        n7 = 3;
                    } else {
                        n8 = 6;
                        n7 = 5;
                    }
                } else if (n3 > n - 3) {
                    if (n4 < 2) {
                        n8 = 2;
                        n7 = 3;
                    } else if (n4 > n2 - 3) {
                        n8 = 4;
                        n7 = 3;
                    } else {
                        n8 = 2;
                        n7 = 5;
                    }
                } else if (n4 < 2) {
                    n8 = 0;
                    n7 = 5;
                } else if (n4 > n2 - 3) {
                    n8 = 4;
                    n7 = 5;
                } else {
                    n8 = 0;
                    n7 = 8;
                }
                n7 += n8;
                for (n6 = n8; n6 < n7; ++n6) {
                    springNode.addSpring(this.nodes[(n4 + 2 * DY[n6 & 7]) * n + n3 + 2 * DX[n6 & 7]]);
                }
            }
        }
    }

    public void resetNaturalLengths() {
        for (int i = 0; i < this.numNodes; ++i) {
            this.nodes[i].resetNaturalLengths();
        }
    }

    public void update(float f) {
        this.update(f, null, null);
    }

    public void update(float f, SpringEvaluatorCallback springEvaluatorCallback) {
        this.update(f, springEvaluatorCallback, null);
    }

    public void update(float f, SpringEvaluatorCallback springEvaluatorCallback, float[] fArray) {
        int n;
        float f2 = (float)Math.pow(0.5, f);
        for (n = 0; n < this.numNodes; ++n) {
            if (this.nodes[n].locked) continue;
            SpringNode springNode = this.nodes[n];
            springNode.dir[0] = springNode.dir[0] * f2;
            springNode.dir[1] = springNode.dir[1] * f2;
            springNode.dir[2] = springNode.dir[2] * f2;
            float f3 = springNode.position[springNode.offset];
            float f4 = springNode.position[springNode.offset + 1];
            float f5 = springNode.position[springNode.offset + 2];
            for (int i = 0; i < springNode.numConnections; ++i) {
                int n2 = springNode.connections[i].offset;
                float f6 = springNode.connections[i].position[n2] - f3;
                float f7 = springNode.connections[i].position[n2 + 1] - f4;
                float f8 = springNode.connections[i].position[n2 + 2] - f5;
                float f9 = (float)Math.sqrt(f6 * f6 + f7 * f7 + f8 * f8);
                float f10 = (f9 - springNode.naturalLengths[i]) / f9;
                float f11 = 3.0f * f6 * f10;
                float f12 = 3.0f * f7 * f10;
                float f13 = 3.0f * f8 * f10;
                springNode.dir[0] = springNode.dir[0] + this.springConstant * f * f11;
                springNode.dir[1] = springNode.dir[1] + this.springConstant * f * f12;
                springNode.dir[2] = springNode.dir[2] + this.springConstant * f * f13;
            }
            springNode.dir[0] = springNode.dir[0] + f * this.gravity[0];
            springNode.dir[1] = springNode.dir[1] + f * this.gravity[1];
            springNode.dir[2] = springNode.dir[2] + f * this.gravity[2];
            if (springEvaluatorCallback == null) continue;
            springEvaluatorCallback.processSpringNode(springNode, fArray);
        }
        for (n = 0; n < this.numNodes; ++n) {
            int n3;
            if (this.nodes[n].locked) continue;
            int n4 = n3 = this.nodes[n].offset;
            this.nodes[n].position[n4] = this.nodes[n].position[n4] + f * this.nodes[n].dir[0];
            int n5 = n3 + 1;
            this.nodes[n].position[n5] = this.nodes[n].position[n5] + f * this.nodes[n].dir[1];
            int n6 = n3 + 2;
            this.nodes[n].position[n6] = this.nodes[n].position[n6] + f * this.nodes[n].dir[2];
        }
    }

    public void evaluateNormals() {
        for (int i = 0; i < this.numNodes; ++i) {
            SpringNode springNode = this.nodes[i];
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = springNode.position[springNode.offset];
            float f5 = springNode.position[springNode.offset + 1];
            float f6 = springNode.position[springNode.offset + 2];
            int n = springNode.connections[0].offset;
            float f7 = springNode.connections[0].position[n] - f4;
            float f8 = springNode.connections[0].position[n + 1] - f5;
            float f9 = springNode.connections[0].position[n + 2] - f6;
            for (int j = 1; j < springNode.nNormal; ++j) {
                float f10 = f7;
                float f11 = f8;
                float f12 = f9;
                n = springNode.connections[j].offset;
                f7 = springNode.connections[j].position[n] - f4;
                f8 = springNode.connections[j].position[n + 1] - f5;
                f9 = springNode.connections[j].position[n + 2] - f6;
                float f13 = f10 * f10 + f11 * f11 + f12 * f12;
                float f14 = f7 * f7 + f8 * f8 + f9 * f9;
                float f15 = f11 * f9 - f12 * f8;
                float f16 = f12 * f7 - f10 * f9;
                float f17 = f10 * f8 - f11 * f7;
                float f18 = this.rsqrt(f13 * f14);
                f += f15 * f18;
                f2 += f16 * f18;
                f3 += f17 * f18;
            }
            float f19 = this.rsqrt(f * f + f2 * f2 + f3 * f3);
            springNode.normal[springNode.offset] = f * f19;
            springNode.normal[springNode.offset + 1] = f2 * f19;
            springNode.normal[springNode.offset + 2] = f3 * f19;
        }
    }

    public SpringNode getNode(int n) {
        return this.nodes[n];
    }

    public int getNodeCount() {
        return this.numNodes;
    }

    public void setGravity(float[] fArray) {
        this.gravity[0] = fArray[0];
        this.gravity[1] = fArray[1];
        this.gravity[2] = fArray[2];
    }

    public void getGravity(float[] fArray) {
        fArray[0] = this.gravity[0];
        fArray[1] = this.gravity[1];
        fArray[2] = this.gravity[2];
    }

    public void setSpringConstant(float f) {
        this.springConstant = f;
    }

    public float getSpringConstant() {
        return this.springConstant;
    }

    private void incNodeListSize(int n) {
        int n2 = this.numNodes + n;
        SpringNode[] springNodeArray = new SpringNode[n2];
        if (this.numNodes != 0) {
            System.arraycopy(this.nodes, 0, springNodeArray, 0, this.numNodes);
        }
        this.nodes = springNodeArray;
    }

    private float rsqrt(float f) {
        float f2 = f * 0.5f;
        int n = Float.floatToRawIntBits(f);
        n = 1597463007 - (n >> 1);
        f = Float.intBitsToFloat(n);
        return f * (1.5f - f2 * f * f);
    }
}

