/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.BaseEmitter;
import org.j3d.geom.particle.Particle;

public class MaxAgePointForceEmitter
extends BaseEmitter {
    private static final int DELTA_LIMIT = 5;
    private float particlesPerMs;
    private float[] origin;
    private float force;
    private float[] initialVelocity;
    private int zeroDeltaCounter;
    private int elapsedZeroParticleTime;

    public MaxAgePointForceEmitter(int n, int n2, float[] fArray, float[] fArray2, float f, float f2) {
        super(n, n2, fArray2, 0.0f, f2);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
        this.elapsedZeroParticleTime = 0;
        this.origin = new float[3];
        this.origin[0] = fArray[0];
        this.origin[1] = fArray[1];
        this.origin[2] = fArray[2];
        this.force = f;
    }

    public void setMaxParticleCount(int n) {
        super.setMaxParticleCount(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public void setParticleLifetime(int n) throws IllegalArgumentException {
        super.setParticleLifetime(n);
        this.particlesPerMs = this.lifetime == 0 ? 1.0f : (float)this.particleCount / (float)this.lifetime;
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = (int)(this.particlesPerMs * (float)n);
                if (n2 != 0) break;
                this.elapsedZeroParticleTime += n;
                n2 = (int)(this.particlesPerMs * (float)this.elapsedZeroParticleTime);
                if (n2 == 0) break;
                this.elapsedZeroParticleTime = 0;
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        float f = 1.0f - (float)Math.random() * this.variation;
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3] * f);
        f = 1.0f - (float)Math.random() * this.lifetimeVariation;
        particle.setCycleTime((int)((float)this.lifetime * f));
        particle.setPosition(this.origin[0], this.origin[1], this.origin[2]);
        particle.setMass(this.initialMass);
        particle.setSurfaceArea(this.surfaceArea);
        f = 1.0f - (float)Math.random() * this.variation;
        float f2 = f * this.force * (float)Math.random();
        float f3 = f * this.force * (float)Math.random();
        float f4 = f * this.force * (float)Math.random();
        particle.resultantForce.set(f2, f3, f4);
        particle.velocity.set(0.0f, 0.0f, 0.0f);
        return true;
    }

    public void setPosition(float f, float f2, float f3) {
        this.origin[0] = f;
        this.origin[1] = f2;
        this.origin[2] = f3;
    }
}

