/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.interpolator;

import javax.vecmath.Point3f;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.util.interpolator.PositionInterpolator;

public class TestPositionInterpolator
extends TestCase {
    private static float[] keys = new float[]{0.1f, 0.4f, 5.0f};
    private static float[][] values = new float[][]{{0.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 5.0f, 2.0f}};
    private PositionInterpolator interpolator;

    public TestPositionInterpolator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestPositionInterpolator("testCreateFloat"));
        testSuite.addTest((Test)new TestPositionInterpolator("testCreatePoint"));
        testSuite.addTest((Test)new TestPositionInterpolator("testValueInsertFloat"));
        testSuite.addTest((Test)new TestPositionInterpolator("testValueInsertPoint"));
        testSuite.addTest((Test)new TestPositionInterpolator("testKeyGenFloat"));
        testSuite.addTest((Test)new TestPositionInterpolator("testKeyGenPoint"));
        testSuite.addTest((Test)new TestPositionInterpolator("testClamping"));
        return testSuite;
    }

    public void setUp() {
        TestPositionInterpolator.assertEquals((String)"Keys and values arrays are not the same size", (int)keys.length, (int)values.length);
        this.interpolator = new PositionInterpolator();
    }

    public void testCreateFloat() {
        int n;
        int n2 = keys.length;
        for (n = 0; n < n2; ++n) {
            this.interpolator.addKeyFrame(keys[n], values[n][0], values[n][1], values[n][2]);
        }
        for (n = 0; n < n2; ++n) {
            float[] fArray = this.interpolator.floatValue(keys[n]);
            TestPositionInterpolator.assertEquals((String)(n + " X coord not same"), (float)values[n][0], (float)fArray[0], (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(n + " Y coord not same"), (float)values[n][1], (float)fArray[1], (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(n + " Z coord not same"), (float)values[n][2], (float)fArray[2], (float)0.0f);
        }
    }

    public void testCreatePoint() {
        int n;
        int n2 = keys.length;
        for (n = 0; n < n2; ++n) {
            Point3f point3f = new Point3f(values[n]);
            this.interpolator.addKeyFrame(keys[n], point3f);
        }
        for (n = 0; n < n2; ++n) {
            Point3f point3f = this.interpolator.pointValue(keys[n]);
            TestPositionInterpolator.assertEquals((String)(n + " X coord not same"), (float)values[n][0], (float)point3f.x, (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(n + " Y coord not same"), (float)values[n][1], (float)point3f.y, (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(n + " Z coord not same"), (float)values[n][2], (float)point3f.z, (float)0.0f);
        }
    }

    public void testValueInsertFloat() {
        int n = keys.length;
        TestPositionInterpolator.assertTrue((String)"Not enough keys ( < 3) to do this test", (n > 2 ? 1 : 0) != 0);
        this.interpolator.addKeyFrame(keys[0], values[0][0], values[0][1], values[0][2]);
        this.interpolator.addKeyFrame(keys[2], values[2][0], values[2][1], values[2][2]);
        this.interpolator.addKeyFrame(keys[1], values[1][0], values[1][1], values[1][2]);
        for (int i = 0; i < n; ++i) {
            float[] fArray = this.interpolator.floatValue(keys[i]);
            TestPositionInterpolator.assertEquals((String)(i + " X coord not same"), (float)values[i][0], (float)fArray[0], (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(i + " Y coord not same"), (float)values[i][1], (float)fArray[1], (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(i + " Z coord not same"), (float)values[i][2], (float)fArray[2], (float)0.0f);
        }
    }

    public void testValueInsertPoint() {
        int n = keys.length;
        TestPositionInterpolator.assertTrue((String)"Not enough keys ( < 3) to do this test", (n > 2 ? 1 : 0) != 0);
        Point3f point3f = new Point3f(values[0]);
        this.interpolator.addKeyFrame(keys[0], point3f);
        point3f = new Point3f(values[2]);
        this.interpolator.addKeyFrame(keys[2], point3f);
        point3f = new Point3f(values[1]);
        this.interpolator.addKeyFrame(keys[1], point3f);
        for (int i = 0; i < n; ++i) {
            Point3f point3f2 = this.interpolator.pointValue(keys[i]);
            TestPositionInterpolator.assertEquals((String)(i + " X coord not same"), (float)values[i][0], (float)point3f2.x, (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(i + " Y coord not same"), (float)values[i][1], (float)point3f2.y, (float)0.0f);
            TestPositionInterpolator.assertEquals((String)(i + " Z coord not same"), (float)values[i][2], (float)point3f2.z, (float)0.0f);
        }
    }

    public void testKeyGenFloat() {
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(keys[i], values[i][0], values[i][1], values[i][2]);
        }
        float f = keys[0] + (keys[1] - keys[0]) / 2.0f;
        float f2 = values[0][0] + (values[1][0] - values[0][0]) / 2.0f;
        float f3 = values[0][0] + (values[1][1] - values[0][1]) / 2.0f;
        float f4 = values[0][0] + (values[1][2] - values[0][2]) / 2.0f;
        float[] fArray = this.interpolator.floatValue(f);
        TestPositionInterpolator.assertEquals((String)"1st X coord not same", (float)f2, (float)fArray[0], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"1st Y coord not same", (float)f3, (float)fArray[1], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"1st Z coord not same", (float)f4, (float)fArray[2], (float)0.0f);
        f = keys[1] + (keys[2] - keys[1]) / 2.0f;
        f2 = values[1][0] + (values[2][0] - values[1][0]) / 2.0f;
        f3 = values[1][1] + (values[2][1] - values[1][1]) / 2.0f;
        f4 = values[1][2] + (values[2][2] - values[1][2]) / 2.0f;
        fArray = this.interpolator.floatValue(f);
        TestPositionInterpolator.assertEquals((String)"2nd X coord not same", (float)f2, (float)fArray[0], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"2nd Y coord not same", (float)f3, (float)fArray[1], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"2nd Z coord not same", (float)f4, (float)fArray[2], (float)0.0f);
    }

    public void testKeyGenPoint() {
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            Point3f point3f = new Point3f(values[i]);
            this.interpolator.addKeyFrame(keys[i], point3f);
        }
        float f = keys[0] + (keys[1] - keys[0]) / 2.0f;
        float f2 = values[0][0] + (values[1][0] - values[0][0]) / 2.0f;
        float f3 = values[0][0] + (values[1][1] - values[0][1]) / 2.0f;
        float f4 = values[0][0] + (values[1][2] - values[0][2]) / 2.0f;
        Point3f point3f = this.interpolator.pointValue(f);
        TestPositionInterpolator.assertEquals((String)"1st X coord not same", (float)f2, (float)point3f.x, (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"1st Y coord not same", (float)f3, (float)point3f.y, (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"1st Z coord not same", (float)f4, (float)point3f.z, (float)0.0f);
        f = keys[1] + (keys[2] - keys[1]) / 2.0f;
        f2 = values[1][0] + (values[2][0] - values[1][0]) / 2.0f;
        f3 = values[1][1] + (values[2][1] - values[1][1]) / 2.0f;
        f4 = values[1][2] + (values[2][2] - values[1][2]) / 2.0f;
        point3f = this.interpolator.pointValue(f);
        TestPositionInterpolator.assertEquals((String)"2nd X coord not same", (float)f2, (float)point3f.x, (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"2nd Y coord not same", (float)f3, (float)point3f.y, (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"2nd Z coord not same", (float)f4, (float)point3f.z, (float)0.0f);
    }

    public void testClamping() {
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            this.interpolator.addKeyFrame(keys[i], values[i][0], values[i][1], values[i][2]);
        }
        float f = keys[0] - 1.0f;
        float[] fArray = this.interpolator.floatValue(f);
        TestPositionInterpolator.assertEquals((String)"Min X coord not same", (float)values[0][0], (float)fArray[0], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"Min Y coord not same", (float)values[0][1], (float)fArray[1], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"Min Z coord not same", (float)values[0][2], (float)fArray[2], (float)0.0f);
        f = keys[--n] + 1.0f;
        fArray = this.interpolator.floatValue(f);
        TestPositionInterpolator.assertEquals((String)"Max X coord not same", (float)values[n][0], (float)fArray[0], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"Max Y coord not same", (float)values[n][1], (float)fArray[1], (float)0.0f);
        TestPositionInterpolator.assertEquals((String)"Max Z coord not same", (float)values[n][2], (float)fArray[2], (float)0.0f);
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestPositionInterpolator.suite());
    }
}

