/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.nodes.sensor;

import java.util.HashMap;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.nodes.VRMLTouchSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.BaseSensorNode;

public class BaseTouchSensor
extends BaseSensorNode
implements VRMLTouchSensorNodeType {
    protected static final int FIELD_HITNORMAL_CHANGED = 3;
    protected static final int FIELD_HITPOINT_CHANGED = 4;
    protected static final int FIELD_HITTEXCOORD_CHANGED = 5;
    protected static final int FIELD_IS_OVER = 6;
    protected static final int FIELD_TOUCH_TIME = 7;
    protected static final int FIELD_DESCRIPTION = 8;
    protected static final int LAST_TOUCHSENSOR_INDEX = 8;
    protected static final int NUM_FIELDS = 9;
    private static VRMLFieldDeclaration[] fieldDecl;
    private static HashMap fieldMap;
    private static int[] nodeFields;
    protected float[] vfHitNormalChanged;
    protected float[] vfHitPointChanged;
    protected float[] vfHitTexCoordChanged;
    protected boolean vfIsOver;
    protected double vfTouchTime;
    protected String vfDescription;

    public BaseTouchSensor() {
        super("TouchSensor");
        this.hasChanged = new boolean[9];
        this.vfHitNormalChanged = new float[3];
        this.vfHitPointChanged = new float[3];
        this.vfHitTexCoordChanged = new float[2];
    }

    public BaseTouchSensor(VRMLNodeType vRMLNodeType) {
        this();
        this.checkNodeType(vRMLNodeType);
        this.copy((VRMLSensorNodeType)vRMLNodeType);
    }

    public boolean requiresPointOnly() {
        return false;
    }

    public String getDescription() {
        return this.vfDescription;
    }

    public void setDescription(String string) {
        this.vfDescription = string;
        if (!this.inSetup) {
            this.hasChanged[8] = true;
            this.fireFieldChanged(8);
        }
    }

    public void setIsOver(boolean bl) {
        this.vfIsOver = bl;
        this.hasChanged[6] = true;
        this.fireFieldChanged(6);
    }

    public boolean getIsOver() {
        return this.vfIsOver;
    }

    public void notifyPressed(int n, double d, float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = true;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
    }

    public void notifyReleased(int n, double d, float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfIsActive = false;
        this.hasChanged[2] = true;
        this.fireFieldChanged(2);
        if (this.vfIsOver) {
            this.vfTouchTime = d;
            this.hasChanged[7] = true;
            this.fireFieldChanged(7);
        }
    }

    public void notifyHitChanged(float[] fArray, float[] fArray2, float[] fArray3) {
        if (!this.vfEnabled) {
            return;
        }
        this.vfHitPointChanged[0] = fArray[0];
        this.vfHitPointChanged[1] = fArray[1];
        this.vfHitPointChanged[2] = fArray[2];
        this.vfHitNormalChanged[0] = fArray2[0];
        this.vfHitNormalChanged[1] = fArray2[1];
        this.vfHitNormalChanged[2] = fArray2[2];
        this.vfHitTexCoordChanged[0] = fArray3[0];
        this.vfHitTexCoordChanged[1] = fArray3[1];
        this.hasChanged[4] = true;
        this.fireFieldChanged(4);
        this.hasChanged[3] = true;
        this.fireFieldChanged(3);
        this.hasChanged[5] = true;
        this.fireFieldChanged(5);
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)fieldMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        if (n < 0 || n > 8) {
            return null;
        }
        return fieldDecl[n];
    }

    public int getNumFields() {
        return fieldDecl.length;
    }

    public int getPrimaryType() {
        return 36;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldData vRMLFieldData = (VRMLFieldData)this.fieldLocalData.get();
        switch (n) {
            case 3: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfHitNormalChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 4: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfHitPointChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 5: {
                vRMLFieldData.clear();
                vRMLFieldData.floatArrayValue = this.vfHitTexCoordChanged;
                vRMLFieldData.dataType = (short)11;
                vRMLFieldData.numElements = 1;
                break;
            }
            case 6: {
                vRMLFieldData.clear();
                vRMLFieldData.booleanValue = this.vfIsOver;
                vRMLFieldData.dataType = 1;
                break;
            }
            case 7: {
                vRMLFieldData.clear();
                vRMLFieldData.doubleValue = this.vfTouchTime;
                vRMLFieldData.dataType = (short)5;
                break;
            }
            case 8: {
                vRMLFieldData.clear();
                vRMLFieldData.stringValue = this.vfDescription;
                vRMLFieldData.dataType = (short)6;
                break;
            }
            default: {
                super.getFieldValue(n);
            }
        }
        return vRMLFieldData;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        try {
            switch (n) {
                case 3: {
                    vRMLNodeType.setValue(n2, this.vfHitNormalChanged, 3);
                    break;
                }
                case 4: {
                    vRMLNodeType.setValue(n2, this.vfHitPointChanged, 3);
                    break;
                }
                case 5: {
                    vRMLNodeType.setValue(n2, this.vfHitTexCoordChanged, 2);
                    break;
                }
                case 6: {
                    vRMLNodeType.setValue(n2, this.vfIsOver);
                    break;
                }
                case 7: {
                    vRMLNodeType.setValue(n2, this.vfTouchTime);
                    break;
                }
                case 8: {
                    vRMLNodeType.setValue(n2, this.vfDescription);
                    break;
                }
                default: {
                    super.sendRoute(d, n, vRMLNodeType, n2);
                    break;
                }
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("BaseTouchSensor.sendRoute: No field! " + n);
            invalidFieldException.printStackTrace();
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("BaseTouchSensor.sendRoute: Invalid field value: " + invalidFieldValueException.getMessage());
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException {
        switch (n) {
            case 8: {
                this.setDescription(string);
                break;
            }
            default: {
                super.setValue(n, string);
            }
        }
    }

    static {
        nodeFields = new int[]{0};
        fieldDecl = new VRMLFieldDeclaration[9];
        fieldMap = new HashMap(27);
        BaseTouchSensor.fieldDecl[0] = new VRMLFieldDeclaration(3, "SFNode", "metadata");
        BaseTouchSensor.fieldDecl[1] = new VRMLFieldDeclaration(3, "SFBool", "enabled");
        BaseTouchSensor.fieldDecl[8] = new VRMLFieldDeclaration(3, "SFString", "description");
        BaseTouchSensor.fieldDecl[3] = new VRMLFieldDeclaration(4, "SFVec3f", "hitNormal_changed");
        BaseTouchSensor.fieldDecl[4] = new VRMLFieldDeclaration(4, "SFVec3f", "hitPoint_changed");
        BaseTouchSensor.fieldDecl[5] = new VRMLFieldDeclaration(4, "SFVec2f", "hitTexCoord_changed");
        BaseTouchSensor.fieldDecl[2] = new VRMLFieldDeclaration(4, "SFBool", "isActive");
        BaseTouchSensor.fieldDecl[6] = new VRMLFieldDeclaration(4, "SFBool", "isOver");
        BaseTouchSensor.fieldDecl[7] = new VRMLFieldDeclaration(4, "SFTime", "touchTime");
        Integer n = new Integer(0);
        fieldMap.put("metadata", n);
        fieldMap.put("set_metadata", n);
        fieldMap.put("metadata_changed", n);
        n = new Integer(8);
        fieldMap.put("description", n);
        fieldMap.put("set_description", n);
        fieldMap.put("description_changed", n);
        n = new Integer(1);
        fieldMap.put("enabled", n);
        fieldMap.put("set_enabled", n);
        fieldMap.put("enabled_changed", n);
        fieldMap.put("hitNormal_changed", new Integer(3));
        fieldMap.put("hitPoint_changed", new Integer(4));
        fieldMap.put("hitTexCoord_changed", new Integer(5));
        fieldMap.put("isActive", new Integer(2));
        fieldMap.put("isOver", new Integer(6));
        fieldMap.put("touchTime", new Integer(7));
    }
}

