/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmTest.h"

#include "cmMakefile.h"
#include "cmProperty.h"
#include "cmState.h"
#include "cmStringAlgorithms.h"

cmTest::cmTest(cmMakefile* mf)
  : CommandExpandLists(false)
  , Backtrace(mf->GetBacktrace())
{
  Makefile = mf;
  OldStyle = true;
}

cmTest::~cmTest() = default;

cmListFileBacktrace const& cmTest::GetBacktrace() const
{
  return Backtrace;
}

void cmTest::SetName(const std::string& name)
{
  Name = name;
}

void cmTest::SetCommand(std::vector<std::string> const& command)
{
  Command = command;
}

const char* cmTest::GetProperty(const std::string& prop) const
{
  cmProp retVal = Properties.GetPropertyValue(prop);
  if (!retVal) {
    const bool chain =
      Makefile->GetState()->IsPropertyChained(prop, cmProperty::TEST);
    if (chain) {
      if (cmProp p = Makefile->GetProperty(prop, chain)) {
        return p->c_str();
      }
    }
    return nullptr;
  }
  return retVal->c_str();
}

bool cmTest::GetPropertyAsBool(const std::string& prop) const
{
  return cmIsOn(GetProperty(prop));
}

void cmTest::SetProperty(const std::string& prop, const char* value)
{
  Properties.SetProperty(prop, value);
}

void cmTest::AppendProperty(const std::string& prop, const std::string& value,
                            bool asString)
{
  Properties.AppendProperty(prop, value, asString);
}

bool cmTest::GetCommandExpandLists() const
{
  return CommandExpandLists;
}

void cmTest::SetCommandExpandLists(bool b)
{
  CommandExpandLists = b;
}
