/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmPathLabel.h"

#include <utility>

cmPathLabel::cmPathLabel(std::string label)
  : Label(std::move(label))
  , Hash(0)
{
  // Use a Jenkins one-at-a-time hash with under/over-flow protection
  for (char i : Label) {
    Hash += i;
    Hash += ((Hash & 0x003FFFFF) << 10);
    Hash ^= ((Hash & 0xFFFFFFC0) >> 6);
  }
  Hash += ((Hash & 0x1FFFFFFF) << 3);
  Hash ^= ((Hash & 0xFFFFF800) >> 11);
  Hash += ((Hash & 0x0001FFFF) << 15);
}

bool cmPathLabel::operator<(const cmPathLabel& l) const
{
  return Hash < l.Hash;
}

bool cmPathLabel::operator==(const cmPathLabel& l) const
{
  return Hash == l.Hash;
}
