/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#pragma once

#include "cmConfigure.h" // IWYU pragma: keep

#include <string>

#include "cmListFileCache.h"
#include "cmMessageType.h"

class cmMessenger
{
public:
  void IssueMessage(
    MessageType t, std::string const& text,
    cmListFileBacktrace const& backtrace = cmListFileBacktrace()) const;

  void DisplayMessage(MessageType t, std::string const& text,
                      cmListFileBacktrace const& backtrace) const;

  void SetSuppressDevWarnings(bool suppress)
  {
    SuppressDevWarnings = suppress;
  }
  void SetSuppressDeprecatedWarnings(bool suppress)
  {
    SuppressDeprecatedWarnings = suppress;
  }
  void SetDevWarningsAsErrors(bool error) { DevWarningsAsErrors = error; }
  void SetDeprecatedWarningsAsErrors(bool error)
  {
    DeprecatedWarningsAsErrors = error;
  }

  bool GetSuppressDevWarnings() const { return SuppressDevWarnings; }
  bool GetSuppressDeprecatedWarnings() const
  {
    return SuppressDeprecatedWarnings;
  }
  bool GetDevWarningsAsErrors() const { return DevWarningsAsErrors; }
  bool GetDeprecatedWarningsAsErrors() const
  {
    return DeprecatedWarningsAsErrors;
  }

private:
  bool IsMessageTypeVisible(MessageType t) const;
  MessageType ConvertMessageType(MessageType t) const;

  bool SuppressDevWarnings = false;
  bool SuppressDeprecatedWarnings = false;
  bool DevWarningsAsErrors = false;
  bool DeprecatedWarningsAsErrors = false;
};
