/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#pragma once

#include <cmConfigure.h> // IWYU pragma: keep

#include <string>

class cmMakefile;

/** \class cmExecutionStatus
 * \brief Superclass for all command status classes
 *
 * when a command is involked it may set values on a command status instance
 */
class cmExecutionStatus
{
public:
  cmExecutionStatus(cmMakefile& makefile)
    : Makefile(makefile)
    , Error("unknown error.")
  {
  }

  cmMakefile& GetMakefile() { return Makefile; }

  void SetError(std::string const& e) { Error = e; }
  std::string const& GetError() const { return Error; }

  void SetReturnInvoked() { ReturnInvoked = true; }
  bool GetReturnInvoked() const { return ReturnInvoked; }

  void SetBreakInvoked() { BreakInvoked = true; }
  bool GetBreakInvoked() const { return BreakInvoked; }

  void SetContinueInvoked() { ContinueInvoked = true; }
  bool GetContinueInvoked() const { return ContinueInvoked; }

  void SetNestedError() { NestedError = true; }
  bool GetNestedError() const { return NestedError; }

private:
  cmMakefile& Makefile;
  std::string Error;
  bool ReturnInvoked = false;
  bool BreakInvoked = false;
  bool ContinueInvoked = false;
  bool NestedError = false;
};
