/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCursesWidget.h"

cmCursesWidget::cmCursesWidget(int width, int height, int left, int top)
{
  Field = new_field(height, width, top, left, 0, 0);
  set_field_userptr(Field, reinterpret_cast<char*>(this));
  field_opts_off(Field, O_AUTOSKIP);
  Page = 0;
}

cmCursesWidget::~cmCursesWidget()
{
  if (Field) {
    free_field(Field);
    Field = nullptr;
  }
}

void cmCursesWidget::Move(int x, int y, bool isNewPage)
{
  if (!Field) {
    return;
  }

  move_field(Field, y, x);
  if (isNewPage) {
    set_new_page(Field, true);
  } else {
    set_new_page(Field, false);
  }
}

void cmCursesWidget::SetValue(const std::string& value)
{
  Value = value;
  set_field_buffer(Field, 0, const_cast<char*>(value.c_str()));
}

const char* cmCursesWidget::GetValue()
{
  return Value.c_str();
}
