/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCursesPathWidget.h"

#include <vector>

#include "cmCursesColor.h"
#include "cmCursesMainForm.h"
#include "cmCursesStringWidget.h"
#include "cmStateTypes.h"
#include "cmSystemTools.h"

cmCursesPathWidget::cmCursesPathWidget(int width, int height, int left,
                                       int top)
  : cmCursesStringWidget(width, height, left, top)
{
  Type = cmStateEnums::PATH;
  Cycle = false;
  CurrentIndex = 0;
  if (cmCursesColor::HasColors()) {
    set_field_fore(Field, COLOR_PAIR(cmCursesColor::Path));
    set_field_back(Field, COLOR_PAIR(cmCursesColor::Path));
  } else {
    set_field_fore(Field, A_NORMAL);
    set_field_back(Field, A_STANDOUT);
  }
}

void cmCursesPathWidget::OnType(int& key, cmCursesMainForm* fm, WINDOW* w)
{
  Cycle = false;
  CurrentIndex = 0;
  LastGlob = "";
  cmCursesStringWidget::OnType(key, fm, w);
}

void cmCursesPathWidget::OnTab(cmCursesMainForm* fm, WINDOW* w)
{
  if (!GetString()) {
    return;
  }
  FORM* form = fm->GetForm();
  form_driver(form, REQ_NEXT_FIELD);
  form_driver(form, REQ_PREV_FIELD);
  std::string cstr = GetString();
  cstr = cstr.substr(0, cstr.find_last_not_of(" \t\n\r") + 1);
  if (LastString != cstr) {
    Cycle = false;
    CurrentIndex = 0;
    LastGlob = "";
  }
  std::string glob;
  if (Cycle) {
    glob = LastGlob;
  } else {
    glob = cstr + "*";
  }
  std::vector<std::string> dirs;

  cmSystemTools::SimpleGlob(glob, dirs, (Type == cmStateEnums::PATH ? -1 : 0));
  if (CurrentIndex < dirs.size()) {
    cstr = dirs[CurrentIndex];
  }
  if (cstr[cstr.size() - 1] == '*') {
    cstr = cstr.substr(0, cstr.size() - 1);
  }

  if (cmSystemTools::FileIsDirectory(cstr)) {
    cstr += "/";
  }

  SetString(cstr);
  touchwin(w);
  wrefresh(w);
  form_driver(form, REQ_END_FIELD);
  LastGlob = glob;
  LastString = cstr;
  Cycle = true;
  CurrentIndex++;
  if (CurrentIndex >= dirs.size()) {
    CurrentIndex = 0;
  }
}

void cmCursesPathWidget::OnReturn(cmCursesMainForm* fm, WINDOW* w)
{
  cmCursesStringWidget::OnReturn(fm, w);
}
