/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCursesOptionsWidget.h"

#include "cmCursesColor.h"
#include "cmCursesWidget.h"
#include "cmStateTypes.h"

#define ctrl(z) ((z)&037)

cmCursesOptionsWidget::cmCursesOptionsWidget(int width, int height, int left,
                                             int top)
  : cmCursesWidget(width, height, left, top)
{
  Type = cmStateEnums::BOOL; // this is a bit of a hack
  // there is no option type, and string type causes ccmake to cast
  // the widget into a string widget at some point.  BOOL is safe for
  // now.
  if (cmCursesColor::HasColors()) {
    set_field_fore(Field, COLOR_PAIR(cmCursesColor::Choice));
    set_field_back(Field, COLOR_PAIR(cmCursesColor::Choice));
  } else {
    set_field_fore(Field, A_NORMAL);
    set_field_back(Field, A_STANDOUT);
  }
  field_opts_off(Field, O_STATIC);
}

bool cmCursesOptionsWidget::HandleInput(int& key, cmCursesMainForm* /*fm*/,
                                        WINDOW* w)
{
  if (Options.empty()) {
    return false;
  }
  switch (key) {
    case 10: // 10 == enter
    case KEY_ENTER:
      NextOption();
      touchwin(w);
      wrefresh(w);
      return true;
    case KEY_LEFT:
    case ctrl('b'):
      touchwin(w);
      wrefresh(w);
      PreviousOption();
      return true;
    case KEY_RIGHT:
    case ctrl('f'):
      NextOption();
      touchwin(w);
      wrefresh(w);
      return true;
    default:
      return false;
  }
}

void cmCursesOptionsWidget::AddOption(std::string const& option)
{
  Options.push_back(option);
}

void cmCursesOptionsWidget::NextOption()
{
  CurrentOption++;
  if (CurrentOption > Options.size() - 1) {
    CurrentOption = 0;
  }
  SetValue(Options[CurrentOption]);
}
void cmCursesOptionsWidget::PreviousOption()
{
  if (CurrentOption == 0) {
    CurrentOption = Options.size() - 1;
  } else {
    CurrentOption--;
  }
  SetValue(Options[CurrentOption]);
}

void cmCursesOptionsWidget::SetOption(const std::string& value)
{
  CurrentOption = 0; // default to 0 index
  SetValue(value);
  int index = 0;
  for (auto const& opt : Options) {
    if (opt == value) {
      CurrentOption = index;
    }
    index++;
  }
}
