/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestUploadCommand.h"

#include <set>
#include <sstream>

#include <cm/vector>
#include <cmext/string_view>

#include "cmCTest.h"
#include "cmCTestUploadHandler.h"
#include "cmMakefile.h"
#include "cmMessageType.h"
#include "cmSystemTools.h"

void cmCTestUploadCommand::BindArguments()
{
  Bind("FILES"_s, Files);
  Bind("QUIET"_s, Quiet);
  Bind("CAPTURE_CMAKE_ERROR"_s, CaptureCMakeError);
}

void cmCTestUploadCommand::CheckArguments(std::vector<std::string> const&)
{
  cm::erase_if(Files, [this](std::string const& arg) -> bool {
    if (!cmSystemTools::FileExists(arg)) {
      std::ostringstream e;
      e << "File \"" << arg << "\" does not exist. Cannot submit "
        << "a non-existent file.";
      Makefile->IssueMessage(MessageType::FATAL_ERROR, e.str());
      return true;
    }
    return false;
  });
}

cmCTestGenericHandler* cmCTestUploadCommand::InitializeHandler()
{
  cmCTestUploadHandler* handler = CTest->GetUploadHandler();
  handler->Initialize();
  handler->SetFiles(std::set<std::string>(Files.begin(), Files.end()));
  handler->SetQuiet(Quiet);
  return handler;
}
