/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestUpdateCommand.h"

#include "cmCTest.h"
#include "cmCTestUpdateHandler.h"
#include "cmMakefile.h"
#include "cmProperty.h"
#include "cmSystemTools.h"

cmCTestGenericHandler* cmCTestUpdateCommand::InitializeHandler()
{
  if (!Source.empty()) {
    CTest->SetCTestConfiguration(
      "SourceDirectory", cmSystemTools::CollapseFullPath(Source), Quiet);
  } else {
    CTest->SetCTestConfiguration(
      "SourceDirectory",
      cmSystemTools::CollapseFullPath(
        cmToCStrSafe(Makefile->GetDefinition("CTEST_SOURCE_DIRECTORY"))),
      Quiet);
  }
  std::string source_dir = CTest->GetCTestConfiguration("SourceDirectory");

  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "UpdateCommand",
                                                "CTEST_UPDATE_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "UpdateOptions",
                                                "CTEST_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "CVSCommand",
                                                "CTEST_CVS_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "CVSUpdateOptions", "CTEST_CVS_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "SVNCommand",
                                                "CTEST_SVN_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "SVNUpdateOptions", "CTEST_SVN_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "SVNOptions",
                                                "CTEST_SVN_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "BZRCommand",
                                                "CTEST_BZR_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "BZRUpdateOptions", "CTEST_BZR_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "GITCommand",
                                                "CTEST_GIT_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "GITUpdateOptions", "CTEST_GIT_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "GITInitSubmodules", "CTEST_GIT_INIT_SUBMODULES", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "GITUpdateCustom", "CTEST_GIT_UPDATE_CUSTOM", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "UpdateVersionOnly", "CTEST_UPDATE_VERSION_ONLY", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "UpdateVersionOverride", "CTEST_UPDATE_VERSION_OVERRIDE", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "HGCommand",
                                                "CTEST_HG_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "HGUpdateOptions", "CTEST_HG_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "P4Command",
                                                "CTEST_P4_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "P4UpdateOptions", "CTEST_P4_UPDATE_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "P4Client",
                                                "CTEST_P4_CLIENT", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(Makefile, "P4Options",
                                                "CTEST_P4_OPTIONS", Quiet);

  cmCTestUpdateHandler* handler = CTest->GetUpdateHandler();
  handler->Initialize();
  handler->SetCommand(this);
  if (source_dir.empty()) {
    SetError("source directory not specified. Please use SOURCE tag");
    return nullptr;
  }
  handler->SetOption("SourceDirectory", source_dir.c_str());
  handler->SetQuiet(Quiet);
  return handler;
}
