/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestMemCheckCommand.h"

#include <cmext/string_view>

#include "cmCTest.h"
#include "cmCTestMemCheckHandler.h"
#include "cmMakefile.h"

void cmCTestMemCheckCommand::BindArguments()
{
  cmCTestTestCommand::BindArguments();
  Bind("DEFECT_COUNT"_s, DefectCount);
}

cmCTestGenericHandler* cmCTestMemCheckCommand::InitializeActualHandler()
{
  cmCTestMemCheckHandler* handler = CTest->GetMemCheckHandler();
  handler->Initialize();

  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "MemoryCheckType", "CTEST_MEMORYCHECK_TYPE", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "MemoryCheckSanitizerOptions",
    "CTEST_MEMORYCHECK_SANITIZER_OPTIONS", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "MemoryCheckCommand", "CTEST_MEMORYCHECK_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "MemoryCheckCommandOptions", "CTEST_MEMORYCHECK_COMMAND_OPTIONS",
    Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "MemoryCheckSuppressionFile",
    "CTEST_MEMORYCHECK_SUPPRESSIONS_FILE", Quiet);

  handler->SetQuiet(Quiet);
  return handler;
}

void cmCTestMemCheckCommand::ProcessAdditionalValues(
  cmCTestGenericHandler* handler)
{
  if (!DefectCount.empty()) {
    Makefile->AddDefinition(
      DefectCount,
      std::to_string(
        static_cast<cmCTestMemCheckHandler*>(handler)->GetDefectCount()));
  }
}
