/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCTestCoverageCommand.h"

#include <set>

#include <cmext/algorithm>
#include <cmext/string_view>

#include "cmCTest.h"
#include "cmCTestCoverageHandler.h"

class cmCTestGenericHandler;

void cmCTestCoverageCommand::BindArguments()
{
  cmCTestHandlerCommand::BindArguments();
  Bind("LABELS"_s, Labels);
}

void cmCTestCoverageCommand::CheckArguments(
  std::vector<std::string> const& keywords)
{
  LabelsMentioned = !Labels.empty() || cm::contains(keywords, "LABELS");
}

cmCTestGenericHandler* cmCTestCoverageCommand::InitializeHandler()
{
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "CoverageCommand", "CTEST_COVERAGE_COMMAND", Quiet);
  CTest->SetCTestConfigurationFromCMakeVariable(
    Makefile, "CoverageExtraFlags", "CTEST_COVERAGE_EXTRA_FLAGS", Quiet);
  cmCTestCoverageHandler* handler = CTest->GetCoverageHandler();
  handler->Initialize();

  // If a LABELS option was given, select only files with the labels.
  if (LabelsMentioned) {
    handler->SetLabelFilter(
      std::set<std::string>(Labels.begin(), Labels.end()));
  }

  handler->SetQuiet(Quiet);
  return handler;
}
