/* Distributed under the OSI-approved BSD 3-Clause License.  See accompanying
   file Copyright.txt or https://cmake.org/licensing for details.  */
#include "cmCPackComponentGroup.h"

#include <string>

#include "cmStringAlgorithms.h"
#include "cmSystemTools.h"

unsigned long cmCPackComponent::GetInstalledSize(
  const std::string& installDir) const
{
  if (TotalSize != 0) {
    return TotalSize;
  }

  for (std::string const& file : Files) {
    std::string path = cmStrCat(installDir, '/', file);
    TotalSize += cmSystemTools::FileLength(path);
  }

  return TotalSize;
}

unsigned long cmCPackComponent::GetInstalledSizeInKbytes(
  const std::string& installDir) const
{
  unsigned long result = (GetInstalledSize(installDir) + 512) / 1024;
  return result ? result : 1;
}
