/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export.compressors;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.web3d.vrml.export.compressors.BitPacker;

public class HuffmanNode {
    public int tag;
    public int tagLength;
    protected int frequency;
    protected HuffmanNode child0;
    protected HuffmanNode child1;
    static FrequencyComparator frequencyComparator = new FrequencyComparator();
    static TagLengthComparator tagLengthComparator = new TagLengthComparator();

    public void addCount() {
        ++this.frequency;
    }

    public void writeData(BitPacker bitPacker, int n) throws IOException {
        System.out.println("Writing untyped Huffman node?");
    }

    void addChildren(HuffmanNode huffmanNode, HuffmanNode huffmanNode2) {
        this.child0 = huffmanNode;
        this.child1 = huffmanNode2;
        this.frequency = huffmanNode.frequency + huffmanNode2.frequency;
    }

    void collectLeaves(int n, int n2, Collection collection) {
        if (this.child0 == null) {
            this.tag = n;
            this.tagLength = n2;
            collection.add(this);
        } else {
            this.child0.collectLeaves(n << 1 | 0, n2 + 1, collection);
            this.child1.collectLeaves(n << 1 | 1, n2 + 1, collection);
        }
    }

    public String toString() {
        return "HN." + this.hashCode() + " freq: " + this.frequency;
    }

    static class TagLengthComparator
    implements Comparator {
        TagLengthComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((HuffmanNode)object2).tagLength - ((HuffmanNode)object).tagLength;
        }
    }

    static class FrequencyComparator
    implements Comparator {
        FrequencyComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((HuffmanNode)object).frequency - ((HuffmanNode)object2).frequency;
        }
    }
}

