# state file generated using paraview version 5.6.0

# ----------------------------------------------------------------
# setup views used in the visualization
# ----------------------------------------------------------------

# trace generated using paraview version 5.6.0
#
# To ensure correct image size when batch processing, please search 
# for and uncomment the line `# renderView*.ViewSize = [*,*]`

#### import the simple module from the paraview
from paraview.simple import *
#### disable automatic camera reset on 'Show'
paraview.simple._DisableFirstRenderCameraReset()

# get the material library
materialLibrary1 = GetMaterialLibrary()

# Create a new 'Render View'
renderView1 = CreateView('RenderView')
renderView1.ViewSize = [1280, 1024]
renderView1.AnnotationColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid = 'GridAxes3DActor'
renderView1.OrientationAxesVisibility = 0
renderView1.OrientationAxesLabelColor = [0.0, 0.0, 0.0]
renderView1.OrientationAxesOutlineColor = [0.0, 0.0, 0.0]
renderView1.StereoType = 0
renderView1.CameraPosition = [-2.0374229994615005, 1.0354323519913504, 3.1704731424582286]
renderView1.CameraFocalPoint = [1.4504718988179726, -0.7371397741595146, -2.257107238068981]
renderView1.CameraViewUp = [0.16438828689168156, 0.9639614579960429, -0.20917647724101598]
renderView1.CameraParallelScale = 1.7316919011044623
renderView1.Background = [1.0, 1.0, 1.0]
renderView1.OSPRayMaterialLibrary = materialLibrary1

# init the 'GridAxes3DActor' selected for 'AxesGrid'
renderView1.AxesGrid.XTitleColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.XTitleFontFile = ''
renderView1.AxesGrid.YTitleColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.YTitleFontFile = ''
renderView1.AxesGrid.ZTitleColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.ZTitleFontFile = ''
renderView1.AxesGrid.GridColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.XLabelColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.XLabelFontFile = ''
renderView1.AxesGrid.YLabelColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.YLabelFontFile = ''
renderView1.AxesGrid.ZLabelColor = [0.0, 0.0, 0.0]
renderView1.AxesGrid.ZLabelFontFile = ''

# ----------------------------------------------------------------
# restore active view
SetActiveView(renderView1)
# ----------------------------------------------------------------

# ----------------------------------------------------------------
# setup the data processing pipelines
# ----------------------------------------------------------------

# create a new 'Sphere'
sphere1 = Sphere()
sphere1.Radius = 1.0
sphere1.ThetaResolution = 100
sphere1.PhiResolution = 100

# create a new 'Slice'
slice1 = Slice(Input=sphere1)
slice1.SliceType = 'Plane'
slice1.SliceOffsetValues = [0.0]

# init the 'Plane' selected for 'SliceType'
slice1.SliceType.Normal = [0.0, 1.0, 0.0]

# create a new 'Sphere'
sphere2 = Sphere()
sphere2.Radius = 0.05
sphere2.ThetaResolution = 64
sphere2.PhiResolution = 64

# create a new 'Cylinder'
cylinder1 = Cylinder()
cylinder1.Resolution = 64
cylinder1.Radius = 0.015
cylinder1.Center = [0.0, 0.5, 0.0]

# create a new 'Transform'
transform1 = Transform(Input=cylinder1)
transform1.Transform = 'Transform'

# init the 'Transform' selected for 'Transform'
transform1.Transform.Rotate = [0.0, 0.0, 90.0]

# ----------------------------------------------------------------
# setup the visualization in view 'renderView1'
# ----------------------------------------------------------------

# show data from sphere1
sphere1Display = Show(sphere1, renderView1)

# trace defaults for the display properties.
sphere1Display.Representation = 'Surface'
sphere1Display.AmbientColor = [0.0, 0.0, 0.0]
sphere1Display.ColorArrayName = [None, '']
sphere1Display.Opacity = 0.5
sphere1Display.BackfaceRepresentation = 'Cull Backface'
sphere1Display.OSPRayScaleArray = 'Normals'
sphere1Display.OSPRayScaleFunction = 'PiecewiseFunction'
sphere1Display.SelectOrientationVectors = 'None'
sphere1Display.ScaleFactor = 0.2
sphere1Display.SelectScaleArray = 'None'
sphere1Display.GlyphType = 'Arrow'
sphere1Display.GlyphTableIndexArray = 'None'
sphere1Display.GaussianRadius = 0.01
sphere1Display.SetScaleArray = ['POINTS', 'Normals']
sphere1Display.ScaleTransferFunction = 'PiecewiseFunction'
sphere1Display.OpacityArray = ['POINTS', 'Normals']
sphere1Display.OpacityTransferFunction = 'PiecewiseFunction'
sphere1Display.DataAxesGrid = 'GridAxesRepresentation'
sphere1Display.SelectionCellLabelFontFile = ''
sphere1Display.SelectionPointLabelFontFile = ''
sphere1Display.PolarAxes = 'PolarAxesRepresentation'

# init the 'PiecewiseFunction' selected for 'OSPRayScaleFunction'
sphere1Display.OSPRayScaleFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
sphere1Display.ScaleTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
sphere1Display.OpacityTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'GridAxesRepresentation' selected for 'DataAxesGrid'
sphere1Display.DataAxesGrid.XTitleColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.XTitleFontFile = ''
sphere1Display.DataAxesGrid.YTitleColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.YTitleFontFile = ''
sphere1Display.DataAxesGrid.ZTitleColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.ZTitleFontFile = ''
sphere1Display.DataAxesGrid.GridColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.XLabelColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.XLabelFontFile = ''
sphere1Display.DataAxesGrid.YLabelColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.YLabelFontFile = ''
sphere1Display.DataAxesGrid.ZLabelColor = [0.0, 0.0, 0.0]
sphere1Display.DataAxesGrid.ZLabelFontFile = ''

# init the 'PolarAxesRepresentation' selected for 'PolarAxes'
sphere1Display.PolarAxes.PolarAxisTitleColor = [0.0, 0.0, 0.0]
sphere1Display.PolarAxes.PolarAxisTitleFontFile = ''
sphere1Display.PolarAxes.PolarAxisLabelColor = [0.0, 0.0, 0.0]
sphere1Display.PolarAxes.PolarAxisLabelFontFile = ''
sphere1Display.PolarAxes.LastRadialAxisTextColor = [0.0, 0.0, 0.0]
sphere1Display.PolarAxes.LastRadialAxisTextFontFile = ''
sphere1Display.PolarAxes.SecondaryRadialAxesTextColor = [0.0, 0.0, 0.0]
sphere1Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''

# show data from slice1
slice1Display = Show(slice1, renderView1)

# trace defaults for the display properties.
slice1Display.Representation = 'Surface'
slice1Display.AmbientColor = [0.0, 0.0, 0.0]
slice1Display.ColorArrayName = [None, '']
slice1Display.DiffuseColor = [0.0, 0.0, 0.0]
slice1Display.LineWidth = 10.0
slice1Display.RenderLinesAsTubes = 1
slice1Display.OSPRayScaleArray = 'Normals'
slice1Display.OSPRayScaleFunction = 'PiecewiseFunction'
slice1Display.SelectOrientationVectors = 'None'
slice1Display.ScaleFactor = 0.2
slice1Display.SelectScaleArray = 'None'
slice1Display.GlyphType = 'Arrow'
slice1Display.GlyphTableIndexArray = 'None'
slice1Display.GaussianRadius = 0.01
slice1Display.SetScaleArray = ['POINTS', 'Normals']
slice1Display.ScaleTransferFunction = 'PiecewiseFunction'
slice1Display.OpacityArray = ['POINTS', 'Normals']
slice1Display.OpacityTransferFunction = 'PiecewiseFunction'
slice1Display.DataAxesGrid = 'GridAxesRepresentation'
slice1Display.SelectionCellLabelFontFile = ''
slice1Display.SelectionPointLabelFontFile = ''
slice1Display.PolarAxes = 'PolarAxesRepresentation'

# init the 'PiecewiseFunction' selected for 'OSPRayScaleFunction'
slice1Display.OSPRayScaleFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
slice1Display.ScaleTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
slice1Display.OpacityTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'GridAxesRepresentation' selected for 'DataAxesGrid'
slice1Display.DataAxesGrid.XTitleColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.XTitleFontFile = ''
slice1Display.DataAxesGrid.YTitleColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.YTitleFontFile = ''
slice1Display.DataAxesGrid.ZTitleColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.ZTitleFontFile = ''
slice1Display.DataAxesGrid.GridColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.XLabelColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.XLabelFontFile = ''
slice1Display.DataAxesGrid.YLabelColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.YLabelFontFile = ''
slice1Display.DataAxesGrid.ZLabelColor = [0.0, 0.0, 0.0]
slice1Display.DataAxesGrid.ZLabelFontFile = ''

# init the 'PolarAxesRepresentation' selected for 'PolarAxes'
slice1Display.PolarAxes.PolarAxisTitleColor = [0.0, 0.0, 0.0]
slice1Display.PolarAxes.PolarAxisTitleFontFile = ''
slice1Display.PolarAxes.PolarAxisLabelColor = [0.0, 0.0, 0.0]
slice1Display.PolarAxes.PolarAxisLabelFontFile = ''
slice1Display.PolarAxes.LastRadialAxisTextColor = [0.0, 0.0, 0.0]
slice1Display.PolarAxes.LastRadialAxisTextFontFile = ''
slice1Display.PolarAxes.SecondaryRadialAxesTextColor = [0.0, 0.0, 0.0]
slice1Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''

# show data from sphere2
sphere2Display = Show(sphere2, renderView1)

# trace defaults for the display properties.
sphere2Display.Representation = 'Surface'
sphere2Display.AmbientColor = [0.0, 0.0, 0.0]
sphere2Display.ColorArrayName = [None, '']
sphere2Display.DiffuseColor = [1.0, 0.0, 0.0]
sphere2Display.OSPRayScaleArray = 'Normals'
sphere2Display.OSPRayScaleFunction = 'PiecewiseFunction'
sphere2Display.SelectOrientationVectors = 'None'
sphere2Display.ScaleFactor = 0.010000000149011612
sphere2Display.SelectScaleArray = 'None'
sphere2Display.GlyphType = 'Arrow'
sphere2Display.GlyphTableIndexArray = 'None'
sphere2Display.GaussianRadius = 0.0005000000074505806
sphere2Display.SetScaleArray = ['POINTS', 'Normals']
sphere2Display.ScaleTransferFunction = 'PiecewiseFunction'
sphere2Display.OpacityArray = ['POINTS', 'Normals']
sphere2Display.OpacityTransferFunction = 'PiecewiseFunction'
sphere2Display.DataAxesGrid = 'GridAxesRepresentation'
sphere2Display.SelectionCellLabelFontFile = ''
sphere2Display.SelectionPointLabelFontFile = ''
sphere2Display.PolarAxes = 'PolarAxesRepresentation'

# init the 'PiecewiseFunction' selected for 'OSPRayScaleFunction'
sphere2Display.OSPRayScaleFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
sphere2Display.ScaleTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
sphere2Display.OpacityTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'GridAxesRepresentation' selected for 'DataAxesGrid'
sphere2Display.DataAxesGrid.XTitleColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.XTitleFontFile = ''
sphere2Display.DataAxesGrid.YTitleColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.YTitleFontFile = ''
sphere2Display.DataAxesGrid.ZTitleColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.ZTitleFontFile = ''
sphere2Display.DataAxesGrid.GridColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.XLabelColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.XLabelFontFile = ''
sphere2Display.DataAxesGrid.YLabelColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.YLabelFontFile = ''
sphere2Display.DataAxesGrid.ZLabelColor = [0.0, 0.0, 0.0]
sphere2Display.DataAxesGrid.ZLabelFontFile = ''

# init the 'PolarAxesRepresentation' selected for 'PolarAxes'
sphere2Display.PolarAxes.PolarAxisTitleColor = [0.0, 0.0, 0.0]
sphere2Display.PolarAxes.PolarAxisTitleFontFile = ''
sphere2Display.PolarAxes.PolarAxisLabelColor = [0.0, 0.0, 0.0]
sphere2Display.PolarAxes.PolarAxisLabelFontFile = ''
sphere2Display.PolarAxes.LastRadialAxisTextColor = [0.0, 0.0, 0.0]
sphere2Display.PolarAxes.LastRadialAxisTextFontFile = ''
sphere2Display.PolarAxes.SecondaryRadialAxesTextColor = [0.0, 0.0, 0.0]
sphere2Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''

# show data from transform1
transform1Display = Show(transform1, renderView1)

# trace defaults for the display properties.
transform1Display.Representation = 'Surface'
transform1Display.AmbientColor = [0.0, 0.0, 0.0]
transform1Display.ColorArrayName = [None, '']
transform1Display.DiffuseColor = [0.0, 0.6666666666666666, 1.0]
transform1Display.OSPRayScaleArray = 'Normals'
transform1Display.OSPRayScaleFunction = 'PiecewiseFunction'
transform1Display.SelectOrientationVectors = 'None'
transform1Display.ScaleFactor = 0.1
transform1Display.SelectScaleArray = 'None'
transform1Display.GlyphType = 'Arrow'
transform1Display.GlyphTableIndexArray = 'None'
transform1Display.GaussianRadius = 0.005
transform1Display.SetScaleArray = ['POINTS', 'Normals']
transform1Display.ScaleTransferFunction = 'PiecewiseFunction'
transform1Display.OpacityArray = ['POINTS', 'Normals']
transform1Display.OpacityTransferFunction = 'PiecewiseFunction'
transform1Display.DataAxesGrid = 'GridAxesRepresentation'
transform1Display.SelectionCellLabelFontFile = ''
transform1Display.SelectionPointLabelFontFile = ''
transform1Display.PolarAxes = 'PolarAxesRepresentation'

# init the 'PiecewiseFunction' selected for 'OSPRayScaleFunction'
transform1Display.OSPRayScaleFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'ScaleTransferFunction'
transform1Display.ScaleTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'PiecewiseFunction' selected for 'OpacityTransferFunction'
transform1Display.OpacityTransferFunction.Points = [293.1499938964844, 0.0, 0.5, 0.0, 913.1500244140625, 1.0, 0.5, 0.0]

# init the 'GridAxesRepresentation' selected for 'DataAxesGrid'
transform1Display.DataAxesGrid.XTitleColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.XTitleFontFile = ''
transform1Display.DataAxesGrid.YTitleColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.YTitleFontFile = ''
transform1Display.DataAxesGrid.ZTitleColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.ZTitleFontFile = ''
transform1Display.DataAxesGrid.GridColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.XLabelColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.XLabelFontFile = ''
transform1Display.DataAxesGrid.YLabelColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.YLabelFontFile = ''
transform1Display.DataAxesGrid.ZLabelColor = [0.0, 0.0, 0.0]
transform1Display.DataAxesGrid.ZLabelFontFile = ''

# init the 'PolarAxesRepresentation' selected for 'PolarAxes'
transform1Display.PolarAxes.PolarAxisTitleColor = [0.0, 0.0, 0.0]
transform1Display.PolarAxes.PolarAxisTitleFontFile = ''
transform1Display.PolarAxes.PolarAxisLabelColor = [0.0, 0.0, 0.0]
transform1Display.PolarAxes.PolarAxisLabelFontFile = ''
transform1Display.PolarAxes.LastRadialAxisTextColor = [0.0, 0.0, 0.0]
transform1Display.PolarAxes.LastRadialAxisTextFontFile = ''
transform1Display.PolarAxes.SecondaryRadialAxesTextColor = [0.0, 0.0, 0.0]
transform1Display.PolarAxes.SecondaryRadialAxesTextFontFile = ''

# ----------------------------------------------------------------
# finally, restore active source
SetActiveSource(transform1)
# ----------------------------------------------------------------