#include "descriptor_array_of.hpp"


// ------------------------------------------------------------------
/// A representation of a descriptor of fixed type and variable size
template < typename T >
class descriptor_dynamic :
  public descriptor_array_of< T >
{
public:
  /// Constructor
  descriptor_dynamic< T > (size_t len)
  : data_( new T[len] ),
  length_( len ),
  node_id_(std::numeric_limits<unsigned int>::max()) { }

  descriptor_dynamic< T > (size_t len, T* dat)
  : length_( len )
  {
    data_ = new T[len];
    memmove( data_, dat, len*sizeof(T) );
  }

  /// Destructor
  virtual ~descriptor_dynamic< T > ( ) { delete [] data_; }

  /// The number of elements of the underlying type
  std::size_t size() const { return length_; }

  /// Return an pointer to the raw data array
  T* raw_data() { return data_; }

  /// Return an pointer to the raw data array
  const T* raw_data() const { return data_; }

  virtual  descriptor_sptr clone() const
  {
    auto ptr = std::make_shared<descriptor_dynamic<T>>(length_);
    memcpy(ptr->data_, data_, length_ * sizeof(T));
    return ptr;
  }

  virtual unsigned int node_id() const { return node_id_; }

  virtual bool set_node_id(unsigned int node_id)
  {
    node_id_ = node_id;
    return true;
  }

protected:
  /// data array
  T* data_;
  /// length of data array
  size_t length_;
  /// node id
  unsigned int node_id_;
};

